/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_LangTexte
#include <io.h>
#include <IDEClass.h>
#include "IDE.h"
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <fcntl.h>

#define STDOUT 1
#define STDERR 2

int oldstderr,oldstdout;
char *cpp_errname;
char *cpp_outname;
static char *errname = NULL;
static char *outname = NULL;

char *open_stderr(void)
{
  int nul;
  if (errname) free(errname);
  errname = strdup(tmpnam(NULL));
  if (debug_tempfiles)
  {
    fprintf(stderr,GT(TextRedirecting),"stderr",errname);
  }
  fflush(stderr);
  nul = creat(errname, S_IREAD | S_IWRITE);
  oldstderr = dup(STDERR);
  dup2(nul, STDERR);
  close(nul);
  return errname;
}

void close_stderr(void)
{
  dup2(oldstderr, STDERR);
  close(oldstderr);
}

char *open_stdout(void)
{
  int nul;
  if (outname) free(outname);
  outname = strdup(tmpnam(NULL));
  if (debug_tempfiles)
  {
    fprintf(stderr,GT(TextRedirecting),"stdout",outname);
  }
  fflush(stdout);
  nul = creat(outname, S_IREAD | S_IWRITE);
  oldstdout = dup(STDOUT);
  dup2(nul, STDOUT);
  close(nul);
  return outname;
}

void close_stdout(void)
{
  dup2(oldstdout, STDOUT);
  close(oldstdout);
}
