/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TProject
#define Uses_TOptions
#define Uses_TDirList
#include <IDEClass.h>
#include "IDE.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dpmi.h>
#include <libc/dosio.h>

char *expand_variables(char *x)
{
  char *var,*var_end,*env;
  char buffer[1000];
  char *xptr = x, *bptr = buffer;
  if (!strchr(x,'$')) return x;
  while (*xptr)
  {
    if (*xptr == '$' && xptr[1] == '(')
    {
      char old;
      var = xptr+2;
      var_end = var+1;
      while (*var_end && *var_end != ')') var_end++;
      old = *var_end;
      *var_end = 0;
      env = getenv(var);
      *var_end = old;
      if (env)
      {
        while (*env)
        {
          *bptr++ = *env++;
        }
        xptr = var_end+1;
        continue;
      }
      *bptr++ = *xptr++;
    }
    else
    {
      *bptr++ = *xptr++;
    }
  }
  *bptr = 0;
  strcpy(x,buffer);
  return x;
}

char *expand_variables(char **val)
{
  if (!strchr(*val,'$')) return *val;
  char buffer[1000];
  strcpy(buffer,*val);
  expand_variables(buffer);
  string_free(*val);
  string_dup(*val,buffer);
  return *val;
}

Boolean FindFile(const char * name,char * & full_name)
{
  FILE_TYPE t;
  Boolean retval = False;
  char *dir,*file,*ext;
  if (!name)
  {
    string_dup(full_name,"");
    return retval;
  }
  if (strchr(name,'/') != NULL)
  {
    string_dup(full_name,name);
    return retval;
  }
  split_fname(name,dir,file,ext);
  t = get_file_type(ext);
  switch (t)
  {
    case FILE_C_SOURCE:
    case FILE_CC_SOURCE:
    case FILE_ASM_SOURCE:
    case FILE_FLEX_SOURCE:
    case FILE_BISON_SOURCE:
    case FILE_OBJC_SOURCE:
      retval = FindFile(name,Options.SrcDirs,full_name,False);
      break;
    case FILE_LIBRARY:
      retval = FindFile(name,Options.library_path,full_name);
      break;
    case FILE_OBJECT:
    case FILE_COFF:
    case FILE_EXE:
      retval = FindFile(name,Options.ObjDirs,full_name);
      break;
    case FILE_HEADER:
      retval = FindFile(name,Options.include_path,full_name,False);
      break;
    default:
      string_dup(full_name,name);
      break;
  }
  string_free(dir);
  string_free(file);
  string_free(ext);
  return retval;
}

class FindCacheCollection : public TNSSortedCollection
{
public:
  FindCacheCollection(ccIndex alimit,ccIndex adelta) :
    TNSSortedCollection(alimit,adelta) {}
private:
  virtual int compare(void *,void *);
  virtual void freeItem(void *);
};

struct FileFind {
  char *name;
  char *full_name;
  FileFind(const char *_name,const char *_full_name)
  {
    string_dup(name,_name);
    if (_full_name) string_dup(full_name,_full_name);
    else full_name = NULL;
  }
  ~FileFind()
  {
    delete name;
    delete full_name;
  }
};

int FindCacheCollection::compare(void *key1,void *key2)
{
  return strcmp(((FileFind *)key1)->name,((FileFind *)key2)->name);
}

void FindCacheCollection::freeItem(void *item)
{
  delete (FileFind *)item;
}

static FindCacheCollection *FindCache = NULL;

void ClearFindCache()
{
  if (FindCache) delete FindCache;
  FindCache = NULL;
}

Boolean FindFile(const char * name,TDirList * list,char * & full_name,Boolean uselist)
{
  int i;
  FileFind *ff;
  ccIndex findIndex;
  char *bname;
  if (!name)
  {
    string_dup(full_name,"");
    return False;
  }
  ff = new FileFind(name,NULL);
  if (!FindCache) FindCache = new FindCacheCollection(100,100);
  if (FindCache->search(ff,findIndex) == True)
  {
    string_dup(full_name,((FileFind *)FindCache->at(findIndex))->full_name);
    delete ff;
    return True;
  }
  BaseName(name,bname);
  if (TimeOfFile(bname,False) != 0 || list->getCount() == 0)
  {
    full_name = bname;
    FExpand(full_name);
    string_dup(ff->full_name,full_name);
    FindCache->atInsert(findIndex,ff);
    return True;
  }
  for (i=0;i<list->getCount();i++)
  {
    string_dup(full_name,(char *)list->at(i));
    expand_variables(&full_name);
    string_cat(full_name,"/");
    string_cat(full_name,bname);
    if (TimeOfFile(full_name,False) != 0)
    {
      FExpand(full_name);
      string_dup(ff->full_name,full_name);
      FindCache->atInsert(findIndex,ff);
      string_free(bname);
      return True;
    }
    string_free(full_name);
  }
  if (uselist == True)
  {
    string_dup(full_name,(char *)list->at(0));
    expand_variables(&full_name);
    string_cat(full_name,"/");
    string_cat(full_name,bname);
  }
  else
  {
    string_dup(full_name,name);
  }
  string_free(bname);
  {
    FExpand(full_name);
    string_dup(ff->full_name,full_name);
    FindCache->atInsert(findIndex,ff);
  }
  return False;
}

