/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEditor
#define Uses_IDEConst
#define Uses_TKeys
#define Uses_TMenuBar
#include <IDEClass.h>
#include "IDE.h"
#include "inf.h"
#include <ctype.h>

#define cIDEInfWindowColor "\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\x73"
#define cIDEInfWindowBW    "\x74\x75\x76\x77\x78\x79\x7A\x7B\x7C\x7D"
#define cIDEInfWindowMono  "\x7E\x7F\x80\x81\x82\x83\x84\x85\x86\x87"

class TIDEInfViewer : public TInfViewer
{
public:
    TIDEInfViewer( const TRect& r, TScrollBar* ah, TScrollBar* av,
                   TInfFile* inf, char * inff,
                   TInfIndicator *infi,char *match ) :
      TInfViewer(r,ah,av,inf,inff,infi,match) {}
    virtual void handleEvent(TEvent &);
};

class TIDEInfWindow : public TWindow
{
public:
  TIDEInfWindow(TInfFile *, char *, char *match = NULL);
  virtual TPalette& getPalette() const;
};

TIDEInfWindow::TIDEInfWindow(TInfFile *hFile, char *context, char *match) :
       TWindow( TRect(0,0,50,18), "InfView", wnNoNumber ),
       TWindowInit( &TInfWindow::initFrame)
{
  TRect r(0, 0, 50, 18);
  options = (options | ofCentered);
  r.grow(-1,-1);

  TInfIndicator *Indic = new TInfIndicator(TRect(6,0,45,1));
  insert(Indic);
  insert(new TIDEInfViewer (r,
    standardScrollBar(sbHorizontal | sbHandleKeyboard),
    standardScrollBar(sbVertical | sbHandleKeyboard), hFile, context,
    Indic, match));
  helpCtx = hcInfView;
}

void TIDEInfViewer::handleEvent(TEvent &event)
{
#if 0
  if (event.what == evKeyDown && event.keyDown.keyCode == kbEsc)
  {
    owner->hide();
    clearEvent(event);
  }
  else
#endif
  {
    TInfViewer::handleEvent(event);

  }
}

TPalette & TIDEInfWindow::getPalette() const
{
  static TPalette color(cIDEInfWindowColor,sizeof(cIDEInfWindowColor)-1);
  static TPalette blackwhite(cIDEInfWindowBW,sizeof(cIDEInfWindowBW)-1);
  static TPalette monochrome(cIDEInfWindowMono,sizeof(cIDEInfWindowMono)-1);
  static TPalette *palettes[] =
  {
    &color,
    &blackwhite,
    &monochrome
  };
  return *(palettes[TProgram::appPalette]);
}

TIDEInfWindow *InfWindow = NULL;

void Help(ushort);

void Help()
{
  ushort ctx = TProgram::application->getHelpCtx();
  Help(ctx);
}

typedef struct {
  char *help_file;
  char *help_string;
} InfoHelpRec;

typedef struct {
  ushort ctx;
  InfoHelpRec help;
} CtxInfoRec;

#define H(x) {hc##x,{"rhide",#x}}
#define HH(x,y) {hc##x,{"rhide",y}}

static CtxInfoRec known_contexts[] = {
  {hcOptFlagList,{"gcc","Optimize Options"}},
  {hcDebFlagList,{"gcc","Debugging Options"}},
  {hcWarnFlagList,{"gcc","Warning Options"}},
  {hcCFlagList,{"gcc","C Dialect Options"}},
  {hcCXXFlagList,{"gcc","C++ Dialect Options"}},
  H(About),
  H(FSDB),
  H(GREP),
  H(GDB),
  HH(Repaint,"Refresh Desktop"),
  H(Help),
  H(Open),
  H(New),
  H(Save),
  HH(SaveAs,"Save as"),
  HH(SaveAll,"Save all"),
  HH(DosShell,"DOS Shell"),
  HH(Quit,"Exit"),
  H(Undo),
  H(Cut),
  H(Copy),
  H(Paste),
  HH(ShowClip,"Show Clipboard"),
  H(Clear),
  H(Find),
  H(Replace),
  HH(SearchAgain,"Search again"),
  HH(GotoLine,"Goto line"),
  HH(NextMessage,"Next message"),
  HH(PrevMessage,"Previous message"),
  H(Run),
#ifdef INTERNAL_DEBUGGER
  H(Step),
  H(Trace),
  HH(Goto,"Go to cursor"),
  HH(Reset,"Program reset"),
#endif
  HH(ProgArgs,"Arguments"),
  H(Compile),
  H(Make),
  H(Link),
  HH(Build,"Build all"),
  HH(OpenProject,"Open project"),
  HH(CloseProject,"Close project"),
  HH(AddProjectItem,"Add item"),
  HH(DelProjectItem,"Delete item"),
  HH(LocalOptions,"Local options"),
  HH(ShowIncludes,"Includes"),
  HH(TargetName,"Main targetname"),
  HH(ClearDependencies,"Clear dependencies"),
  HH(MakeClear,"Delete rebuildable files"),
  H(Directories),
  HH(IncludeDir,"Include directories"),
  HH(LibDir,"Library directories"),
  HH(ObjDir,"Object directories"),
  HH(SrcDir,"Sources directories"),
  HH(C_CXXCompiler,"C/C++-Compiler"),
  HH(WarningFlags,"Warnings"),
  HH(OptimizationFlags,"Optimizations"),
  HH(DebugFlags,"Debugging"),
  HH(CFlags,"C options"),
  HH(CXXFlags,"CXX options"),
  H(Libraries),
  HH(LinkerOptions,"Linker options"),
  HH(CompilerOptions,"Compiler options"),
  H(Environment),
  H(Colors),
  H(Preferences),
  HH(EditReserved,"Reserved words"),
  HH(EditCFlags,"C-Flags"),
  HH(EditCXXFlags,"CXX-Flags"),
  HH(EditWarnFlags,"Warning-Flags"),
  HH(EditDebugFlags,"Debugging-Flags"),
  HH(EditOptFlags,"Optimization-Flags"),
  HH(EditUserWords,"User words"),
  HH(WriteMake,"Write makefile"),
  HH(Resize,"Size/move"),
  H(Zoom),
  H(Tile),
  H(Cascade),
  H(Next),
  HH(Prev,"Previous"),
  H(Close),
  HH(ShowWindowList,"List"),
  HH(ShowProject,"Project"),
  H(UserScreen),
  HH(IDEFileEditor,"How the editor works"),
  HH(WindowList,"List"),
  HH(OptFlagList,"Optimizations"),
  HH(DebFlagList,"Debugging"),
  HH(WarnFlagList,"Warnings"),
  HH(CFlagList,"C options"),
  HH(CXXFlagList,"CXX Options"),
  HH(MsgListBox,"Messages window"),
  HH(ProjectListBox,"Project window"),
  {0,{"rhide",""}}
};

#undef H

const InfoHelpRec *HelpstringFromCtx(ushort ctx)
{
  int i=0;
  while (known_contexts[i].ctx)
  {
    if (known_contexts[i].ctx == ctx) return &(known_contexts[i].help);
    i++;
  }
  return &(known_contexts[i].help);
}

void Help(ushort ctx)
{
  const InfoHelpRec *help_rec;
  help_rec = HelpstringFromCtx(ctx);
  SyntaxHelp(help_rec->help_string,help_rec->help_file);
}  

static int isWordChar(char c)
{
  return isalnum(c) || c == '_';
}

char *WordUnderCursor(TEditor *editor)
{
  char *word;
  uint32 word_start,word_end,curptr = editor->curPtr,i;
  if (!isWordChar(editor->bufChar(curptr))) return NULL;
  word_start = curptr-1;
  while (isWordChar(editor->bufChar(word_start)))
    word_start--;
  word_start++;
  word_end = curptr+1;
  while (isWordChar(editor->bufChar(word_end)))
    word_end++;
  word_end--;
  word = new char[word_end-word_start+2];
  for (i=word_start;i<=word_end;i++)
  {
    word[i-word_start] = editor->bufChar(i);
  }
  word[word_end-word_start+1] = 0;
  return word;
}

void HelpIndex()
{
  SyntaxHelp("Index","rhide");
}

int help_in_use = 0;

void SyntaxHelp(const char *word,const char *fname)
{
  if (!help_in_use)
  {
    help_in_use = 1;
    TInfFile *i=new TInfFile((char *)fname);
    InfWindow = new TIDEInfWindow(i,(char *)word);
  }
  else
  {
  }
  if (TProgram::application->validView(InfWindow) != 0)
  {
    int fromModal = TProgram::deskTop->current->state & sfModal;
    if (fromModal)
    {
      TProgram::deskTop->execView(InfWindow);
    }
    else
    {
      AddWindow(InfWindow);
    }
  }
}
