/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if (__GNUC_MINOR__ < 7)
#pragma interface
#endif
#if defined( Uses_TIDEFileEditor ) && !defined( __TIDEFileEditor__ )
#define __TIDEFileEditor__

class TPalette;

typedef void (*formatlineProc)(TEditor *,void *,uint32,int,ushort);

class TIDEFileEditor : public TFileEditor
{
public:
  TIDEFileEditor(const TRect &,TScrollBar *,TScrollBar *,TIndicator *,const char *);
  static TStreamable * build();
  static const char * const name;
  virtual void handleEvent(TEvent &);
  virtual Boolean valid(ushort);
  virtual TPalette& getPalette() const;
  virtual void formatLine(void *,uint32,int,ushort);
  static formatlineProc formatline;
private:
  virtual const char * streamableName() const { return name; }
  void Marcar(int Accion, int Marca);
  uint32 Marcas[10];

protected:
  TIDEFileEditor(StreamableInit);
  virtual void * read(ipstream &);
  virtual void write( opstream& );

public:
  long edittime;
};

inline ipstream& operator >> ( ipstream& is, TIDEFileEditor& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TIDEFileEditor*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TIDEFileEditor& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TIDEFileEditor* cl )
    { return os << (TStreamable *)cl; }

void goto_line(TFileEditor *editor,int line);

#endif
