/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if (__GNUC_MINOR__ < 7)
#pragma interface
#endif
#if defined( Uses_TDepCollection) && !defined( __TDepCollection__)
#define __TDepCollection__

class TDepCollection : public TSortedCollection
{
public:
  TDepCollection(ccIndex aLimit,ccIndex aDelta) : TSortedCollection(aLimit,aDelta) {}
private:
    virtual const char *streamableName() const
	{ return name; }
    virtual void *readItem( ipstream& );
    virtual void writeItem( void *, opstream& );
    virtual void *keyOf(void *);
    virtual int compare(void *,void *);
protected:
    TDepCollection( StreamableInit ) : TSortedCollection(streamableInit) {}
    virtual void write( opstream& );
    virtual void *read( ipstream& );
public:
    static const char * const near name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDepCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDepCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDepCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDepCollection* cl )
    { return os << (TStreamable *)cl; }

#endif

#if defined( Uses_TDependency ) && !defined( __TDependency__ )
#define __TDependency__

class TDepCollection;
class TParamList;

class TDependency : public TObject, public TStreamable
{
public:
  char * source_name;
  char * dest_name;
  FILE_TYPE source_file_type;
  FILE_TYPE dest_file_type;
  COMPILE_ID compile_id;
  TDepCollection *dependencies;
  TParamList *local_options;
  TDependency(void);
private:
    virtual const char *streamableName() const
	{ return name; }
protected:
    TDependency( StreamableInit ) {}
    virtual void write( opstream& );
    virtual void *read( ipstream& );
public:
    static const char * const near name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDependency& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDependency*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDependency& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDependency* cl )
    { return os << (TStreamable *)cl; }

#endif
