/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TProject
#define Uses_TOptions
#define Uses_TDepCollection
#define Uses_TStreamable
#define Uses_TEditor
#define Uses_TScreen
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TApplication

#include "IDEClass.h"

static ushort TProject_Version = 2;

TProject::TProject() : TDependency()
{
  options = new TOptions();
  string_dup(defaultprojectmask,"*.cc");
  dependencies = new TDepCollection(5,5);
}

TProject::~TProject()
{
  delete options;
  string_free(defaultprojectmask);
}

TStreamable *TProject::build()
{
  return new TProject( streamableInit );
}

void * TProject::read(ipstream & is)
{
  ushort version;
  is >> version;
  TDependency::read(is);
  is >> options;
  defaultprojectmask = is.readString();
  if (version >= 2)
  {
    is >> tabsize;
    is >> screen_mode;
  }
  else
  {
    tabsize = 8;
    screen_mode = 3;
  }
  return this;
}

void TProject::write(opstream & os)
{
  os << TProject_Version;
  TDependency::write(os);
  os << options;
  os.writeString(defaultprojectmask);
  tabsize = TEditor::tabSize;
  os << tabsize;
  screen_mode = TScreen::getCrtMode();
  os << screen_mode;
}
