/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TProjectWindow
#define Uses_TProjectListBox
#define Uses_TDepCollection
#define Uses_TScrollBar

#include "IDEClass.h"
#include <libc/dosio.h>

#define COLS (_USE_LFN ? 3 : 5)

TProjectWindow::TProjectWindow(const TRect & rect,
                               TDepCollection *deps,
                               const char *tit) : 
        TDialog(rect,tit),
	TWindowInit(&TProjectWindow::initFrame)
{
  TRect r = getExtent();
  TScrollBar *scrollbar;
  r.grow(-1,-1);
  scrollbar = standardScrollBar(sbVertical | sbHandleKeyboard);
  liste = new TProjectListBox(r,COLS,scrollbar);
  growMode = gfGrowLoY | gfGrowHiX | gfGrowHiY;
  liste->growMode = gfGrowHiX | gfGrowHiY;
  liste->newList(deps);
  insert(liste);
  insert(scrollbar);
  flags |= wfGrow | wfZoom;
  helpCtx = hcProjectWindow;
}

