/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TProjectListBox
#define Uses_TDependency
#define Uses_TDepCollection
#define Uses_TEditWindow
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TKeys

#include "IDEClass.h"

void TProjectListBox::getText(char *dest,ccIndex item,short maxlen)
{
  strncpy(dest,((TDependency *)list()->at(item))->source_name,maxlen);
  dest[maxlen] = EOS;
}

void TProjectListBox::selectItem(ccIndex item)
{
  TDependency * rec;
  TEditWindow *ewindow;
  if (!list()) return;
  rec = (TDependency *)list()->at(item);
  if (!rec->source_name) return;
  switch (rec->source_file_type)
  {
    case FILE_C_SOURCE:
    case FILE_CC_SOURCE:
    case FILE_ASM_SOURCE:
    case FILE_FLEX_SOURCE:
    case FILE_BISON_SOURCE:
      ewindow = OpenEditor(rec->source_name,True);
      ewindow->select();
      break;
    case FILE_PROJECT:
    {
      TEvent event;
      event.what = evCommand;
      event.message.command = cmSelectProject;
      event.message.infoPtr = rec;
      putEvent(event);
      break;
    }
        
    default:
       break;
  }
}

void TProjectListBox::handleEvent(TEvent &event)
{
  TSortedListBox::handleEvent(event);
  if (event.what == evKeyDown)
  {
    switch (event.keyDown.keyCode)
    {
      case kbEnter:
        if (!list() || list()->getCount() == 0) break;
        selectItem(focused);
	clearEvent(event);
	break;
    }
  }
}

