/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TFlagListBox
#define Uses_TFlagEntry
#define Uses_TFlagCollection

#include "IDEClass.h"
#include <string.h>
#include <stdio.h>

void TFlagListBox::getText(char *dest,ccIndex item,short maxlen)
{
  char *tmp = ((TFlagEntry *)list()->at(item))->GetText();
  strncpy(dest,tmp,maxlen);
#ifdef DEBUG
  fprintf(stderr,"TFlagListBox::getText: %s\n",tmp);
#endif
  string_free(tmp);
}

void TFlagListBox::selectItem(ccIndex item)
{
  TListBox::selectItem(item);
  ((TFlagEntry *)list()->at(item))->ToggleActive();
  drawView();
}

