/* LiveWire 3.1 Upgrade script */

/* Send all commands only to CMD.EXE */
ADDRESS CMD.EXE

/* Install REXX system functions */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* Determine the path to LiveWire */
parse source . . argv0 .
temp = reverse(argv0)
temp = substr(temp, pos('\', temp))
if length(temp) > 3 then temp = substr(temp, 2)
CurrentPath = reverse(temp)

/* Begin installation */
ECHO OFF
call SysCls

Say "Running upgrade script, please wait ..."
Say "Recreating LiveWire Accessories folder"

/* Create the LiveWire folder */
setting="OBJECTID=<LIVEWIRE30_MAIN_FOLDER>;";
ret = SysCreateObject("WPFolder", "LiveWire Accessories", "<WP_DESKTOP>", setting, "R")

/* Create Registration object */
setting="OBJECTID=<LIVEWIRE30_REG>;"||,
	 "EXENAME="||CurrentPath||"\TextMode\LW30.EXE;"||,
         "ICONFILE="||CurrentPath||"\TextMode\LWREG.ICO;"||,
	 "STARTUPDIR="CurrentPath"\TextMode;"||,
	 "PARAMETERS=REGISTER;"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "Register LiveWire", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create README object */
setting="OBJECTID=<LIVEWIRE30_README>;"||,
	 "EXENAME=E.EXE;"||,
	 "PARAMETERS=READ.ME;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "Read Me", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create DOCUMENTATION object */
setting="OBJECTID=<LIVEWIRE30_WPS_DOCS>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LWHLP.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "LiveWire 3.1 Manual", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create DOCUMENTATION object */
setting="OBJECTID=<LIVEWIRE30_DOCS>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LW30.INF;"||,
	 "STARTUPDIR="CurrentPath"\TextMode;"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "Text Mode Manuals", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create DOCUMENTATION object */
setting="OBJECTID=<LIVEWIRE30_SCRIPT_DOCS>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LWSCR.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "Script Manual", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create FAQ object */
setting="OBJECTID=<LIVEWIRE30_FAQ>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LWFAQ.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "Frequently Asked Questions", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create NOTES object */
setting="OBJECTID=<LIVEWIRE30_NOTES>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=NOTES.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "InfoNags", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create ORDER.FRM object */
setting="SHADOWID="||CurrentPath||"\TextMode\ORDER.FRM;"
ret = SysCreateObject("WPShadow", "How to order LiveWire", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create Program object */
setting="OBJECTID=<LW30_TEXTMODE_EXE>;"||,
	 "EXENAME="||CurrentPath||"\TextMode\LW30.EXE;"||,
         "ICONFILE="||CurrentPath||"\TextMode\LWPRG.ICO;"||,
	 "STARTUPDIR="CurrentPath"\TextMode;"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "LiveWire Text Mode", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create deinstall object */
setting="OBJECTID=<LW30_DEINSTALL_EXE>;"||,
	 "EXENAME="||CurrentPath||"\DEINST.EXE;"||,
	 "STARTUPDIR="CurrentPath";"
ret = SysCreateObject("WPProgram", "Deinstall", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create ZIP utility deinstall object */
setting="OBJECTID=<LW30_RMVZIP_EXE>;"||,
	 "EXENAME="||CurrentPath||"\RMVZIP.EXE;"||,
	 "STARTUPDIR="CurrentPath";"
ret = SysCreateObject("WPProgram", "Remove ZIP utility", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

/* Create Shadow to the template object */
setting="SHADOWID=<LW_FOLDER_TEMPLATE>;"
ret = SysCreateObject("WPShadow", "LiveWire Folder Template", "<LIVEWIRE30_MAIN_FOLDER>", setting, "R")

Say "Done"

