// Fensterprozedur des Hauptprogramms

#include "pc64.h"

static void CheckResume() {
  if (wResume) {
    PostMessage(hwndFrame, WM_COMMAND, IDM_RUNSTART, 0);
    wResume = 0;
  }
}

LONG FAR PASCAL FrameWndProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  static flag fAll = FALSE;
  FILEWND* pfwTemp;
  switch (wMsg) {
  case WM_COMMAND:
    wDialogHelp = wParam;
    switch (wParam) {
    case IDM_FILENEW:
      ReplaceFileWnd();
      pfwTemp = AllocFileWnd();
      assert(pfwTemp);
      pfwTemp->c = def.c;
      CreateFileWnd(pfwTemp, NULL);
      break;
    case IDM_FILEDUPLICATE:
      DuplicateFileWnd();
      break;
    case IDM_FILEOPEN:
      pfwTemp = OpenFileWnd();
      if (pfwTemp) {
        ReplaceFileWnd();
        if (!CreateFileWnd(pfwTemp, NULL)) {
          free(pfwTemp);
        }
      }
      break;
    case IDM_FILERELOAD:
      ReloadFileWnd();
      CheckResume();
      break;
    case IDM_FILESAVE:
      SaveFileWnd(hwndChild, FALSE);
      CheckResume();
      break;
    case IDM_FILESAVEAS:
      SaveFileWnd(hwndChild, TRUE);
      break;
    case IDM_FILESHELL:
      if (hLogFile > 0) {
        int hDup = _dup(hLogFile);
        if (hDup > 0) {
          _lclose(hDup);
        }
      }
      _chdrive(::acShellDir[0] - '@');
      _chdir(::acShellDir);
      fSwapEMS = def.fSwapEMS;
      fSwapXMS = def.fSwapXMS;
      WinExec(NULL, EXEC_SWAP | EXEC_80X25);
      _getcwd(::acShellDir, 80);
      _chdrive(::acDir[0] - '@');
      _chdir(::acDir);
      break;
    case IDM_FILEEXIT:
      SendMessage(hwnd, WM_CLOSE, 0, 0L);
      break;
    case IDM_LINKNEW:
      CreateLinkWnd(NULL);
      break;
    case IDM_LINKEXECUTE:
      LinkExecute();
      break;
    case IDM_LINKRENAME:
      DialogBox(hInst, "Rename", hwnd, (FARPROC)RenameDlgProc);
      break;
    case IDM_LINKMOVE:
      DialogBoxParam(hInst, "Move", hwnd, (FARPROC)CopyMoveDlgProc, TRUE);
      break;
    case IDM_LINKCOPY:
      DialogBoxParam(hInst, "Copy", hwnd, (FARPROC)CopyMoveDlgProc, FALSE);
      break;
    case IDM_LINKDELETE:
      {
        assert(IsWindow(hwndChild));
        assert(GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc);
        LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
        assert(plw->hwnd == hwndChild);
        assert(plw->hwndListBox);
        int iCount = (int)SendMessage(plw->hwndListBox, LB_GETSELCOUNT, 0, 0);
        assert(iCount >= 0);
        if (!iCount) {
          iCount = 1;
        }
        char ac[128];
        wsprintf(ac, acDelete, iCount);
        MessageBeep(MB_ICONQUESTION);
        if (MessageBox(hwndFrame, ac, acConfirm, MB_ICONQUESTION | MB_OKCANCEL) == IDOK) {
          DialogBox(hInst, "Delete", hwnd, (FARPROC)DeleteDlgProc);
        }
      }
      break;
    case IDM_LINKIMPORT:
      LinkImport();
      break;
    case IDM_LINKEXPORT:
      LinkExport();
      break;
    case IDM_LINKMAKEDIR:
      DialogBox(hInst, "MakeDir", hwnd, (FARPROC)MakeDirDlgProc);
      break;
    case IDM_LINKRENAMEDIR:
      DialogBox(hInst, "RenameDir", hwnd, (FARPROC)RenameDirDlgProc);
      break;
    case IDM_LINKDELDIR:
      DelDir();
      break;
    case IDM_LINKMAKEIMAGE:
      DialogBoxParam(hInst, "MakeRenameImage", hwnd, (FARPROC)MakeRenameImageDlgProc, FALSE);
      break;
    case IDM_LINKRENAMEIMAGE:
      DialogBoxParam(hInst, "MakeRenameImage", hwnd, (FARPROC)MakeRenameImageDlgProc, TRUE);
      break;
    case IDM_LINKCOPYSLOW:
      extern flag gfCopySlow;
      gfCopySlow = TRUE;
    case IDM_LINKCOPYIMAGE:
      DialogBox(hInst, "CopyImage", hwnd, (FARPROC)CopyImageDlgProc);
      gfCopySlow = FALSE;
      break;
    case IDM_LINKDELIMAGE:
      DelImage();
      break;
    case IDM_LINKREFRESH:
      {
        assert(IsWindow(hwndChild));
        assert(GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc);
        LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
        assert(plw);
        if (!ReadNames(plw)) {
          plw->hwndFocus = plw->hwndDirTree;
          SetFocus(plw->hwndDirTree);
        }
      }
      break;
    case IDM_LINKSCANDRIVES:
      if (UserIgnoresWindowsNT()) {
        if (ScanForC64Drives()) {
          MessageBox(hwndFrame, acDrivesFound, acScanDrives, MB_ICONINFORMATION | MB_OK);
        } else {
          ErrorBox(NULL, acDrivesNotFound);
        }
      }
      break;
    case IDM_LINKCLONE:
      if (UserIgnoresWindowsNT()) {
        if (DialogBox(hInst, "Clone", hwnd, (FARPROC)CloneDlgProc)) {
          MessageBox(hwndFrame, acEnterClose1, acCloneSuccess, MB_ICONINFORMATION | MB_OK);
        }
      }
      break;
    case IDM_LINKREADROMS:
      if (UserIgnoresWindowsNT()) {
        DialogBox(hInst, "ReadROMs", hwnd, (FARPROC)ReadROMsDlgProc);
      }
      break;
    case IDM_SEARCHTEXT:
      if (DialogBox(hInst, "SearchText", hwnd, (FARPROC)SearchTextDlgProc)) {
        Search();
      }
      break;
    case IDM_SEARCHADR:
      if (DialogBox(hInst, "SearchAdr", hwnd, (FARPROC)SearchAdrDlgProc)) {
        Search();
      }
      break;
    case IDM_SEARCHNEXT:
      fSearchBack = FALSE;
      Search();
      break;
    case IDM_SEARCHPREV:
      fSearchBack = TRUE;
      Search();
      break;
    case IDM_NEXTERROR:
      PostMessage(hwndChild, WM_CHAR, VK_F4, 0);
      break;
    case IDM_PREVERROR:
      PostMessage(hwndChild, WM_CHAR, VK_SH_F4, 0);
      break;
    case IDM_SEARCHLINE:
      PostMessage(hwndChild, WM_CHAR, '-', 0);
      break;
    case IDM_SEARCHREM:
      PostMessage(hwndChild, WM_CHAR, 'r', 0);
      break;
    case IDM_SEARCHVIC:
      PostMessage(hwndChild, WM_CHAR, 'v', 0);
      break;
    case IDM_SEARCHSID:
      PostMessage(hwndChild, WM_CHAR, 's', 0);
      break;
    case IDM_SEARCHCIA:
      PostMessage(hwndChild, WM_CHAR, 'c', 0);
      break;
    case IDM_SEARCHIEC:
      PostMessage(hwndChild, WM_CHAR, 'e', 0);
      break;
    case IDM_SEARCHDEV:
      PostMessage(hwndChild, WM_CHAR, 'd', 0);
      break;
    case IDM_SEARCHINT:
      PostMessage(hwndChild, WM_CHAR, 'i', 0);
      break;
    case IDM_RUNDEBUG:
      fRunDebug = TRUE;
    case IDM_RUNSTART:
      RunStart(0);
      break;
    case IDM_RUNRESETDEBUG:
      fRunDebug = TRUE;
    case IDM_RUNRESET:
    case IDM_RUNTOTALRESET:
      MessageBeep(MB_ICONQUESTION);
      if (MessageBox(hwndFrame, acReset, acConfirm, MB_ICONQUESTION | MB_YESNO) == IDYES) {
        wResume = 0;
        RunStart(wParam == IDM_RUNTOTALRESET ? 2 : 1);
      } else if (wResume) {
        wResume = 0;
        RunStart(0);
      }
      break;
    case IDM_RUNFILTERS:
      DialogBox(hInst, "Filters", hwnd, (FARPROC)FiltersDlgProc);
      break;
    case IDM_RUNCLEAR:
      assert(pfw);
      assert(pfw->acLogName[0]);
      assert(hLogFile);
      DeleteLogFile(pfw);
      assert(!pfw->acLogName[0]);
      assert(!hLogFile);
      assert(hwndChild);
      SetScrollRange(hwndChild, SB_VERT, 0, 0, TRUE);
      InvalidateRect(hwndChild, NULL, TRUE);
      break;
    case IDM_OPTIONSALL:
      fAll = TRUE;
    case IDM_OPTIONSFILE:
      DialogBox(hInst, "FileOpt", hwnd, (FARPROC)FileOptDlgProc);
      if (!fAll) {
        break;
      }
    case IDM_OPTIONSROMS:
      DialogBox(hInst, "ROMs", hwnd, (FARPROC)ROMsDlgProc);
      if (!fAll) {
        break;
      }
    case IDM_OPTIONSKEYBOARD:
      DialogBox(hInst, "Keyboard", hwnd, (FARPROC)KeyboardDlgProc);
      if (!fAll) {
        break;
      }
    case IDM_OPTIONSJOYSTICKS:
      DialogBox(hInst, "Joysticks", hwnd, (FARPROC)JoysticksDlgProc);
      CheckResume();
      if (!fAll) {
        break;
      }
    case IDM_OPTIONSFLOPPIES:
      DialogBox(hInst, "Floppies", hwnd, (FARPROC)FloppiesDlgProc);
      CheckResume();
      if (!fAll) {
        break;
      }
    case IDM_OPTIONSTIMING:
      DialogBox(hInst, "Timing", hwnd, (FARPROC)TimingDlgProc);
      if (!fAll) {
        break;
      }
    case IDM_OPTIONSSOUND:
      DialogBox(hInst, "Sound", hwnd, (FARPROC)SoundDlgProc);
      fAll = FALSE;
      break;
    case IDM_OPTIONSDESKTOP:
      DialogBox(hInst, "Desktop", hwnd, (FARPROC)DesktopDlgProc);
      break;
    case IDM_OPTIONSHARDWARE:
      if (UserIgnoresWindowsNT()) {
        DialogBox(hInst, "Hardware", hwnd, (FARPROC)HardwareDlgProc);
      }
      break;
    case IDM_OPTIONSPRINTERS:
      DialogBox(hInst, "Printers", hwnd, (FARPROC)PrintersDlgProc);
      break;
    case IDM_WINDOWHTILE:
      SendMessage(hwndClient, WM_MDITILE, MDITILE_HORIZONTAL, 0L);
      if (def.fAutoArrange && def.wAutoArrange != IDM_WINDOWHTILE) {
        def.wAutoArrange = IDM_WINDOWHTILE;
        SaveDefault();
      }
      break;
    case IDM_WINDOWVTILE:
      SendMessage(hwndClient, WM_MDITILE, MDITILE_VERTICAL, 0L);
      if (def.fAutoArrange && def.wAutoArrange != IDM_WINDOWVTILE) {
        def.wAutoArrange = IDM_WINDOWVTILE;
        SaveDefault();
      }
      break;
    case IDM_WINDOWCASCADE:
      SendMessage(hwndClient, WM_MDICASCADE, 0, 0L);
      if (def.fAutoArrange && def.wAutoArrange != IDM_WINDOWCASCADE) {
        def.wAutoArrange = IDM_WINDOWCASCADE;
        SaveDefault();
      }
      break;
    case IDM_WINDOWARRANGE:
      SendMessage(hwndClient, WM_MDIICONARRANGE, 0, 0L);
      break;
    case IDM_HELPCONTENTS:
      strcpy(pcStart, acHelpFile);
      WinHelp(hwnd, acStart, HELP_INDEX, 0);
      break;
    case IDM_HELPLAST:
      strcpy(pcStart, acHelpFile);
      WinHelp(hwnd, acStart, VK_BACK, 0);
      break;
    case IDM_HELPCONTEXT:
      Help(hwnd, IDM_HELPCONTEXT);
      break;
    case IDM_HELPONHELP:
      strcpy(pcStart, acHelpFile);
      WinHelp(hwnd, acStart, HELP_HELPONHELP, 0);
      break;
    case IDM_HELPABOUT:
      DialogBox(hInst, "About", hwnd, (FARPROC)AboutDlgProc);
      break;
    default:
      wDialogHelp = 0;
      goto Default;
    }
    wDialogHelp = 0;
    break;
  case WM_ENTERIDLE:
    if (hwndEnterIdle) {
      SendMessage(hwndEnterIdle, WM_ENTERIDLE, wParam, lParam);
    }
    break;
  case WM_TIMER:
    assert(wParam == 1);
    assert(wCtrlTab);
    if (!(*(byte __far *)0x00000417L & 0x04)) {
      if (hwndChild && GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)FileWndProc) {
        PostMessage(hwndFrame, WM_COMMAND, IDM_RUNSTART, 0);
      }
      KillTimer(hwnd, 1);
      wCtrlTab = 0;
    }
    break;
  case WM_KEYDOWN:
    if (wParam == VK_F1) {
      strcpy(pcStart, acHelpFile);
      WinHelp(hwnd, acStart, HELP_INDEX, 0);
      return TRUE;
    } else goto Default;
  case WM_HELP:
    SetFocus(hwnd);
    if (wParam > IDM_WINDOWCHILDREN && wParam < IDM_WINDOWCHILDREN + 100) {
      wParam = IDM_WINDOWCHILDREN;
    } else if (wParam < IDM_MENUFIRST ||
               wParam > IDM_MENULAST && wParam < IDM_POPUPFIRST ||
               wParam > IDM_POPUPLAST) break;
    Help(hwnd, wParam);
    break;
  case WM_INITMENU:
    InitMenu();
    break;
  case WM_SIZE:
    iFrameWidth = LOWORD(lParam);
    iFrameHeight = HIWORD(lParam);
    MoveWindow(hwndClient, 0, 0, iFrameWidth, iFrameHeight, TRUE);
    goto Default;
  case WM_NCLBUTTONDOWN:
    break;
  case WM_CLOSE:
    if (CloseAllWindows()) {
      goto Default;
    }
    break;
  case WM_DESTROY:
    PostQuitMessage(0);
    break;
  default:
  Default:
    return DefFrameProc(hwnd, hwndClient, wMsg, wParam, lParam);
  }
  return 0;
}

// Hauptmeldungsschleife
int MessageLoop() {
  MSG msg;
  while (GetMessage(&msg, NULL, 0, 0)) {
    if (!TranslateAccelerator(hwndFrame, hAccel, &msg)) {
      if (!TranslateMDISysAccel(hwndClient, &msg)) {
        if (hwndPassKeys) switch (msg.message) {
        case WM_KEYDOWN:
        case WM_SYSKEYDOWN:
        case WM_CHAR:
          if (SendMessage(hwndPassKeys, WM_PASSKEYS, msg.wParam, msg.lParam)) {
            continue;
          }
        }
        TranslateMessage(&msg);
        DispatchMessage(&msg);
      }
    }
    if (fDoArrange) {
      AutoArrange();
      fDoArrange = FALSE;
    }
  }
  return msg.wParam;
}

// Hilfefenster aufrufen
void Help(HWND hwndParent, word wContext) {
  strcpy(pcStart, acHelpFile);
  WinHelp(hwndParent, acStart, HELP_CONTEXT, wContext);
}

// Filterprozedur fr Dialoge und Messageboxen
LONG FAR PASCAL MsgFilter(int iCode, WORD, LPMSG lpmsg) {
  WORD w;
  HWND hwndParent;
  if (iCode == MSGF_DIALOGBOX) switch (lpmsg->message) {
  case WM_KEYDOWN:
  case WM_SYSKEYDOWN:
  case WM_CHAR:
    switch (lpmsg->wParam) {
    case VK_F1:
      // Avoid recursive calls of WinHelp()
      if (hwndHelp) {
        return FALSE;
      }
      hwndHelp = (HWND)-1;
      // Get the ID of the active control in the dialog
      w = GetFocus();
      assert(w);
      w = GetWindowWord(w, GWW_ID);
      if (w >= 1000 && w < 1200) {
        // Warn the programmer, if Marc has changed the IDs again
        #pragma warning(disable: 4127)
        assert(COMMFILE_EDIT == 1152);
        #pragma warning(default: 4127)
        // <File / Open> and <File / Save as> use the same dialog template,
        // but there are different help texts for them
        switch (wDialogHelp) {
        case IDM_FILESAVE:
        case IDM_FILESAVEAS:
          w += 200;
        case IDM_FILEOPEN:
          break;
        default:
          goto NotValid;
        }
      } else if (w < ID_DIALOG_FIRST || w > ID_DIALOG_LAST) {
      NotValid:
        // ID is not a valid number in RESOURCE.H, e.g. IDOK or IDCANCEL
        if (wDialogHelp) {
          // A global help context for this dialog exists
          w = wDialogHelp;
        } else {
          ErrorBox(NULL, acNoHelp);
          // Reset the anti-recurse flag (HWND)-1
          hwndHelp = NULL;
          // Eat the VK_F1
          return TRUE;
        }
      }
      // Get the handle of the message box
      hwndParent = GetParent(lpmsg->hwnd);
      // This line is needed for ComboBox controls
      if (!IS_DIALOG(WID_TO_WIN(hwndParent))) {
        hwndParent = GetParent(hwndParent);
      }
      assert(IS_DIALOG(WID_TO_WIN(hwndParent)));
      // Execute the modal help dialog
      strcpy(pcStart, acHelpFile);
      WinHelp(hwndParent, acStart, HELP_CONTEXT, w);
      // Reset the anti-recurse flag (HWND)-1
      hwndHelp = NULL;
      // Eat the VK_F1
      return TRUE;
    case VK_RETURN:
    case VK_CTRL_ENTER:
      if (lpmsg->hwnd == hwndMultiLineEdit) {
        assert(GetParent(hwndMultiLineEdit));
        if (lpmsg->wParam == VK_RETURN) {
          SendMessage(GetParent(hwndMultiLineEdit), WM_COMMAND, IDOK, 0);
          // Eat the keystroke
          return TRUE;
        } else {
          // Change <Ctrl+Enter> to <Enter>
          lpmsg->wParam = VK_RETURN;
          return FALSE;
        }
      }
    case VK_TAB:
    case VK_SH_TAB:
    case VK_ESC:
      // Prevent the message loop in DialogBox() from
      // catching WinHelp() dialog keys
      if (lpmsg->hwnd != hwndHelp) {
        return FALSE;
      }
      SendMessage(hwndHelp, lpmsg->message, lpmsg->wParam, lpmsg->lParam);
      // Eat the keystroke
      return TRUE;
    default:
      if (hwndMsgFilter) {
        if (SendMessage(hwndMsgFilter, lpmsg->message, lpmsg->wParam, lpmsg->lParam)) {
          return TRUE;
        }
      }
    }
  }
  // Handle the message normal
  return FALSE;
}

// Daten in Text oder Ziffernfolge wandeln und abschneiden
char* MakeStr(char* pText, word wLength, word wMax) {
  assert(pText);
  assert(wMax <= 80);
  static char sReturn[86];
  if (!wLength) {
    strcpy(sReturn, "\"\"");
    return sReturn;
  }
  word wIndex = 0;
  word awBreak[4];
  flag afBreak[4];
  word wBreak = 0;
  flag fText = FALSE;
  while (wLength-- && wIndex < wMax) {
    awBreak[wBreak] = wIndex;
    afBreak[wBreak] = fText;
    wBreak = wBreak + 1 & 3;
    if (!fText && wIndex) sReturn[wIndex++] = ',';
    if (*pText >= 32 && *pText < 127) {
      if (!fText) {
        sReturn[wIndex++] = '"';
        fText = TRUE;
      }
      sReturn[wIndex++] = *pText++;
    } else {
      if (fText) {
        sReturn[wIndex++] = '"';
        fText = FALSE;
        sReturn[wIndex++] = ',';
      }
      wIndex += sprintf(sReturn + wIndex, "%u", (byte)*pText++);
    }
  }
  if (fText) sReturn[wIndex++] = '"';
  sReturn[wIndex] = 0;
  if (wIndex < wMax) return sReturn;
  do wBreak = wBreak - 1 & 3;
  while (awBreak[wBreak] > wMax - (word)afBreak[wBreak]);
  if (afBreak[wBreak]) strcpy(sReturn + awBreak[wBreak], "...\"");
  else strcpy(sReturn + awBreak[wBreak], "...");
  return sReturn;
}

// Dateinamen kopieren und Defaulterweiterung hinzufgen
char* addext(char* pcPath, char* pcName, char* pcExt) {
  assert(pcPath);
  assert(pcName && *pcName);
  _fullpath(pcPath, pcName, 80);
  AnsiUpper(pcPath);
  if (pcExt && !strchr(pcPath, '.')) {
    strcat(pcPath, pcExt);
  }
  assert(*pcPath && strlen(pcPath) < 80);
  return pcPath;
}

// User auf Windows NT hinweisen
flag UserIgnoresWindowsNT() {
  if (!fWindowsNT) {
    return TRUE;
  }
  MessageBeep(MB_ICONEXCLAMATION);
  if (MessageBox(hwndFrame, acWindowsNT, acError, MB_ICONEXCLAMATION | MB_OKCANCEL | MB_DEFBUTTON2) == IDOK) {
    fWindowsNT = FALSE;
    return TRUE;
  }
  return FALSE;
}
