// ROMs auslesen

#include "pc64.h"

word GetLpt() {
  *(long*)L64State = -1;
  for (word wLpt = 0; wLpt < 4; wLpt++) {
    byte b = (byte)(0x20 + def.fScreenOn);
    if (L64Send(wLpt, &b, 1) == 1) {
      return wLpt;
    }
  }
  ErrorBox(NULL, acNoL64);
  return 65535;
}

BOOL FAR PASCAL ReadROMsDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    {
      strcpy(pcStart, "ORIGINAL.64K");
      if (_access(acStart, 0) != 0) {
        SetDlgItemText(hwnd, IDE_READROMS + 0, "ORIGINAL");
      }
      strcpy(pcStart, "ORIGINAL.64B");
      if (_access(acStart, 0) != 0) {
        SetDlgItemText(hwnd, IDE_READROMS + 1, "ORIGINAL");
      }
      strcpy(pcStart, "ORIGINAL.64C");
      if (_access(acStart, 0) != 0) {
        SetDlgItemText(hwnd, IDE_READROMS + 2, "ORIGINAL");
      }
      SetDlgItemText(hwnd, IDE_READDEVICE, "8");
      strcpy(pcStart, "VC1541.64D");
      if (_access(acStart, 0) != 0) {
        SetDlgItemText(hwnd, IDE_READROMS + 4, "VC1541");
      }
      char* pc = strrchr(acConfig, '\\');
      assert(pc);
      if (pc == acConfig + 2) {
        pc++;
      }
      char c = *pc;
      *pc = 0;
      SetDlgItemText(hwnd, IDE_ROMDIR, acConfig);
      *pc = c;
    }
    wDialogHelp = IDM_LINKREADROMS;
    if (GetLpt() == 65535) {
      EndDialog(hwnd, 0);
    }
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        word wLpt = GetLpt();
        if (wLpt == 65535) {
          return TRUE;
        }
        static byte abReadROMs[16] = {
          0x27,0xA2,0xE0,0xA0,0x20,0xA9,0x00,0x85,0xF7,0x86,0xF8,0x85,0xF9,0x84,
          0xFA,0x60
        };
        static byte abReadCharSet[50] = {
          0x27,0x78,0xA9,0x33,0x85,0x01,0xA9,0xD0,0xA2,0xC0,0xA0,0x00,0x84,0xF7,
          0x85,0xF8,0x84,0xF9,0x86,0xFA,0xA2,0x10,0xB1,0xF7,0x91,0xF9,0xC8,0xD0,
          0xF9,0xE6,0xF8,0xE6,0xFA,0xCA,0xD0,0xF2,0xA9,0xC0,0x85,0xF8,0xA9,0x10,
          0x85,0xFA,0xA9,0x37,0x85,0x01,0x58,0x60
        };
        static byte abReadFloppy[117] = {
          0x27,0xA9,0x08,0x85,0xBA,0xA0,0x00,0xA9,0x40,0x84,0xF7,0x85,0xF8,0x84,
          0xF9,0x84,0xFA,0x84,0x90,0xA5,0xBA,0x20,0x0C,0xED,0xA5,0x90,0xD0,0x58,
          0xA9,0x6F,0x20,0xB9,0xED,0xA9,0x4D,0x20,0xDD,0xED,0xA9,0x2D,0x20,0xDD,
          0xED,0xA9,0x52,0x20,0xDD,0xED,0x98,0x20,0xDD,0xED,0xA5,0xF8,0x09,0x80,
          0x20,0xDD,0xED,0xA9,0x20,0x20,0xDD,0xED,0x20,0xFE,0xED,0xA5,0x90,0xD0,
          0x2D,0xA5,0xBA,0x20,0x09,0xED,0xA5,0x90,0xD0,0x24,0xA9,0x6F,0x20,0xC7,
          0xED,0xA2,0x20,0x20,0x13,0xEE,0x91,0xF7,0xC8,0xCA,0xD0,0xF7,0x20,0xEF,
          0xED,0xA5,0x90,0xD0,0x0D,0x98,0xD0,0xA9,0xE6,0xF8,0x10,0xA5,0xA9,0x40,
          0x85,0xF8,0x85,0xFA,0x60
        };
        char acDir[80];
        GetDlgItemText(hwnd, IDE_ROMDIR, acDir, 80);
        char* pcName = strend(acDir);
        if (pcName != acDir && pcName[-1] != '\\') {
          *pcName++ = '\\';
        }
        byte* pbBuffer = (byte*)malloc(16384);
        assert(pbBuffer);
        for (int i = 0; i < 5; i++) {
          GetDlgItemText(hwnd, IDE_READROMS + i, pcName, 9);
          if (*pcName) {
            SetFocus(GetDlgItem(hwnd, IDE_READROMS + i));
            switch (i) {
            case 0:
              strcat(pcName, ".64K");
              abReadROMs[2] = 0xE0;
              L64Send(wLpt, abReadROMs, 16);
              break;
            case 1:
              strcat(pcName, ".64B");
              abReadROMs[2] = 0xA0;
              L64Send(wLpt, abReadROMs, 16);
              break;
            case 2:
              strcat(pcName, ".64C");
              L64Send(wLpt, abReadCharSet, 50);
              break;
            case 3:
              strcat(pcName, ".64M");
              abReadROMs[2] = 0x80;
              L64Send(wLpt, abReadROMs, 16);
              break;
            case 4:
              strcat(pcName, ".64D");
              abReadFloppy[2] = (byte)GetDlgItemInt(hwnd, IDE_READDEVICE, NULL, FALSE);
              L64Send(wLpt, abReadFloppy, 117);
              break;
            }
            if (i == 4) {
              for (int iTry = 0; iTry < 2000; iTry++) {
                if (L64Receive(wLpt, pbBuffer, 16384) >= 0) {
                  goto OK;
                }
              }
              free(pbBuffer);
              return ErrorBox(NULL, acNoL64);
            OK:
              if (L64Result == 0) {
                free(pbBuffer);
                #if GERMAN
                  return ErrorBox(NULL, "Das externe Diskettenlaufwerk am C64 ist nicht bereit!");
                #else
                  return ErrorBox(NULL, "The external C64 drive is not ready!");
                #endif
              }
            } else {
              if (L64Receive(wLpt, pbBuffer, 16384) < 0) {
                free(pbBuffer);
                return ErrorBox(NULL, acNoL64);
              }
            }
            if (access(acDir, 0) == 0) {
              char ac[256];
              #if GERMAN
                sprintf(ac, "Die Datei %s gibt es bereits. Wollen Sie sie berschreiben?", acDir);
              #else
                sprintf(ac, "%s exists. Overwrite?", acDir);
              #endif
              MessageBeep(MB_ICONQUESTION);
              if (MessageBox(hwnd, ac, acConfirm, MB_ICONQUESTION | MB_OKCANCEL) != IDOK) {
                free(pbBuffer);
                return FALSE;
              }
            }
            if (i == 0) { // Kernal
              if (!memcmp(pbBuffer + 0x1D83, "\xC8\xD0\xE8\xF0\xE4", 5)) {
                MessageBeep(MB_ICONQUESTION);
                if (MessageBox(hwnd,
                               #if GERMAN
                                 "Wollen Sie den in der Emulation unntigen Speichertest verkrzen?",
                               #else
                                 "Do you want to use the fast memory test?",
                               #endif
                               acConfirm, MB_ICONQUESTION | MB_YESNO) == IDYES) {
                  *(long*)(pbBuffer + 0x1D83) = 0xF0FD6C4C;
                }
              }
              if (!memcmp(pbBuffer + 0x01D9, "\xA2\x01\xA0\x00\x20\xBA\xFF", 7)) {
                MessageBeep(MB_ICONQUESTION);
                if (MessageBox(hwnd,
                               #if GERMAN
                                 "Wollen Sie die Vorgabe der Gerteadresse bei LOAD von 1 auf 8 ndern?",
                               #else
                                 "Do you want to change the default LOAD device from 1 to 8?",
                               #endif
                               acConfirm, MB_ICONQUESTION | MB_YESNO) == IDYES) {
                  pbBuffer[0x01DA] = 8;
                }
              }
            }
            int hFile = _open(acDir, _O_BINARY | _O_RDWR | _O_CREAT | _O_TRUNC, _S_IREAD | _S_IWRITE);
            if (hFile == -1) {
              free(pbBuffer);
              return ErrorBox(acDir, NULL);
            }
            if (_write(hFile, pbBuffer, L64Result) == -1) {
              free(pbBuffer);
              ErrorBox(acDir, NULL);
              _close(hFile);
              return FALSE;
            }
            if (_close(hFile) == -1) {
              free(pbBuffer);
              return ErrorBox(acDir, NULL);
            }
            SetDlgItemText(hwnd, IDE_READROMS + i, NULL);
            UpdateWindow(GetDlgItem(hwnd, IDE_READROMS + i));
          }
        }
        free(pbBuffer);
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}
