// Emulation eines Druckers

#include "pc64.h"
#pragma warning(disable: 4127)

// Konstruktor
CPrinter::CPrinter() {
  acFileName[0] = 0;
  hFile = 0;
  wIndex = 0;
  wConvert = 0;
}

// Destruktor
CPrinter::~CPrinter() {
  Flush(TRUE);
}

// Typ liefern
word CPrinter::GetType() {
  return DEVPRINTER;
}

// Puffer schreiben
flag CPrinter::Flush(flag fClose) {
  flag fReturn = TRUE;
  if (hFile > 0) {
    if (wIndex) {
      fReturn = _write(hFile, abBuffer, wIndex) == (int)wIndex;
      wIndex = 0;
    }
    if (fClose) {
      _close(hFile);
      hFile = 0;
    }
  }
  return fReturn;
}

// Datei ffnen
#pragma optimize("leg", off)
flag CPrinter::OpenFile() {
  assert(!hFile);
  if (!acFileName[0]) {
    return FALSE;
  }
  hFile = _open(acFileName, _O_BINARY | _O_CREAT | _O_WRONLY, _S_IREAD | _S_IWRITE);
  if (hFile == -1) {
    hFile = 0;
    return FALSE;
  }
  fIsATTY = _isatty(hFile);
  if (fIsATTY) {
    int hTemp = hFile;
    __asm {
      mov BX,hTemp;
      mov AX,4400h
      int 21h
      or DL,00100000b // Set file handle to RAW mode
      xor DH,DH       // Highbyte must be 0
      mov AX,4401h
      int 21h
    }
  } else {
    _lseek(hFile, 0, SEEK_END);
  }
  return TRUE;
}
#pragma optimize("", on)

// Ein Zeichen auf dem Drucker ausgeben
flag CPrinter::Print(byte bValue) {
  if (wIndex < 256) {
    abBuffer[wIndex++] = bValue;
  }
  if (hFile == 0) {
    return OpenFile() && Flush(FALSE);
  }
  if (bValue == 13 || bValue == 10 || bValue == 12) {
    return Flush(FALSE);
  }
  if (wIndex >= 256) {
    return Flush(FALSE);
  }
  return TRUE;
}

// Neuen Dateinamen setzen
flag CPrinter::SetDir(char* pDir) {
  Flush(TRUE);
  strcpy(acFileName, pDir);
  return TRUE;
}

// Aktuellen Dateinamen auslesen
void CPrinter::GetDir(char* pDir, word wMax) {
  strncpy(pDir, acFileName, wMax);
}

// Zeichenumsetzung setzen
void CPrinter::SetConvert(word w) {
  assert(w < 4);
  wConvert = w;
}

// Zeichenumsetzung auslesen
word CPrinter::GetConvert() {
  return wConvert;
}

// Drucker zurcksetzen
word CPrinter::Reset() {
  Flush(TRUE);
  return 0;
}

// Befehl abschicken
word CPrinter::Command(char* sCommand, word wLength) {
  while (wLength--) {
    word w = Put(15, *sCommand++);
    if (w) {
      return w;
    }
  }
  return 0;
}

// Fehlermeldung holen
word CPrinter::GetError(char* pBuffer, word wMax) {
  *pBuffer = 0;
  return ENDOFFILE;
}

// Status in Image schreiben
flag CPrinter::Save(int hFile) {
  return TRUE;
}

// Status aus Image lesen
flag CPrinter::Load(int hFile) {
  return TRUE;
}

// C64-Dateien unter DOS ffnen
word CPrinter::Start() {
  return 0;
}

// C64-Dateien unter DOS schlieen
word CPrinter::Stop() {
  Flush(TRUE);
  return 0;
}

// Datei oder Verzeichnis ffnen
word CPrinter::Open(word wChannel, char* pcName, word wLength) {
  while (wLength--) {
    word w = Put(wChannel, *pcName++);
    if (w) {
      return w;
    }
  }
  return 0;
}

// Zeichen auf Drucker schreiben
word CPrinter::Put(word wChannel, byte bValue) {
  word w = wConvert;
  if (w == 0) {
    if (wChannel == 0) {
      w = 2;
    } else {
      if (wChannel == 7) {
        w = 3;
      } else {
        if (wChannel == 8) {
          w = 4;
        }
      }
    }
  }
  if (w >= 2) {
    switch (bValue) {
    case 10:
      if (w != 4) {
        return 0;
      }
      break;
    case 13:
    case 141:
      if (w != 4) {
        if (!Print(13)) {
          return ENODEVICE;
        }
        bValue = 10;
      }
      break;
    case 0x5B:
    case 0x5C:
    case 0x5D:
    case 0x7B:
    case 0x7C:
    case 0x7D:
    case 0x7E:
      if (w == 4) {
        break;
      }
    default:
      switch (bValue & ~0x1F) {
      case 0x00:
        if (w == 4) {
          break;
        }
      case 0x40:
        if (w == 2) {
          bValue = "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^"[bValue & 0x1F];
        } else {
          bValue = "@abcdefghijklmnopqrstuvwxyz[]^"[bValue & 0x1F];
        }
        break;
      case 0x80:
        if (w == 4) {
          break;
        }
      case 0x60:
      case 0xC0:
        if (w == 2) {
          bValue = "ĳ\\/ڿXOű\\"[bValue & 0x1F];
        } else {
          bValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZű\\"[bValue & 0x1F];
        }
        break;
      case 0xA0:
      case 0xE0:
        bValue = " _/´߲"[bValue & 0x1F];
        if (bValue == (byte)'' && w == 2) {
          bValue = '';
        }
        break;
      }
      break;
    }
  }
  if (!Print(bValue)) {
    return ENODEVICE;
  }
  return 0;
}

// Ende Schreiben
word CPrinter::Unlisten() {
  return 0;
}

// Zeichen aus Datei lesen
word CPrinter::Get(word wChannel) {
  return EINPUT;
}

// Block schreiben
word CPrinter::Write(word wChannel, byte* pbBuffer, word* pwCount) {
  assert(0);
  return ENODEVICE;
}

// Block lesen
word CPrinter::Read(word wChannel, byte* pbBuffer, word* pwCount) {
  assert(0);
  return ENODEVICE;
}

// Datei schliessen
word CPrinter::Close(word wChannel) {
  if (!Flush(FALSE)) {
    return ENODEVICE;
  }
  return 0;
}

// Satzlnge einer relativen Datei liefern
byte CPrinter::GetRelLength(word wChannel) {
  assert(0);
  return 0;
}

// Disketten kopieren
flag CPrinter::BeginTrack(flag fWrite) {
  assert(0);
  return FALSE;
}

word CPrinter::ReadNextTrack(byte* pbBuffer) {
  assert(0);
  return 0;
}

flag CPrinter::WriteNextTrack(byte* pbBuffer, word wLength) {
  assert(0);
  return FALSE;
}

flag CPrinter::EndTrack() {
  assert(0);
  return FALSE;
}
