// Verwaltung der Joysticks

#include "pc64.h"

BOOL FAR PASCAL JoysticksDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  JOYSTICK joystick;
  int i;
  word w;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    CheckRadioButton(hwnd, IDB_JOYSTICK1, IDB_JOYSTICK1 + 7, IDB_JOYSTICK1 + pfw->c.joystick.awPort[0]);
    CheckRadioButton(hwnd, IDB_JOYSTICK2, IDB_JOYSTICK2 + 7, IDB_JOYSTICK2 + pfw->c.joystick.awPort[1]);
    CheckRadioButton(hwnd, IDB_FIRE1, IDB_FIRE1 + 2, IDB_FIRE1 + pfw->c.joystick.awFire[0]);
    CheckRadioButton(hwnd, IDB_FIRE2, IDB_FIRE2 + 2, IDB_FIRE2 + pfw->c.joystick.awFire[1]);
    for (i = 0; i < 2; i++) {
      char acHz[20];
      real rHz = 985250.0 / (pfw->c.joystick.alStart[i] * 2);
      if (rHz >= 100.0) sprintf(acHz, "%.0f", rHz);
      else if (rHz >= 10.0) sprintf(acHz, "%.1f", rHz);
      else sprintf(acHz, "%.2f", rHz);
      if (strchr(acHz, '.')) {
        char* pc = strend(acHz);
        while (pc[-1] == '0') pc--;
        if (pc[-1] == '.') pc--;
        *pc = 0;
      }
      SetDlgItemText(hwnd, i ? IDE_FIRE2 : IDE_FIRE1, acHz);
    }
    CheckDlgButton(hwnd, IDB_GREYJOYSTICK, (def.c.timing.wRealTime & 0x8000) != 0);
    CheckDlgButton(hwnd, IDB_LEFTCONTROL, (def.c.timing.wRealTime & 0x4000) != 0);
    SetFocus(GetDlgItem(hwnd, IDB_JOYSTICK1 + pfw->c.joystick.awPort[0]));
    wDialogHelp = IDM_OPTIONSJOYSTICKS;
    return FALSE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      assert(pfw);
      for (i = 0; i < 8; i++) if (IsDlgButtonChecked(hwnd, IDB_JOYSTICK1 + i)) joystick.awPort[0] = i;
      for (i = 0; i < 8; i++) if (IsDlgButtonChecked(hwnd, IDB_JOYSTICK2 + i)) joystick.awPort[1] = i;
      for (i = 0; i < 3; i++) if (IsDlgButtonChecked(hwnd, IDB_FIRE1 + i)) joystick.awFire[0] = i;
      for (i = 0; i < 3; i++) if (IsDlgButtonChecked(hwnd, IDB_FIRE2 + i)) joystick.awFire[1] = i;
      for (i = 0; i < 2; i++) {
        joystick.alCount[i] = pfw->c.joystick.alCount[i];
        joystick.awFlags[i] = pfw->c.joystick.awFlags[i];
        char acHz[20];
        GetDlgItemText(hwnd, i ? IDE_FIRE2 : IDE_FIRE1, acHz, 20);
        real rHz = strtod(acHz, NULL);
        if (rHz < 0.01) rHz = 0.01;
        else if (rHz > 999.0) rHz = 999.0;
        joystick.alStart[i] = (long)(985250.0 / (rHz * 2));
        if (joystick.alCount[i] > joystick.alStart[i]) {
          joystick.alCount[i] = joystick.alStart[i];
        }
      }
      if (memcmp(&joystick, &pfw->c.joystick, sizeof JOYSTICK)) {
        pfw->c.joystick = joystick;
        pfw->fModified = TRUE;
        Database(pfw, TRUE);
      }
      if (IsDlgButtonChecked(hwnd, IDB_DEFJOYSTICKS)) {
        if (memcmp(&joystick, &def.c.joystick, sizeof JOYSTICK)) {
          def.c.joystick = joystick;
          SaveDefault();
        }
      }
      w = def.c.timing.wRealTime & 0x3FFF;
      if (IsDlgButtonChecked(hwnd, IDB_GREYJOYSTICK)) {
        w |= 0x8000;
      }
      if (IsDlgButtonChecked(hwnd, IDB_LEFTCONTROL)) {
        w |= 0x4000;
      }
      if (w != def.c.timing.wRealTime) {
        def.c.timing.wRealTime = w;
        SaveDefault();
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
