// Menpunkte sperren

#include "pc64.h"

void InitMenu() {
  EnableMenuItem(hmenu, IDM_FILERELOAD, MF_GRAYED);
  EnableMenuItem(hmenu, IDM_FILESAVE, MF_GRAYED);
  EnableMenuItem(hmenu, IDM_RUNCLEAR, MF_GRAYED);
  int iFile = MF_GRAYED;
  int iLog = MF_GRAYED;
  int iNext = MF_GRAYED;
  if (pfw) {
    assert(hwndChild);
    iFile = MF_ENABLED;
    if (pfw->acLogName[0]) {
      iLog = MF_ENABLED;
      if (fSearchAdr || acSearchText[0]) {
        iNext = MF_ENABLED;
      }
    }
    if (pfw->fModified || pfw->fTemp) {
      if (pfw->acFileName[0]) EnableMenuItem(hmenu, IDM_FILERELOAD, MF_ENABLED);
      EnableMenuItem(hmenu, IDM_FILESAVE, MF_ENABLED);
    }
  }
  EnableMenuItem(hmenu, IDM_FILEDUPLICATE, iFile);
  EnableMenuItem(hmenu, IDM_FILESAVEAS, iFile);
  EnableMenuItem(hmenu, IDM_SEARCHTEXT, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHADR, iLog);
  CheckMenuItem(hmenu, IDM_SEARCHTEXT, !fSearchAdr && acSearchText[0] ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(hmenu, IDM_SEARCHADR, fSearchAdr ? MF_CHECKED : MF_UNCHECKED);
  EnableMenuItem(hmenu, IDM_SEARCHNEXT, iNext);
  EnableMenuItem(hmenu, IDM_SEARCHPREV, iNext);
  EnableMenuItem(hmenu, IDM_NEXTERROR, iLog);
  EnableMenuItem(hmenu, IDM_PREVERROR, iLog);
  flag fZoomed = IsZoomed(hwndChild);
  HMENU hmenuSub = GetSubMenu(hmenu, SEARCHMENUPOS + fZoomed);
  assert(hmenuSub);
  EnableMenuItem(hmenuSub, EVENTSMENUPOS, MF_BYPOSITION | iLog);
  EnableMenuItem(hmenu, IDM_SEARCHLINE, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHREM, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHVIC, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHSID, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHCIA, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHIEC, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHDEV, iLog);
  EnableMenuItem(hmenu, IDM_SEARCHINT, iLog);
  EnableMenuItem(hmenu, IDM_RUNSTART, iFile);
  EnableMenuItem(hmenu, IDM_RUNRESET, iFile);
  EnableMenuItem(hmenu, IDM_RUNTOTALRESET, iFile);
  EnableMenuItem(hmenu, IDM_RUNDEBUG, iFile);
  EnableMenuItem(hmenu, IDM_RUNRESETDEBUG, iFile);
  EnableMenuItem(hmenu, IDM_RUNFILTERS, iFile);
  EnableMenuItem(hmenu, IDM_RUNCLEAR, iLog);
  EnableMenuItem(hmenu, IDM_OPTIONSFILE, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSROMS, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSKEYBOARD, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSJOYSTICKS, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSFLOPPIES, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSTIMING, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSSOUND, iFile);
  EnableMenuItem(hmenu, IDM_OPTIONSALL, iFile);
  int iFileWnd = MF_GRAYED;
  int iFiles = MF_GRAYED;
  int iExecute = MF_GRAYED;
  int iImport = MF_GRAYED;
  int iMakeDirOrImage = MF_GRAYED;
  int iIsDir = MF_GRAYED;
  int iIsImage = MF_GRAYED;
  int iIsImageOrLink = MF_GRAYED;
  if (hwndChild && GetWindowLong(hwndChild, GWL_WNDPROC) == (LONG)LinkWndProc) {
    iFileWnd = MF_ENABLED;
    LINKWND* plw = (LINKWND*)GetWindowLong(hwndChild, 0);
    assert(plw);
    assert(plw->hwndDirTree);
    assert(plw->hwndListBox);
    char ac[80];
    if (plw->hwndFocus == plw->hwndListBox) {
      iImport = MF_ENABLED;
      int iIndex = (int)SendMessage(plw->hwndListBox, LB_GETCARETINDEX, 0, 0);
      if (iIndex >= 0 && SendMessage(plw->hwndListBox, LB_GETTEXT, iIndex, (LONG)(LPSTR)ac) > 0) {
        assert(strlen(ac) < 19);
        if (strend(ac)[-2] != ',') {
          iExecute = MF_ENABLED;
        }
      }
      if (SendMessage(plw->hwndListBox, LB_GETCOUNT, 0, 0) > 0) {
        iFiles = MF_ENABLED;
      }
    }
    GetWindowText(plw->hwndDirTree, ac, 80);
    if (IsLink(ac)) {
      iIsImageOrLink = MF_ENABLED;
    } else if (IsImage(ac)) {
      iIsImage = MF_ENABLED;
      iIsImageOrLink = MF_ENABLED;
    } else {
      iMakeDirOrImage = MF_ENABLED;
      if (strlen(ac) > 3) {
        iIsDir = MF_ENABLED;
      }
    }
  }
  EnableMenuItem(hmenu, IDM_LINKEXECUTE, iExecute);
  EnableMenuItem(hmenu, IDM_LINKRENAME, iFiles);
  EnableMenuItem(hmenu, IDM_LINKMOVE, iFiles);
  EnableMenuItem(hmenu, IDM_LINKCOPY, iFiles);
  EnableMenuItem(hmenu, IDM_LINKDELETE, iFiles);
  EnableMenuItem(hmenu, IDM_LINKIMPORT, iImport);
  EnableMenuItem(hmenu, IDM_LINKEXPORT, iFiles);
  hmenuSub = GetSubMenu(hmenu, LINKMENUPOS + fZoomed);
  assert(hmenuSub);
  EnableMenuItem(hmenuSub, DIRMENUPOS, MF_BYPOSITION | iMakeDirOrImage);
  EnableMenuItem(hmenuSub, IMAGEMENUPOS, MF_BYPOSITION | iFileWnd);
  EnableMenuItem(hmenu, IDM_LINKMAKEDIR, iMakeDirOrImage);
  EnableMenuItem(hmenu, IDM_LINKRENAMEDIR, iIsDir);
  EnableMenuItem(hmenu, IDM_LINKDELDIR, iIsDir);
  EnableMenuItem(hmenu, IDM_LINKMAKEIMAGE, iMakeDirOrImage);
  EnableMenuItem(hmenu, IDM_LINKRENAMEIMAGE, iIsImage);
  EnableMenuItem(hmenu, IDM_LINKCOPYIMAGE, iIsImageOrLink);
  EnableMenuItem(hmenu, IDM_LINKCOPYSLOW, iIsImageOrLink);
  EnableMenuItem(hmenu, IDM_LINKDELIMAGE, iIsImage);
  EnableMenuItem(hmenu, IDM_LINKREFRESH, iFileWnd);
  int iChildren = wChildren ? MF_ENABLED : MF_GRAYED;
  EnableMenuItem(hmenu, IDM_WINDOWHTILE, iChildren);
  EnableMenuItem(hmenu, IDM_WINDOWVTILE, iChildren);
  EnableMenuItem(hmenu, IDM_WINDOWCASCADE, iChildren);
  int iIcons = MF_GRAYED;
  for (HWND hwnd = GetWindow(hwndClient, GW_CHILD); hwnd; hwnd = GetWindow(hwnd, GW_HWNDNEXT)) {
    if (IsIconic(hwnd)) {
      iIcons = MF_ENABLED;
      break;
    }
  }
  EnableMenuItem(hmenu, IDM_WINDOWARRANGE, iIcons);
}
