#test
#h.pg1
#h.default
#h.notfound
#h.contents
#pc64.hlp
#PC64
#Personal C64
#@0
0Contents

    <Copyright>
    <Installation>
    <Introduction>
    <Command reference>
    <Tips and tricks>
    <Programming>
    <Appendix>

\bQuick start\p

    Running D64 and P00 programs: <Manager / New>, select a directory or a
    D64 disk image with the cursor keys, press Tab to enter the file list on
    the right side, select the program and press Enter. You will get back to
    the main screen with Esc. Windows can be closed with Ctrl+F4.

    Running T64 programs: Use T64TOP00.EXE to convert them to P00.

    Changing the disk in a multi disk game: Press F9, then select another
    directory or D64 disk image and klick OK. Confirm the disk change to the
    C64 program.

    Joystick emulation with keyboard: Control with the white arrow keys in
    the number pad, the fire button is the right Ctrl key. You can change
    the emulated joystick port with F10.

    Analog IBM joystick: Use SETJOY.EXE to set up all games for "Analog A".
    If there are problems, use TESTJOY.EXE.

    Digital C64 joystick: Test the function with <Options / Waitstates>,
    and set up all games for "LPTx" with SETJOY.EXE.

    Emulation is too slow: Increase
    <Options / Timing / Update screen every xth vertical refresh> to 3 or 4.

    Converting texts to DOS: Copy the text files to an empty subdirectory
    with the manager and run CBMTEXT directory\\*.?00 from the DOS shell.

    Converting graphics to DOS: Load a memory resident snapshot program
    (e.g. Screen Thief), start the emulator, load the C64 painting program.
    Load and display the picture in full screen mode, and use the hot key of
    the snapshot program to save the picture.

    Getting C64 games: Ask in "news:comp.emulators.cbm".

    Transferring 1541 disks: Use the Star Commander SC*.ZIP from
    ftp://ftp.funet.fi/pub/cbm/transfer/1541-to-PC

----------------------------------------------------------------------------
1Copyright

                               \bPersonal C64
                           Version 1.22 for DOS\p
                        Public Domain (no Copyright)

                             \bSystem software:\p
          Copyright (C) 1982-1995 Commodore Business Machines, Inc.
                 Basic V2 Copyright (C) 1979-1995 Microsoft

                                 \bDesktop:\p
                 MEWEL Window System Version 4.0 Text Mode
                    Copyright (C) 1989-1995 Magma Systems

                                \bFastloader:\p
                             Michael Niemeyer

                               \bTranslation:\p
                               Marko Mkel

                               \bTrade marks:\p
                     C64, C128, 1541, 1571: Commodore
                  MS-DOS, Windows, Windows NT: Microsoft
                                 OS/2: IBM
                           DesqView: Quarterdeck
                         Stacker: Stac Electronics
                       Sound Blaster: Creative Labs
                               Adlib: Adlib

----------------------------------------------------------------------------
1Installation

    <The installation program>
    <Adjusting for special operating systems>
    <Files used by the emulator>
    <Compatibility test with unknown floppy drives>

----------------------------------------------------------------------------
2The installation program

    To install Personal C64 to your hard disk, start the installation
    program INSTALL.EXE. It is located on the first
    diskette. Enter

    C:\\>a:install

    and press Return. The installation program will then ask for a
    destination drive. Simply press C here. Now the files will be unpacked
    to C:\\PC64. If there was an older version of the emulator in this
    directory, the configuration files are not overwritten. That's all, now
    you can start the emulator with

    C:\\PC64>pc64

    If you press Esc instead of specifying a destination drive, you can
    install PC64 to a different directory. Esc will also allow you to
    overwrite your configuration files.

----------------------------------------------------------------------------
2Adjusting for special operating systems

    PC64 is a DOS program, but you can use it under other operating systems
    if they can start DOS programs.

    <Windows and Windows NT>
    <No screen refresh under Windows 3.1 Enhanced Mode with ET3000 drivers>
    <Workplace Shell of OS/2>
    <Linux dosemu>
    <Configuration files in network>

----------------------------------------------------------------------------
3Windows and Windows NT

    In order to install PC64 as an icon in Windows 3.1 or Windows NT 3.1 for
    easy execution, follow these steps:

    1. Select a program group. Start the Program manager and activate the
       program group in which you want to insert the icon for the C64
       emulator.

    2. Create a new program item. Activate the Program manager menu item
       "File / New". A dialog box with multiple text controls will be
       opened.

    3. Input the program parameters. Type "Personal C64" in the control
       Program description. Go to the control Command line with Tab and
       type PC64.EXE. Now go further to the control Working directory with
       Tab and input the directory name where the emulator was installed,
       for instance C:\\PC64.

    4. Select the icon. Click on the button Another symbol. An error
       message will be displayed that can be ignored. Specify the full
       path of the icon file, for example C:\\PC64\\PC64WIN.ICO, and confirm
       the selection twice with the Enter key. Then you land in the
       original dialog box, which can now be closed with OK.

    5. Start the program. To start the C64 emulator, double click on the
       C64 symbol with the mouse.

----------------------------------------------------------------------------
3No screen refresh under Windows 3.1 Enhanced Mode with ET3000 drivers

    If you are using the ET3000 display drivers with 256 colors in full
    screen mode, the picture will freeze in a couple of seconds. However,
    the C64 program still continues to run in the background. After
    pressing Esc and F5 it will work a couple of seconds again.

    This error does not occur in the Standard mode. The 256 color drivers
    from other companies should also work.

----------------------------------------------------------------------------
3Workplace Shell of OS/2

    In order to install PC64 as an icon in OS/2 2.0 or 2.1 for easy
    execution, follow these steps:

    1. Create a new program item. Open the file Templates and drag the icon
       Program to the desktop. Fill the edit control Path and filename with
       the full path of the C64 emulator, for instance C:\\PC64\\PC64.EXE.

    2. Change the DOS settings. Go to the page Session and activate the
       setting DOS-Full screen. Click on the button DOS settings and enter
       the following values, which differ from the default:

       \bSetting                    Value\p
       DOS_BACKGROUND_EXECUTION   OFF
       EMS_FRAME_LOCATION         NONE
       HW_TIMER                   ON
       IDLE_SENSITIVITY           100
       VIDEO_RETRACE_EMULATION    OFF
       XMS_MEMORY_LIMIT           1024

       Confirm your modifications with the corresponding command button.

    3. Select the icon. Go to the page General and enter the title Personal
       C64. Click on the button Search and input the program directory, e.g.
       C:\\PC64. Start the search for icons with Enter. A dialog box will be
       opened, in which you select the icon PC64OS2.ICO. Confirm the dialog
       box with OK. Now you can close the setting window.

    4. Start the program. To start the C64 emulator, double click on the C64
       symbol with the mouse. To gain as much speed as possible, turn the
       switch DOS_BACKGROUND_EXECUTION of other running DOS applications to
       OFF.

----------------------------------------------------------------------------
3Linux dosemu

    The emulator has been used on Linux with kernel versions 1.1.64 to
    1.1.73 and dosemu 0.53.35. If you get a newer version of dosemu, you may
    need to upgrade the Linux kernel as well.

    This instruction assumes that dosemu is already running. Note that the
    configuration file /etc/dosemu.conf must be edited to allow graphics.
    Disable the video BIOS shadowing and use the setting
    "allowvideoportaccess on". Uncomment the "video" line that corresponds
    to your display adapter.

    You should be able to start PC64 from the DOS command line, just like
    you would do in MS-DOS. If you want to use the joysticks or the L64
    link, you may need to edit /etc/dosemu.conf to grant access to the
    corresponding I/O ports. The sound is not likely to work, even though
    you grant access to the AdLib or Soundblaster registers. The
    SoundBlaster registers are at 0x210-0x29f, depending on the jumper
    settings.

    ports { 0x201 }                      # analog joystick
    ports { 0x378 0x379 0x37a 0x37b }    # LPT1
    ports { 0x3bc 0x3bd 0x3be 0x3bf }    # LPT2
    ports { 0x278 0x279 0x27a 0x27b }    # LPT3
    ports { 0x2bc 0x2bd 0x2be 0x2bf }    # LPT4
    ports { 0x388 0x389 }                # AdLib

    Note that there is a bug in dosemu: If a DOS program is running in
    graphics mode, and you switch to another console with Ctrl+Alt+Function
    key (F1-F8) and back to dosemu, the graphics screen will not be updated.
    If you haven't set <Options / Desktop / VGA has VL or PCI bus>, you have
    to press ESC and F5 after switching back to PC64 in order to refresh the
    C64 screen.

----------------------------------------------------------------------------
3Configuration files in network

    If PC64 is installed to a network, write access to the configuration
    files should be denied, because the users would have to work with the
    same settings. As a system manager, you should execute the commands

    attrib +r pc64.cfg

    and possibly also

    attrib +r pc64.pdb.

    When a new user starts PC64, these configuration files cannot be opened
    in the PC64 directory, as they are write protected now. The emulator
    creates them in the current directory and asks the user to move the
    files to a local directory that is in the search path. As a result, all
    net users can use their own configuration.

    You can make an exception with the file PC64.PDB. It contains the
    settings for programs that get started with <Manager / Run>. If this
    file is in the PC64 directory, then all C64 programs must be adapted for
    the emulator only once. Alas, it does not work very well, if the clients
    in the system are of different speed. For instance, if a 386DX-40 user
    sets the screen refresh rate to 4, the 486DX2-66 users will get angry
    about the flickering screen. On the other hand, a 386DX-40 is too slow
    with the setting 2.

    The configuration file DRIVES.INI should not be write protected, so that
    you only need to check the compatibility of different external C64 disk
    drives once.

----------------------------------------------------------------------------
2Files used by the emulator

    Here is the description for all files that can have something to do with
    the C64 emulator. If you are running out of hard disk space, you can
    delete all files except PC64.EXE and ORIGINAL.*. If you delete the
    configuration files, they will be created when you run PC64 again. Your
    old settings will of course be lost.

    The following files are in the PC64 directory. It is also the place for
    the executable file PC64.EXE. The default name for the start directory
    is C:\\PC64.

    \bFilename       Meaning\p
    PC64.EXE       Executable emulator program file
    PC64.HLP       The file for online help.
    PC64WIN.ICO    C64 icon for Windows and Windows NT
    PC64OS2.ICO    C64 icon for OS/2
    CBMWIN.ICO     Commodore icon for Windows and Windows NT
    CBMOS2.ICO     Commodore icon for OS/2
    C64TVWIN.ICO   C64 with monitor as icon for Windows and Windows NT
    C64TVOS2.ICO   C64 with monitor as icon for OS/2
    SCRWIN.ICO     C64 startup screen icon for Windows and Windows NT
    SCROS2.ICO     C64 startup screen icon for OS/2
    T64TOP00.EXE   Converts T64 files from the C64S emulator
    T64TOP00.CPP   Source code for T64TOP00.EXE for Visual C++ 1.0.
                   Includes the function ReduceName() for truncating 16
                   characters long C64 filenames to 8 chars long DOS
                   names
    NEWNAME.EXE    Converts old PC64 files from the beta test versions
    SETJOY.EXE     When upgrading to new hardware, this program will
                   change the jostick settings of all programs in
                   PC64.PDB.
    SETJOY.CPP     Source code for SETJOY.EXE
    CBMTEXT.EXE    Converts text files from several C64 text programs into
                   MS-DOS format
    CBMTEXT.CPP    Source code for CBMTEXT.EXE
    DIR64.EXE      Shows the contents of all PC64 files, disk images and T64
                   files with their 16 chars names
    DIR64.CPP      Source code for DIR64.EXE
    MAGFORM.EXE    Removes the fast loader from files which have been frozen
                   with the Magic Formel cartridge
    MAGFORM.CPP    Source code for MAGFORM.EXE
    NOGDI.COM      Bypasses a conflict between PC64 and GDI printers under
                   Windows. Specify NOGDI.COM instead of PC64.EXE in
                   PC64.PIF if you have a GDI printer
    NOGDI.ASM      Source code for NOGDI.COM
    USERPORT.COM   Control your customized C64 hardware over the LPT
    USERPORT.ASM   Source code for USERPORT.COM. Must be customized for your
                   PC
    TESTJOY.EXE    Checks the joystick conversion from IBM analog to digital
    TESTJOY.CPP    Source code for TESTJOY.EXE
    TESTCABL.EXE   Checks whether the signals on the PC64 cable come through
    TESTCABL.CPP   Source code for TESTCABL.EXE
    TESTCABL.P00   TESTCABLE - Counterpart for the C64
    ISEPCLDR.P00   ISEPIC LOADER - Replacement loader for files which have
                   been frozen with ISEPIC, only necessary on disk images
    ISEPICSM.P00   ISEPIC.ASM - Source code for ISEPIC LOADER
    ISPCDFRS.P00   ISEPIC DEFROSTER (public domain) - Removes the ISEPIC
                   loader completely
    README.DOC     System requirements, shareware limitations and copyright
    ORDER.DOC      Order form for the licensed version
    GAMES.DOC      Optimal settings for a bunch of C64 games
    *.64M          System software cartridge $8000- $9FFF or $8000-$BFFF
    *.64K          System software KERNAL $E000- $FFFF
    *.64B          System software BASIC $A000- $BFFF
    *.64C          System software character set $D000-$DFFF
    VC1541.64D     System software of the Commodore 1541 floppy drive
    ORIGINAL.64K   Original operating system by Commodore, possibly with
                   truncated memory test and changed default device
                   address 8 instead of 1 with LOAD
    ORIGINAL.64B   Original BASIC ROM V2 by Commodore
    ORIGINAL.64C   Original character set by Commodore
    L64.P00        L64 - Makes the disk drives of a real C64 computer
                   available to the PC
    L64ASM.P00     L64.ASM - Source code for the transfer program in
                   Turbo-Ass format
    LINKASM.ASM    Source code for the transfer routines on the PC in
                   MASM format
    WHEREAMI.P00   WHERE AM I - Detects the emulator version on the
                   (virtual) C64
    JOYSTCKS.P00   JOYSTICKS - Tests digital joysticks 1 and 2
    PADDLES.P00    PADDLES - Tests analog paddles 1 and 2
    SPRITES.P00    SPRITES - Tests sprites
    COLORS.P00     COLORS - Displays all 16 available colors
    PRINTER.P00    PRINTER - Tests the printer. Printing graphics only
                   works on Epson compatible dot matrix printers

    On non-networked installations, also the configuration files are in the
    PC64 directory. On networks, they can be copied to a local directory
    that is in the search path, to allow individual settings. The
    corresponding file must then be write protected in the start directory.

    \bFilename       Meaning\p
    PC64.CFG       Global settings and layout of the recently opened windows
    PC64.PDB       Program options from <Manager / Run>
    DRIVES.INI     Compatibility list of different external C64 disk drives

    Temporary files will be created in the directory specified by the
    environment variable TEMP or TMP. Because of the enourmous amounts of
    needed disk space, this should not be any RAM disk. The temporary files
    will be deleted on normal program exiting.

    \bFilename       Meaning\p
    C64*.TMP       Temporary files when using several windows. They have
                   the same format than *.C64, and if the system crashes,
                   they can be opened later with <Emulator / Open>.
    LOG*.TMP       Protocols of the record mode. They are text files with 78
                   characters per line and can be loaded from the DOS shell.

    The following files can be present in any subdirectories. Instead of the
    ending 00 other numbers can be used to avoid filename conflicts.

    \bFilename       Meaning\p
    *.C64          Normal emulator states created with the command
                   <Emulator / Save as>
    *.000          Duplicates created with <Emulator / Duplicate>
    *.P00          Program files in PC64 format
    *.S00          Sequential files in PC64 format
    *.U00          User files in PC64 format
    *.D00          Deleted files in PC64 format
    *.R00          Relative files in PC64 format
    *.D64          Disk images, that is, 1:1 copies of 1541 diskettes

----------------------------------------------------------------------------
2Compatibility test with unknown floppy drives

    In the file DRIVES.INI that is in the start directory of the emulator,
    there is compatibility information of different C64 disk drives. You can
    edit this file with a text editor, because the format is the same than
    in the Windows .INI files. The section header corresponds to the
    power-on message of a disk drive, excluding the error number and the
    track and sector numbers. For instance, on the original 1541 floppy
    drive it is [CBM DOS V2.6 1541]. The power-on message will be generated
    with the floppy command UI.

    If there is an unknown drive on a connected C64, a dialog box will
    appear.

    When you confirm this dialog box with OK, a compatibility test will be
    started. It takes the new disk drive under the magnifying glass and
    writes the results to the file DRIVES.INI.

    But before that, you must insert a disk without write protection, on
    which a temporary file PC64COMPTEST will be created. If the disk drive
    manages it, the disk should be in the 1541 format, that is,
    single-sided, in GCR format, and with 35 tracks of 21 to 17 sectors
    each. If the emulator recognizes a different format, you cannot copy any
    disk images to this floppy later. Instead of it, the command
    <Manager / Disk image / Copy> will display the error message 98,DRIVE
    NOT 1541 COMPLIANT,00,00. This protection mechanism will prevent you
    from creating unreadable diskettes.

    When testing the fastloader, the external C64 and the disk drive can
    hang. The emulator recognizes this after a while and writes then
    UseL64FastAccess=0 to L64.INI. As a consequence, the normal routines
    will be used for copying whole disks. To make the crashed devices
    available again, press the reset button on the C64 or switch it off and
    on again. Then load the L64 program and start it.

    You can manually edit the file DRIVES.INI later, if the compatibility
    test has recognized something wrong. To repeat the test, simply delete
    the corresponding section in DRIVES.INI. If the floppy is switched on
    and the L64 program runs when starting the emulator, the settings will
    be determined again.

----------------------------------------------------------------------------
1Introduction

    <Starting the emulator>
    <C64 programs on the command line>
    <The /nosound switch>
    <The desktop>
    <Transferring files from C64>
    <Loading and executing programs>

----------------------------------------------------------------------------
2Starting the emulator

    In the optional operating systems Windows, Windows NT and OS/2, simply
    click on the C64 symbol when you would like to start the emulator. In
    DOS and in Linux dosemu, change to the start directory with

    cd \\pc64

    and execute the command

    pc64

    on the command prompt. Alternatively, you can start the emulator from
    any directory. To accomplish this, specify the whole program path, for
    example

    c:\\pc64\\pc64

    If that is too much typing for you, load your AUTOEXEC.BAT file to a
    text editor and add the PC64 directory to the environment variable PATH.
    As PC64 is in a single executable file, you can also write a small batch
    file with three lines:

    @echo off
    c:\\pc64\\pc64 %1 %2 %3 %4 %5
    echo.

    The percent marks redirect the parameters of the batch file to PC64, and
    the two ECHO commands ensure that the screen output remains the same. If
    you create this batch file in a directory that is in the search path,
    you can start the program from any point, without modifying the
    environment variable PATH.

    The menu commands <Emulator / Open>, <Emulator / DOS Shell> and
    <Manager / New> use the current directory that was used when running
    PC64. If you add the lines

    c:
    cd \\pc64\\games

    to the batch file, you don't have to change the directories in new
    Manager windows.

----------------------------------------------------------------------------
2C64 programs on the command line

    If you just type PC64 without any parameters, the windows opened in the
    last session will be automatically loaded, as far as they were saved at
    least once. The information about these windows is in the file PC64.CFG,
    which is located in the PC64 start directory.

    Alternatively you can also specify a PC64 file *.P00, a disk image *.D64
    or a saved emulation state *.C64 directly in the command line, for
    instance

    pc64 c:\\pc64\\games\\jumpman\\jumpman.p00

    or

    pc64 c:\\pc64\\games\\qftires.d64

    If the file suffix is missing, the default value .C64 will be used. If
    there are any parameters on the command line, the window data of
    PC64.CFG will be ignored.

    You can also utilize this property to start a C64 game directly from
    Norton Commander or from the Windows File manager. To make this
    possible, associate the file suffixes P00 through P03, D64 and C64 with
    PC64.EXE or PC64.PIF.

    When you specify a disk image on the command line, its first program
    will be loaded and executed. You can change the file order in the disk
    image with a dir sorter in the C64 mode.

----------------------------------------------------------------------------
2The /nosound switch

    On some computers the automatic detection of the sound hardware does not
    work. The emulator will display "use /nosound" and crash. In this case,
    please press Ctrl+Alt+Del in order to reboot your computer. Then start
    PC64 with

    pc64 /nosound

    If the yellow desktop now appears then write "pc64 /nosound %1" into a
    batch file and start PC64 from there.

----------------------------------------------------------------------------
2The desktop

    After starting the program from DOS with

    C:\\PC64>pc64

    you land to the desktop of the emulator. It is in text mode and is very
    similar to Microsoft Windows, both in the look and in the usage.

    <Mouse pointer>
    <Windows>
    <System menu>
    <Desktop>
    <Icon>
    <Maximize>
    <Menu bar>
    <Emulator window>
    <Manager window>
    <Dialog boxes>
    <The online help>

----------------------------------------------------------------------------
3Mouse pointer

    In order to use the program with a mouse, you have to load a Microsoft
    compatible mouse driver, for instance MOUSE.COM. The mouse will be
    automatically detected while booting the program, and the mouse pointer
    will appear. Because the desktop is drawn in text mode, the pointer is
    not the usual arrow but a rectangular block with that is one character
    big.

----------------------------------------------------------------------------
3Windows

    Windows are bordered rectangular areas on the screen, in which the data
    will be displayed. On their top, there is a title line with the window
    name. On the three other edges, there are single or double border lines.
    You can move the window on the screen by moving the mouse pointer to the
    title line and then pressing the left mouse button. If you now move the
    mouse, keeping the button depressed, the symbolic border lines follow
    the movements. Right after you release the left mouse button, the window
    will be moved to the new place.

    The window size can be changed in a similar way. Click the left mouse
    button on one of the three window edges and move the mouse to set the
    new size. If you click on one of the bottom corners, you can adjust the
    width and the height imultaneously.

----------------------------------------------------------------------------
3System menu

    On the top left corner of the window, there is the system menu. Using
    it, you can move and resize the window, even if you haven't loaded any
    mouse driver and only work with the keyboard. Press Alt+Minus to open
    the system menu. Use the arrow keys to move the selection on the wanted
    menu item and press the Enter key. Then move or resize the symbolic
    borders with the direction keys, and when you are ready, press the Enter
    key again.

    As mouse user, you can close a window by double clicking on the system
    menu. If you like to use the keyboard, you can press Ctrl+F4 instead.

----------------------------------------------------------------------------
3Desktop

    The windows will be opened to the light yellow desktop. In contradiction
    to Windows, the emulator will automatically divide the available desktop
    space upon any modification. Thus, if you open a new window, it won't
    overlap the old ones, but it makes them smaller and opens itself to a
    neighboring position. You can change this behaviour with the switch
    <Options / Desktop / Auto arrange windows>.

----------------------------------------------------------------------------
3Icon

    If you want to keep a window open but need its space on the screen for
    something else, you can minimize it to an icon. To accomplish this, move
    the mouse pointer on the top right window corner and click on the arrow
    that points downwards. Alternatively, you can go to the system menu with
    Alt+Minus and choose the command Minimize. The window appears now on the
    bottom right corner of the desktop, and the freed space will be divided
    between the remaining windows automatically.

----------------------------------------------------------------------------
3Maximize

    By clicking on the upward arrow in the top right window corner, you can
    maximize the window. The window name appears in the main window title
    bar, and the window borders disappear. Thus, there is more screen space
    available for the actual data. The system menu is now available under
    the minus sign on the left edge of the menu bar. You can restore the
    window to its original form with the double arrow on the right edge of
    the menu bar.

    In contradiction to Windows, the emulator opens each window in maximized
    form by default, if it is the only window on the screen. Thus the system
    menu commands Restore and Minimize remain without any effect. The switch
    <Options / Desktop / Maximize single window> changes this default
    behaviour.

----------------------------------------------------------------------------
3Menu bar

    You execute commands by using the menu bar that is located on the top of
    the screen. The commands usually affect on the active window, that is,
    the window with the blue title bar. When you press the Alt key together
    with a menu bar letter that is marked with red, the corresponding menu
    will be opened. Now release the Alt key and press the highlighted letter
    of the command that you would like to execute. For instance, to create a
    new emulator window with the command <Emulator / New>, press Alt+E and
    then N. Alternatively, you can move the selection bar with the direction
    keys and confirm with Enter.

    If you prefer to use the mouse, then move the mouse pointer to the menu
    bar and open the wanted menu title by clicking with the left mouse
    button. Pull the mouse down to the wanted menu item and release the
    mouse button.

    You will note that there are some menu items that are printed in grey
    color. This means that they are currently disabled and cannot be
    executed. For example, the menu command <Search / Continue forward> will
    be grayed until you search for something.

    There appear some shortcut keys on the side of some menu items, for
    instance F2 with the command <Search / Address>. The shortcut keys are
    provided for faster execution of some menu commands. Instead of the
    three keys Alt+S and A you only need to press F2 to open the dialog box
    for address input.

----------------------------------------------------------------------------
##259
3Emulator window

    In every emulator window there is an individual virtual C64. With F5 you
    can switch to the emulation mode; the familiar C64 power-on message will
    appear. With Esc you come back to the desktop again. You can work with
    several virtual C64s simultaneously, but multi-tasking is not possible.
    Thus, when you switch to next window with Ctrl+Tab, the active C64
    program will be paused and the new one continued in the place where it
    was abandoned the last time. You can also save the complete state of an
    emulator window to the hard disk; this corresponds to a freezer on a
    real C64.

   <Protocol>
   <Keys for emulator windows>

----------------------------------------------------------------------------
4Protocol

    Normally the emulator window is empty. But if you start the virtual C64
    in record mode with Shift+F5, all executed processor commands and I/O
    events will be recorded. The emulation speed will slow down to about
    five percent of the normal power. When you return to the desktop with
    Esc, the record protocol will be displayed in the emulator window. You
    can browse it with the direction keys or search for events. The lines
    with the processor commands have the following structure:

                            address
                               
    program counter             old data         flags (upper=1, lower=0)
                                                   
       machine language           new data           clock cycles
                                                      
                                                      
    \bFD65 EE0080  INC 8000     8000:00=01  80 FF 00 nv1bdIzC 6 FD:F7 FC...\p
                                                            
                                                            
              mnemonic                  accu      stack pointer
                                                               
                    operand            X register           stack data
                                                 
                                            Y register

    Register contents, Flags and Stack describe the state \bafter\p executing
    the processor command.

    To get to a particular location fast, you can use the scroll bar. Move
    the mouse pointer to the scroll indicator and press the left mouse
    button. If you now pull the mouse up or down, the protocol in the window
    will move to the corresponding position.

----------------------------------------------------------------------------
3Manager window

    A manager window corresponds somewhat to the Windows File manager or the
    MS-DOS Dosshell. Using it, you can copy, move, rename, delete and
    execute PC64 files. It is very difficult with a conventional DOS
    program, as the C64 file names are 16 characters long. In DOS, they must
    be abbreviated to 8 characters because of this, which is very confusing.
    Or do you know, which program is hiding itself behind SPRTDTR4.P00?

    <Directory tree>
    <File list>

----------------------------------------------------------------------------
##260
4Directory tree

    The left part of the manager window is the directory tree. There you can
    choose the disk drive and the directory with the arrow keys. A plus sign
    before a directory name indicates that the directory contains further
    subdirectories. You can open the directory with the right arrow key or
    the space bar. Also disk images and external C64 disk drives will appear
    in the directory tree, e.g. 28: or DISK.D64. In Manager, you can access
    both as normal subdirectories.

    Please note that all file operations will take place on the external C64
    disk drive whenever the item 28: is selected in the directory tree.
    Thus, if you press Del and confirm it, the original files on your C64
    disk will be deleted!

    <Keys for the directory tree>

----------------------------------------------------------------------------
##261
4File list

    The bigger right part of the manager window is the file list. All PC64
    files of the selected directory will appear here with their 16
    characters long filenames. Other files than programs will be suffixed
    with a comma and the file type, for instance DATA,S for a sequential
    file. You can select one or more files with the space bar or the mouse,
    and then apply one of the Manager menu commands on them.

    The block size of the highlighted files will appear in the title bar of
    the window. In this way, you can find out if all files fit in a 1541
    disk with 664 blocks. If no files are highlighted, the Manager menu
    commands are applied on the file with the selection triangle.

    You can jump between the directory tree and the file list with the Tab
    key. The file list will be reread, if you change the directory.
    Otherwise you can force a reread with F5.

    Oh yes, the secretful program is SPRITE EDITOR V4. In five passes, strip
    all special characters, spaces, wovels, consonants and numbers,
    beginning from the right, until you have reduced the name to 8 letters.
    With the suffix P for program and two digits in order to avoid duplicate
    filenames you get the cryptical name SPRTDTR4.P00.

    <Keys for the file list>

----------------------------------------------------------------------------
3Dialog boxes

    Behind some menu items, there are three points, for instance at
    <Options / Desktop>. When you execute such a command, a window will
    appear on the screen, where you will be prompted for further data. This
    window is called a dialog box. It contains controls in which you can
    change the current settings. When you are finished, confirm the changes
    with the Enter key or abort with Esc.

    <List boxes>
    <Radio buttons>
    <Check box>
    <Edit control>
    <Command buttons>

----------------------------------------------------------------------------
4List boxes

    In list boxes, you can activate one of the provided items. The active
    list item will be indicated with a black selection rectangle, which can
    be moved around with the arrow keys or with the mouse. If the selection
    rectangle is not visible, simply press the downward arrow.

    If there are very many available items, the visible part of the list
    will automatically scroll up when you move down the selection. You can
    also click on the scroll bar with the mouse. In that way, you only
    scroll the visible part of the list, and the selection rectangle remains
    on the selected list item.

----------------------------------------------------------------------------
4Radio buttons

    Radio buttons can be recognized by the round parentheses. They can be
    used to choose between alternatives that exclude each other, so that
    only one option is active at a time. It works just like the station
    buttons on your radio. There, you can also select only a single sender
    at a time.

    To activate a radio button, click with the mouse on the parentheses or
    on the text. If the text contains a red letter, you can also activate it
    by pressing it together with the Alt key. A third way is to move the
    selection with the arrow keys.

----------------------------------------------------------------------------
4Check box

    In contrast to radio buttons, check boxes consist of square brackets.
    They work as independent switches, they do not affect each other. A
    check box is active when there is an X between the brackets.

    Check boxes can be activated and deactivated with the mouse or the red
    letter combined with Alt. In addition, you can move to the check box
    with Tab or the arrow keys and change its state with the space bar.

----------------------------------------------------------------------------
4Edit control

    An edit control can be recognized from a blinking cursor, and it will be
    bounded by two square brackets. It works similarly to the DOS command
    line. You can input a single line of text there, for example a file name
    for the command <Emulator / Open> or a number for
    <Options / Timing / Update screen every xth vertical refresh>.

    If the text is marked, that is, if it has a black background, it will be
    automatically deleted on entering a character. You can avoid this by
    pressing a direction key first, like Home or End. If you want the
    opposite, you can mark existing text with Shift+direction key and delete
    all of it with Del.

----------------------------------------------------------------------------
4Command buttons

    Command buttons are surrounded by a border and are usually placed on the
    bottom of a dialog box. In contrary to other controls, you cannot change
    any data in the command buttons, but you execute commands with them.

    The command button OK closes the dialog box and confirms the changes
    that were made to the other dialog box controls. The OK button is also
    the default button, as it has double border lines on its top left.
    Default buttons can be selected with Enter, if no other button is
    activated at the time.

    The command button Cancel also closes the dialog box, but discards the
    changes. Using this button makes sense e.g. when you have executed the
    command <Emulator / Open> and cannot find the wanted file. The key
    abbreviation for Cancel is Esc.

    Some dialog boxes contain a message text and some other command buttons,
    for instance Yes and No. In these message boxes, the highlighted letters
    of the buttons can be used as shortcut keys.

----------------------------------------------------------------------------
#QuickHelp
3The online help

    The online help is a dialog box that covers the whole screen.

    You can open the help window with a Help menu command, e.g. with
    Shift+F1 you get the Overview, or Help contents. The Esc key takes you
    back to the emulator.

    The online help contains almost the same information as this manual, but
    it is in hypertext format. This means that you can jump to a new title
    by clicking the mouse button on different links. Keyboard users choose a
    link with Tab and Shift+Tab and press the Enter key or the space bar.
    Links are indicated by two green triangles surrounding them. With a
    conventional book, you would have to search the correct page first.

    There is an even better way of calling the online help. To try this,
    move the selection bar to a menu item or choose a control in a dialog
    box and press the F1 key. You will land in the online help, and the
    title describing the menu command or the dialog box field will be opened
    automatically. This is called context-sensitive help.

    <Navigating in the hierarchy>

----------------------------------------------------------------------------
4Navigating in the hierarchy

    Similar to the subdirectories of your hard disk, also the online help is
    divided to hierarchical levels. For instance, if you want to know
    something about the settings under Options / Timing and are currently in
    the Overview, you must first click on the link <The Options menu>. A
    further help text will be displayed with the items of the Options menu.
    Here you must click on the link <Options / Timing>. Finally, you can
    decide which aspect of the timing interests you. As a shortcut, you
    could naturally also have opened the dialog box <Options / Timing> and
    then pressed F1.

    In the top line of the help text you will find special links, with which
    you can navigate in the hierarchy. If you have used a normal link in a
    text to jump to an undertitle, the special link Up will return you to
    the previous level. In DOS, you would execute the command

    cd ..

    to accomplish this. The links >> and << lead you to the next or the
    previous title on the same level. In DOS, this corresponds to the
    command

    cd ..\\next

    You can abbreviate both these commands with the + and - keys. Upon
    reaching the first or the last item of the current level, the + and -
    keys do not have any effect any more.

    If you have "lost your way", <Contents> brings you back to the title
    page of the online help. The keyboard shortcut is Shift+F1, and it
    corresponds to the

    cd \\

    command in DOS.

    By the way, not all links follow this strict hierarchy. There are also
    some links that jump between different titles. For these links, there is
    the command Back, which can be abbreviated with Alt+F1 or Backspace. It
    will bring you to the last displayed title, no matter where you are
    located. The menu command <Help / Last topic> will also work if the help
    window is not displayed any more.

----------------------------------------------------------------------------
2Transferring files from C64

    Unfortunately it is technically impossible to directly read GCR coded
    1541 diskettes with the PC's MFM disk controller. But there are other
    ways of getting your programs and data from the C64 to the emulator.

    <The PC64 cable>
    <Importing DOS files>
    <Transferring over the serial interface>
    <Transferring files with other tools>
    <Importing programs from C64S>

----------------------------------------------------------------------------
3The PC64 cable

    The fastest and best way is using the PC64 cable. It was specially
    developed for the emulator, and there is also a version of it with a
    digital joystick interface.

            +--------------+
            +------------+
                         
                       +---+ \iJoystick\p
            +----+----+----+           +-\u\p-+ (digital)
        +----------------------+         \u\p
         +--+     \iPC\p                   \u\p       +-------------------+
         +--+            LPT\u----------+\p              \iC64\p Userport
        +------------------\u\p---+                 +---------------\u\p---+
                           \u+-------------------------------------+\p

    You must do the following:

    1. Connect the computers to each other.

       \bFirst, you must switch off all equipment, including the TV set
       connected to the C64! All units must be connected to the same power
       outlet, to avoid current loops. The producer disclaims any warranties
       for defects caused by connecting the cable while some of the
       equipment is powered on, or by high voltage coming from the antenna
       outlet of a defect television set!\p

       Now locate a free parallel interface on the PC. If possible, avoid
       LPT1, or you cannot print any more. On the C64, insert the other end
       of the cable to the user port. Then power on both computers and the
       TV set and disk drive of the C64 again.

    2. Prepare the disk for L64. Label an empty and formatted C64 disk with
       L64 and insert it to the floppy drive.

    3. Copy L64 to the C64. Start the C64 emulator and execute the command
       <Manager / Clone L64>. A message box with a 5-line BASIC program will
       appear. Enter this program on the C64 and execute it with RUN. On the
       PC, select the appropriate interface in the dialog box and start the
       transfer with OK.

       The progress meter now displays, how much of the program has been
       cloned. As it finishes, break the C64 program with STOP+RESTORE and
       close the file with CLOSE 1. The originally empty disk now contains a
       program called L64.

    4. Test the connection. Load and start the L64 program on the C64 and
       execute the command <Options / Waitstates> on the emulator. Let the
       transfer run for a couple of seconds. No errors should occur. Should
       they occur anyway, you should increase the amount of the link wait
       states, until you get an error free transfer. Confirm the new
       settings with OK.

    5. Add the new disk drive. Execute <Manager / Add L64 drives> on the
       emulator. Open a manager window with the <Manager / New> command and
       go to the root of the directory tree with Ctrl+Home. The C64 drive
       appears on the bottom of the list and is normally called 28:. The
       first digit is for the interface, LPT2, and the digits after it
       represent the IEC bus device number, in this case 8. Select this
       external drive with the End key.

    6a Copy whole disks (the fast way). Thanks to the fastloader, the 1541,
       1570 and 1571 drives are at best when copying whole diskettes at a
       time. Insert the source disk to the C64 drive and press Alt+F8. In a
       dialog box, you can enter the DOS path and filename, the default is
       DISK1.D64. After confirming it with OK, the copying begins. When
       finished, insert the next source disk and press Alt+F8 again.

       The digits in the end of the DOS name will automatically increment,
       so that you can easily copy whole disk series. Afterwards you can
       divide the single files to appropriate subdirectories in Manager and
       delete the disk images.

    6b Copy single files (the slow way). When using other disk drives than
       1541, 1570 or 1571, insert the disk to be copied and go to the file
       list by pressing Tab. Mark all files with + and copy them to the PC
       with F8. You may need to open another Manager window to create a new
       subdirectory. It is wiser than copying all files to the same
       directory, in which case you will forget which file belongs to which
       game. After replacing the source disk, you can read the contents
       simply with F5.

    When copying much, Windows users can press Alt+Space to get to the
    system menu and activate the background execution there. The switch is
    normally off, since the VGA mode 13h cannot be displayed with all
    display drivers in a window. Normally you will get two error messages if
    you put the emulator with a C64 screen to background. As the copying
    takes place in text mode, this causes no problems.

    Linux users can switch to another virtual console anytime, and the
    copying will continue on background.

----------------------------------------------------------------------------
3Importing DOS files

    If there are already C64 programs on your hard disk, you can import them
    to the emulator with the command <Manager / Import>. Do the following:

    1. Choose the destination directory. Open a new Manager window and
       select the destination directory in the directory tree. You can also
       create it with <Manager / Directory / New>. Then switch to the file
       list with Tab to enable the Import command.

    2. Select the DOS file. Use the command <Manager / Import>. A file
       dialog box appears. Switch to the source directory and select the
       source file. Confirm with OK.

    3. Input the C64 filename and type. These will be input in another
       dialog box that opens after confirming the first one. You can enter
       up to 16 characters for the filename. The radio button group lets you
       to choose the file type, the default will be extracted from the DOS
       filename. You start the copying process with OK. Then you return back
       to the file list in the Manager window.

    To import further files, repeat from step 2. You don't need to set the
    source directory again, the emulator remembers it.

    Finally you can delete the DOS files manually, if you don't need them
    any more. To do this, you have to leave the program with Alt+F4 or to go
    to the DOS level with the <Emulator / DOS Shell> command.

----------------------------------------------------------------------------
3Transferring over the serial interface

    If you have an RS232 adapter for the C64, you can also copy your files
    over the serial interface to the PC. In addition to the RS232 adapter,
    you need a serial null modem cable and the terminal software for the C64
    and the PC.

    A direct connection between the user port and the PC's serial port is
    unfortunately impossible, because the C64 does not contain any internal
    driver circuitry for 12 volts. Besides, this method is very slow. Should
    you even succeed in using a C64 terminal program at 9600 bits per
    second, the transfer is still 10 times slower than with the PC64 cable.
    A further drawback is that you cannot copy whole disk images without
    extra software. Relative files can lead to problems, too.

    The actual transfer takes place in two steps:

    1. Copy the programs in DOS. Connect the PC's serial port to the RS232
       adapter with a null modem cable and turn on the computers. Load both
       terminal programs and set the transfer parameters to 8,N,1. Use the
       highest possible baud rate that you can use on the C64 without
       errors. Without special transfer routines in the terminal program, it
       is 600 bauds if the screen is enabled. Then insert the disk to be
       copied and start the upload on the C64. Select a transfer protocol
       that is available on both terminal programs. The best alternative is
       Zmodem, then Kermit. Xmodem is the worst choice, since it expands all
       files to 128 byte blocks. When downloading on the PC, enter a 8
       characters long DOS name. You should use PRG, SEQ, USR or DEL as a
       file suffix. With relative files, use the record length in decimal.
       If you have done everything correctly, both terminal programs will
       now start the transfer.

    2. Import the DOS files to PC64 as described above.

----------------------------------------------------------------------------
3Transferring files with other tools

    The program X1541.EXE utilizes a homebuilt cable that connects a
    Commodore disk drive directly to the PC printer port. The program shows
    the schematic diagram when you start it. The X1541 cable is not
    identical to the PC64 cable, as it requires no C64 in between.

    X1541 is programmed by Leopoldo Ghielmetti, it is shareware and costs
    $10 registration fee. The author has lost his e-mail account long time
    ago, and the program is very buggy. But the X1541 cable is somewhat
    standard, and many other programs, like the Trans64 by Bernhard Schwall,
    use the same cable. These utilities can be downloaded from
    ftp.funet.fi:/pub/cbm/transfer/1541-to-PC.

    You can also write MS-DOS diskettes with the 1571 and 1581 drives, and
    even the 1541 manages the single-sided 180 kilobyte format with a small
    hardware modification. These programs are relatively slow, maybe faster
    than RS-232, but usually slower than x1541-like tools.

    Anyway, these utilities are sorted under ftp.funet.fi:/pub/cbm/transfer.

    After copying the files to the PC, you have to import them to PC64 as
    described above.

----------------------------------------------------------------------------
3Importing programs from C64S

    Disk images with the .D64 suffix can be used in both emulators, any
    conversion isn't required.

    However, the C64S tape files with the .T64 suffix must be converted to
    the PC64 format. The T64TOP00.EXE file, which is located in the start
    directory of the emulator, takes care of this task. Start it on the DOS
    prompt with

    C:\\PC64>t64top00 c:\\c64s

    All subdirectories of the specified starting directory will be searched
    for T64 files, and the files in them will be converted to PC64 format.
    The T64 files will not be deleted in this process.

----------------------------------------------------------------------------
2Loading and executing programs

    In contrast to a real C64, you don't need to write any complicated
    commands any more. Instead of them, you start the programs comfortably
    using the built-in Manager which will be used similar to the Windows
    File manager.

    First open a Manager window with the menu command <Manager / New>. The
    blinking cursor will move to the left part of the window, to the so
    called directory tree. Here you can use the direction keys to select the
    drive and the directory where the wanted program is. If there is a plus
    sign before a directory, there will be further directories or diskimages
    in there. You can go there with the right arrow or with the space bar.
    The left arrow or the backspace key take you up in the hierarchy by one
    branch. The previously opened subdirectories will disappear again, which
    increases the readability of the directory tree.

    After selecting the wanted directory, jump to the right part of the
    Manager window with the Tab key. The C64 files with their 16 characters
    long filenames will be listed here. DOS files, subdirectories and
    partitions of external C64 drives will not be displayed. Normal
    executable files don't have any suffix, only the sequential or relative
    files get a ,S ,U ,D or ,R suffix.

    Now move the selection triangle to the program, that is, a file name
    without a type suffix, and press the Enter key. That is all you need to
    do to start a C64 program. PC64 will automatically open a new emulator
    window, use the options of previous sessions from PC64.PDB, go to the
    emulation mode, load the program with LOAD"NAME",8 and start it with
    RUN. After that, the C64 program will take over.

    When you finally want to go back to the desktop, press the Escape key.
    You can now close the emulator window with Ctrl+F4, or you can change
    the settings under the Options menu, or continue the emulation by
    pressing F5. The menu command <Emulator / Save> even lets you to save
    the complete state of the emulated C64 to your hard disk and thus to
    make it available for further sessions.

    <More than 100 games included>

----------------------------------------------------------------------------
3More than 100 games included

    An emulator is of little use if you don't have software for it. To help
    you in getting started, the PC64 distribution includes more than 100
    games from the Sonderheft disks of the German 64'er Magazin. They will
    be copied to the 64ERGAME subdirectory by the installation program. Half
    the games runs directly on the emulator, and the rest, which include a
    fastloader, can be copied to a real C64 and played on it.

----------------------------------------------------------------------------
1Command reference

    <The Emulator menu>
    <The Manager menu>
    <The Search menu>
    <The Run menu>
    <The Options menu>
    <The Windows menu>
    <The Help menu>

----------------------------------------------------------------------------
##4
2The Emulator menu

    <Emulator / New>
    <Emulator / Duplicate>
    <Emulator / Open>
    <Emulator / Reload>
    <Emulator / Save>
    <Emulator / Save as>
    <Emulator / DOS shell>
    <Emulator / Exit>

----------------------------------------------------------------------------
##500
3Emulator / New

    This command opens a new emulator window on the screen. The window
    contains a complete C64 with all settings that were saved to the
    configuration file PC64.CFG. You can edit these defaults by setting the
    check box "Default for new emulator windows" before leaving the dialog
    boxes under the Options menu. When you open a new emulator window again,
    the modified settings will be used.

    A new emulator window gets the title No name. Windows without any name
    cannot be duplicated or reloaded. When starting PC64 again, these
    windows won't be automatically restored either. So, if you don't merely
    want to experiment a bit, then you should use the menu command
    <Emulator / Save as> to give a name to the window as soon as possible.

    The program counter of a new emulator window is always on the reset
    routine. Thus, depending on your computer speed and operating system,
    the <Run / Start> command may take a couple of seconds before the
    startup screen appears.

----------------------------------------------------------------------------
##501
3Emulator / Duplicate

    With this command you can create a copy of the current emulator window,
    e.g. to try something out with it without modifying the original. But
    this will only work if the original file has a name, that is, it has
    been saved at least once.

    Usually the emulator state files have the format NAME.C64. Unlike them,
    duplicated files will have numbers from 000 to 999 as file suffix. A
    unique suffix number will be chosen to avoid overwriting previously
    existing duplicates. If you want to delete duplicates that are not
    needed any more, you have to do it in DOS.

----------------------------------------------------------------------------
##502
3Emulator / Open

    This command is used to load a previously saved emulator state from hard
    disk. It is possible to open the same file more than once. But there is
    no protection mechanism when you save the file. This means that only the
    changes of the last saved file remain, while all other versions will be
    overwritten. So is the case also when you exit the emulator while the
    option "Save on exit" was set to "Yes, overwrite file." Therefore, if
    you want to work with several versions of the same file, it makes more
    sense to use the <Emulator / Duplicate> command.

    You can also specify a file on the command line to be automatically
    opened and run in the emulator.

    <Emulator / Open / Filename>
    <Emulator / Open / Directories>
    <Emulator / Open / File format>
    <Emulator / Open / Drives>

----------------------------------------------------------------------------
##1152
##1120
4Emulator / Open / Filename

    Input the name of the file you would like to load in this field. If the
    suffix is missing, the .C64 suffix will be assumed. If you want to load
    a file without a suffix, you must input a period as the last character.
    You can save yourself from typing by going to the list box with Tab and
    selecting one of the listed filenames.

----------------------------------------------------------------------------
##1121
4Emulator / Open / Directories

    If the wanted file is in another directory, you can jump to it with this
    list box. Double click on the wanted directory or select the entry with
    the direction keys and press Enter.

----------------------------------------------------------------------------
##1136
4Emulator / Open / File format

    This combo box lets you to limit the file name display. The default for
    emulator state files is "C64 image files". By selecting "All files" this
    limit will be disabled, and all files in the current directory will be
    displayed. Alternatively, you can also input the mask (like *.*)
    directly in the Filename edit box.

----------------------------------------------------------------------------
##1137
4Emulator / Open / Drives

    If the searched file is located on another drive, you can jump to it
    with this combo box.

----------------------------------------------------------------------------
##503
3Emulator / Reload

    This command reverts to the last saved state of the current emulator
    window. It is the same than closing the window without saving it, and
    opening the file again. After confirming the command, all changes that
    have been made in the meantime will be destroyed.

    With Emulator / Reload you can undo losing a life without having to
    start the game from the beginning. This naturally requires that you have
    saved the current state earlier with Shift+F11.

----------------------------------------------------------------------------
##504
3Emulator / Save

    This command saves the current state of the active emulator window to
    the disk. If the window doesn't have any name, this command is disabled.

    The normal save command overwrites the old version of the file without
    asking for your confirmation. If you want to keep it, you should give
    another name to the new version with the <Emulator / Save as> command.

----------------------------------------------------------------------------
##505
3Emulator / Save as

    With this command you can save the active emulator window state under a
    new filename. The same dialog box than with <Emulator / Open> will
    appear.

    If there is already a file with the specified name, you will be asked
    for confirmation before it will be overwritten. The old contents will
    then be deleted.

----------------------------------------------------------------------------
##506
3Emulator / DOS shell

    This command brings you to the DOS command prompt, without exiting the
    emulator. You can now copy files or start other programs. Though it does
    not make much sense, you can even open a second copy of the emulator.
    When you are finished with the work, return to the emulator with

    C:\\PC64>exit

    You may not start any resident programs in the DOS shell! If you do it,
    the emulator cannot restore itself and denies the return. The exit
    command doesn't then have any effect any more, and all changes after the
    last save will are destroyed. In this case, after rebooting the machine,
    you can try to open one of the C64*.TMP files in your temporary file
    directory. The current state of the emulator window that was active when
    going to the DOS shell cannot be restored, though. The whole thing only
    works if you had further unsaved emulator windows on the background.

    On going to the DOS shell, the emulator will be swapped into the hard
    disk or to the extended or expanded memory. If you want to disable the
    latter, you can turn off <Options / Desktop / Swap into EMS and XMS>.

----------------------------------------------------------------------------
##507
3Emulator / Exit

    This command exits the emulator and returns to DOS. Before it, the
    changes of all open emulator windows will be either saved or lost, in
    regard to what you have specified in <Options / File / Save on Exit>.
    Furthermore, the names and positions of all open windows will be saved
    to the file PC64.CFG, so that the desktop will look exactly the same
    when starting the emulator again. Nameless emulator windows will be
    removed, though.

----------------------------------------------------------------------------
##5
2The Manager menu

    <Manager / New>
    <Manager / Run>
    <Manager / Rename>
    <Manager / Move>
    <Manager / Copy>
    <Manager / Delete>
    <Manager / Import>
    <Manager / Export>
    <Manager / Directory>
    <Manager / Disk Image>
    <Manager / Refresh>
    <Manager / Add L64 drives>
    <Manager / Clone L64>
    <Manager / Read ROMs>

----------------------------------------------------------------------------
##550
3Manager / New

    This command opens a new Manager window on the screen. The window is
    divided to two parts. The left part contains the directory tree where
    you can change the current drive or directory, or a disk image. The C64
    files of the chosen directory or disk image will be listed in the right
    part of the window. Improperly closed files, which are normally marked
    with an asterisk before the file type, and normal DOS files will not be
    listed. Partitions of the CBM type are not recognized either.

    Whenever you move in the directory tree, the file list will be deleted,
    and the title bar of the window changes to (unknown). After selecting
    the wanted directory, you can force the read of the directory by
    changing to the file list with Tab or with the mouse. You can also use
    the F5 key if you remain in the directory tree and only want to take a
    quick look at the files in the selected directory.

----------------------------------------------------------------------------
##551
3Manager / Run

    This command is only available when the selection triangle is on the
    file list pointing a program, that is, a filename without a comma on the
    last column but one. The Enter key opens a new emulator window, loads
    the corresponding program and runs it.

    If the program hasn't been run before or if it always has run with the
    default settings, the same default settings than with the
    <Emulator / New> command will be used. You can change them by setting
    the check box Default for new emulator windows before leaving the dialog
    boxes under the Options menu. The only exception against
    <Emulator / New> concerns the drive 8. It is set to the directory where
    the program file is, so that multi-load programs will work without
    problem.

----------------------------------------------------------------------------
##552
3Manager / Rename

    You can rename a file with this command. Only the name will change, the
    file type remains. If you want to change the type, you must do it in the
    emulated C64 by using an appropriate copy program.

    You can also select multiple files before selecting this command. You
    will then be individually asked for each filename. If you don't want to
    rename a file on a list, you can skip it simply with OK.

----------------------------------------------------------------------------
##553
3Manager / Move

    This command lets you to move one or more files to another directory. A
    dialog box appears where you can select the destination directory.

    If the target directory doesn't exist, you must create it first with
    <Manager / Directory / New>.

----------------------------------------------------------------------------
##554
3Manager / Copy

    This command is just like <Manager / Move>, but it won't delete the
    source files.

----------------------------------------------------------------------------
##555
3Manager / Delete

    With this command you can delete one or multiple files. To prevent
    unwanted data loss, the program will ask for your confirmation first.

----------------------------------------------------------------------------
##556
3Manager / Import

    This command converts DOS file to PC64 format. For instance, if you have
    downloaded C64 files from a BBS to your PC, you cannot use them on the
    emulator because of filename length limitations.

    After selecting the command, the same dialog box than with
    <Emulator / Open> will appear. Select the wanted DOS file and confirm
    with OK. Now a second dialog box will appear, asking you for the up to
    16 characters long C64 filename.

    You can also set the file type, the default depends on the DOS filename
    extension PRG, SEQ, USR, DEL or REL. For relative files, you must also
    input the record length, which should be indicated in the DOS filename
    extension in the best case. After confirming the dialog box with OK, the
    new PC64 file will be created. The file will be copied, so the old DOS
    file will remain. If you don't need it any more, you can delete it
    manually in the DOS shell.

----------------------------------------------------------------------------
##557
3Manager / Export

    With this command, you convert PC64 files to DOS files, for instance to
    edit C64 pictures or text files on the PC. A format conversion won't be
    performed though, you'll need special software for it.

    Select one of more files in the file list and use this command. For each
    file, the same dialog box than with <Emulator / Open> will appear, with
    the C64 filename in the title bar.

    There is a default for the DOS filename, but it isn't always adequate,
    because of the 8 characters restriction. Relative files will get their
    record length to the file extension, as it doesn't get saved anywhere
    else.

    After you are happy with the file name, confirm with OK. The DOS file
    will be created. It will be copied, so the old PC64 file will remain. If
    you don't need it any more, you can delete it from the disk with
    <Manager / Delete>.

----------------------------------------------------------------------------
##6
3Manager / Directory

    This popup menu contains commands that lets you to manipulate
    directories, conventional DOS directories that is. There is an own popup
    menu for disk images, and you can change the partitions of an external
    C64 disk drive only in an emulated C64.

    <Manager / Directory / New>
    <Manager / Directory / Rename>
    <Manager / Directory / Delete>

----------------------------------------------------------------------------
##558
4Manager / Directory / New

    You create a new subdirectory with this command.

    Enter an up to 8 characters long filename and an optional extension of
    up to 3 characters. The directory will be created with OK, and if it
    succeeds, it will appear in the directory trees of all Manager windows.

    It is a \bsub\pdirectory that will be created. Thus, if you want to add a
    new directory to a list of directories, you must use the left arrow
    first to go up by one branch.

----------------------------------------------------------------------------
##559
4Manager / Directory / Rename

    With this command, you can rename the current directory in the directory
    tree.

    In addition to a new name, you can also input a 3 characters long
    extension. The directory will be renamed with OK, and if it succeeds, it
    will appear in the directory trees of all Manager windows. The command
    will be disabled if a root directory, a disk image or a disk drive is
    selected.

    If you rename the starting directory of the emulator, the emulator
    cannot find its files PC64.CFG, PC64.PDB and PC64.HLP any more. If this
    happens, leave the emulator and start it again.

----------------------------------------------------------------------------
##560
4Manager / Directory / Delete

    This command removes the selected subdirectory of the current Manager
    window. Root directories cannot be deleted.

    The directory to be deleted must be empty, and it may not contain any
    further subdirectories. You can see it from plus signs in the directory
    tree. As DOS files won't show up on the file list, an error message can
    be displayed, even though the directory seems to be empty. In such case,
    delete the directory in the DOS shell, for instance with the DELTREE
    command on MS-DOS 6.0 and later.

----------------------------------------------------------------------------
##7
3Manager / Disk Image

    The commands in this popup menu let you to manipulate disk images. They
    are files with the .D64 suffix that are about 170 kilobytes in size.
    They contain all data of a standard 1541 disk, including the BAM and the
    directory.

    Unlike normal DOS directories, the disk images have a limited capacity
    of 664 blocks, but on the other hand, programs that access sectors
    directly will work with them. Accesses to the floppy RAM is also
    possible, and relative files will be handled in a more compatible way
    than with the PC64 files. But programs with fast loaders as well as copy
    protected software still won't work.

    <Manager / Disk Image / New>
    <Manager / Disk Image / Rename>
    <Manager / Disk Image / Copy>
    <Manager / Disk Image / Delete>

----------------------------------------------------------------------------
##561
4Manager / Disk Image / New

    You create a new disk image in the current directory with this command.
    If the cursor is already on a disk image in the directory tree, the
    command is disabled.

    In the dialog box, enter an up to 8 characters long DOS filename. The
    suffix cannot be modified, it is always .D64. In the two other edit
    fields, you can input the C64 name as well as the disk ID. The C64 name
    will appear later in the Manager window title bar as well as when you
    type LOAD"$",8:LIST in the emulator. The disk ID is very seldom used, so
    it can usually remain 00. After you have confirmed the dialog with OK,
    the disk image will be created on your hard disk.

----------------------------------------------------------------------------
##562
4Manager / Disk Image / Rename

    This command lets you to rename the current disk image. The dialog box
    is the same than with <Manager / Disk Image / New>. You can change the
    DOS name as well as the disk label and the ID.

    The command is disabled if you have selected a directory or an external
    C64 disk drive.

----------------------------------------------------------------------------
##563
4Manager / Disk Image / Copy

    You can copy complete disk images with all files they contain using this
    command. But it will only work to external drives if they are 1541
    compatible. In the Manager window, select an external C64 drive or a
    disk image with the .D64 suffix and press Alt+F8. Now you can select the
    destination drive and directory in a dialog box.

    If the destination is a normal directory, you can input the DOS filename
    in an extra field. The limit is 8 characters, and the .D64 suffix will
    be added automatically. If the target is an existing disk image or an
    external C64 drive, the edit field will be disabled.

    On confirmation with OK the disk will be copied. A progress indicator
    will help you to estimate the time required to complete. If the target
    is an external C64 drive, and the disk is not formatted, it will be
    automatically formatted after you have been asked for confirmation. If
    the target is an existing disk image, you must confirm the copying too.

    If the copying succeeds and the DOS name ended to a number, the digits
    will be automatically counted up. So you can copy complete disk series
    from an external C64 disk drive in a convenient way.

    In contrast to normal file access, a fastloader will be used when
    copying whole disk images. Thus you can speed up data transfers from the
    C64 by first copying whole disks to the PC and sorting the programs to
    subdirectories later.

----------------------------------------------------------------------------
##564
4Manager / Disk Image / Delete

    This command deletes the selected disk image in the current directory
    tree.

    You will be asked for confirmation first, as all files in the disk image
    will be deleted.

----------------------------------------------------------------------------
##565
3Manager / Refresh

    If you have made some changes in the DOS shell, or if a C64 program has
    created or deleted some files, you can force a read of the file list
    with this command. It is also needed if you have changed disks in your
    PC drive or an external C64 drive.

----------------------------------------------------------------------------
##566
3Manager / Add L64 drives

    On startup the emulator searches all four parallel interfaces for
    connected C64 computers and registers all found disk drives in the
    directory tree. You can repeat this search with the Add L64 drives
    command and thus bring afterwards connected drives to the list. This is
    not necessary for the emulator window, loading L64 is enough there.

    In order for the emulator to detect the drives, the connected C64 must
    be running L64. The program can be transferred with the menu command
    <Manager / Clone L64>. All devices on the serial bus with device numbers
    0 to 15 will be detected, if they return a status message on channel 15.
    Except printers, all floppies, hard disks and other drives should
    actually do this.

----------------------------------------------------------------------------
##567
3Manager / Clone L64

    This command transfers the L64 program to an external C64. After that,
    you can access its drives directly from the emulator, for instance with
    LOAD"$",9. This command was implemented to allow your distributor to
    save the production costs and leave a separate 1541 disk out of the
    emulator package.

    Turn both computers off and connect a free parallel port of the PC to
    the user port of the C64. Now start the emulator and execute the menu
    command Manager / Clone L64. A dialog box appears with a 5 lines long
    BASIC listing that you must input and run on the C64.

    When you have started the program on the C64, select the correct printer
    port and start the transfer with OK. It will take about 4 minutes, and a
    progress indicator tells you how far it is.

    As the transfer gets finished, stop the program on the C64 and close the
    file that was created.

    Now you can start the L64 program and test the connection with the
    <Options / Waitstates> command.

    If an error message gets displayed instead of the first dialog box, the
    link program is not located in the emulator start directory. In this
    case, please confirm that you haven't deleted or renamed the L64.P00
    file by mistake.

    If you have installed the 64'er System V1 that was published by the
    German computer magazine 64'er, and if the program is the first file of
    the disk, you can simply start the link with the key combination
    SHIFT+STOP. You don't even need to turn the TV on, as typing errors are
    almost impossible.

----------------------------------------------------------------------------
##568
3Manager / Read ROMs

    This command copies the firmware of a connected C64 to your PC. First
    confirm that the PC and the C64 are connected to each other and that the
    L64 program is running on the C64. If you don't have the L64 program on
    a C64 disk yet, you can transfer it with the <Manager / Clone L64>
    command.

    Execute the command <Manager / Read ROMs>. A dialog box appears.

    <Manager / Read ROMs / KERNAL>
    <Manager / Read ROMs / BASIC>
    <Manager / Read ROMs / Charset>
    <Manager / Read ROMs / Cartridge>
    <Manager / Read ROMs / Disk #x>
    <Manager / Read ROMs / Target directory>

    If the original files are not available in the emulator's starting
    directory, the individual text fields will contain the default names
    that are needed for normal operation of the emulator.

    If a text field is empty, the corresponding ROM will be skipped. After
    the emulator has successfully copied a ROM, it will delete the
    corresponding text field, so that the chip won't be read again if there
    are errors in the other fields.

----------------------------------------------------------------------------
##153
4Manager / Read ROMs / KERNAL

    The actual operating system of the C64 from $E000 to $FFFF. After the
    transfer, you will be asked if you want to activate the shortened memory
    test and if the default device number of LOAD should be changed from 1
    to 8. You can answer both questions with Yes.

    If you have installed further operating systems on your C64, you can
    transfer them also. Just input a different name from ORIGINAL.64K. If
    the custom KERNAL contains different byte sequences in the affected
    addresses, the questions about the memory test and the default device
    number won't be asked.

----------------------------------------------------------------------------
##154
4Manager / Read ROMs / BASIC

    The built-in ROM BASIC V2 from $A000 to $BFFF, which was originally
    programmed by Microsoft. Separately available BASIC extensions are
    normally located at $8000 and must be transferred as cartridge.

----------------------------------------------------------------------------
##155
4Manager / Read ROMs / Charset

    Both character sets for upper and lower case text from $D000 to $DFFF.
    Before the transfer, the data will be copied to $C000, as the character
    set ROM is "under" the I/O chips in the C64, and thus cannot be directly
    accessed.

----------------------------------------------------------------------------
##156
4Manager / Read ROMs / Cartridge

    This is for additional ROM cartridges for the C64's expansion port from
    $8000 to $9FFF. When copying games, you should remove the cartridge
    shortly before reading it out, so that you can load and start the L64
    program. Inserting a cartridge to a running computer should not be done,
    though, and it can crash the program. We take no responsibility if you
    damage your hardware in such trials! A better way is to install a switch
    on the EXROM line, or to use a KERNAL replacement that lets you to
    prevent cartridges from starting. A switch on the GAME line would let
    you to copy UltiMax-style cartridges, too. But they are not supported by
    the current version of the emulator.

    Some cartridges are 16 kilobytes in length, from $8000 to $BFFF. To
    transfer those ones, you must read the second part as BASIC ROM, and
    then select the both parts of it in Options / ROMs as cartridge and as
    BASIC ROM. Another possibility is to concatenate the two files with the
    DOS command

    copy /b cart.64m+cart.64b

    together. This is only a theoretical possibility, though, as you cannot
    load the L64 program if the BASIC is disabled.

    Unfortunately, you can only read a half of the famous Simons' BASIC
    cartridge. The reason is that the cartridge actually contains two 8
    kilobyte ROMs that are switched with a register in $DE00. It is true
    that you will get the startup screen, but when you try to execute a
    command, all you will get is a NEXT WITHOUT FOR ERROR.

----------------------------------------------------------------------------
##157
##158
4Manager / Read ROMs / Disk #x

    This is the firmware of a connected C64's disk drive from $C000 to
    $FFFF. If the file VC1541.64D is not available in the starting
    directory, you cannot work with disk images. Accessing normal PC64 files
    is always possible, though.

    Before the transfer, you must set the correct device number of the
    floppy disk drive, the default is 8. Reading the ROM will take about a
    minute, as no fastloader will be used.

----------------------------------------------------------------------------
##159
4Manager / Read ROMs / Target directory

    The files must be copied to the emulator's starting directory in order
    for it to access them. Thus it is the default. You can change the target
    directory, though, if you want to transfer the firmware for other
    reasons.

----------------------------------------------------------------------------
##8
2The Search menu

    The commands in this menu search the recorded protocol for a text
    string, an address or for a special I/O event. The entries in this menu
    are disabled if a Manager window is currently selected.

    If nothing could be found in the first 1000 lines, a dialog box with a
    Cancel button will be opened.

    In this way, you can stop the search in long protocol files. By the way,
    the graphical display is not a progress indicator, but it indicates the
    absolute position in the protocol file.

    <Search / Text>
    <Search / Address>
    <Search / Continue forward>
    <Search / Backward>
    <Search / Next error>
    <Search / Previous error>
    <Search / Events>

----------------------------------------------------------------------------
##570
3Search / Text

    In this dialog box you can input a text string of up to 78 characters
    that you want to find after the current position. The search is case
    insensitive, so you can only input upper case characters. Wild cards,
    like the question mark, are not available. The search string cannot
    spread over multiple lines either.

    Normally the text will be searched forward. You can change the direction
    with the check box Search backward. It will be cleared every time when
    you enter the dialog box.

----------------------------------------------------------------------------
##571
3Search / Address

    In this dialog box you can input a hexadecimal address range. The search
    will take place as well in the program counter values (column 0) as in
    the data accesses (column 26).

    Usage examples:

    - You are in a loop that is bounded with a 1010 BNE $1000. In order to
      jump to the end of the loop, search for the address $1012.

    - Your program reads a wrong value from the address $8000. By searching
      backward for $8000, you can find the place where the value was
      written.

    - You are in the firmware and would like to find the return to the
      application program. Search for an address in the range from $0800 to
      $9FFF.

----------------------------------------------------------------------------
##572
3Search / Continue forward

    With this menu command, you spring to the next place where the search
    string or address occurs. Whether a text string or an address is being
    searched, is indicated by a check mark next to the corresponding menu
    item.

    You can switch between text and address searches by executing one of the
    commands <Search / Text> or <Search / Address> and by confirming the
    dialog box with OK.

----------------------------------------------------------------------------
##573
3Search / Backward

    The same than <Search / Continue forward>, but in opposite direction.

----------------------------------------------------------------------------
##574
3Search / Next error

    This command jumps to the next error in the protocol file. Errors can be
    located easily, as they will be displayed in red colour.

    Following conditions are treated like errors:

    - A severe problem that crashes the emulation. For example, the hard
      disk runs out of space while recording, or a machine instruction leads
      to crash, like the opcode $02.

    - Accessing property that are not supported by the emulator, for
      instance turning on the ring modulation. These errors will only be
      displayed if the corresponding filter is switched on, in this case the
      SID.

    - An instruction that does not make any sense. For example, the program
      could try to write to a read-only register. Also in this case the
      corresponding filter must be switched on.

    - Errors that occur when accessing PC64 files when the DEV filter is
      switched on. For example, you get the error message 62,FILE NOT
      FOUND,00,00 when the program tries to open a non-existing file.

----------------------------------------------------------------------------
##575
3Search / Previous error

    The same than <Search / Next error>, but in opposite direction.

----------------------------------------------------------------------------
##9
3Search / Events

    This popup menu lets you to jump to the next event of the wanted type.
    Searching backward is possible by using the short-cut key together with
    Shift.

    <Search / Events / Separator>
    <Search / Events / REM(ark)>
    <Search / Events / VIC Graphics>
    <Search / Events / SID>
    <Search / Events / CIA I/O>
    <Search / Events / DEV(ice)>
    <Search / Events / INT(errupt)>

----------------------------------------------------------------------------
##576
4Search / Events / Separator

    A separator will be inserted when you start the emulation in record mode
    with Shift+F5. By stopping the recording with Esc after a short time and
    by continuing the emulation normally again, you can record determined
    sections of the program. If the protocol file is empty before the first
    start, no separator line will be added.

----------------------------------------------------------------------------
##577
4Search / Events / REM(ark)

    Searches for the next remark on undocumented instructions or for the
    next raster line.

----------------------------------------------------------------------------
##578
4Search / Events / VIC Graphics

    Searches for the next access on the Video Interface Controller in the
    address range $D000 to $D3FF.

----------------------------------------------------------------------------
##579
4Search / Events / SID

    Searches for the next access on the Sound Interface Device in the
    address range $D400 to $D7FF.

----------------------------------------------------------------------------
##580
4Search / Events / CIA I/O

    Searches for the next access on either Complex Interface Adapter in the
    address range $DC00-$DDFF, as well as for write accesses to the CPU port
    in the addresses 0 and 1.

----------------------------------------------------------------------------
##581
4Search / Events / IEC Bus

    Searches for the next event on the serial bus that uses the low-level
    serial routines, e.g. Listen or IECOut.

----------------------------------------------------------------------------
##582
4Search / Events / DEV(ice)

    Searches for the next event on the serial bus that uses the higher-level
    device routines, e.g. Open or Close.

----------------------------------------------------------------------------
##583
4Search / Events / INT(errupt)

    Searches for the next event that occurs on the interrupt lines IRQ and
    NMI.

----------------------------------------------------------------------------
##10
2The Run menu

    <Run / Start>
    <Run / Reset>
    <Run / Total Reset>
    <Run / Record>
    <Run / Record Reset>
    <Run / Filters>
    <Run / Clear protocol>

----------------------------------------------------------------------------
##600
3Run / Start

    This command starts the emulation in the active emulator window. If a
    manager window is selected, this command will be disabled.

    The screen will be switched to graphics mode, and the power-on screen of
    the C64 will appear.

    Now you can work just like you do on the C64. For example, to load the
    directory, type LOAD"$",8, and to display it, type LIST. Programs can be
    loaded with LOAD"NAME",8 and started with RUN. However, it is far more
    comfortable with the <Manager / Run> command.

    When you want to return to the desktop again, press the Esc key. When
    you start the emulation again, it will continued from the same place
    where you left it last time. You can even save the complete emulation
    state with the <Emulator / Save as> command to your hard disk.

----------------------------------------------------------------------------
##601
3Run / Reset

    This command resets the emulator. It is the same than pressing the reset
    button on a real C64. The program will ask for your confirmation before
    actually resetting the emulation.

    It is true that most programs and data remain in the memory, but they
    cannot always be restored with a special Old program. So, if you need
    the emulation state before the reset, you must first execute the
    <Emulator / Save> command.

    Some games cannot be reset, but they show their startup screen again.
    This can be accomplished by writing the string CBM80 to memory starting
    from the address $8004. The command <Run / Total Reset> lets you to
    reset such programs.

----------------------------------------------------------------------------
##602
3Run / Total Reset

    The same than <Run / Reset>, but it fills the whole memory with zeroes
    first. It overwrites a possible reset protection of some games, and
    brings advantages with online compression like DoubleSpace or Stacker.

----------------------------------------------------------------------------
##603
3Run / Record

    This command starts the emulator in record mode. All executed processor
    instructions and other events will be recorded in the current window.

    The command <Run / Filters> lets you to specify how much information
    should be recorded.

    If the filter Trace is switched on, the protocol file requires enormous
    amounts of hard disk space. In the average, the file grows by 500
    kilobytes per second. The recording also costs computing time, it eats
    up about 90 to 98 percent of the available power. Because of this, you
    should always start the emulator with <Run / Start> in normal use. You
    should use the record mode only when some programs do not work or if you
    want to see how the processor is working.

    Protocol files and temporary files that will be created when switching
    between several emulator windows will be created in the directory
    specified by the environment variable TEMP. As the files can get several
    megabytes long, you shouldn't set the TEMP variable to a RAM disk. As
    last resort, start the emulator in a batch file and set the variable
    there.

    When the emulator is exited normally, all its temporary files will be
    automatically deleted. But if your computer crashes, you must delete the
    files manually. Because of the enormous data flow to the protocol files,
    you will otherwise lose very much of the disk capacity.

----------------------------------------------------------------------------
##604
3Run / Record Reset

    This command is a combination of <Run / Reset> and <Run / Record>. You
    need it when you want to see how the reset protection works in some
    games.

----------------------------------------------------------------------------
##605
3Run / Filters

    This dialog box lets you to specify what events will be recorded in the
    protocol file.

    The following options are available, and can be turned on or off:

    \bOption        Meaning\p

    TRA(ce)       This check box produces the most output. All executed 6510
                  processor instructions will be displayed.

    REM(ark)      Displays some useful comments, like the meaning of
                  undocumented commands or the start of a new raster line.

    VIC           The Video Interface Controller 6569 (PAL-B and PAL-G) or
                  6567 (NTSC-M) is responsible for displaying the screen. It
                  is located in the address range $D000 to $D3FF.

    SID           The Sound Interface Device chip 6581 generates the sound
                  and random numbers as well as reads the paddles. It is
                  located in the address range $D400 to $D7FF.

    CIA           Both Complex Interface Adapters 6526 are responsible for
                  the I/O. They are located in the addresses $DC00-$DCFF and
                  $DD00-$DDFF. The on-chip I/O register of the CPU in the
                  addresses 0 and 1 falls to the same category.

    IEC           Displays accesses to the serial bus on a lower level, for
                  instance Listen or IECOut.

    DEV(ice)      Device accesses on a higher level, for instance Open or
                  Close.

    INT(errupt)   All events that affect on the interrupt lines IRQ and NMI.

    All settings in this dialog box only affect the active emulator window
    and will be saved with the <Emulator / Save> command. Possible changes
    take place only in further recordings, thus they have no effect on
    already recorded data.

----------------------------------------------------------------------------
##606
3Run / Clear protocol

    This command deletes the recorded protocol in the current emulator
    window. Also the corresponding log file in the TEMP directory will be
    deleted. Then the previously reserved disk space can be used for further
    recordings.

    When you exit PC64, all recordings will be deleted. Thus, they are no
    more available when starting PC64 again.

----------------------------------------------------------------------------
##11
2The Options menu

    The commands in the top part of this menu set the local options for the
    active emulator window. If no emulator window is active, these commands
    are disabled.

    <Options / File>
    <Options / ROMs>
    <Options / Keyboard>
    <Options / Joysticks>
    <Options / Drives>
    <Options / Timing>
    <Options / Sound>
    <Options / All>

    Use <Options / ... / Default for new emulator windows> in one of the
    dialog boxes to make the changes global. The three options on the bottom
    are global for all windows, and they will be saved to the PC64.CFG file.

    <Options / Desktop>
    <Options / Waitstates>
    <Options / Printers>

----------------------------------------------------------------------------
##93
##94
##95
##96
##97
##130
##138
3Options / ... / Default for new emulator windows

    If this check box is on when confirming the new settings with OK, the
    actual settings will be used with all emulator windows that get created
    with the <Emulator / New> command. They also apply to <Manager / Run>,
    if the program to be run does not have individual settings in PC64.PDB.
    As the default settings are already such that as many programs as
    possible run with them, you should be very careful when changing them.

----------------------------------------------------------------------------
##650
3Options / File

    <Options / File / Save on Exit>

----------------------------------------------------------------------------
##50
##51
##52
4Options / File / Save on Exit

    With this radio button group you specify if the emulator state is
    automatically saved when you close the corresponding window or exit the
    emulator. The following settings are possible:

    \bOption                Meaning\p

    Ask user              On closing the window, a dialog box appears that
                          asks you if the changes should be saved.

    Yes, overwrite file   If changes have been made, they will be saved
                          without asking. The old contents of the *.C64 file
                          will be overwritten.

    No, discard changes   If changes have been made, they will be discarded
                          without asking. If this setting should be
                          permanent, you must answer to the following
                          question with Yes.

    The reason for asking the question is that the settings will be saved to
    the *.C64 file. Thus, when closing the window, they will be either saved
    or discarded. If the setting "No, discard changes" is selected, and the
    file hasn't been explicitly saved before closing the window, the setting
    will be discarded. By saving the file you accomplish that the setting is
    in effect also in later sessions.

----------------------------------------------------------------------------
##651
3Options / ROMs

    This dialog box selects the ROM chips for the actual emulator window.
    The setting is local, so you can work with several operating systems in
    different windows simultaneously.

    <Options / ROMs / Cartridge>
    <Options / ROMs / KERNAL>
    <Options / ROMs / BASIC>
    <Options / ROMs / Charset>

----------------------------------------------------------------------------
##20
4Options / ROMs / Cartridge

    This list box lets you to activate an additional ROM at $8000. The
    corresponding files have the .64M suffix and are either 8 or 16
    kilobytes long. On a real C64, you should insert a cartridge to the
    expansion port to accomplish this.

    Usually games are delivered on cartridge as a copy protection. But there
    are also command expansions in this form, for example Simons' BASIC.
    Many cartridges contain additional hardware that unfortunately cannot be
    emulated. In such case, you should try to get a disk version of the
    program.

    Normally you should select the entry (none), because many programs do
    not work with a cartridge inserted.

----------------------------------------------------------------------------
##21
4Options / ROMs / KERNAL

    In this list box you can select the actual operating system of the
    emulated C64. It is in the memory at $E000. The corresponding files have
    the suffix .64K and are always 8 kilobytes long.

    In the file ORIGINAL.64K, two little things were changed. First, the RAM
    test only checks one byte per memory page, because RAM defects will
    already be detected by the PC's BIOS. Thus the power-on screen of the
    emulated C64 appears much faster. Second, the device number 8 is the
    default with the LOAD command, because the cassette recorder interface
    is not supported anyway. So, you can also load the directory with
    LOAD"$.

    The German computer magazine 64'er, published by the MagnaMedia Verlag
    (former Markt&Technik Verlag), has published an enhanced operating
    system called 64'er System V1 that works in the emulator in spite of its
    built-in fastloader. Such expanded operating systems usually offer more
    user friendliness than the original by Commodore. For instance, the
    64'er System shows the directory of drive 8 by pressing F1.

----------------------------------------------------------------------------
##22
4Options / ROMs / BASIC

    In this list box, the BASIC interpreter at $A000 can be selected. The
    corresponding files have the .64B suffix and are always 8 kilobytes
    long. There are also programming languages on cartridges that also begin
    at $A000 and must therefore be loaded as BASIC.

    There are also improved BASIC versions with comfortable graphics and
    sound functions available, clearly winning the possibilities of the
    built-in BASIC V2. They are usually longer than 8 kilobytes, though, so
    they must be loaded as a stand-alone program or as a cartridge.

----------------------------------------------------------------------------
##23
4Options / ROMs / Charset

    This list box selects the character set at $D000. The corresponding
    files have the .64C suffix and are always 4 kilobytes in length.
    Actually there are two character sets, which are 2 kilobytes each. You
    can switch between upper and lower case characters with SHIFT+CBM, which
    is Shift+Alt on the PC. The character matrix is 8 times 8 points big,
    and there are normally only 128 different characters. The other half is
    the inverse of the first half and makes it possible for the cursor to
    blink. The character set ORIGINAL.64C contains a little cosmetic error
    in the graphics characters Alt+G (101) and Alt+M (103). According to the
    keyboard printings, they should be one pixel column wide, but are
    actually two columns wide. This was necessary, as the VIC-II can produce
    color errors with one pixel wide lines.

----------------------------------------------------------------------------
##652
3Options / Keyboard

    <Options / Keyboard / Use national keyboard driver>
    <Options / Keyboard / Enable Ctrl+Tab (switch windows)>

----------------------------------------------------------------------------
##99
4Options / Keyboard / Use national keyboard driver

    This check box specifies how the PC keyboard is redirected to the C64
    keyboard. If the option is switched on, the KERNAL address $EA87 will be
    patched with the pseudo instruction $92. Each time when the C64 wants to
    read the keyboard, the emulator retrieves a key code using the BIOS
    interrupt 16h and converts it to the C64 format. In this way you can use
    all keys normally; the German umlauts will be converted to double
    wovels. Characters can be input even with the number keypad using
    Alt+xxx, or by using the Windows clipboard.

    If the option is turned off, the C64 keyboard will be exactly mapped to
    the PC keyboard. The print on the keys and the resulting characters
    won't always match any more. But now the keyboard can be queried with
    the CIA addresses $DC00 and $DC01, and also programs that use custom
    keyboard routines will work. A piano program that lets you to press
    multiple keys simultaneously is a good example.

    The conversion from the PC keyboard to the C64 graphics characters can
    be found at the end of this manual.

----------------------------------------------------------------------------
##98
4Options / Keyboard / Enable Ctrl+Tab (switch windows)

    This check box specifies if switching to another window with Ctrl+Tab or
    Shift+Ctrl+Tab is enabled in the emulation. If the new window also is an
    emulator window, it will be started when you release the Ctrl key. In
    this way you can switch very fast between different virtual C64s.

    Because the Tab key on the PC corresponds to the STOP key on the C64,
    you must deactivate this option if a program requires the key
    combination CTRL+STOP.

----------------------------------------------------------------------------
##653
3Options / Joysticks

    You can open this dialog box also from the emulation with F10.

    <Options / Joysticks / Port>
    <Options / Joysticks / Auto fire>

----------------------------------------------------------------------------
##24
##25
##26
##27
##28
##29
##30
##31
##32
##33
##34
##35
##36
##37
##38
##39
4Options / Joysticks / Port

    With these two radio button groups you connect the PC's different input
    devices to the emulated C64 joystick ports 1 and 2. Following settings
    are possible:

    \bOption           Meaning\p

    None             There is nothing connected to corresponding port.

    Keyboard         The games will be controlled with the arrow keys on the
                     number keypad, and the Right Ctrl key is the fire
                     button. This is the only possible option in the
                     shareware version. Num Lock must be switched off, or
                     else you will be inputting numbers. You can use all
                     eight directions, also the keys askew. If you press two
                     opposite keys, the direction bits will be deleted. Such
                     combinations are impossible on a real joystick and
                     crash some games.

    Analog A and B   With these options, you convert the conventional analog
                     joysticks of the PC to the digital format. The
                     reference value will be read each time when starting
                     the emulation with F5, and the joystick should be in
                     the middle position at this time. Values that differ
                     from the reference value by more than 5/16 will be
                     interpreted as direction changes. Run TESTJOY.EXE if
                     your analog joystick is not working correctly.

    LPT1: through    Here it comes to a real digital joystick, which is
    LPT4:            connected to the parallel port with the PC64 cable or
                     with the alternative joystick adapter. If the joystick
                     is not working correctly, you can check its operation
                     with the <Options / Waitstates> command and add some
                     waitstates if required.

    It is allowed to set both joystick ports to the same source, e.g.
    Keyboard. In two-player mode you can then share the keyboard with your
    opponent, as long as the game doesn't require any simultaneous actions.

----------------------------------------------------------------------------
##40
##41
##42
##43
##44
##45
##46
##47
4Options / Joysticks / Auto fire

    These two radio button groups are very useful in fast arcade games,
    where you must release the fire button between two shots. In addition,
    you can avoid breaking your fire button or Right Ctrl key with this
    option. The following settings are possible:

    \bOption            Meaning\p

    Off               No autofire active, the fire button functions
                      normally.

    Button            As long as the fire button is pressed down, the
                      autofire will be active at the given frequency.

    Switch            When you press the fire button once, the autofire will
                      be switched on. It remains active until you press the
                      button for a second time.

    Frequency in Hz   Here you must input the auto fire speed. Values from
                      0.01 to 999 Hz are allowed, and the default is 10 Hz.
                      This means that the fire button will be switched on
                      and off 10 times per second. The make/break ratio is
                      1:1 and cannot be altered.

----------------------------------------------------------------------------
##654
3Options / Drives

    This dialog box can also be opened from the emulation with F9. With it
    you can switch disks fast. After leaving the dialog box, you will return
    to the C64 program.

    <Options / Drives / Drive #>
    <Options / Drives / Drive on>
    <Options / Drives / Directory tree>

----------------------------------------------------------------------------
##145
##146
##147
##148
##149
##150
##151
##152
4Options / Drives / Drive #

    This radio button group selects the device number of the emulated disk
    drive that you would like to turn on or whose disk you would like to
    change. When you enter the dialog box, it will always be set to 8, as
    few programs require more than one disk drive.

    After each new selection, the directory tree and the check box for
    turning the drive on will be updated. You can now make the changes and
    then select another disk drive.

----------------------------------------------------------------------------
##48
4Options / Drives / Drive on

    With this check box you can turn the corresponding drive on and off. You
    should always turn on only as many disk drives as you need. A disk drive
    that is turned off does not require any memory, and returns a DEVICE NOT
    PRESENT error in the emulation.

    If you turn a drive off, also the corresponding path will be lost. When
    turning the drive on again, you must set it in the directory tree.

----------------------------------------------------------------------------
##49
4Options / Drives / Directory tree

    In the directory tree you select the DOS path for the selected C64
    drive. You can also select disk images, which are indicated by a .D64
    suffix. External C64 drives can also be accessed from the emulator, they
    will be displayed as a number followed by a colon. For instance, 28:
    indicates drive 8 on the C64 connected to LPT2.

    To update the list with later inserted external drives, you must use the
    main menu command <Manager / Add L64 drives>.

----------------------------------------------------------------------------
##655
3Options / Timing

    <Options / Timing / Update screen every xth vertical refresh>
    <Options / Timing / Limit 6510 performance to x percent>
    <Options / Timing / Use VideoCounter algorithm #x>
    <Options / Timing / Start of interrupt consumes x cycles>
    <Options / Timing / VIC[12h]: Report new line at x percent>
    <Options / Timing / Enable char and sprite DMA>
    <Options / Timing / Video>
    <Options / Timing / Real time>

    This dialog box also displays the achieved computing power. The emulator
    must run for a couple of seconds in order to make the value reliable.

    The value is in percents. 100 percent mean that the computing power of
    a C64 computer running at a 985248 Hz clock speed was achieved.

    The displayed computing power is the average power during the last
    emulation run. As the screen cache must be built up first, unless you
    have selected <Options / Desktop / VGA has VL or PCI bus>, the emulation
    should run at least a couple of seconds to get correct results. The time
    measurement is also affected by multitasking systems like DesqView,
    Windows, OS/2 and NT.

----------------------------------------------------------------------------
##139
4Options / Timing / Update screen every xth vertical refresh

    In this edit box you can speed the emulation up on slow computers. It is
    made so that the VIC-II does not refresh the screen on every vertical
    refresh, but on every second, every third and so on. The top limit is
    60. With this setting, the screen will be drawn only once per second
    (NTSC-M).

    The raster counter in the VIC-II register 12h continues to work
    normally, also when the screen is not being refreshed. Also raster
    interrupts will be generated, otherwise some games would become much
    slower. But the sprite collisions won't be detected. In an arcade game
    this can mean that your bullet will go through your opponent if the
    screen is not currently being updated.

    The best setting in this field depends on your computer. It's best to
    use the smallest number that still makes 100 percent of computing power
    available. For instance, on a 486DX-33 with a fast graphic gard, it is
    2.

----------------------------------------------------------------------------
##142
4Options / Timing / Limit 6510 performance to x percent

    In this field you can limit the performance of the emulator, if your
    games are running too fast. You can input values from 1 to 65535. With
    100 the emulator runs just as fast as a real C64, but only if your PC
    has enough computing power.

    You can also change this setting in C64 mode with LShift+GreyPlus/Minus.
    The steps are 5 units between 10 and 150 percent and 10 units above.

----------------------------------------------------------------------------
##102
4Options / Timing / Use VideoCounter algorithm #x

    The VideoCounter VC is a hidden counter in the VIC-II that points to the
    beginning of the current text row in the video matrix. Another counter,
    the so called RowCounter RC, counts always from 0 to 7 and thus
    determines the raster line of a single character. Every 8 lines, the RC
    will be reset to zero, the VC will be incremented by 40, and the next
    text row will be read to a buffer. This process costs 40 clock cycles,
    and the CPU will be stopped during it.

    Unfortunately, the exact algorithm is not known yet, as the VideoCounter
    will also be affected by the Y scroll register 11h. That is why you can
    select between several algorithms in the edit field.

    Algorithm #1:

    RC++;
    if ((RasterLine & 7) == Y) {
      RC = 0;
      VC = (RasterLine - 48 >> 3) * 40;
      LoadBuffer(VC);
    }

    Algorithm #2:

    if (RasterLine == 48) {
      VC = -40;
    }
    RC++;
    if ((RasterLine & 7) == Y) {
      RC = 0;
      VC += 40;
      LoadBuffer(VC);
    }

    Algorithm #3:

    RC++;
    if (RC == 8) {
      VC += 40;
    }
    if ((RasterLine & 7) == Y) {
      if (RasterLine >> 3 == 6) {
        VC = 0;
      }
      RC = 0;
      LoadBuffer(VC);
    }

    If VC or RC are not in the allowed range, the contents of the memory
    place $3FFF will be displayed.

    There is at least one game that does not run with a given algorithm. So,
    if the screen is distorted on vertical scroll, simply try another
    algorithm out.

----------------------------------------------------------------------------
##143
4Options / Timing / Start of interrupt consumes x cycles

    On a real C64, it takes seven clock cycles before the processor jumps to
    an interrupt routine after detecting the interrupt. Also, the processor
    must finish the current instruction first, and due to the pipelining, it
    will finish the next instruction also, if the interrupt occurs when
    executing the last two cycles of the current instruction.

    Often the interrupt handlers are written so that the visual changes on
    the screen won't be made at once when entering the routine, but the
    program will make some housekeeping chores first. During this time, the
    raster beam moves to the end of the current raster line. The screen
    modes will be switched when the raster beam is in the invisible border
    between the end of the current line and the beginning of the following
    raster line.

    This zone had to be reduced to a single clock cycle on PC64, because the
    CPU and the VIC-II are not running simultaneously. By changing the
    interrupt execution time, you can move the beginning of the next raster
    line, if the modes will be switched too early or too late. Even negative
    values are possible to give more time for the IRQ handler on the first
    raster interrupt line.

    You can change this setting also in the emulation. Press Ctrl+NumPlus or
    Ctrl+NumMinus to achieve this.

----------------------------------------------------------------------------
##129
4Options / Timing / VIC[12h]: Report new line at x percent

    With this field you specify at which time the VIC-II reports the
    beginning of a new raster line. The reason for this abnormal option is
    in the way the emulator works. On a real C64, the CPU and the VIC-II
    work almost independent of each other. On the other hand, to save
    computing power, the emulator calls every 64 microseconds a subroutine
    that draws one scan line on the screen. Between these subroutine calls
    the VIC-II seems to be dead, and the CPU runs alone.

    If a fast program reads the current scan line from the register 12h and
    sets a new background color immediately, on a real C64 it will happen
    yet before the raster beam reaches the visible left screen border. On
    the other hand, if it is a slow program, the beam can have left the
    right border already. As the emulated VIC-II is dead between the two
    lines, it cannot be forecast if the VIC-II register 12h should report
    the current line or the following raster line. Because of this, you can
    use this edit box to specify how many percent of the current line must
    be behind before the register 12h will be incremented.

    You can change this setting also in the emulation. Press Alt+NumPlus or
    Alt+NumMinus to achieve this.

    The option "VIC[12h]: Report new line at x percent" is the same for
    polling raster effects than
    <Options / Timing / Start of interrupt consumes x cycles> is for raster
    interrupts. If sprites are glittering in some games, or if sprite lines
    are missing, you should try to change these parameters to get a correct
    display.

----------------------------------------------------------------------------
##144
4Options / Timing / Enable char and sprite DMA

    Every 8 raster lines, the next text row with its color information will
    be read to an internal buffer. This process halts the processor and
    consumes 43 clock cycles. The video chip takes additional 3 cycles for
    setting the DMA up, to ensure that the processor really stops. The
    processor has the bug that it doesn't stop at DMA when it is performing
    a write cycle, and the maximum amount of consecutive writes is 3.
    Sprites take 2 cycles each, plus the security time of 3 clock cycles.

    Some games depend on these delays, and will display ghost sprites near
    the bottom of the screen, if this check box is not activated. Other
    games have a tight timing, and screen lines that contain sprites will
    start to flicker if the check box is activated. When in doubt, you must
    try which is the correct setting.

----------------------------------------------------------------------------
##140
##141
4Options / Timing / Video

    Here you can switch between PAL (code G) and NTSC (code M). The change
    does not become fully active until a reset. Here are the differences
    between PAL-G and NTSC-M:

    \bVariable                             PAL              NTSC\p
    System clock frequency (Phi2)        17734472/18 Hz   14318181/14 Hz
    KERNAL value for Timer 1A            16421            17045
    (Phi2/60 Hz)
    Table for RS-232 time constants      $E4EC            $FEC2
    Frequency for the TOD clocks 1&2     50 Hz            60 Hz
    CIA[14] bit 7 (in KERNAL always 0)   1                0
    Screen refresh rate                  50 Hz            60 Hz
    Lines for top border                 52 (311, 0-50)   27 (24-50)
    Lines for bottom border              49 (251-299)     25 (251-262, 0-12)
    Lines for vertical retrace           11 (300-310)     11 (13-23)
    Amount of lines per frame            312              263
    Amount of clock cycles per line      63               65
    Factor for SID voices 1-3            17,02841         16,404389
    (F*2^24/Phi2)
    PAL/NTSC flag at address $02A6       1                0

    The PAL-G norm with 50 Hz is in use in Europe, and the NTSC-M norm with
    60 Hz is used in North America. Because emulating the VIC-II consumes
    very much computing power, you should leave the default to PAL. The
    bigger screen refresh rate in NTSC-M only uses up additional computing
    time. But there are some games that have a critical timing, and do not
    run on a PAL-G C64. When running such games, you usually also need to
    switch off the real time options of all timers.

----------------------------------------------------------------------------
##120
##121
##122
##123
##124
##125
4Options / Timing / Real time

    These check boxes determine if the corresponding functions should be run
    in real time. Unlike the CPU emulation, it is always possible, even if
    the PC is not fast enough. You can try it out with your PC's turbo
    switch. If the check box is not set, the corresponding option is
    emulated with the same speed than the CPU.

    \bOption               Meaning\p

    TOD 1, TOD 2         Both built-in Time Of Day clocks that run at the
                         AC net frequency on a real C64. They are used in
                         some games for controlling a time limit.

    Timer 1A             Normally generates an IRQ 60 times per second and
                         thus determines the blinking rate of the cursor.

    Timer 1B             Freely usable, can also be programmed to generate
                         an IRQ. When cascading Timer A and Timer B
                         (concatenating them to a 32-bit counter), this
                         option doesn't have any effect, and the speed will
                         only be determined by the Timer A underflows.

    Timer 2A, Timer 2B   Are both freely usable and can be programmed to
                         generate NMIs. Cascading is done in a similar
                         manner than with Timer 1B.

----------------------------------------------------------------------------
##656
3Options / Sound

    <Options / Sound / Volume>
    <Options / Sound / Enable Voices and Samples>
    <Options / Sound / Detected Hardware>

----------------------------------------------------------------------------
##131
##132
##133
##134
##135
4Options / Sound / Volume

    With these five sliding switches you can set up the volume that is used
    to play the music and sound effects in the current emulator window. If
    some of the switches are grayed, then you don't have the corresponding
    hardware. The settings can be changed in any case, but they will have
    effect only when the file is opened on a computer with the corresponding
    hardware.

    \bOption       Meaning\p

    AdLib        This setting affects on the music output from the SID
                 voices 1 to 3. Because the AdLib card does not have any
                 master volume level, the effect must be simulated through
                 the Total Level register of the individual voices. Because
                 these registers work logarithmically, the volume level
                 drops drastically in the top area of the sliding switches.

    DSP          This is for setting the volume level of the samples that
                 can be played through the $D418 register bits 0 to 3 on the
                 C64.

    Master, FM   These tree sliding switches control a SoundBlaster Pro
    and Voice    compatible mixer. The basic setting is 9. Because the AdLib
                 card and some simple SoundBlaster cards do not have any
                 mixer, you should set up the basic settings with the AdLib
                 and DSP switches.

    You use the three mixer switches only when you need to temporarily raise
    the volume level. In this way, you can load your *.C64 files also on
    other computers.

----------------------------------------------------------------------------
##136
##137
4Options / Sound / Enable Voices and Samples

    With these two check boxes you can deactivate both kinds of sound
    effects independent of each other. It is better than setting the
    corresponding volume level to 0, since the emulator will run a bit
    faster when ignoring the I/O events. The required 23 microsecond delays
    between consecutive accesses to the AdLib card can also be avoided.

    \bOption    Meaning\p

    Voices    This option activates the output of the SID voices 1 to 3.

    Samples   This one activates the output of sampled sound effects from
              the SID register $D418.

----------------------------------------------------------------------------
4Options / Sound / Detected Hardware

    This status box displays the detected hardware. AdLib and SoundBlaster
    compatible cards will be detected. In Windows 3.1 Enhanced Mode, the
    sound hardware won't sometimes be virtualized, and generating sounds
    will be disabled. To avoid the possible two error messages at program
    start, you can disable the automatical detection in Enhanced Mode by
    turning off <Options / Desktop / Sound in Windows Enhanced Mode>. In
    Windows NT, no sound hardware will be detected at all.

    \bOption  Meaning\p

    AdLib   9-voice FM music in the addresses 0388h and 0389h. The card will
            be detected using the official method by AdLib, as described in
            the CompuServe file SSForum\\Lib16\\FMPROG.ZIP.

    DSP     Digital Signal Processor on SoundBlaster cards for playing
            samples. It will be detected by the reset sequence of the SB
            Developer Kit by Creative Labs. The address will be taken from
            the environment variable BLASTER, for instance A220 I2 D1 T2 for
            a SBPro 1.0 at address 0220h with IRQ2 and DMA1. If this
            environment variable is not set, then it will be searched in the
            addresses 0220h, 0240h, 0260h, 0210h, 0230h and 0250h in this
            sequence. If you have a network card in these addresses that
            doesn't survive this, you should set the environment variable
            BLASTER to a imagined value, e.g. A200.

    Mixer   Programmable volume level control on SoundBlaster Pro cards.
            This one will be detected by checking the DSP version number. If
            it is greater than or equal to 3.0, then there is a mixer chip
            available. Uncompatible mixers on other cards are not supported.

----------------------------------------------------------------------------
##657
3Options / All

    This command should be understood as an input help when doing massive
    changes in the settings of the current file. It opens all dialog boxes
    in the Options menu before the separator line, one after each other. You
    cannot break the command, but you can get fast through the dialog boxes
    by pressing the Esc key until the dialog boxes disappear.

----------------------------------------------------------------------------
##658
3Options / Desktop

    The settings that appear in this dialog box get saved in the PC64.CFG
    file and thus apply to all loaded files.

    Note that you must close the dialog box with OK, in order for the
    settings to be saved. If you cancel with Esc, your whole setup effort
    will get lost!

    <Options / Desktop / Item and Color>
    <Options / Desktop / Ask user to save window>
    <Options / Desktop / VGA has VL or PCI bus>
    <Options / Desktop / 28 line mode at start>
    <Options / Desktop / Swap into EMS and XMS>
    <Options / Desktop / Sound in Windows Enhanced Mode>
    <Options / Desktop / Auto arrange windows>
    <Options / Desktop / Maximize single window>
    <Options / Desktop / New window replaces old>

----------------------------------------------------------------------------
##71
##72
##73
##74
##75
##76
##77
##78
##79
##80
##81
##82
##83
##84
##85
##86
##87
4Options / Desktop / Item and Color

    With these controls, you can set up the colors in individual windows.
    When you select the item that you want to change in the item list, the
    selection in the radio button group changes to the current value. Now
    switch to the radio button group with Tab, and select a new color with
    the direction keys. You can switch back to the item list with Shift+Tab
    to select another item. You can also use the mouse, it is a bit faster.

    In the extended video modes or with some old VGA cards, the screen
    refresh rate can be smaller than 72 hertz. In this case, you should use
    a black background in the windows to protect your eyes.

    If you often need to switch between color and black&white, for instance
    if you use a laptop with an external VGA color monitor, the color
    settings will be used with both display types. You can change this with
    a batch file that maintains two configuration files and renames one of
    them to PC64.CFG before starting PC64.EXE. But then the last used files
    will not always be automatically loaded.

    Even though it would have been possible to make also the desktop colors
    adjustable, it wasn't made, since it would only have confused you with
    additional 50 list items.

----------------------------------------------------------------------------
##53
4Options / Desktop / Ask user to save window

    When this checkbox is checked, you will be asked every time when a new
    emulator window is being closed if its contents should be saved.

    The switch only affects on windows that have been created with the
    <Emulator / New> or <Manager / Run> commands, that is, windows whose
    title bar doesn't contain any file name ending in *.C64. For emulation
    windows that have been saved at least once, the corresponding option is
    in the <Options / File> dialog box. With that option, you can determine
    for each individual window whether its contents will be automatically
    saved.

----------------------------------------------------------------------------
##88
4Options / Desktop / VGA has VL or PCI bus

    This checkbox can speed up the emulation in some cases. Try it out to
    see which setting makes the emulator to run faster. If you cannot notice
    any difference, you can see the measured computing power with the
    <Options / Timing> command. But note that the emulation must run for a
    couple of seconds first and that all changes on the screen distort the
    result.

    As the video memory is not installed on the motherboard, the processor
    must access it through the slow ISA bus. Because it takes much time, the
    emulator maintains a copy of the graphics screen in the main memory and
    only transfers the visible changes to the graphics card. Naturally also
    the comparison takes time, but it's much less than the time needed to
    access the graphics memory. On a conventional ISA computer, this trick
    almost doubles the execution speed.

    Newer computers don't have the VGA card on the slow ISA bus any more.
    With the fast bus systems VESA Local Bus and PCI, the screen cache
    doesn't speed the things up any more, but it only consumes time and main
    memory.

----------------------------------------------------------------------------
##89
4Options / Desktop / 28 line mode at start

    This check box enables the desktop display in an extended video mode
    with 80*28 characters. In contrary to the normal text mode, you get 3
    more lines on the screen.

    The change in this setting does not take place until you restart the
    emulator. So, you must exit the program with Alt+F4 and start it again
    to enjoy the 28 line mode.

    A further reason for this option not working is that the mode won't be
    changed if an enhanced video mode is already selected. The 28 line mode
    will only be activated if the current video mode is 02h or 03h, the
    screen width is 80 characters, and the current text font is 16 pixels
    high.

    Some mouse drivers do not work with the 28 line mode. There are no
    problems with the Microsoft mouse driver version 8.20, but not everyone
    has an original Microsoft mouse. In such case you unfortunately must
    forget about the 28 line mode, or get a newer mouse driver.

----------------------------------------------------------------------------
##100
4Options / Desktop / Swap into EMS and XMS

    With this check box, you allow swapping PC64 to EMS and XMS when
    executing the <Emulator / DOS shell> command. If the option is disabled,
    or there is not enough expanded memory available, a swap file in the
    directory specified by the environment variable TEMP will be created. It
    takes a bit longer, but doesn't use up any memory.

----------------------------------------------------------------------------
##101
4Options / Desktop / Sound in Windows Enhanced Mode

    If a DOS program tries to access the sound card in Windows 3.1 Enhanced
    386 mode, Windows sometimes switches back to its graphics display and
    displays two error messages. This is because the drivers SBPFM.DRV and
    VSBPD.386, which get loaded in the SYSTEM.INI file, don't always
    understand each other. In order to avoid the two annoying error
    messages, you must deactivate this check box. PC64 will then detect if
    it runs in Windows Enhanced mode, and the error messages won't appear
    any more. Naturally also the emulated C64 will remain silent.

    The driver SBP2FM.DRV and SoundBlaster compatible cards with other
    drivers don't have this problem any more. You can also delete the item
    Device=VSBPD.386 in your SYSTEM.INI file. But it is not so good, as then
    also programs running in the background will have access to the
    SoundBlaster card. In any case, you must leave the check box "Sound in
    Windows Enhanced Mode" checked, or PC64 won't access the sound card at
    all.

    By the way, in Windows NT, the sound doesn't work at all, as almost
    every direct access to the hardware is forbidden.

----------------------------------------------------------------------------
##90
4Options / Desktop / Auto arrange windows

    This check box helps you to maintain the overview with multiple windows.
    Whenever a window is opened, closed, minimized or restored to its
    original size, the emulator will arrange the desktop using the last
    command you selected from the Windows menu. Thus, if you have used the
    <Windows / Tile horizontal> command, and the auto arrange option is
    turned on, your windows will always be tiled horizontally on the screen
    without you having to do anything.

----------------------------------------------------------------------------
##91
4Options / Desktop / Maximize single window

    With this check box you determine if a window will always be maximized
    if there are no further windows on the screen. The window borders will
    then disappear and the window title will be concatenated to the main
    window title. Thus more information will fit on the screen, and you get
    a better overview.

    Of course you can also maximize windows when there are multiple windows
    on the screen. Just execute the Maximize command in the system menu, or
    click on the arrow in the top right window corner.

----------------------------------------------------------------------------
##54
4Options / Desktop / New window replaces old

    When this check box is activated, the commands <Emulator / New>,
    <Emulator / Open> and <Manager / Run> commands will automatically close
    an existing emulator window before opening the new one. In this way,
    there won't be any windows remaining on the desktop when you don't need
    them any more. But if you like to work with multiple windows, then you
    must turn this option off.

    Manager windows and minimized windows won't be automatically closed.
    Thus, if you want to leave a program open, then you must minimize the
    corresponding window.

----------------------------------------------------------------------------
##659
3Options / Waitstates

    With this dialog box you can test the link between the PC and C64 as
    well as the operation of the digital joystick, and if required, add some
    wait states. In the following picture, the joystick is being pushed up,
    by the way.

    <Options / Waitstates / Link and joystick waitstates>
    <Options / Waitstates / C64 screen on for debugging>

    Turn off both computers and connect the PC and the C64 with the PC64
    cable. If you have a digital Atari 2600 type joystick, connect it to the
    cable, too. Now start the emulator on the PC and the L64 program on the
    C64. It is located in the starting directory of the emulator and can be
    transferred to the C64 with the command <Manager / Clone L64> at any
    time.

    As soon as you have selected the correct interface in the dialog box,
    the transfer begins automatically. The L64 version number, the amount of
    transferred kilobytes, the amount of transfer errors occurred and the
    average transfer speed in kilobytes per second will be displayed. If
    errors keep occurring, you should increase the Link Waitstates value.

    You can also move the digital joystick while the transfer is running and
    see from the arrow indicators if the movements are detected properly. If
    you use the alternative joystick adapter, then the text "Alt.Joyst."
    instead of Joystick will be displayed in the joystick indicator title.
    If this is not the case, you must increase the waitstates on the
    corresponding interface. When there are too few waitstates, some
    directions can also gitter or they do not work at all, or the title
    keeps changing between Joystick and Alt.Joyst.

    After all settings satisfy you, exit the dialog box with OK, so that the
    new values will be written to the file PC64.CFG.

----------------------------------------------------------------------------
##109
##110
##111
##112
##113
##114
##115
##116
4Options / Waitstates / Link and joystick waitstates

    In order to protect the interface ports from high frequency signals,
    computer manufacturers equip them with bypass capacitors. Unfortunately,
    there is no standard for this, and there can also be component
    differences of up to 10 percent. A possible consequence is that a
    handshake signal which is sent later than the actual data, will reach
    the PC earlier, and garbage will be read.

    Because of this, you can add extra waitstates to each port access. It is
    true that they slow down the transfer rate, but on the other hand, they
    will increase the data security. The wait states can be set in the
    matrix of 4 times 2 input fields. In the upper line you set up the link
    wait states, and the lower line is for the joystick. There are columns
    for each printer port, so that you can set the waitstates individually.

    Values from 0 to 127 are allowed, and as an input help, you can also
    click with the mouse on the arrows next to a input box. All changes will
    take place at once, and you can instantly see the consequences in the
    error rate, transfer rate and joystick display.

----------------------------------------------------------------------------
##117
4Options / Waitstates / C64 screen on for debugging

    This check box tells the link to display all commands that it receives
    from the PC for controlling purposes.

    When you disable this, the link will blank the screen. This increases
    the transfer rate by about 10 percent, because the VIC-II doesn't need
    to read the screen memory any more, and leaves the processor's clock
    cycles alone. Also scrolling the screen output won't slow down anything
    any more.

    On a C128, not only the screen will be blanked, but the processor will
    be switched to the 2 MHz mode, which doubles the transfer rate to 20
    kilobytes per second.

----------------------------------------------------------------------------
##660
3Options / Printers

    This dialog box lets you to link the C64 printers to DOS files or
    devices. As this command was integrated to the emulator in a late stage,
    the settings in this emulator version are still global, that is, they
    apply to all emulator windows.

    <Options / Printers / Device>
    <Options / Printers / File name or DOS device>
    <Options / Printers / Delete>
    <Options / Printers / Character mapping CBM to ASCII>

----------------------------------------------------------------------------
##160
##161
##162
##163
4Options / Printers / Device

    You switch between the available device addresses in this radio button
    field. You can connect up to four virtual printers simultaneously.

    The default printer on the C64 is the device number 4. When you select a
    new device number, the other controls will be updated.

----------------------------------------------------------------------------
##164
4Options / Printers / File name or DOS device

    Here you input the name of the file or DOS device where you want to have
    the print output. If you want to print directly on a printer, input a
    DOS device name like PRN, LPTx or COMx. If the input box is empty, you
    will get a ?DEVICE NOT PRESENT ERROR in the emulator when trying to
    print.

----------------------------------------------------------------------------
##165
4Options / Printers / Delete

    Any data that is printed will be appended to the end of the file. With
    this command you can delete the print output file, so that the new
    printout will be right in the beginning of the file. You will be asked
    to confirm this command.

    After deleting, the old file contents will naturally be lost.

    The command button Delete is disabled if the file does not exist or if
    it is a DOS device.

----------------------------------------------------------------------------
##166
##167
##168
##169
4Options / Printers / Character mapping CBM to ASCII

    As the C64 and the PC use different character sets, you can set the
    wanted conversion with this radio button group.

    \bOption            Meaning\p

    IEC Channel 0/7   The data will be converted according to the secondary
                      address used with the OPEN command. If it is missing
                      or is 0, the CBM characters will be converted to IBM
                      upper case characters. With the secondary address 7
                      they will be converted to lower case instead, and when
                      using any other secondary address, no conversion will
                      take place.

    None              The data will be sent to the printer without any
                      conversion, so that also graphics is possible. The C64
                      software used must naturally include the corresponding
                      printer driver. Also note that the C64 code CR (13)
                      for end of line will not be converted to CRLF any
                      more. Because of this, you must use a file number
                      bigger than 127, or add the line feeds manually with
                      CHR$(10).

    Upper case        The C64 upper case character set will be converted to
                      the IBM character set Code page 437. The control codes
                      7, 8, 9 and 12 will get through without conversion,
                      the code 10 will be ignored, and 13 and 141 will be
                      converted to CRLF. All other codes will be converted
                      to printable characters.

    Lower case        The same with the other C64 character set with lower
                      case letters. In the emulation you can switch between
                      these character sets with Shift+Alt.

    The program PRINTER in the emulator's starting directory prints both
    character sets as well as a graphics bar with all codes from 0 to 255 on
    Epson compatible printers.

----------------------------------------------------------------------------
##12
2The Windows menu

    <Windows / Tile horizontal>
    <Windows / Tile vertically>
    <Windows / Cascade>
    <Windows / Arrange icons>
    <Windows / Active window>

    If the switch <Options / Desktop / Auto arrange windows> is active, the
    latest arrange command selected from this menu will be repeated whenever
    a window opens or closes.

----------------------------------------------------------------------------
##700
3Windows / Tile horizontal

    This command arranges all windows on the desktop on top of each other,
    tiling them horizontally. This is the standard setting.

    In emulator windows, you can thus see the whole width of a record
    protocol. Manager windows will display three columns of file names.

----------------------------------------------------------------------------
##701
3Windows / Tile vertically

    With this command you can arrange all desktop windows next to each
    other, that is, tile them vertically.

    In this way, you can compare the record protocols of two emulator
    windows easier. But this option doesn't make sense with Manager windows,
    as there is place only for one column in the file list.

----------------------------------------------------------------------------
##702
3Windows / Cascade

    This command arranges all windows on the desktop in such a way that they
    cover each other like a stack of cards. The title bars remain freely
    accessible.

    This option makes sense when you have opened many windows. Tiling the
    windows would make individual windows too little.

----------------------------------------------------------------------------
##703
3Windows / Arrange icons

    This command arranges the minimized windows on the right edge of the
    desktop without any influence on normal windows. The three other
    commands Tile horizontally, Tile vertically and Cascade arrange the
    icons as well.

----------------------------------------------------------------------------
##10000
3Windows / Active window

    If there are one or more windows on the desktop their names will be
    displayed as additional entries in the Windows menu. By selecting one of
    these entries, the corresponding window will be activated and placed
    into foreground.

    This option is very useful if you have many windows open and the current
    window is maximized. So you can switch to another window very quick
    instead of having to walk though the whole list with Ctrl+Tab. After
    switching to another window it will be maximized also.

----------------------------------------------------------------------------
##13
2The Help menu

    <Help / Contents>
    <Help / Last topic>
    <Help / Current topic>
    <Help / Help on help>
    <Help / About PC64>

----------------------------------------------------------------------------
##750
3Help / Contents

    This command brings you to the Online Help Index, also called the Help
    Contents or Help Overview.

    In the overview page you can click on the topic that is of your
    interest. The keyboard shortcut for the Help Contents is Shift+F1.

----------------------------------------------------------------------------
##751
3Help / Last topic

    This command opens the Help window again, and displays the page that you
    were reading when you exited the Help window with Esc. The shortcut for
    this command is Alt+F1.

----------------------------------------------------------------------------
##752
3Help / Current topic

    With this command you jump to the Help topic that corresponds to the
    current situation. For instance, if you don't know the meaning of a
    dialog box control, you can move to it with Tab and then press F1.

    The Help window with the description of the control will appear.

----------------------------------------------------------------------------
##753
3Help / Help on help

    Here you get instructions in using the Online Help. You can also press
    F1, while you are already in the Help window.

    This manual describes the Online Help functions in the Introduction
    part.

----------------------------------------------------------------------------
##754
3Help / About PC64

    This command displays a dialog box with the version number and the
    copyright message of the emulator.

    In the bottom left window corner you will see the available main memory
    in the 640kB conventional memory. If possible, the emulator will keep
    about 110 kilobytes free and uses the remaining memory for maintaining
    overlay files. This is why the desktop is slower when there isn't much
    free memory.

    When the emulation is running, the emulator will use almost 64 kilobytes
    of the 110 kilobytes for the screen memory cache, if the check box
    <Options / Desktop / VGA has VL or PCI bus> is not checked. Also, each
    open file will use one kilobyte of buffer memory. The desktop is mostly
    in EMS or XMS, but it requires up to 64 kilobytes for temporary
    buffering. Thus there will always be enough reserve for maintaining 4
    simultaneously opened windows on the desktop.

----------------------------------------------------------------------------
1Tips and tricks

    <Copying programs>
    <Running programs>
    <Keyboard>
    <Joystick>
    <Sound>
    <Timing>
    <Miscellanous>
    <Limits of the emulation>

----------------------------------------------------------------------------
2Copying programs

    <The transfers between PC and C64 do not work>
    <When are normal PC64 files better, when disk images?>
    <How secure is the fastloader?>
    <The fastloader crashes when the screen is switched on>
    <Copying whole diskettes between two drives>
    <Determining the space needed for files>
    <Converting C64 text files to DOS>

----------------------------------------------------------------------------
3The transfers between PC and C64 do not work

    There are different reasons for this, which can be caused by software as
    well as by hardware.

    \bThe CIA 2 in C64 is broken.\p This is the most common cause. As the user
    port contacts are unbuffered, the CIA can break easily. For this reason,
    always switch off the C64, before you connect or disconnect the user
    port connector.

    You can detect the broken lines with the TESTCABLE program that is
    located on the L64 diskette and also in the TESTCABL.P00 file in the
    emulator's starting directory. Start the program on the C64 and its
    counterpart TESTCABL.EXE on the PC. Select the correct printer port with
    the + and - keys on the PC, the default is LPT1.

    You can toggle single lines with the keys 1 through 5 on both computers.
    The PC must always display the same picture than the C64. The only
    exception is the FLAG line on the C64. This input is triggered on a
    falling edge, and the display will change whenever the corresponding
    output line on the PC changes from 1 to 0. Thus you must press the 5 key
    twice on the PC to toggle the FLAG display on the C64.

    If the CIA 2 in C64 is broken, one or more of the keys 1 to 5 on the C64
    won't work correctly. A typical sign of this is that the left and the
    right display contain different values. For instance, if you press the 5
    key on the C64, then the lamp next to PA2 as well as the one next to M
    must switch on or off. If the lamp at M does not change, the state of
    the pin could not be changed. In this case, switch the C64 off, remove
    the cable from the user port, and try it once more. If the lamp at M
    still doesn't change, your CIA must be broken.

    Otherwise, connect the cable to the C64 again, but disconnect it from
    the PC. If the error still occurs and you have built the cable yourself,
    it could be a soldering error. But if you bought the cable with the
    emulator, it is probably a problem with the CIA again, because the
    cables are tested before delivery. The 2.5 meters of cable on the user
    port change the electronic conditions only minimally, but it can be
    enough to turn the CIA malfunction visible.

    \bThe printer port in the PC is broken.\p Because many printer ports are
    low-cost design from cheap manufacturers, adventurous errors can occur.
    For instance, an IRQ 7 can always be generated, when the data line D7
    changes its state. Then a Soundblaster card that also uses the IRQ7, can
    make noise. Such errors are difficult to analyze, the telephone support
    is almost helpless. Even if printing works through the port, the same
    does not necessarily apply for the data transfer to the C64. It uses a
    different signal sequence than a printer and does not work on some LPT
    cards because of this.

    The easiest solution is to try it again with another parallel port. If
    it is not possible, you can also test the X1541 cable. You can exchange
    it with the PC64 cable on request.

    \bThe devices are not connected to the same power outlet.\p The C64 itself
    and your television set are normally ungrounded (the power cord only has
    two contacts instead of three), while the PC and some floppy drives are
    grounded. If these devices are connected to different power outlets with
    different ground potentials, there will be electric currents flowing
    through the PC64 cable and disturbing the transfer. Because of this, you
    should always connect all devices to the same power outlet.

    \bThe link cannot be used in Windows NT.\p If you work in the DOS box of
    Windows NT, you unfortunately cannot use the link nor the digital
    joystick. Windows NT simply denies all direct accesses to the parallel
    interfaces from the DOS box. But in Windows 3.1, OS/2 2.1, and Linux
    dosemu, there is no problem with the transfer, although it is a bit
    slower because of the multitasking.

    \bThe cable is connected to wrong port.\p First try out all available
    printer ports that can be selected in the dialog box
    <Manager / Clone L64>. Maybe you have connected the cable to the wrong
    port? Some DOS programs can mix up with the printer ports.

    \bThe connector is connected to the C64 the wrong way around.\p A further
    error source is the interface on the C64. If you are using a connector
    without mechanic key strips, the connector can be inserted both ways
    around. Because of this, mark one side with \bTHIS SIDE UP!\p Inserting the
    cable the wrong way around can destroy your C64 and the PC's printer
    port.

    \bThe interface cannot be selected.\p It is also possible that the printer
    port is physically there in the computer, but the dialog box shows it
    grayed, and it cannot be selected. This means that the corresponding
    port address, which is stored at 0000:0408h through 040fh, is smaller
    than 0100h or is not divisible by 4. In both cases, there must be a
    program that has fiddled with the printer ports, e.g. a network driver.
    In a such case, you should boot the computer in a minimal configuration,
    for instance with the F5 key in MS-DOS 6.x.

    \bThe interface was not detected by BIOS.\p There are printer interface
    cards that use unconventional port addresses that cannot be found by the
    BIOS on boot. In this case, you must explicitly enter the printer port
    address to the BIOS table. For instance, to assign LPT4 with the port
    address 0268h, you need the following little program:

    \bInput                      Remark\p

    debug                      Start the DOS DEBUG utility
    a                          Switch to machine code input
    xor AX,AX                  Set segment register to 0
    mov DS,AX
    mov word ptr [040E],0268   Enter new address
    ret                        Return to DOS
                               Here you must press the Enter key once more
    r cx                       Set the file length
    000B
    n setlpt4.com              Set the file name
    w                          Write the file to disk
    q                          Leave DEBUG

    If you now add the created program SETLPT4.COM to your AUTOEXEC.BAT file
    or execute it in a batch file that starts the emulator, also printer
    ports with unconventional addresses will work with L64 and digital
    joystick.

    \bTransfer errors caused by voltage peaks.\p If the cable connecting the PC
    and C64 is not shielded, transmission errors can occur when there are
    voltage peaks in the power lines. This happens e.g. when you turn the
    lights on or off. Also refrigerators are famous for this kind of
    disturbances. The transfer software naturally takes this into account
    and verifies every data block with a 8-bit checksum. But if the errors
    occur very frequently and you also have an unreliable printer port, the
    errors may cancel each other and pass the checksum. In such case you
    should increase the wait states, so that the voltage levels on the lines
    have more time to stabilize.

    \bThe C64 is under high voltage.\p As you can easily see with a phase tester
    (a little screwdriver with built-in lamp), there is a voltage of several
    hundred volts on the antenna input of some televisions. Fortunately, the
    currents are very small, so that you are not in danger and can only get
    a small shock from it. But your C64 does not like these currents at all,
    and it can e.g. make errors when reading from the floppy drive. If you
    now connect the C64 with your grounded PC, the unwanted voltage from the
    television will flow through the parallel cable and disturb the
    transfer. As L64 only needs the C64 screen for control purposes, it's
    best to simply turn the TV off in such case. You could now also get the
    idea to connect the antenna cable from your television to the ground
    potential in the power outlet. But we recommend you to forget such
    wirings!

----------------------------------------------------------------------------
3When are normal PC64 files better, when disk images?

    The advantage of normal PC64 files is that they can be easily organized
    in subdirectories, which don't have any 170 kilobyte limit. Furthermore,
    they use up only the space that is really required, unless the PC
    operating system uses very big allocation units. The disadvantage is the
    limited compatibility to a real disk drive. Also, reading the disk
    directory takes longer, because the directory routine must peek in each
    found file to find the 16 characters long filename.

    The greatest advantage of disk images is that you can do everything with
    them that you can do on a real 1541, except for fastloaders and copy
    protection. For instance, you can access individual sectors directly and
    run programs in 1541 RAM. The disadvantage is the fixed length of disk
    images. Even if you copy only one program to an otherwise empty disk
    image, the disk image will take 170 kilobytes of your hard disk space.

    Games with direct sector access must, games with many single files
    should be copied to disk images. All other programs belong to normal
    subdirectories, which should be sorted to categories. The finer you make
    the hierarchy, the easier you find a specific game, and the faster also
    the file list will be loaded in the Manager window.

----------------------------------------------------------------------------
3How secure is the fastloader?

    Some fastloaders do not manage read errors on the disk correctly. This
    leads to errorenous data being delivered.

    The fastloader in L64 detects all normal read errors, also checksum
    errors in data area (23,READ ERROR,tt,ss). If an error occurs, the
    fastloader will try to read the corresponding block several times. If it
    doesn't succeed in this, it will return the error code to PC64. The
    emulator will then switch off the fastloader and read the block normally
    using a direct access file. If it doesn't work either, the error will be
    transferred to the disk image, and the next sector will be copied. After
    finishing the transfer, all errors that occurred will be displayed:

    In spite of all these security measures, copying the diskettes is not as
    secure as you know it from your PC disks. The reason for this is that
    1541 diskettes have only a 8-bit checksum in each data block. As a
    consequence, data errors on very old disks cannot be always detected.
    Unfortunately, we don't know the solution to this problem either.

----------------------------------------------------------------------------
3The fastloader crashes when the screen is switched on

    If the check box <Options / Waitstates / C64 screen on for debugging> is
    active, the fastloader will sometimes crash. You should always keep the
    screen blanked, as the transfer will be 10 percent faster so (or twice
    as fast on a C128). This switch is only for control purposes.

----------------------------------------------------------------------------
3Copying whole diskettes between two drives

    The emulator prevents all copying if the source and destination drives
    are the same. But if you have connected two external drives to the C64,
    both of which use the 1541 format, you could theoretically copy whole
    diskettes. But you may not use the fastloader for this, as it can access
    only one disk drive at a time.

    Instead of setting the UseL64FastAccess option in DRIVES.INI to 0, it
    makes far more sense to use a copying program on the C64 for such
    things.

----------------------------------------------------------------------------
3Determining the space needed for files

    If you select one or more entries in a Manager window's file list, the
    title bar text will change to (x blocks). This indicator tells you if
    all files fit on a 1541 disk with 664 blocks, before you start copying.
    But the block count isn't always accurate with relative files, as they
    require additional side sector blocks on a real 1541 disk. Relative
    files in PC64 format only contain the actual data.

    If you want to know how much space is occupied by all files in the
    current directory, just press the plus key to select all files. You can
    cancel the selection with the minus key.

----------------------------------------------------------------------------
3Converting C64 text files to DOS

    With the utility CBMTEXT.EXE you can convert your old C64 text files in
    order to load them into your PC text program. Start PC64 and open a
    manager window. Create a new subdirectory TEXT with
    <Manager / Directory / New> and copy your text files there with F8. Now
    leave PC64 and enter on the DOS command line:

    C:\\PC64>cbmtext text\\*.?00

    The converter loads the first text file and shows its contents. With +
    and - you can select different converting algorithms. Simply press these
    keys until you get the best result. Then press Enter to write the
    current text file to disk. The extension will be modified to .TXT. You
    must confirm overwriting with the Y key if the destination file already
    exists. After writing the file in DOS format, the converter will open
    the next C64 text file.

    Then start your PC text program under DOS or Windows. When opening one
    of the converted files in the C:\\PC64\\TEXT\\*.TXT directory, the PC text
    program may ask you to specify an import format. Select either MS-DOS
    text or Text with layout (DOS) if the file contains "hard returns". Then
    you can save the text file into another directory. Probably you'll have
    to change the kryptic file name which has been generated by the 16-to-8
    char conversion. After completing all files, you can delete the
    C:\\PC64\\TEXT directory with deltree.

----------------------------------------------------------------------------
2Running programs

    <The command Emulator / Open crashes>
    <How does the emulator separate BASIC and machine language programs?>
    <How can I change disks in the emulator?>
    <How can I save the current game state?>
    <A FILE NOT FOUND ERROR occurs with some PC64 files>
    <Opening C64 programs directly from an external file manager>
    <Which files are loaded by the program?>

----------------------------------------------------------------------------
3The command Emulator / Open crashes

    If you still have emulation state files from the emulator's beta phase,
    you cannot load them to PC64 in any way. The reason for this is that the
    format of the *.C64 files has changed several times since the first
    published beta version. If you have saved game states in such format and
    cannot reconstruct them easily, you have to use these files with the
    beta version and live with the error messages concerning the system
    date.

----------------------------------------------------------------------------
3How does the emulator separate BASIC and machine language programs?

    The Manager looks at the loading address before opening the program. If
    it is between $0400 and $A000, with the bit 0 set and bits 1 to 9
    zeroed, it is very probably a BASIC program. Thus it is loaded with
    LOAD"NAME",8 to the address $0801 and then started with RUN.

    If the file has any other loading address, it will be loaded with
    LOAD"NAME",8,1, as it probably is a machine language program. If the
    loading address is between $0000 and $07FF or in the I/O area or under
    the ROMs, nothing else will happen, otherwise the text SYS
    load_address:NEW will be inserted. Then you can press the Enter key to
    start the program. But it doesn't always work. For instance, graphics
    loaded at $2000 cannot be displayed in this way.

    The actual problem here is mixing up. If a machine language program is
    loaded as a BASIC program and gets started with RUN, it will be broken
    with a SYNTAX ERROR IN X. After typing LIST, you will see at once that
    it is machine code or other data.

    In the opposite case, the statement SYS load_address:NEW will be
    inserted on the screen. But if you now confirm it with Enter, the
    emulated C64 will crash, or it will clear the screen and prints READY.
    on the top left corner. Try loading the program without the secondary
    address ,1. If LIST displays something that makes sense, then it was a
    BASIC program with an unconventional loading address. To correct the
    loading address, use the command SAVE"NEW NAME",8. In that way you can
    start the program from the Manager in the future.

    If LIST only displays garbage, then it's either a machine language
    program with unknown starting address, e.g. part of a multi-part game,
    or the file only contains data, although it is marked as program. In
    both cases you must consult the documentation you got with the file.

----------------------------------------------------------------------------
3How can I change disks in the emulator?

    By pressing F9. The running C64 program will be stopped, and you will
    get back to the desktop, to the <Options / Drives> dialog box. Now you
    can choose the new disk with cursor keys. As soon as you confirm the
    disk change with OK, you will be back in the emulation.

----------------------------------------------------------------------------
3How can I save the current game state?

    You simply press Shift+F11. So you save the complete emulated C64 with
    all settings, similar to a freezer cartridge. If you now make a mistake
    in the game and have lost a life, then you only must press F11, and you
    will be back in the position where you saved the game last time.

    By the way, the game state will be automatically saved when the window
    get closed, if the window has a name and if you have set the radio
    button group <Options / File / Save on Exit> to "Yes, overwrite file".

    The command <Emulator / Duplicate> is useful as well. With it you can
    control several saved states of a single program. But you must be
    careful not to mix up, as the saved states only get distinguished by a
    three-digit filename extension. It is best to copy all files to a common
    subdirectory and give them descriptive names with <Emulator / Save as>.

----------------------------------------------------------------------------
3A FILE NOT FOUND ERROR occurs with some PC64 files

    During the beta test phase of the emulator, the file renaming scheme
    from 16 characters long filenames to the 8 characters long DOS names had
    to be changed, because only the characters A-Z, the numbers 0-9 and the
    undersign character _ are allowed on CD-ROMs. If you still have old PC64
    files from the beta phase, some of them cannot be detected because of
    the naming conflict.

    The utility NEWNAME.EXE in the emulator's starting directory corrects
    this error. If you now execute the

    C:\PC64>newname c:\

    command, the program will search your whole hard disk for PC64 files,
    and generates a new DOS name from the 16 characters long filename in the
    file. If the old and the new name differ from each other, the file will
    be renamed. After that, it is accessible from the emulator again.

    Programmers can examine the source code of the name conversion routine
    in the file T64TOP00.CPP.

----------------------------------------------------------------------------
3Opening C64 programs directly from an external file manager

    If start run PC64 under Windows, OS/2 or the Norton Commander, you can
    associate the file suffixes .P00, .D64 and .C64 with PC64.EXE or
    PC64.PIF. In Windows File Manager, this can be done with the File /
    Associate command. If you now double click on a C64 program, the
    emulator will automatically be loaded, and it in turn will start the
    program. After quitting the emulation with Esc, you will not return to
    the emulator desktop, as usual, but to the external file manager.
    Changing disks with F9 remains possible, though.

    If you double click on a disk image *.D64, the first program on it will
    be started. Also normal emulation state files *.C64 will now be executed
    at once, and not merely loaded, like in older versions. Thus specifying
    multiple emulation state files on the command line is no more possible.

----------------------------------------------------------------------------
3Which files are loaded by the program?

    You can use the Record mode in order to find out which files belong to a
    program. First use the <Run / Filters> command and clear all switches
    except DEV(ice). Close the dialog box with OK and switch to the Record
    mode with Shift+F5. Note that the emulator will only have 10 percent of
    its normal power available in this mode.

    After you return to the desktop with Esc, you can see all file names
    that the program tried to open. By the way, the name "#" denotes a
    direct access file, which only works with disk images.

----------------------------------------------------------------------------
2Keyboard

    <I would like to input numbers on the number pad>

----------------------------------------------------------------------------
3I would like to input numbers on the number pad

    Confirm that the check box
    <Options / Keyboard / Use national keyboard driver> is checked. Then
    start the emulation and press the Num Lock key. Now you can input
    numbers, the keyboard joystick is disabled until you press Num Lock
    again.

    If you would like to have a point instead of the comma that is used in
    most European keyboard drivers, switch to the American DOS keyboard with
    Ctrl+Alt+F1. With Ctrl+Alt+F2 you get your national keyboard layout
    again.

----------------------------------------------------------------------------
2Joystick

    <The digital joystick does not work correctly>
    <The analog IBM joystick does not work correctly>
    <The game behaves in a weird way when I move the joystick>
    <No analog joysticks in Windows NT>
    <Hardware autofire must be switched off>
    <Setting joysticks for all programs simultaneously>

----------------------------------------------------------------------------
3The digital joystick does not work correctly

    The dialog box <Options / Waitstates> lets you to adjust the joystick
    query for your parallel interface. There you can test the joystick
    interface's function simultaneously by moving the joystick around and
    observing the graphics in the bottom right window corner. If the display
    is flickering, you should increase the wait states for the joystick.

    If increasing the wait states does not work, then there is a problem
    with your cable, or you have a non-compatible parallel interface. This
    problem is corrected by the separately available alternative joystick
    adapter, which also works with printer ports without open collector
    drivers.

----------------------------------------------------------------------------
3The analog IBM joystick does not work correctly

    If this error occurs, you can find out its cause with the diagnostics
    program TESTJOY.EXE. It works just like the joystick query in the
    emulator, and it additionally displays the analog values before the
    conversion. With the program you can find out if the joystick is
    detected at all, if the analog values make sense, or if there are
    problems with the conversion to digital values.

----------------------------------------------------------------------------
3The game behaves in a weird way when I move the joystick

    The C64 has joystick ports 1 and 2. Unfortunately there is no standard,
    which port should be used in one-player mode. Because of this, both
    joystick are emulated with keyboard by default. This means that both
    ports receive the Fire signal simultaneously when you press the Right
    Ctrl key.

    But some games also read the keyboard, so that you can e.g. throw a bomb
    with the space bar. Because the keyboard matrix on the C64 is connected
    so that the fire button on joystick 1 corresponds to the space bar, you
    will throw bombs with every shot in such games!

    To prevent this, you must disable the joystick port 1 in the
    <Options / Joysticks> dialog box. If you have started the program with
    <Manager / Run>, this setting will automatically be saved in the program
    data base PC64.PDB. So you don't need to correct the setting every time.

----------------------------------------------------------------------------
3No analog joysticks in Windows NT

    Almost all direct accesses to the hardware don't have any effect in the
    Windows NT DOS box. This applies also to the analog joysticks, which
    cannot even be queried using the BIOS routines. Thus you can only
    control your games with the keyboard joystick emulation in Windows NT.

    When the first emulation window is opened under Windows NT, there will
    be a delay of two seconds, where the program tries to read and center
    the analog joysticks. If it fails and Windows NT is detected, the analog
    joysticks will be fully disabled so that the delay will not occur any
    more. This test has been implemented to take future versions of Windows
    NT into account, which could allow reading the joystick.

----------------------------------------------------------------------------
3Hardware autofire must be switched off

    If you have connected a digital joystick to the PC64 cable or to the
    alternative joystick adapter, you must switch off the hardware autofire.
    The reason for this is that there is no +5V power output on the PC's
    parallel interface. That is why the autofire generation circuit in the
    joystick cannot work. After switching the autofire off, the fire button
    will work like a normal switch.

    But you can switch on the software autofire in <Options / Joysticks>
    instead. It works even with the simulated keyboard joystick.

----------------------------------------------------------------------------
3Setting joysticks for all programs simultaneously

    In the dialog box <Options / Joysticks> you choose the way in which the
    C64 joysticks will be emulated. Because it is very annoying to change
    the settings for every program after you have installed new hardware,
    the program SETJOY.EXE was developed.

    When you start the program, a menu will be displayed where you can
    change the default joystick. After you have done it, the settings for
    all programs in the PC64.PDB file will be set to this value. The default
    for new emulator windows in PC64.CFG will also be changed. But in
    emulation state files *.C64 you have to make the changes later in the
    emulator.

    When executing SETJOY.EXE, PC64.PDB and PC64.CFG should be in the
    current directory, or an error message will be displayed.

----------------------------------------------------------------------------
2Sound

    <No sound in Windows 3.1 Enhanced mode>
    <I have installed two sound cards, but they are not detected>
    <The digitalized speech output is horrible>
    <Disable Disney Sound Source>

----------------------------------------------------------------------------
3No sound in Windows 3.1 Enhanced mode

    When using the outdated driver SBPFM.DRV, the sound is not available in
    Windows Enhanced 386 mode. You will get two error messages when starting
    the emulator.

    If you cannot retrieve the newest driver from the Compuserve forum
    Blaster, you should turn off the setting
    <Options / Desktop / Sound in Windows Enhanced Mode>. You won't then
    hear anything either, but the annoying error messages will disappear.

    By the way, in Windows NT, the sound doesn't work at all, as almost
    every direct access to the hardware is forbidden.

----------------------------------------------------------------------------
3I have installed two sound cards, but they are not detected

    According to the definition, an Adlib card is always connected to the
    addresses 0388h and 0389h. Thus it cannot be used in other addresses
    like the Soundblaster card. So there will be access conflicts if you
    have two soundcards in your computer, both being Adlib compatible. This
    I/O conflict is the reason why the original test by Adlib used in the
    emulator does not detect the FM chip. And if there is no Adlib card,
    there cannot be any Soundblaster either. That's why the emulator does
    not go on trying to detect the DSP and mixer, as it could lead to
    problems with network cards installed to 0210h through 0260h.

    In order to enable sound in the emulator, you must disable the Adlib
    part on one of your soundcards. How it can be done should be printed in
    the user's manual. You can also go the radical way and remove one
    soundcard.

----------------------------------------------------------------------------
3The digitalized speech output is horrible

    If the setting
    <Options / Timing / Update screen every xth vertical refresh> is not set
    to 1, there will be timing inaccuracies. The reason is that the first
    visible screen refresh takes very much computing time. The emulated CPU
    runs slower during this time. But during the next vertical refresh, the
    CPU will run faster, as the screen will not be updated. The varying
    execution speed is the reason why digitized speech is extremely hard to
    understand.

    The easiest solution to this problem is to disable the samples, if they
    aren't really important in the program. If your computer is fast enough,
    a 486DX2- 66, for example, then you should set the screen update rate to
    1.

    If you only want to hear the samples on a slow computer, you can turn
    down the screen update rate to the minimum of every 60th vertical
    refresh and tune the speed with the execution speed limit and with the
    Turbo switch on your PC. As the screen will only be updated once per
    second, the screen display won't unfortunately make much sense.

----------------------------------------------------------------------------
3Disable Disney Sound Source

    A Disney Sound Source compatible card uses the same address than a
    parallel printer port. The hardware determines from the control lines if
    the data is for printer, or if it should be played as a sample. But
    neither the PC64 cable nor the alternative joystick adapter act like a
    printer, and using them can lead to unconvenient noise on the audio
    amplifier.

    If your sound card is compatible with Disney Sound Source, you should
    disable the mode if the PC64 cable is connected to the same parallel
    port.

----------------------------------------------------------------------------
2Timing

    <Why does the detected computing power vary so much?>

----------------------------------------------------------------------------
3Why does the detected computing power vary so much?

    If the screen display changes much, the emulation will get slower, as
    accessing the screen memory on the VGA card is much slower than
    accessing the main system memory. Changing the check box
    <Options / Desktop / VGA has VL or PCI bus> can result in better
    performance, you just have to try it out.

    A further cause of the computing power varying are programs running on
    the background, e.g. when SmartDrive writes data to the hard disk. Also
    multitasking systems like Windows or OS/2 can steal execution time from
    the emulator and give it to other programs.

----------------------------------------------------------------------------
2Miscellanous

    <The desktop is displayed in black and white instead of colours>
    <Starting the emulator with 50 lines>
    <Changing the default KERNAL colours>
    <How can I access the emulation protocols?>
    <Using extended video modes>
    <Capturing the screen>
    <Copying diskettes>
    <Custom hardware on the PC>
    <Creating a list of all C64 files on the hard disk>
    <Starting programs freezed with Isepic or Magic Formel>
    <Conflict with GDI printers solved>

----------------------------------------------------------------------------
3The desktop is displayed in black and white instead of colours

    If the emulator desktop is suddenly black and white, the reason is the
    active screen mode. If the mode 03h is active when starting the
    emulator, the colourful desktop will appear as usually. In the mode 02h
    everything is black and white.

    You can change screen modes either with the program delivered with your
    VGA card, if the card manufacturer made such program. Or you can use the
    DOS utility MODE.COM. By entering

    mode co80

    you switch back to the colourful mode 03h, while

    mode bw80

    returns you to the black and white mode 02h. The parameter "mono" is
    only for Hercules cards and you should not use it with a VGA card.

----------------------------------------------------------------------------
3Starting the emulator with 50 lines

    As the emulator will keep the current text mode, you can also work in 43
    or 50 lines mode. That leaves more place on the screen for file lists
    and emulation protocols. You can switch the modes either with the
    utility you got with your VGA card, or with the DOS program MODE.COM:

    @echo off
    mode con lines=50
    c:\\pc64\\pc64 %1 %2 %3 %4 %5
    mode con lines=25

    But you must include the line

    devicehigh=c:\\msdos6\\ansi.sys

    in the CONFIG.SYS file and reboot the computer, since MODE.COM will
    otherwise display an error message.

----------------------------------------------------------------------------
3Changing the default KERNAL colours

    To make it easier to distinguish the operating systems from each other,
    you could want to change the default color settings, light blue on dark
    blue, by patching the corresponding *.64K files with a disk editor.

    \bKERNAL  File   Decimal  Meaning\p

    $ECD9   0CD9h  3289     Background color
    $ECDA   0CDAh  3290     Foreground color
    $E535   0535h  1333     Cursor color (original KERNALs and EXOS V3)
    $E532   0532h  1330     Cursor color (64'er System V1)

----------------------------------------------------------------------------
3How can I access the emulation protocols?

    On program exit, all emulation protocol files will be deleted, as they
    use up loads of hard disk capacity. If you would like to print parts of
    them or edit them in other programs, use the <Emulator / DOS shell>
    command. The emulation protocol files will be closed and they will be
    available as LOG*.TMP. They can be loaded in any editor that manages
    such big files.

    They are plain ASCII files with a fixed line length of 78 characters, so
    they can be printed without problem. The only speciality is in the first
    character on the line. If it is the protected space character Alt+255,
    an error has occurred. In this case the line will be displayed in red in
    the emulation window.

    Please do not modify or delete the emulation protocol files while you
    are in the DOS shell. Otherwise the emulator may crash when you return
    from the shell.

----------------------------------------------------------------------------
3Using extended video modes

    On emulator startup, most expanded SuperVGA text modes will be detected.
    Thus you are not limited to the normal VGA resolution with 80 x 25
    characters, but you can select the 80 x 50 mode first to get double
    resolution. Please consult your graphics card documentation for
    information on using the extended modes.

    In addition, the checkbox <Options / Desktop / 28 line mode at start>
    will give you three extra lines on normal VGA cards without shrinking
    the characters too much.

    Modes with 100 or 132 columns don't normally have any problems. Only the
    mouse cursor may be displayed wrong. Should this happen, you should
    avoid using these modes.

    Theoretically you can also use graphics modes, as far as you limit the
    colors to 16. But you will only notice the graphics mode in the mouse
    cursor, everything else on the desktop will look just like in text mode.
    It is highly recommended to start the emulator only in text mode,
    because of text output speed.

    Some screen modes are available in two versions: with colors, and in
    black and white. The difference can only be seen in the functional parts
    of the desktop, for instance in title bars, menus and dialog boxes. In
    contrary to that, the colors in the windows apply for both modes
    simultaneously.

----------------------------------------------------------------------------
3Capturing the screen

    The emulation runs in the normal video mode 13h with 320 x 200 pixels
    and 256 colors. No tricks are used when programming the VGA cards, so
    that you can capture the screen output with your favourite snapshot
    program. Alternatively, you can pause the emulator with Pause and
    photocopy the screen with a camera.

----------------------------------------------------------------------------
3Copying diskettes

    With the <Manager / Disk image / Copy> command you use your PC as buffer
    when copying whole 1541 diskettes. In this way you don't need a second
    floppy drive to avoid the frequent disk changing. The built-in
    fastloader will copy the disks pretty fast.

----------------------------------------------------------------------------
3Custom hardware on the PC

    Your C64 hardware on the user port can also be used on the PC. To do
    this, do not start the emulator directly, but start the USERPORT.COM
    program. It installs the access functions to the C64 user port and
    starts then the emulator. If a C64 program now accesses the user port in
    the emulator, the data will be rerouted to the USERPORT.COM program. By
    default the output will be redirected to LPT1. But as the source code is
    included, you can change this any time. Even non-standard industrial I/O
    cards can be utilized by this method.

----------------------------------------------------------------------------
3Creating a list of all C64 files on the hard disk

    The DIR64.EXE program lets you to maintain an overview on your C64
    programs. It lists the contents of all disk and tape images in the
    current directory in familiar C64 format. In addition, all PC64 files
    will be listed with their 16 characters long filenames.

    You can use the /s switch to descend to subdirectories, like with

    dir64 c:\ /s >c64.dir

    Now you will just need to load the file C64.DIR in an editor, if you
    cannot find a C64 program any more.

----------------------------------------------------------------------------
3Starting programs freezed with Isepic or Magic Formel

    If you have a game in two files of the form NAME and -NAME, it is
    usually a freezed program with fastloader, which does not work in the
    current emulator version. If the files are located in a disk image, try
    copying the files to a normal directory, and try starting the game from
    there. With Isepic the odds aren't now bad at all, because the
    fastloader will detect if the drive is a 1541, and it will use the
    normal loader if the drive is not detected. If the loading screen tells
    that it is an Isepic file, you can also start the game from a disk
    image, if you replace the file NAME with the included ISEPIC LOADER.
    This program must naturally be renamed to NAME in advance.

    If the screen remains black also when the files are in the PC64 format,
    the file is probably a program freezed with Magic Formel. To get it to
    work, switch to the DOS prompt and use the MAGFORM.EXE utility. It
    appends additional code to the first file NAME.P00, which disables the
    fastloader on an emulator.

----------------------------------------------------------------------------
3Conflict with GDI printers solved

    If you start PC64 under Windows and there is a GDI printer installed
    (e.g. Star WinType 4000), it can occur that the printer dialog gets
    displayed and wants to output a form feed. Also data transfers with an
    external C64 are no more possible.

    In this case, load the file PC64.PIF to the PIF editor and replace the
    program name PC64.EXE with NOGDI.COM. This sets all printer port
    addresses to 8000h, so that the virtual device driver SUMOVMI.386 gets
    worked around. The original settings will be restored when you exit the
    emulator.

----------------------------------------------------------------------------
2Limits of the emulation

    An emulator can never achieve the original. This applies naturally also
    for the PC64.

    <Unsupported properties>
    <Null characters in filenames only in disk images>
    <Manager displays special characters as question marks>
    <The last character of a file name is a quotation mark or a space>
    <No direct access to the hard disk>
    <Relative PC64-files on the hard disk>
    <No relative files or direct access over L64>
    <Fast loaders are not supported>
    <No copy protection with disk images>
    <A program notifies that it won't run on the emulator>

----------------------------------------------------------------------------
3Unsupported properties

    All pheripheral chips are emulated with some limitations. The main
    limitation is that the chips are only refreshed once per raster line,
    that is every 64 microseconds. Current computers are yet too slow for
    updating the pheripheral chips on every clock cycle.

    <Processor 6510>
    <Video Interface Chip VIC-II>
    <Sound Interface Device SID>
    <Complex Interface Adapter CIA1 and 2>

----------------------------------------------------------------------------
4Processor 6510

    All official machine instructions are supported, including additions and
    subtractions in Decimal mode. The undocumented instructions were also
    implemented using the table on page 85 in 64'er Magazin issue 3/85. Some
    undocumented instructions crash the 6510 and thus abort the emulation
    with an error message.

    The instruction JMP ($xxFF) is also emulated correctly. That is, the
    most significant byte of the jump address will not be read from $xxFF+1,
    but from $xx00.

    Sometimes there can be problems with the CPU timing in some special
    cases. For instance, a conditional branch requires one clock cycle more
    if it jumps to another page. That is not emulated.

    The bits 0 through 2 in the addresses $0000 and $0001 switch the memory
    bankings just like in a real C64. Any ROM cartridges enabled at $8000
    will be enabled and disabled together with the BASIC ROM at $A000.

    The bits 3 through 5 are connected to a cassette recorder, the so called
    datasette, on a real C64. These bits are not emulated.

    Some programs jump to the I/O area, executing pheripheral chip register
    contents as program. It works on the emulator only if the jump target is
    a BRK, RTS or RTI instruction. Otherwise an error message will be
    displayed.

----------------------------------------------------------------------------
4Video Interface Chip VIC-II

    All 6 operation modes of the VIC are emulated, as well as raster
    interrupts and sprites. The undocumented resetting of interrupt events
    with instructions like INC $D019 works as well.

    The bit 5 in Control Register 2 that should commit a reset is not
    emulated. And it does not reset any chip newer than the 6567R56A anyway,
    which should be the oldest video chip used in any sold C64 unit. The
    light pen registers 19 and 20 and the corresponding interrupt are not
    supported either.

    As the VGA screen mode 13h is limited to 320 x 200 pixels, the specially
    generated sprites in borders cannot be seen either. Sprite collisions
    outside of the visible screen region are ignored.

    Unfortunately the exact algorithm of the internal video counter is
    unknown, and must be selected by the user in <Options / Timing>. Using
    the wrong algorithm will lead to errorenous display when programs change
    the vertical screen offset in a raster interrupt.

    If the screen refresh rate in <Options / Timing> is slower than 1, the
    emulator will record all sprite collisions in a buffer during the first
    screen update. Changes in the following frames won't be updated until
    the next visible screen update. For this reason, the emulator sometimes
    detects sprite collisions that are not in effect any more.

----------------------------------------------------------------------------
4Sound Interface Device SID

    The normal sound generators 1 to 3 are emulated on the AdLib card. The
    different waveforms must be approximated with frequency modulation,
    which is not always possible with sound effects exploiting square waves
    with variable pulse width. But it is still better than trying to emulate
    everything with digitized samples.

    Synchronisation and ring modulation are not possible.

    Both Paddle inputs are emulated with IBM analog joysticks, not including
    the fire buttons, though. A proportional mouse is not supported.

    If a SoundBlaster compatible card is available, samples created with
    $D418 can be heard. Because of the asymmetric timing on screen update,
    digitized speech is hardly understandable.

    Reading the envelope and oscillator outputs works as well, but the
    oscillator values will be random and independent of the frequency. Only
    the noise waveform output can be read.

----------------------------------------------------------------------------
4Complex Interface Adapter CIA1 and 2

    Both real time clocks with alarms as well as the four 16 bit timers are
    fully emulated as well as it is possible with the 64-microsecond timing
    resolution.

    The keyboard matrix in CIA1 works exactly like on a real C64. It is also
    possible to read the keyboard in another direction. Also the joystick
    inputs will be mapped to the corresponding bits.

    Userport, IEC bus, RS232 and serial shift registers are not supported.
    The connections FLAG and CNT are not available either. Outputting timer
    underflows with PB6 and PB7 does not work, and counting external
    frequencies isn't possible.

    Disabling the Restore key with CIA2 doesn't work either.

----------------------------------------------------------------------------
3Null characters in filenames only in disk images

    The null character marks the end of a string in the C language. That's
    why you can't copy any files whose name contain a null to your hard
    disk. If a program package requires this, you must copy it to a disk
    image.

----------------------------------------------------------------------------
3Manager displays special characters as question marks

    If there are nulls, tabulators, carriage returns, asterisks, colons or
    commas in the name, they will be displayed as question marks in the
    Manager. Files with question marks in their names cannot be copied,
    moved, or renamed with the Manager. But deleting them with Del and
    executing them with Enter does work. You just must look out not to
    delete similar files with them, since the question mark is a wild card.

----------------------------------------------------------------------------
3The last character of a file name is a quotation mark or a space

    In the directory the filenames end in a quotation mark, if there is no
    quotation mark in the name itself. But when the last character of the
    file name is a quotation mark, you cannot notice it in the directory.
    Because of this, the file NAME" will be displayed as NAME in the
    Manager. Something similar happens if the last character of the filename
    is a space and there are one or more quotation marks before it in the
    name.

    Unfortunately, you cannot make anything in the Manager with such files,
    that is, you cannot execute, copy, or even delete them. To escape this
    situation, you must execute the appropriate commands in the emulator,
    for example OPEN 15,8,15,"S:NAME"+CHR$(34):CLOSE 15 to delete the file.

----------------------------------------------------------------------------
3No direct access to the hard disk

    You cannot perform any direct accesses to disk drives that are linked to
    normal DOS directories, i.e. to .P00 and .S00 files. The reason is that
    only normal file accesses, such as reading the directory, will be
    performed by DOS, but there are no tracks or sectors on the drive. The
    disabled features include reading the disk name and BAM, accessing the
    floppy RAM, and executing routines in the disk drive.

    If you want to use such things, you have to map the floppy to a disk
    image (.D64) with <Options / Drives>.

    <How do I recognize direct access?>

----------------------------------------------------------------------------
4How do I recognize direct access?

    Turn off all options in <Run / Filters> except DEV(ice) and start the
    emulator in scanning mode with Shift+F5. Now the emulation speed is only
    a tenth of the normal speed. Stop it after some time with Esc and
    observe the record protocol. If a file gets opened whose name begins
    with #, your program uses direct access.

----------------------------------------------------------------------------
3Relative PC64-files on the hard disk

    If you work with the *.R00 PC64 relative files directly on your hard
    disk, that is, not in disk images, you may not use any tricks or
    undocumented features. Above all, you may not read or write several
    records in a row without using the position command on the channel 15 in
    between. You cannot use the variable ST either to find out the length of
    variable-length data records. Reading the maximal record length from the
    floppy address 200 doesn't work either, because the Memory commands are
    only allowed with the *.D64 disk images.

    But relative files on the hard disk have the advantage that they aren't
    limited to the 170 kilobytes capacity of a 1541 disk, like the disk
    images are. A relative file with 65535 records of 255 bytes each can be
    almost 16 megabytes big.

----------------------------------------------------------------------------
3No relative files or direct access over L64

    If you access an external C64 disk drive from the emulation, a
    1-kilobyte-buffer will be allocated for each opened channel. The data
    you send to these channels won't be transferred until the buffer is
    full. Because of this, using relative files and accessing the disk
    sectors directly is not possible with external C64 drives, as their data
    flow is controlled with the command channel.

    The solution is to transfer the diskette with the
    <Manager / Disk image / Copy> command to the PC and to use the resulting
    disk image with the emulator. Owners of other drives than the
    1541/1570/1571 have the last resort of closing and reopening the file
    between each write/read process. In this way the buffer will be reset.

    Naturally these limitations only apply for the emulation. No problems
    occur when copying relative files in the Manager.

----------------------------------------------------------------------------
3Fast loaders are not supported

    Disk images are emulated by switching the virtual CPU between C64 and
    1541. But fast loaders would require that the two virtual CPUs would run
    simultaneously, and the currently available PCs are yet too slow for
    this. Thus, if you have a game with a built-in fastloader, and cannot
    find the routines using the Record mode, you cannot start the game on
    the emulator.

    <How do I recognize fast loaders?>

----------------------------------------------------------------------------
4How do I recognize fast loaders?

    Start the game normally and wait until the emulated C64 hangs. Now press
    the Esc key once. If nothing happens, the program has started a machine
    language routine in the floppy, which now hangs in an infinite loop.
    That is always a sign of a fast loader. You can quit the emulation by
    pressing Esc once more.

    But if you was able to abort the program with the first Esc press, start
    the emulation in Record mode with Shift+F5. Abort it after a second with
    Esc and observe the emulation protocol. If the red-coloured error
    message "Bit 2 (Userport PA2) and bits 3-7 (serial bus) are not
    supported!" appears often, it hints also that a fastloader is being
    used.

----------------------------------------------------------------------------
3No copy protection with disk images

    Some games use data on the tracks 36 through 40 or custom GCR format on
    some sectors. Such things cannot be transferred to the PC with the
    <Manager / Disk image / Copy> command. If you cannot locate and patch
    the critical place using the Record mode (naturally only for your
    private use), then you unfortunately cannot run this program on the
    emulator.

----------------------------------------------------------------------------
3A program notifies that it won't run on the emulator

    As there are means for detecting the emulation on the C64, program
    manufacturers can exploit it to disable using the program on the
    emulator. If you don't think that there is a reason for such message,
    like the missing user port interface with L64, you can locate and patch
    the query routine exploiting the Record mode. Just search for the word
    "Emulator" with Ctrl+F3, and patch the place with a disk editor. To
    accomplish this, you must naturally be familiar with the C64's machine
    language.

----------------------------------------------------------------------------
1Programming

    <The format of the PC64 files>
    <Detecting the emulation from the C64>
    <Using L64 in your own programs>
    <The transfer routines on the C64>
    <The L64 control codes>

----------------------------------------------------------------------------
2The format of the PC64 files

    PC64 files have the suffixes .P00 for program files, .S00 for sequential
    files, .U00 for user files (or system files) on the floppy, .D00 for
    deleted files, like separator lines, and .R00 for relative files.
    Instead of the two zeroes, there can also be other numbers. This is
    required, as the file name conversion to the 8 characters long DOS names
    would otherwise cause duplicate filenames.

    The structure is relatively simple. In the beginning of each file, there
    is a 26-bytes-long header:

    typedef struct {
      char acTag[8];    // Signature "C64File" and 0
      char acName[17];  // The 16 characters long filename
      byte bRecord;     // Record length of relative files
    } C64Header;

    Unused characters at the end of acName should be padded with null
    characters, as well as the bRecord field with non-relative files.

    The actual data will follow this header immediately at offset 26. You
    can insert and remove the header with the <Manager / Import> and
    <Manager / Export> commands.

    If you want to create PC64 files for the emulator, you must use the
    correct translation from 16 to 8 characters. Otherwise you will get the
    error message FILE NOT FOUND ERROR, as the emulator will only be
    searching through the files NAME8.* in DOS. Otherwise it would have to
    examine all PC64 files in the current directory, which would be way too
    slow.

    The correct translation from 16 to 8 characters is performed by the
    function ReduceName() in the T64TOP00.CPP file, which can be found in
    the emulator's starting directory. The function only uses the characters
    0 through 9, A through Z and the underscore character _, so that PC64
    files won't make any trouble on CD-ROMs either. In addition, names that
    could be interpreted as DOS devices, like LPT1 or CON, will get an
    underscore at their end, so that the corresponding device wouldn't be
    opened.

----------------------------------------------------------------------------
2Detecting the emulation from the C64

    One of the most annoying things for a programmer is hardware or software
    for which there are no detection routines. Whoever who has tried to find
    out the address of a Hercules graphics screen, or to detect different
    processors ranging from 8088 and V20 to the 80486, can write a song
    about it. That is why we define a standard here for detecting an
    emulator in a C64 program. The main thing is the memory address $DFFF on
    the I/O2 area, which will change between $55 and $AA upon reading it in
    the emulator. By reading it several times, you can easily find out if
    the program is running on a real C64 or on an emulator. In BASIC, the
    code looks like this:

    X=57343
    IF PEEK(X)<>85 THEN IF PEEK(X)<>85 THEN original
    IF PEEK(X)<>170 THEN original
    IF PEEK(X)<>85 THEN original
    IF PEEK(X)<>170 THEN original
    REM It is an emulator

    and in machine language:

            LDA #$55
            CMP $DFFF
            BEQ FOUND55
            CMP $DFFF
            BNE ORIGINAL
    FOUND55 LDX #$AA
            CPX $DFFF
            BNE ORIGINAL
            CMP $DFFF
            BNE ORIGINAL
            CPX $DFFF
            BNE ORIGINAL
    ;It is an emulator

    On a real C64 with no I/O device connected to the address, the values
    read from it will represent the data that was read by the video chip on
    the preceding clock cycle. Many units do not have that clean bus timing,
    and the data seems random. In any case, it is highly improbable that the
    same byte sequence would be read on a real C64.

    After you have detected that your program is running on an emulator, you
    would perhaps want to know the producer and the version number. The
    producer code is at the address $DFFE, in our case P for "Personal". If
    you are writing a C64 emulator yourself, you can use some other value
    here. The version number is stored at $DFFC in hexadecimal format, that
    is $0100 for version 1.00. The digit before the point is the main
    version number, while the digit after the point is the subversion
    number. The last digit specifies the patch level, which should also be
    readable from the emulated C64.

    The version number and manufacturer are also stored in plain text
    beginning at $DFA0. There is a carriage return code 13 between them, and
    the whole string ends in a null byte. By the way, this string was at
    $DF00 in some beta versions of PC64, but that address range was reserved
    for Commodore RAM Expansion Units (REUs).

    A practical example is the BASIC program WHERE AM I in the emulator's
    starting directory, which will print out all the relevant data.

----------------------------------------------------------------------------
2Using L64 in your own programs

    The L64 source code is included with the PC64 distribution files. If you
    write your own applications that transfer data between PC and C64, you
    can always use this source code. In order to make the parallel transfer
    cable to standard, so that not every application will require its own
    hardware, we have placed the L64 source code to the public domain. In
    other words, you may use both source files as they were written by
    yourself.

    The transfer routines for the PC side are in the LINKASM.ASM file. You
    can use the following functions and variables:

    <int L64Send(word wLpt, void far *lpBuffer, int iCount)>
    <int L64Receive(word wLpt, void far *lpBuffer, int iCount)>
    <int L64Joystick(word wLpt)>
    <int L64Result>
    <byte L64LinkWaits[4]>
    <byte L64JoyWaits[4]>
    <byte L64AlternateJoy[4]>
    <byte L64State[4]>

----------------------------------------------------------------------------
3int L64Send(word wLpt, void far *lpBuffer, int iCount)

    This function sends a data block from the PC to the C64.

    \bParameter            Meaning\p

    word wLpt            Number of the parallel port from 0 (LPT1) to 3
                         (LPT4).

    void far *lpBuffer   Pointer to the data buffer in the segment:offset
                         format.

    int iCount           Amount of bytes to be transferred, 0 to 65533. The
                         values 65534 and 65535 correspond to -2 and -1, and
                         they should not be used because of the error
                         detection.

    int return value     Amount of successfully transferred bytes,
                         corresponds to iCount. If the time limit of 1/18 to
                         2/18 seconds was exceeded, a -1 will be returned,
                         and a -2 will be returned on transfer error.

----------------------------------------------------------------------------
3int L64Receive(word wLpt, void far *lpBuffer, int iCount)

    This function retrieves a data block from C64 to the PC.

    \bParameter            Meaning\p

    word wLpt            Number of the parallel port from 0 (LPT1) to 3
                         (LPT4).

    void far *lpBuffer   Pointer to the data buffer in the segment:offset
                         format.

    int iCount           Data buffer size in bytes.

    int return value     Amount of received bytes. If the time limit of 1/18
                         to 2/18 seconds was exceeded, a -1 will be
                         returned, and a -2 will be returned on transfer
                         error or data buffer overflow.

----------------------------------------------------------------------------
3int L64Joystick(word wLpt)

    This function reads the switch positions of the digital joystick. By
    this we mean joysticks connected directly to the PC64 cable or to the
    alternative joystick adapter, and not joysticks connected to the C64.

    \bParameter            Meaning\p

    word wLpt            Number of the parallel port from 0 (LPT1) to 3
                         (LPT4).

    int return value     bit 0 = joystick is being pushed up
                         bit 1 = joystick is being pushed down
                         bit 2 = joystick is being pushed left
                         bit 3 = joystick is being pushed right
                         bit 4 = the fire button is being pushed
                         The bits 5 to 15 are always 0.

----------------------------------------------------------------------------
3int L64Result

    This variable contains the latest return value of the L64Send(),
    L64Receive() and L64Joystick() functions. It allows you to avoid using
    an extra variable, like in this example:

    L64Joystick(Port);
    dx = L64Result & 4 ? -1 : L64Result & 8 ? 1 : 0;
    dy = L64Result & 1 ? -1 : L64Result & 2 ? 1 : 0;

----------------------------------------------------------------------------
3byte L64LinkWaits[4]

    This field contains the wait states for the four parallel interfaces on
    your PC for the data transfer. Values ranging from 0 to 127 are allowed.

    Let the user to specify these values and save them to a configuration
    file. When starting your application, read it from there before
    transferring any data with the L64Send() and L64Receive() functions.

----------------------------------------------------------------------------
3byte L64JoyWaits[4]

    This field contains the wait states for the four parallel interfaces on
    your PC for reading the joystick. Values ranging from 0 to 127 are
    allowed. Let the user to specify these values and save them to a
    configuration file. When starting your application, read it from there
    before reading the joystick with L64Joystick().

----------------------------------------------------------------------------
3byte L64AlternateJoy[4]

    If this field contains a 1, there is an alternative joystick adapter
    connected to the corresponding parallel port. If the byte is 0, there is
    some other hardware present, e.g. the PC64 cable or a printer.

    On program start, all four values are set to 255. When the function
    L64Joystick() is called for the first time, a test program will be
    executed that checks for the alternative joystick adapter. After this
    the byte will be either 0 or 1. You can repeat the test every time by
    explicitly setting the byte to 255. This happens in PC64 e.g. with the
    <Run / Start> command.

    If the alternative joystick adapter is not correctly detected, you
    should increase the corresponding value in L64JoyWaits[].

----------------------------------------------------------------------------
3byte L64State[4]

    This field contains internal states for the data transfer. By setting an
    entry to 255, you can force resynchronisation between the PC and the C64
    connected to that port, which takes automatically place in case of a
    transfer error. In other cases, the bit 7 contains the state of the BUSY
    line after the latest transfer function. This line serves as a trigger
    and changes its status whenever there is new data available from the
    C64.

----------------------------------------------------------------------------
2The transfer routines on the C64

    You can find the transfer routines for the C64 side in the file
    L64ASM.P00. In order to test them, you must proceed according to the
    following scheme:

                LDA #255        ;Force
                STA L64STATE    ; resynchronisation
    GETCOMMAND  JSR L64SYNC     ;What does the PC want?
                BCC RECEIVE
    ;--------------------------------------------------
    ;Send data from C64 to the PC
                LDX #<LENGTH    ;Specify the length
                LDY #>LENGTH
                STX 172
                STY 173
                LDX #<BUFFER    ;Specify the address
                LDY #>BUFFER
                JSR L64SEND     ;Send the data
                BCS ERROR
    ;Here you will process the data,
    ;e.g. prepare the next data block
                JMP GETCOMMAND  ;Next command
    ;---------------------------------------------------
    ;Receive data from the PC
    RECEIVE     LDX #<SIZE      ;Specify the buffer size
                LDY #>SIZE
                STX 172
                STY 173
                LDX #<BUFFER    ;Specify the address
                LDY #>BUFFER
                JSR L64REC      ;Receive the data
                BCS ERROR
    ;Here you will process the data
                JMP GETCOMMAND  ;Next command
    ;----------------------------------------------------
    ERROR       ...             ;Print error message
                JMP GETCOMMAND  ;Next command

    As you see, the PC dictates alone if data should be sent or received.
    The C64 must ensure that the data is available when the PC wants to
    receive, and it must be ready to retransmit a block when there are
    transfer errors.

----------------------------------------------------------------------------
2The L64 control codes

    In your own program it doesn't matter which control codes you transfer
    between PC and C64. But if you want to use L64, then you are bound to
    the following control codes:

    \bNo operation\p
    L64Send(Port, Buffer, 0)

    \bRead data from an IEC bus device (except printer)\p
    Buffer[0] = 00h + Device number from 0 to 15
    Buffer[1] = 60h + Channel number from 0 to 15 (secondary address)
    Buffer[2] = LOBYTE(amount of bytes to read)
    Buffer[3] = HIBYTE(amount of bytes to read)
    L64Send(Port, Buffer, 4)
    amount of read bytes = L64Receive(Port, Buffer, buffer size)
    length of status word = L64Receive(Port, Status, status word size)
    IEC status = Status[0]
    Error message from channel 15 = Status + 1 (terminated with 13)

    \bWrite data to an IEC bus device\p
    Buffer[0] = 10h + Device number from 0 to 15
    Buffer[1] = 60h or F0h/E0h for open/close + Channel number
    Copy the data to the address Buffer + 2
    L64Send(Port, Buffer, 2 + length of data)
    length of status word = L64Receive(Port, Status, status word size)
    IEC status = Status[0]
    Error message from channel 15 = Status + 1 (only disk drives, terminated
        with 13)

    \bBlank screen and disable debugging output\p
    Buffer[0] = 20h
    L64Send(Port, Buffer, 1)

    \bUnblank screen and enable debugging output\p
    Buffer[0] = 21h
    L64Send(Port, Buffer, 1)

    \bRetrieve version and buffer parameter information\p
    Buffer[0] = 22h
    L64Send(Port, Buffer, 1)
    L64Receive(Port, Buffer, 6)
    Major version number (hex) = Buffer[1]
    Minor version number (hex) = Buffer[0]
    Absolute buffer address C64 = Buffer[2] + Buffer[3] * 256
    Buffer size C64 = Buffer[4] + Buffer[5] * 256

    \bExit program on the C64\p
    Buffer[0] = 23h
    L64Send(Port, Buffer, 1)

    \bTest the link between PC and C64\p
    Buffer[0] = 24h
    Copy random values to Buffer + 1
    L64Send(Port, Buffer, 1 + amount of random values)
    L64Receive(Port, Comparison_buffer, 1 + amount of random values)

    The contents of Buffer and Comparison_buffer must be the same, otherwise
    undetected transfer errors have occurred.

    \bRead data from C64 memory\p
    Buffer[0] = 25h
    Buffer[1] = LOBYTE(start address)
    Buffer[2] = HIBYTE(start address)
    Buffer[3] = LOBYTE(length)
    Buffer[4] = HIBYTE(length)
    L64Send(Port, Buffer, 5)
    L64Receive(Port, Buffer, buffer size)

    \bWrite data to C64 memory\p
    Buffer[0] = 26h
    Buffer[1] = LOBYTE(start address)
    Buffer[2] = HIBYTE(start address)
    Copy the data to Buffer + 3
    L64Send(Port, Buffer, 3 + amount of data)

    \bTransfer and execute program\p
    Buffer[0] = 27h
    Copy the program code to Buffer + 1
    L64Send(Port, Buffer, 1 + program length)

    For data buffer and routine addresses, you can consult the L64 function
    22h. You have two possibilities in passing the return value. The first
    way is to only return the three CPU registers as well as the flags:

    LDA #VALUE1
    LDX #VALUE2
    LDY #VALUE3
    RTS
    L64Receive(Port, Buffer, 4)
    Value1 = Buffer[0]
    Value2 = Buffer[1]
    Value3 = Buffer[2]
    6510 flags = Buffer[3]

    The second way allows you to return a pointer to a data buffer:

    LDX #<ADDRESS
    LDY #>ADDRESS
    STX 247
    STY 248
    LDX #<LENGTH
    LDY #>LENGTH
    STX 249
    STY 250
    RTS
    Length = L64Receive(Port, Buffer, buffer size)

    \bEnable fast loader\p
    Buffer[0] = 28h
    Buffer[1] = Device number from 0 to 15
    L64Send(Port, Buffer, 2)

    \bDisable fast loader\p
    Buffer[0] = 29h
    Buffer[1] = Device number from 0 to 15
    L64Send(Port, Buffer, 2)

    \bRead whole tracks with fast loader\p
    Buffer[0] = 2Ah
    Buffer[1] = Starting track from 1 to 35
    Buffer[2] = Amount of tracks
    L64Send(Port, Buffer, 3)
    Length = L64Receive(Port, Buffer, buffer size)
    End = Buffer + Length
    Pointer = Buffer
    while (Pointer < End) {
      Amount of sectors = *Pointer++
      while (Amount of sectors--) {
        Job error code = *Pointer++
        Track = *Pointer++
        Sector = *Pointer++
        memcpy(Data, Pointer, 256)
        Pointer += 256
      }
    }

    \bRead single sectors with fast loader\p
    Buffer[0] = 2Bh
    Buffer[1] = Track between 1 and 35
    Buffer[2] = Sector between 0 and 20
    L64Send(Port, Buffer, 3)
    L64Receive(Poirt, Buffer, 3 + 256)
    Job error code = Buffer[0]
    Track = Buffer[1]
    Sector = Buffer[2]
    memcpy(Data, Pointer + 3, 256)

    \bRead floppy disk memory with fastloader\p

    This command having the code 2Ch had to be deleted in order to save
    memory.

    \bWrite single sectors with fastloader\p
    Buffer[0] = 2Dh
    Buffer[1] = Track between 1 and 35
    Buffer[2] = Sector between 0 and 20
    memcpy(Buffer + 3, Data, 256)
    L64Send(Port, Buffer, 259)
    L64Receive(Port, Buffer, 1)
    Job error code = Buffer[0]

    Instead 01h for OK, the fastloader returns here with the error code 39h.

    You can append your own control codes starting at 80h. The codes from
    2Eh to 7Fh are reserved for expansion by the producer.

    Maybe you cannot imagine what advantages a link between PC and C64 could
    have? In that case, take a look at the following ideas:

    - You create pictures on the PC and transfer them then to video tape
      using the C64. Movies are not possible using this technique, but the
      transfer speed allows for a rate of 1 picture per second.

    - Programmers can use the C64 as a terminal for debug output and can
      thus save the money required for a monochrome monitor or a second PC.

    - To backup your C64 programs, simply copy them to the PC hard disk and
      from there to streamer tape.

    - You can program new C64 applications in an integrated development
      environment on the PC and transfer only the executable program to the
      C64.

----------------------------------------------------------------------------
1Appendix

    <The layout of the PC64 cable>
    <The alternative joystick adaptor>
    <List of shortcut keys>
    <Where can I get updates?>

----------------------------------------------------------------------------
2The layout of the PC64 cable

            +--------------+
            +------------+
                         
                       +---+ \iJoystick\p
            +----+----+----+           +-\u\p-+ (digital)
        +----------------------+         \u\p
         +--+     \iPC\p                   \u\p       +-------------------+
         +--+            LPT\u----------+\p              \iC64\p Userport
        +------------------\u\p---+                 +---------------\u\p---+
                           \u+-------------------------------------+\p

    The PC64 cable connects the PC parallel port with the C64 userport. The
    transfer rate is aproximately 10 kbyte/s without floppy disk accesses.
    If you have a C128 and the display is off, the rate doubles to 20
    kbyte/s.

        \bPC                C64        Meaning\p

    D0      \b2\p   ------>  \bH\p  PB4      4 data lines from PC to C64
    D1      \b3\p   ------>  \bJ\p  PB5               "
    D2      \b4\p   ------>  \bK\p  PB6               "
    D3      \b5\p   ------>  \bL\p  PB7               "
    D7      \b9\p   ------>  \bB\p  FLAG     Hardware trigger falling edge
    GND    \b25\p   ------   \bA\p  GND      Ground (PC also 18 to 24, C64
                                     also 1, 12 and N)
    ERR    \b15\p  <------   \bC\p  PB0      4 data lines from C64 to PC
    SEL    \b13\p  <------   \bD\p  PB1               "
    PE     \b12\p  <------   \bE\p  PB2               "
    ACK    \b10\p  <------   \bF\p  PB3               "
    BUSY   \b11\p  <------   \bM\p  PA2      Software trigger level change

    If you are building the cable yourself then ask for a userport connector
    which is coded. It has two sticks which fit into the notches on the C64
    motherboard. Thus you cannot plug it the wrong way round.

    \bIf you can't get a coded userport connector, please mark the side with
    the numbers 1 to 12 with THIS SIDE UP! Your C64 and the PC's parallel
    port will be destroyed if you plug the userport connector the wrong way!\p
    The reason is the AC current on pins 10 and 11 which has 9 Volts and
    several hundred Milliamperes.

    The cable should be about 3 Meters long. If your cable is longer, you
    may get transmission errors. Increase the waitstates with
    <Options / Waitstates> then. Both a round cable with 10 lines plus
    shield or a flat cable with 11 lines will do.

    On the front side of some connectors, the labels A, N and 12 are
    standing on their heads. But the pins on the back side should be labeled
    correctly. Solder the cable only to the side with the letters, the side
    with the numbers must be left free! You can connect the ground pins A
    and 1 together if the cable has a thick shield. When plugging the
    connector to the C64 userport, the letters (and thus the cable) must be
    on the bottom side! Note that the letters G and I are missing when
    counting the pins.

    In addition to the C64 you can also connect a digital C64 joystick to
    the extended version of the PC64 cable:

        \bPC               Joystick    Meaning\p

    AUTOFD \b14\p   ---->  \b1\p  UP       5 data lines with decoupling diodes,
                                     black rings on PC side
    SELIN  \b17\p   ---->  \b2\p  DOWN                      "
    D4      \b6\p   ---->  \b3\p  LEFT                      "
    D5      \b7\p   ---->  \b4\p  RIGHT                     "
    D6      \b8\p   ---->  \b6\p  FIRE                      "
    STROBE  \b1\p  <------   \b8\p  GND      Common back line

    At a first glance this seems to be illegal because there are several
    outputs connected together. But it is correct because, according to the
    original IBM PC, the control lines must be open collector. In this
    wiring scheme you can determine the state of the fire button by setting
    all lines to 1 except D6. If you now are reading a 0 from the STROBE
    line, the fire button is depressed.

----------------------------------------------------------------------------
2The alternative joystick adaptor

            +--------------+
            +------------+
                         
                       +---+ \iJoystick\p
            +----+----+----+           +-\u\p-+ (digital)
        +----------------------+         \u\p
         +--+     \iPC\p                   \u\p
         +--+            LPT\u----------+\p
        +----------------------+

    About 5 percent of the LPT cards don't have open collector control
    lines. If the digital C64 joystick doesn't work although you have
    increased the settings under <Options / Waitstates>, you probably have
    such a LPT card. The alternative joystick adaptor is also useful for
    laptop users because it doesn't contain a transfer part like the PC64
    cable.

    If you don't have a PC64 cable with a joystick adaptor, you can find out
    with the following test program if your control lines are open collector
    or not. Switch your PC off and connect the lines STROBE (1) and GND (25)
    with a resistor between 100 ohms and 330 ohms. Then switch your PC on
    and run the program OPENCOLL.COM in the PC64 start directory. It shows
    for each of the parallel ports if the control lines are open collector.
    \bNote that OPENCOLL.COM is useless if you don't have a resistor!\p Here is
    an example:

    C:\PC64>opencoll
    01
    C:\PC64>

    Two digits are shown, the PC has two parallel ports. The resistor is
    connected to LPT2 and the corresponding digit is 1. This means that LPT2
    has open collector control lines and you can use the normal PC64 cable
    with the joystick adaptor. If the program prints two zeroes, you should
    connect the resistor to LPT1 and repeat the test. If there are still two
    zeroes then, you need the alternative joystick adaptor.

    It cannot be combined with the PC64 cable because the transfer part is
    using up all input lines. That's why you need either two free LPT ports
    or you have to plug the cables when switching between transfer and
    joystick.

    The alternative joystick adaptor is wired the following way:

        \bPC               Joystick    Meaning\p

    ERROR  \b15\p  <------   \b1\p  UP       Input with 1k pull-up resistor on data
    D0      \b2\p   -+                line
    SELECT \b13\p  <------   \b2\p  DOWN                       "
    D4      \b6\p   -+
    PE     \b12\p  <------   \b3\p  LEFT                       "
    D5      \b7\p   -
                +-+
    ACK    \b10\p  <------   \b4\p  RIGHT                      "
    D6      \b8\p   -
                +-+
    BUSY   \b11\p  <------   \b6\p  FIRE                       "
    D7      \b9\p   -+
    GND    \b25\p   ------   \b8\p  GND       Ground (PC also 18 to 24)

    For reading the switches, all data lines must be set to 1. If the button
    is released, the corresponding input is drawn to 1 by the pull-up
    resistor. If the button is pressed, the connection over GND will set the
    input to 0. With impulses on the data lines D5 and D6 one can
    distinguish between the alternative joystick adaptar and other hardware,
    e.g. the PC64 cable (see L64Joystick() in LINKASM.ASM). The two diodes
    will ensure that the input lines are set to a clean 0 level.

----------------------------------------------------------------------------
2List of shortcut keys

    <Common keys for the desktop>
    <Keys for the directory tree>
    <Keys for the file list>
    <Keys for emulator windows>
    <Keys in C64 mode>

----------------------------------------------------------------------------
3Common keys for the desktop

    The following shortcuts are valid for all windows.

    \bKey                   Meaning\p

    Alt+F4                Exit PC64

    Ctrl+F4               Close current window

    Alt                   Activate menu bar

    Alt+Minus             Activate system menu of the current window

    Tab/Shift+Tab         Jump to the previous/next field in a dialog box

    Highlighted letter,   Switch radio buttons and check boxes, execute
    Space,                command buttons
    Mouse klick left

    Home/End              Go to the start/end of a list

    Enter                 Leave dialog box, confirm changes

    Esc                   Abort dialog box, discard changes

----------------------------------------------------------------------------
3Keys for the directory tree

    The directory tree displays all internal DOS and external C64 drives as
    well as directories and disk images in a hierarchical structure. In
    difference to similar controls in other programs, the subtree opens to
    the current level only. This means that the subdirectories will be
    closed if you are changing to the parent directory.

    \bKey                   Meaning\p

    Cursor up/down,       Go to the previous/next subdirectory
    Mouse click left,
    Mouse draw left

    Cursor right, Space,  Change to subdirectory
    +, Mouse doubleclick
    left

    Cursor left,          Change to parent directory
    Backspace, -, Mouse
    doubleclick right

    Page up/down          One page forward/backward

    Home/End              Go to the first/last subdirectory

    Letter or Digit       Go to the next subdirectory starting with this
                          letter

    Ctrl+Home             Close all subdirectories and jump to drive A:

    F5                    Update the names in the file list

    Alt+F8                Copy 1541 disk image

    Tab/Shift+Tab         Leave directory tree and jump to the next/previous
                          field

----------------------------------------------------------------------------
3Keys for the file list

    The file list displays all PC64 files in the current directory. Normal
    DOS files and subdirectories are not shown. By default, the files are
    sorted by name. Only external C64 drives and disk images will appear in
    the physical order. This allows you to group the components of
    multi-file games by using separator lines.

    You can tag one or more names in the file list and then execute a
    command from the Manager menu. If no name has been tagged, the command
    is using the file with the selection triangle.

    \bKey                   Meaning\p

    Cursor up/down        Go to the previous/next file name

    Cursor left/right     Go one column left/right

    Home/End              Go to the first/last file name

    Letter or digit       Go to the next file name starting with this letter

    Space, Ins,           Tag or untag the current file name
    Mouse klick left,
    Mouse draw left

    +                     Tag all file names

    -                     Untag all file names

    *                     Switch tags for all file names

    Enter, Mouse          Create a new emulator window and run the C64
    doubleklick left      program

    Del                   Delete tagged files

    F7                    Move tagged files

    F8                    Copy tagged files

    Alt+F8                Copy disk image or 1541 disk

    F5                    Update the names in the file list

    Tab/Shift+Tab         Switch to directory tree

----------------------------------------------------------------------------
3Keys for emulator windows

    Each emulator window contains a complete virtual C64 and maybe a
    recorded protocol.

    \bKey                   Meaning\p

    F5                    Run C64 program

    Shift+F5              Run C64 program and record protocol

    Shift+F11             Save current state into a *.C64 file (freezer)

    F11                   Restore state from a *.C64 file

    F9                    Change the disk

    F10                   Set options for joysticks

    Cursor up/down,       Go to the previous/next protocol line
    Mouse klick left

    Page up/down          Go to the previous/next protocol page

    Ctrl+Home/Ctrl+End    Go to the first/last protocol line

    Shift+Cursor,         Select a group of protocol lines (you can't do
    Mouse draw left       something with the selection)

    Ctrl+F3               Search for text

    F2                    Search for address or address range

    F3                    Continue the last search forward

    Shift+F3              Continue the last search backward

    F4/Shift+F4           Go to the previous/next error (red line)

    Minus/Shift+Minus     Go to the previous/next line

    R/Shift+R             Go to the previous/next comment

    V/Shift+V             Go to the previous/next VIC event

    S/Shift+S             Go to the previous/next SID event

    C/Shift+C             Go to the previous/next CIA event

    E/Shift+E             Go to the previous/next IEC event

    D/Shift+D             Go to the previous/next DEV(ice) event

    I/Shift+I             Go to the previous/next INT(errupt) event

----------------------------------------------------------------------------
3Keys in C64 mode

    After switching into C64 mode, most of the PC keys are passed to the
    virtual C64. With the check box
    <Options / Keyboard / Use national keyboard driver> you can switch
    between the standard PC layout and the original C64 layout.

    \bKey                   Meaning\p

    Esc                   Leave C64 mode and return to the desktop. If the
                          link is just waiting for an external C64 or the
                          virtual 1541 is performing an endless loop, you
                          must press Esc twice

    Ctrl+Tab/             Leave C64 mode and switch to the next/previous
    Shift+Ctrl+Tab        window. If this is an emulator window, then go
                          back into C64 mode when releasing Ctrl

    Ctrl+Pause            Returns an error message to the C64 program if the
                          link is waiting in an endless loop. Pressing Esc
                          twice and then restarting the emulation with F5
                          has the same effect

    F9                    Shortcut for <Options / Drives> (changing disks)

    F10                   Shortcut for <Options / Joysticks>

    F11                   Shortcut for <Emulator / Reload>

    Shift+F11             Shortcut for <Emulator / Save>

    Ctrl+Num Plus/Minus   Modify
                   <Options / Timing / Start of interrupt consumes x cycles>

    Alt+Num Plus/Minus    Modify
                 <Options / Timing / VIC[12h]: Report new line at x percent>

    Alt                   C64 key CBM

    Tab                   C64 key STOP

    F12                   C64 key RESTORE

    Backspace             C64 key DEL

    Home                  C64 key HOME

    Ins                   C64 key 

    Del                   C64 key ARROW UP

    ^                     C64 key ARROW UP when national keyboard driver
                          is off

    End                   C64 key ARROW LEFT

    <                     C64 key ARROW LEFT when national keyboard driver
                          is off

    Page up/down          C64 keys F1/F7 (for Turbo Ass)

    Cursor up             C64 key combination SHIFT+CRSR DOWN

    Cursor left           C64 key combination SHIFT+CRSR RIGHT

    Numeric keypad        Joystick directions, also diagonal. Num Lock must
                          be off

    Right Ctrl            Joystick fire button

----------------------------------------------------------------------------
2Where can I get updates?

    The program is Public Domain. If someone wants to continue development,
    just do it...

    <Creating versions to be distributed>

----------------------------------------------------------------------------
#@262
3Creating versions to be distributed

    The Program is Public Domain. You can distribute everything without
    limitations.

----------------------------------------------------------------------------
