#include "pc64.h"

#ifdef _DEBUG

static flag fInDebug = FALSE;
static int hTraceFile = 0;

void _assert(char* pcCondition, char* pcFile, word wLine) {
  if (fInDebug) {
    return;
  }
  fInDebug = TRUE;
  char acMessage[1024];
  wsprintf(acMessage, "%s\n\nAssertion failed in file %s line %u", pcCondition, pcFile, wLine);
  if (*(byte _far*)0x00000449L != 0x03) {
    __asm {
      mov AX,0x0003
      int 0x10
    }
  }
  MessageBeep(MB_ICONSTOP);
  MessageBox(hwndFrame, acMessage, "Assert", MB_ICONSTOP | MB_OK);
  exit(255);
  fInDebug = FALSE;
}

void tracefile(char* pcName) {
  if (hTraceFile > 0) {
    _lclose(hTraceFile);
  }
  if (pcName) {
    hTraceFile = _lopen(pcName, READ_WRITE);
    if (hTraceFile > 0) {
      _llseek(hTraceFile, 0, 2);
      _lwrite(hTraceFile, "\r\n", 2);
    } else {
      hTraceFile = _lcreat(pcName, 0);
    }
  } else {
    hTraceFile = 0;
  }
}

void __cdecl trace(char* pcFormat, ...) {
  if (fInDebug) return;
  fInDebug = TRUE;
  char acMessage[1024];
  wvsprintf(acMessage, pcFormat, (char*)(&pcFormat + 1));
  if (hTraceFile > 0) {
    strcat(acMessage, "\r\n");
    _lwrite(hTraceFile, acMessage, strlen(acMessage));
  } else {
    MessageBeep(MB_ICONINFORMATION);
    if (MessageBox(hwndFrame, acMessage, "Trace", MB_ICONINFORMATION | MB_OKCANCEL) == IDCANCEL) {
      exit(255);
    }
  }
  fInDebug = FALSE;
}

#endif
