#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

#if MASTER
  #ifndef NDEBUG
    #error Bitte schalten Sie die Build Options auf RELEASE!
  #endif
#endif

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int uint;
typedef unsigned long dword;
typedef int handle;
typedef int flag;
const FALSE = 0;
const TRUE = 1;

// Auf grogeschriebenen Vokal prfen
static inline flag isvocal(char c) {
  return memchr("AEIOU", c, 5) != NULL;
}

// Dateinamen von 16 Zeichen auf 8 Zeichen reduzieren
flag ReduceName(const char* sC64Name, char* pDOSName) {
  int iStart;
  // Lnge berprfen
  int iLen = strlen(sC64Name);
  if (iLen > 16) {
    return FALSE;
  }
  // Bei einem Jokerzeichen alle Dateien durchsuchen
  if (strpbrk(sC64Name, "*?")) {
    strcpy(pDOSName, "*");
    return TRUE;
  }
  // In Puffer umkopieren
  char sBuf[16 + 1];
  memset(sBuf, 0, 16);
  strcpy(sBuf, sC64Name);
  // Gltige Zeichen holen
  for (int i = 0; i <= 15; i++) {
    switch (sBuf[i]) {
    case ' ':
    case '-':
      // Leerzeichen durch Unterstrich ersetzen
      sBuf[i] = '_';
      break;
    default:
      // Kleinbuchstaben gro machen
      if (islower((byte)sBuf[i])) {
        sBuf[i] -= 32;
        break;
      }
      // Grobuchstaben und Ziffern sind OK
      if (isalnum((byte)sBuf[i])) {
        break;
      }
      // Ungltige Zeichen entfernen
      if (sBuf[i]) {
        sBuf[i] = 0;
        iLen--;
      }
    }
  }
  // Namen auf 8 Zeichen bringen
  if (iLen <= 8) {
    goto Copy;
  }
  // Unterstriche entfernen
  for (i = 15; i >= 0; i--) {
    if (sBuf[i] == '_') {
      sBuf[i] = 0;
      if (--iLen <= 8) {
        goto Copy;
      }
    }
  }
  // Ersten Nicht-Vokal suchen
  for (iStart = 0; iStart < 15; iStart++) {
    if (sBuf[iStart] && !isvocal(sBuf[iStart])) {
      break;
    }
  }
  // Vokale entfernen
  for (i = 15; i >= iStart; i--) {
    if (isvocal(sBuf[i])) {
      sBuf[i] = 0;
      if (--iLen <= 8) {
        goto Copy;
      }
    }
  }
  // Konsonanten entfernen
  for (i = 15; i >= 0; i--) {
    if (isalpha(sBuf[i])) {
      sBuf[i] = 0;
      if (--iLen <= 8) {
        goto Copy;
      }
    }
  }
  // briggebliebene Ziffern entfernen
  for (i = 0; i <= 15; i++) {
    if (sBuf[i]) {
      sBuf[i] = 0;
      if (--iLen <= 8) {
        goto Copy;
      }
    }
  }
Copy:
  // Dummy-Namen bei Lnge = 0 erfinden
  if (!iLen) {
    strcpy(pDOSName, "_");
    return TRUE;
  }
  // Dateinamen umkopieren
  char* p = pDOSName;
  for (i = 0; i <= 15; i++) {
    if (sBuf[i]) {
      *p++ = sBuf[i];
    }
  }
  *p = 0;
  // DOS-Namen auf Gert prfen
  int hFile = _open(pDOSName, _O_BINARY | _O_RDONLY);
  if (hFile == -1) {
    return TRUE;
  }
  // Wenn es ein Gertename ist, dann '_' als letztes Zeichen anhngen
  if (isatty(hFile)) {
    if (iLen < 8) {
      strcat(pDOSName, "_");
    } else if (pDOSName[7] != '_') {
      pDOSName[7] = '_';
    } else {
      pDOSName[7] = 'X';
    }
  }
  // Zur Probe geffnetes Gert wird nicht mehr gebraucht
  _close(hFile);
  return TRUE;
}

struct {
  char acTag[8];
  char acName[17];
  byte bRecord;
} C64Header;

void Convert(char* pcDir) {
  printf("\r%-79s", pcDir);
  char acName[80];
  strcpy(acName, pcDir);
  char* pcName = acName + strlen(acName);
  if (pcName[-1] != '\\') {
    *pcName++ = '\\';
  }
  strcpy(pcName, "*.*");
  _find_t find;
  uint uFind = _dos_findfirst(acName, _A_NORMAL | _A_SUBDIR, &find);
  while (!uFind) {
    strcpy(pcName, find.name);
    if (find.attrib & _A_SUBDIR) {
      if (find.name[0] != '.') {
        Convert(acName);
      }
    } else {
      char* pcExt = strchr(pcName, '.');
      if (pcExt && strchr("PSUR", pcExt[1]) && isdigit(pcExt[2]) && isdigit(pcExt[3])) {
        handle hFile = _open(acName, _O_BINARY | _O_RDONLY);
        if (hFile == -1) {
          goto Error;
        }
        int iRead = _read(hFile, &C64Header, 26);
        if (iRead == -1) {
          goto Error;
        }
        if (_close(hFile) == -1) {
          goto Error;
        }
        if (iRead == 26 && !strcmp(C64Header.acTag, "C64File")) {
          char acNewName[80];
          strcpy(acNewName, acName);
          char* pcNewName = acNewName + (pcName - acName);
          ReduceName(C64Header.acName, pcNewName);
          *pcExt = 0;
          int iDiff = strcmp(pcName, pcNewName);
          *pcExt = '.';
          if (iDiff) {
            char* pcNum = pcNewName + strlen(pcNewName);
            *pcNum++ = '.';
            *pcNum++ = pcExt[1];
            for (int i = 0; i < 100; i++) {
              sprintf(pcNum, "%02d", i);
              if (!rename(acName, acNewName)) {
                break;
              }
            }
            if (i != 100) {
              printf("\r%s  >  %s\n", acName, pcNewName);
            } else {
              #if GERMAN
                printf("\r%s  >  (keine Ziffer mehr frei)\n", acName);
              #else
                printf("\r%s  >  (no more numbers free)\n", acName);
              #endif
            }
          } else {
            printf("\r%s\n", acName);
          }
        }
      }
    }
    uFind = _dos_findnext(&find);
  }
  return;
Error:
  perror(NULL);
  exit(1);
}

int main(int argc, char** argv) {
  _bdos(0x0D, 0, 0);
  #if GERMAN
    printf("Alte PC64-Dateien an die CD-ROM-kompatible Namenskonvention anpassen\n");
  #else
    printf("Converting old PC64 files to CD-ROM compliant name mapping\n");
  #endif
  char acDir[80];
  if (argc < 2) {
    _fullpath(acDir, ".", 80);
  } else {
    _fullpath(acDir, argv[1], 80);
    _strupr(acDir);
  }
  #if GERMAN
    printf("Startverzeichnis ist %s\n", acDir);
  #else
    printf("Start directory is %s\n", acDir);
  #endif
  Convert(acDir);
  printf("\r%79c", '\r');
  return 0;
}
