;Sound Interface Device an Adresse D400

include pc64.inc

;Variablen und Funktionen aus anderen Modulen
data?
extrn SID:byte
extrn abAdlib:byte
extrn abPulse:byte
extrn c bAdlib:byte
extrn c wDSPCommand:word
extrn c wAdlib:word
extrn c bVolAdlib:byte
extrn c bVolDSP:byte
extrn c bVolMaster:byte
extrn c bVolFM:byte
extrn c bVolVoice:byte
extrn c dSIDtoAdlib:dword
extrn wVolume:word
extrn wVolCounter:word

;Feld fr Lautstrken: [0..2] = Modulator, [3..5] = Carrier
;0 = leise, 63 = laut, -1 = nicht verndern (fr Modulator im FM-Modus)
extrn abVolume:byte

;Fr Frequenz = 0: [0..2] = Modulator, [3..5] = Carrier
;0 = Ton aus, -1 = Ton an
extrn abCellOn:byte

extrn c awUpdate:word
extrn dADSR3:dword
extrn awPaddles:word
extrn awPaddleScale:word
extrn bReadPaddles:byte
extrn wPaddleSet:word
code
IMP WriteIOTable,word
IMP EndUpdate,near
IMP ReadPaddles,near

ifdef DEBUG

data
extrn dVolVal:dword
extrn wVolCount:word
extrn c wRunDebug:word
extrn fnContinue:word
extrn wParam:word
extrn WriteAdlib:word
code
extrn DumpText:far

else

data? 4
dVolVal dd ?
  public dVolVal
wVolCount dw ?
  public wVolCount

;Soundcontroller zurcksetzen
data? 2
WriteAdlib dw ?
  public WriteAdlib
code 1
ResetSID proc near
  public ResetSID
  mov BX,256-4                          ;Adlib-Registercache initialisieren
  xor EAX,EAX
@@Zero:
  mov dword ptr abAdlib[BX],EAX
  sub BX,4
  jns @@Zero
  mov abAdlib[01h],00100000b            ;Wave Selection Enable
  mov WriteAdlib,offset _NoAdlib        ;Registernderungen nicht in die
  mov wDSPCommand,0                     ;  Hardware schreiben
  xor BP,BP                             ;Alle SID-Register auf 0 setzen
@@Next:
  mov CX,offset @@Continue              ;Rcksprungadresse
  xor AL,AL                             ;Register auf 0 setzen
  jmp WriteIOTable[0400h*2+EBP*2]
@@Continue:
  inc BP
  cmp BP,29
  jb @@Next
  ret
ResetSID endp

endif

code 4
@@CheckGate proc near
  test AL,00000001b                     ;Gate fr Timer 2 freigeschaltet?
  je @@DontWait
_Adlib label near
  in AL,61h                             ;Warten 23 us seit letztem Zugriff
  test AL,00100000b
  je @@CheckGate
@@DontWait:
  mov DX,wAdlib                         ;Adreregister schreiben
  mov AL,BL
  cli
  out DX,AL
  in AL,61h                             ;Gate fr Timer 2 freischalten
  or AL,00000001b
  out 61h,AL
  mov AL,10010000b                      ;Timer 2 in Modus 0 schalten
  out 43h,AL
  mov AL,28                             ;Zhler auf 23 us stellen und starten
  out 42h,AL
  inc DX                                ;Datenregister schreiben
  mov AL,AH
  out DX,AL
  sti
  ret
@@CheckGate endp

code 4
_NoAdlib proc near
  ret
_NoAdlib endp

;Lautstrke nach einer nderung neu setzen
code 4
SetVolume proc near
  cmp wVolume,AX
  je @@SameVolume
  mov wVolume,AX
  mov BX,40h
@@NextVolume:
  mov AL,abVolume[BX-40h]
  and AL,AL                             ;Lautstrke = -1: nicht verndern
  js @@DontWrite
  cmp abCellOn[BX-40h],0                ;Frequenz = 0: nicht verndern
  je @@DontWrite
  xor AH,AH
  imul wVolume
  xor AH,00111111b
  cmp AH,abAdlib[BX]
  je @@DontWrite
  call WriteAdlib
  mov abAdlib[BX],AH
@@DontWrite:
  inc BX
  cmp BL,46h
  jb @@NextVolume
@@SameVolume:
  ret
SetVolume endp

;Emulator einschalten
code 1
abFactor db 0,9,10,11,12,13,13,13,14,14,14,15,15,15,16,16
awInit dw 0401h,0108h,06E0h,03C0h,0620h,0640h,0660h,0680h,03A0h,03B0h,01BDh,-1
EXP StartSID,near
StartSID proc near
  mov DX,wDSPCommand                    ;Gerusche zugelassen?
  and DX,DX
  je @@NoDSP
@@WaitCommand:
  in AL,DX                              ;Auf Empfangsbereitschaft warten
  and AL,AL
  js @@WaitCommand
  mov AL,0D1h                           ;Lautsprecher einschalten
  out DX,AL
@@NoDSP:
  mov WriteAdlib,offset _NoAdlib        ;Neue Lautstrke berechnen
  mov BL,SID[24]
  and BX,0000000000001111b
  mov AL,abFactor[BX]
  mul bVolAdlib
  call SetVolume
  cmp bAdlib,0                          ;Funktion frs Schreiben scharfmachen
  je @@NoAdlib
  mov WriteAdlib,offset _Adlib
  mov DI,offset awInit                  ;Inhalt des Adlib-Caches bertragen
@@NextGroup:
  movzx BX,byte ptr CS:[DI]
  cmp BL,-1
  je @@NoAdlib
  inc DI
  movzx CX,byte ptr CS:[DI]
  inc DI
@@NextRegister:
  mov AH,abAdlib[BX]
  call WriteAdlib
  inc BX
  loop @@NextRegister
  jmp @@NextGroup
@@NoAdlib:
  mov dVolVal,0
  mov AL,SID[24]
  mov byte ptr dVolVal,AL
  mov wVolCount,1
  mov wVolCounter,9853                  ;nchste Abfrage in 10 ms
  ret
StartSID endp

;Emulator ausschalten
code 1
EXP StopSID,near
StopSID proc near
  cmp bAdlib,0
  je @@NoAdlib
  mov BX,01h                            ;Alle Adlib-Register auf 0 setzen
  xor AH,AH
@@WriteNext:
  call WriteAdlib
  inc BX
  cmp BL,0F6h
  jb @@WriteNext
@@NoAdlib:
  ret
StopSID endp

code 4
EXP ReadSID0to24,near
ReadSID0to24 proc near
  ifdef DEBUG
    TBEG SID
    mov AX,BX
    and AX,31
    if GERMAN
      WARN "Register %02X lesen (write only)!",<AX>
    else
      WARN "Reading write-only register %02X!",<AX>
    endif
    TEND
  endif
  xor AL,AL
  jmp CX
ReadSID0to24 endp

;SID Register 0

code 4
EXP WriteSID0,near
WriteSID0 proc near
  mov SID[0],AL
  movzx EAX,word ptr SID[0]
  xor BX,BX
ChangeFreq label near
  ifdef DEBUG
    TBEG SID
    inc BX
    if GERMAN
      INFO "Frequenz Stimme %d schreiben (%04X)",<BX,AX>
    else
      INFO "Write sound %d frequency (%04X)",<BX,AX>
    endif
    dec BX
    TEND
  endif
  push CX
  push DX
  cmp AX,17
  jb @@VoiceOff
  imul EAX,dSIDtoAdlib
  bsr ECX,EAX
  cmp CL,24
  jb @@Bound
@@Cont:
  sub CL,17
  shr EAX,CL
  add BL,0A0h
  cmp AH,abAdlib[BX]
  je @@DontWriteLow
  call WriteAdlib
  mov abAdlib[BX],AH
@@DontWriteLow:
  shr EAX,8
  sub CL,7
  shl CL,2
  or AH,CL
  add BL,0B0h-0A0h
  mov AL,abAdlib[BX]
  and AL,11100000b
  or AH,AL
  cmp AH,abAdlib[BX]
  je @@DontWriteHigh
  mov abAdlib[BX],AH
  call WriteAdlib
@@DontWriteHigh:
  sub BL,0B0h
  cmp abCellOn[0+BX],0
  je @@VoiceOn
  pop DX
  ret
@@VoiceOn:
  mov AL,abVolume[0+BX]
  and AL,AL                             ;Lautstrke = -1: nicht verndern
  js @@NoVol1
  xor AH,AH
  imul wVolume
  xor AH,00111111b
  cmp AH,abAdlib[40h+BX]
  je @@NoVol1
  add BL,40h
  call WriteAdlib
  sub BL,40h
  mov abAdlib[40h+BX],AH
@@NoVol1:
  mov abCellOn[0+BX],-1
  mov abCellOn[3+BX],-1
  mov AL,abVolume[3+BX]                 ;Carrier ist niemals -1
  xor AH,AH
  imul wVolume
  xor AH,00111111b
  cmp AH,abAdlib[43h+BX]
  je @@NoVol2
  mov abAdlib[43h+BX],AH
  add BL,43h
  call WriteAdlib
@@NoVol2:
  pop DX
  ret
@@VoiceOff:
  cmp abCellOn[0+BX],0                  ;Stimme bereits ausgeschaltet?
  je @@IsOff
  test abVolume[0+BX],80h               ;Lautstrke = -1: nicht verndern
  jne @@NoVol3
  mov AH,63
  cmp AH,abAdlib[40h+BX]
  je @@NoVol3
  add BL,40h
  call WriteAdlib
  sub BL,40h
  mov abAdlib[40h+BX],AH
@@NoVol3:
  mov abCellOn[0+BX],0
  mov abCellOn[3+BX],0
  mov AH,63
  cmp AH,abAdlib[43h+BX]
  je @@IsOff
  mov abAdlib[43h+BX],AH
  add BL,43h
  call WriteAdlib
@@IsOff:
  pop DX
  ret
@@Bound:
  mov CL,27
  jmp @@Cont
WriteSID0 endp

;SID Register 1

code 4
EXP WriteSID1,near
WriteSID1 proc near
  mov SID[1],AL
  movzx EAX,word ptr SID[0]
  xor BX,BX
  jmp ChangeFreq
WriteSID1 endp

;SID Register 2

;Pulsbreiten fr Modulator Rechteck
code 1
abPulseMod label byte
  db 00,01,02,03,04,04,05,05
  db 06,06,07,07,08,08,09,09
  db 10,10,11,11,12,12,13,13
  db 14,14,15,15,16,16,16,16
code 4
EXP WriteSID2,near
WriteSID2 proc near
  mov SID[2],AL
  mov DI,word ptr SID[2]
  xor BX,BX
  push DX
  mov DL,SID[4]
PulseChanged label near
  ifdef DEBUG
    TBEG SID
    inc BX
    if GERMAN
      INFO "Pulsbreite Stimme %d schreiben (%04X)",<BX,DI>
    else
      INFO "Write sound %d pulse width (%04X)",<BX,DI>
    endif
    dec BX
    TEND
  endif
  shr DI,6                              ;Pulsbreite nach Modulator Amplitude
  mov AH,abPulseMod[DI]
  mov abPulse[BX],AH
  and DL,11110000b                      ;Ist Rechteck eingeschaltet?
  cmp DL,01000000b
  jne @@DontWrite
  add BL,40h                            ;Stimmt Inhalt bereits berein?
  cmp AH,abAdlib[BX]
  je @@DontWrite
  mov abAdlib[BX],AH                    ;Wert in Cache schreiben
  call WriteAdlib
@@DontWrite:
  pop DX
  jmp CX
WriteSID2 endp

;SID Register 3

code 4
EXP WriteSID3,near
WriteSID3 proc near
  and AL,00000111b
  mov SID[3],AL
  mov DI,word ptr SID[2]
  xor BX,BX
  push DX
  mov DL,SID[4]
  jmp PulseChanged
WriteSID3 endp

;SID Register 4

;Adressen und Inhalte der Adlib-Register fr die unterschiedlichen Wellenformen
ifdef DEBUG
data
extrn abIndex:byte
extrn abWave:byte
else
data 1
abIndex db 0E0h,0E3h,0C0h,20h,23h,40h ;und 40h,43h fr Lautstrkeregelung
  public abIndex
abWave label byte
  public abWave
  db 00h,00h,01h,21h,21h,-1,   63-4,63-4 ;Dreieck
  db 03h,03h,01h,20h,20h,-1,   63,  63   ;Sgezahn
  db 00h,00h,00h,21h,21h,?,    -1,  63   ;Rechteck
  db 00h,00h,0Eh,25h,21h,0,    -1,  63-4 ;Rauschen FM
endif

code 4
EXP WriteSID4,near
WriteSID4 proc near
  mov SID[4],AL
  xor BX,BX
WriteControl label near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    inc BX
    if GERMAN
      INFO "Steuerregister Stimme %d schreiben (%02X)",<BX,AX>
    else
      INFO "Write sound %d control register (%02X)",<BX,AX>
    endif
    dec BX
    test AL,00000001b
    jne @@Bit0
    if GERMAN
      INFO2 "Bit 0 = 0: Ton aus"
    else
      INFO2 "Bit 0 = 0: Sound off (start Release sequence)"
    endif
    jmp @@NoBit0
  @@Bit0:
    if GERMAN
      INFO2 "Bit 0 = 1: Ton an"
    else
      INFO2 "Bit 0 = 1: Sound on (start Attack/Decay/Sustain sequence)"
    endif
    cmp BL,2
    jne @@NoBit0
    test SID[24],10000000b
    je @@NoBit0
    and AL,11111110b
    if GERMAN
      INFO2 "Bit 7 in D418 ist gesetzt, Stimme 3 ist stummgeschaltet"
    else
      INFO2 "Bit 7 of D418 is set, Oscillator 3 disabled"
    endif
  @@NoBit0:
    test AL,00000010b
    je @@NoBit1
    if GERMAN
      INFO2 "Bit 1 = 1: Synchronisation (wird nicht untersttzt)"
    else
      INFO2 "Bit 1 = 1: Synchronization (not supported)"
    endif
  @@NoBit1:
    test AL,00000100b
    je @@NoBit2
    if GERMAN
      INFO2 "Bit 2 = 1: Ringmodulation (wird nicht untersttzt)"
    else
      INFO2 "Bit 2 = 1: Ring modulation (not supported)"
    endif
  @@NoBit2:
    test AL,00001000b
    je @@NoBit3
    if GERMAN
      INFO2 "Bit 3 = 1: Test (bewirkt nichts)"
    else
      INFO2 "Bit 3 = 1: Test (no operation)"
    endif
  @@NoBit3:
    test AL,00010000b
    je @@NoBit4
    if GERMAN
      INFO2 "Bit 4 = 1: Wellenform Dreieck"
    else
      INFO2 "Bit 4 = 1: Triangle waveform"
    endif
  @@NoBit4:
    test AL,00100000b
    je @@NoBit5
    if GERMAN
      INFO2 "Bit 5 = 1: Wellenform Sgezahn"
    else
      INFO2 "Bit 5 = 1: Sawtooth waveform"
    endif
  @@NoBit5:
    test AL,01000000b
    je @@NoBit6
    if GERMAN
      INFO2 "Bit 6 = 1: Wellenform Rechteck"
    else
      INFO2 "Bit 6 = 1: Pulse waveform"
    endif
  @@NoBit6:
    test AL,10000000b
    je @@NoBit7
    if GERMAN
      INFO2 "Bit 7 = 1: Wellenform Rauschen"
    else
      INFO2 "Bit 7 = 1: White noise waveform"
    endif
  @@NoBit7:
    TEND
  endif
  push DX
  push BP
  push AX
  mov BP,offset DGROUP:abWave[3*8]      ;Rauschen
  test AL,10000000b
  jne @@SetWave
  mov BP,offset DGROUP:abWave[1*8]      ;Sgezahn
  test AL,00100000b
  jne @@SetWave
  mov BP,offset DGROUP:abWave[0*8]      ;Dreieck
  test AL,00010000b
  jne @@SetWave
  test AL,01000000b                     ;Rechteck
  je @@NoWave
  mov BP,offset DGROUP:abWave[2*8]
  mov DL,abPulse[BX]                    ;Puls/Pause-Verhltnis bertragen
  mov abWave[2*8+5],DL
@@SetWave:
  xor DI,DI
@@WriteNext:
  add BL,abIndex[DI]                    ;Registerindex nach BX holen
  mov AH,DS:[BP+DI]                     ;Neuen Inhalt lesen
  and AH,AH                             ;-1 bedeutet berspringen
  js @@DontWrite
  cmp AH,abAdlib[BX]                    ;Stimmt Inhalt bereits berein?
  je @@DontWrite
  mov abAdlib[BX],AH                    ;Wert in Cache schreiben
  call WriteAdlib
@@DontWrite:
  sub BL,abIndex[DI]                    ;Adresse wieder herausrechnen
  inc DI
  cmp DI,6
  jb @@WriteNext
  mov AL,DS:[BP+6]                      ;Lautstrke Modulator bertragen
  mov abVolume[0+BX],AL
  and AL,AL                             ;Lautstrke -1 = nicht verndern
  js @@NoVol1
  cmp abCellOn[0+BX],0                  ;Frequenz = 0: nicht verndern
  je @@NoVol1
  xor AH,AH                             ;Lautstrke berechnen
  imul wVolume
  xor AH,00111111b
  cmp AH,abAdlib[40h+BX]
  je @@NoVol1
  add BL,40h
  call WriteAdlib
  sub BL,40h
  mov abAdlib[40h+BX],AH
@@NoVol1:
  mov AL,DS:[BP+7]                      ;Lautstrke Carrier bertragen
  mov abVolume[3+BX],AL
  cmp abCellOn[0+BX],0                  ;Frequenz = 0: nicht verndern
  je @@NoVol2
  xor AH,AH                             ;Lautstrke berechnen
  imul wVolume
  xor AH,00111111b
  cmp AH,abAdlib[43h+BX]
  je @@NoVol2
  add BL,43h
  call WriteAdlib
  sub BL,43h
  mov abAdlib[43h+BX],AH
@@NoVol2:
@@NoWaveCont:
  pop AX                                ;Ton laut KeyOn ein- oder ausschalten
  shl AX,13
  cmp BL,2                              ;Bei stummgeschalteter Stimme 3
  jne @@NoMute3                         ;  KeyOn-Bit lschen
  test SID[24],10000000b
  je @@NoMute3
  xor AH,AH
@@NoMute3:
  add BL,0B0h
  mov AL,abAdlib[BX]
  and AX,0010000011011111b
  or AH,AL
  cmp AH,abAdlib[BX]
  je @@Return
  mov abAdlib[BX],AH
  call WriteAdlib
@@Return:
  pop BP
  pop DX
  jmp CX
@@NoWave:
  mov AH,00111111b
  cmp AH,abAdlib[40h+BX]
  je @@Vol1Ok
  add BL,40h
  call WriteAdlib
  sub BL,40h
  mov abAdlib[40h+BX],AH
@@Vol1Ok:
  mov abVolume[0+BX],0
  mov abVolume[3+BX],0
  cmp AH,abAdlib[43h+BX]
  je @@NoWaveCont
  add BL,43h
  call WriteAdlib
  sub BL,43h
  mov abAdlib[43h+BX],AH
  jmp @@NoWaveCont
WriteSID4 endp

;SID Register 5

code 1
abAttack label byte
  db (15-4)*16,(15-6)*16,(15-7)*16,(15-8)*16
  db (15-8)*16,(15-9)*16,(15-9)*16,(15-9)*16
  db (15-10)*16,(15-11)*16,(15-12)*16,(15-13)*16
  db (15-13)*16,(15-14)*16,(15-14)*16,(15-14)*16
abDecay label byte
  db 15-4,15-5,15-6,15-6
  db 15-6,15-6,15-6,15-7
  db 15-8,15-9,15-10,15-11
  db 15-12,15-13,15-14,15-14
code 4
EXP WriteSID5,near
WriteSID5 proc near
  xor BX,BX
AttackDecay label near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    inc BX
    if GERMAN
      INFO "Attack/Decay Stimme %d schreiben (%02X)",<BX,AX>
    else
      INFO "Write sound %d Attack/Decay (%02X)",<BX,AX>
    endif
    dec BX
    TEND
  endif
  shld DI,AX,12
  and DI,0000000000001111b
  mov AH,abAttack[DI]
  mov DI,AX
  and DI,0000000000001111b
  or AH,abDecay[DI]
  push DX
  add BL,60h
  call WriteAdlib
  mov abAdlib[BX],AH
  add BL,63h-60h
  mov abAdlib[BX],AH
  call WriteAdlib
  pop DX
  jmp CX
WriteSID5 endp

;SID Register 6

code 1
abSustain label byte
  db (15-0)*16,(15-8)*16,(15-10)*16,(15-11)*16
  db (15-12)*16,(15-12)*16,(15-13)*16,(15-13)*16
  db (15-13)*16,(15-14)*16,(15-14)*16,(15-14)*16
  db (15-14)*16,(15-14)*16,(15-15)*16,(15-15)*16
abRelease label byte
  db 15-0,15-1,15-2,15-3
  db 15-4,15-5,15-6,15-7
  db 15-8,15-9,15-10,15-11
  db 15-12,15-13,15-14,15-14
code 4
EXP WriteSID6,near
WriteSID6 proc near
  xor BX,BX
SustainRelease label near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    inc BX
    if GERMAN
      INFO "Sustain/Release Stimme %d schreiben (%02X)",<BX,AX>
    else
      INFO "Write sound %d Sustain/Release (%02X)",<BX,AX>
    endif
    dec BX
    TEND
  endif
  shld DI,AX,12
  and DI,0000000000001111b
  mov AH,abSustain[DI]
  mov DI,AX
  and DI,0000000000001111b
  or AH,abRelease[DI]
  push DX
  add BL,80h
  call WriteAdlib
  mov abAdlib[BX],AH
  add BL,83h-80h
  mov abAdlib[BX],AH
  call WriteAdlib
  pop DX
  jmp CX
WriteSID6 endp

;SID Register 7

code 4
EXP WriteSID7,near
WriteSID7 proc near
  mov SID[7],AL
  movzx EAX,word ptr SID[7]
  mov BX,1
  jmp ChangeFreq
WriteSID7 endp

;SID Register 8

code 4
EXP WriteSID8,near
WriteSID8 proc near
  mov SID[8],AL
  movzx EAX,word ptr SID[7]
  mov BX,1
  jmp ChangeFreq
WriteSID8 endp

;SID Register 9

code 4
EXP WriteSID9,near
WriteSID9 proc near
  mov SID[9],AL
  mov DI,word ptr SID[9]
  mov BX,1
  push DX
  mov DL,SID[11]
  jmp PulseChanged
WriteSID9 endp

;SID Register 10

code 4
EXP WriteSID10,near
WriteSID10 proc near
  and AL,00000111b
  mov SID[10],AL
  mov DI,word ptr SID[9]
  mov BX,1
  push DX
  mov DL,SID[11]
  jmp PulseChanged
WriteSID10 endp

;SID Register 11

code 4
EXP WriteSID11,near
WriteSID11 proc near
  mov SID[11],AL
  mov BX,1
  jmp WriteControl
WriteSID11 endp

;SID Register 12

code 4
EXP WriteSID12,near
WriteSID12 proc near
  mov BX,1
  jmp AttackDecay
WriteSID12 endp

;SID Register 13

code 4
EXP WriteSID13,near
WriteSID13 proc near
  mov BX,1
  jmp SustainRelease
WriteSID13 endp

;SID Register 14

code 4
EXP WriteSID14,near
WriteSID14 proc near
  mov SID[14],AL
  movzx EAX,word ptr SID[14]
  mov BX,2
  jmp ChangeFreq
WriteSID14 endp

;SID Register 15

code 4
EXP WriteSID15,near
WriteSID15 proc near
  mov SID[15],AL
  movzx EAX,word ptr SID[14]
  mov BX,2
  jmp ChangeFreq
WriteSID15 endp

;SID Register 16

code 4
EXP WriteSID16,near
WriteSID16 proc near
  mov SID[16],AL
  mov DI,word ptr SID[16]
  mov BX,2
  push DX
  mov DL,SID[18]
  jmp PulseChanged
WriteSID16 endp

;SID Register 17

code 4
EXP WriteSID17,near
WriteSID17 proc near
  and AL,00000111b
  mov SID[17],AL
  mov DI,word ptr SID[16]
  mov BX,2
  push DX
  mov DL,SID[18]
  jmp PulseChanged
WriteSID17 endp

;SID Register 18

code 4
EXP WriteSID18,near
WriteSID18 proc near
  mov AH,SID[18]
  mov SID[18],AL
  mov BX,2
  xor AH,AL                             ;Hat sich Key On von Stimme 3 gendert?
  test AH,00000001b
  je WriteControl
  mov dADSR3,0                          ;Ja, dann Zhler zurcksetzen
  jmp WriteControl
WriteSID18 endp

;SID Register 19

code 4
EXP WriteSID19,near
WriteSID19 proc near
  mov SID[19],AL                        ;Fr ADSR Stimme 3 lesen
  mov BX,2
  jmp AttackDecay
WriteSID19 endp

;SID Register 20

code 4
EXP WriteSID20,near
WriteSID20 proc near
  mov SID[20],AL                        ;Fr ADSR Stimme 3 lesen
  mov BX,2
  jmp SustainRelease
WriteSID20 endp

;SID Register 21

code 4
EXP WriteSID21,near
WriteSID21 proc near
  shl AL,5
  mov SID[21],AL
FilterChanged label near
  ifdef DEBUG
    TBEG SID
    mov AX,word ptr SID[21]
    shr AX,5
    if GERMAN
      INFO "Filterfrequenz setzen (%04X, wird nicht untersttzt)",<AX>
    else
      INFO "Set filter frequency (%04X, not supported)",<AX>
    endif
    TEND
  endif
  jmp CX
WriteSID21 endp

;SID Register 22

code 4
EXP WriteSID22,near
WriteSID22 proc near
  mov SID[22],AL
  jmp FilterChanged
WriteSID22 endp

;SID Register 23

code 4
EXP WriteSID23,near
WriteSID23 proc near
  mov SID[23],AL
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      INFO "Filterresonanz und Schalter setzen (%02X, wird nicht untersttzt)",<AX>
    else
      INFO "Set filter resonance and switches (%02X, not supported)",<AX>
    endif
    test AL,00000001b
    je @@NoBit0
    if GERMAN
      INFO2 "Bit 0 = 1: Stimme 1 wrde gefiltert"
    else
      INFO2 "Bit 0 = 1: Sound 1 would be filtered"
    endif
  @@NoBit0:
    test AL,00000010b
    je @@NoBit1
    if GERMAN
      INFO2 "Bit 1 = 1: Stimme 2 wrde gefiltert"
    else
      INFO2 "Bit 1 = 1: Sound 2 would be filtered"
    endif
  @@NoBit1:
    test AL,00000100b
    je @@NoBit2
    if GERMAN
      INFO2 "Bit 2 = 1: Stimme 3 wrde gefiltert"
    else
      INFO2 "Bit 2 = 1: Sound 3 would be filtered"
    endif
  @@NoBit2:
    test AL,00001000b
    je @@NoBit3
    if GERMAN
      WARN2 "Bit 3 = 1: Externe Signalquelle wird nicht untersttzt!"
    else
      WARN2 "Bit 3 = 1: External signal source is not supported!"
    endif
  @@NoBit3:
    TEND
  endif
  jmp CX
WriteSID23 endp

;SID Register 24

code 4
EXP WriteSID24,near
WriteSID24 proc near
  mov SID[24],AL
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      INFO "Gesamtlautstrke schreiben (%02X)",<AX>
    else
      INFO "Write master volume setting (%02X)",<AX>
    endif
    test AL,00010000b
    je @@NoBit4
    if GERMAN
      INFO2 "Bit 4 = 1: Tiefpa ein (wird nicht untersttzt)"
    else
      INFO2 "Bit 4 = 1: Low-pass filter on (not supported)"
    endif
  @@NoBit4:
    test AL,00100000b
    je @@NoBit5
    if GERMAN
      INFO2 "Bit 5 = 1: Bandpa ein (wird nicht untersttzt)"
    else
      INFO2 "Bit 5 = 1: Band-pass filter on (not supported)"
    endif
  @@NoBit5:
    test AL,01000000b
    je @@NoBit6
    if GERMAN
      INFO2 "Bit 6 = 1: Hochpa ein (wird nicht untersttzt)"
    else
      INFO2 "Bit 6 = 1: High-pass filter on (not supported)"
    endif
  @@NoBit6:
    test AL,10000000b
    je @@NoBit7
    if GERMAN
      INFO2 "Bit 7 = 1: Stimme 3 ist stummgeschaltet"
    else
      INFO2 "Bit 7 = 1: Oscillator 3 has been disabled"
    endif
  @@NoBit7:
    TEND
  endif
  and EAX,0000000Fh                     ;Durchschnittslautstrke
  add dVolVal,EAX
  inc wVolCount
  push DX
  mov DX,wDSPCommand                    ;Gerusche zugelassen?
  and DX,DX
  je @@NoDSP
@@WaitCommand:
  in AL,DX                              ;Auf Empfangsbereitschaft warten
  and AL,AL
  js @@WaitCommand
  mov AL,10h                            ;8 bit DAC output
  out DX,AL
  mov AL,SID[24]                        ;Lautstrke berechnen
  and AL,00001111b
  mul bVolDSP
  mov AH,AL                             ;Auf Empfangsbereitschaft warten
@@WaitData:
  in AL,DX
  and AL,AL
  js @@WaitData
  mov AL,AH                             ;Wert ausgeben
  out DX,AL
@@NoDSP:
  pop DX
  jmp CX
WriteSID24 endp

;SID Register 25

code 4
EXP ReadSID25,near
ReadSID25 proc near
  xor DI,DI
ReadAD label near
  push CX
  cmp bReadPaddles,0                    ;Neulesen erforderlich?
  je @@DontRead
  push BX
  push DX
  push DI
  call ReadPaddles                      ;Paddles alle 1/18 sec neu einlesen
  pop DI
  pop DX
  pop BX
@@DontRead:
  add DI,wPaddleSet                     ;-4 = keins, 0 = Set 1, 4 = Set 2
  js @@NoPaddle
  mov AX,awPaddleScale[DI]              ;Faktor = 0: nicht vorhanden
  and AX,AX
  je @@NoPaddle
  imul AX,awPaddles[DI]                 ;Wert auf 0..255 skalieren
  shr AX,7
  cmp AX,255
  jb @@Return
@@NoPaddle:
  mov AX,255
@@Return:
  ifdef DEBUG
    TBEG SID
    sar DI,2
    sbb CX,CX
    neg CX
    add CL,'X'
    inc DI
    xor AH,AH
    if GERMAN
      INFO "Paddle %d %c-Koordinate lesen (%02X)",<DI,CX,AX>
    else
      INFO "Read paddle %d %c coordinate (%02X)",<DI,CX,AX>
    endif
    TEND
  endif
  ret
ReadSID25 endp

code 4
EXP WriteSID25,near
WriteSID25 proc near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      WARN "Paddle X-Koordinate schreiben (%02X)",<AX>
    else
      WARN "Write paddle X coordinate (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
WriteSID25 endp

;SID Register 26

code 4
EXP ReadSID26,near
ReadSID26 proc near
  mov DI,2
  jmp ReadAD
ReadSID26 endp

code 4
EXP WriteSID26,near
WriteSID26 proc near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      WARN "Paddle Y-Koordinate schreiben (%02X)",<AX>
    else
      WARN "Write paddle Y coordinate (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
WriteSID26 endp

;SID Register 27 -- Frequenzgenerator liefert Zufallswerte 0..255 (nur lesen)
;Bedingung: Stimme 3 mu auf Wellenform gesetzt sein, Frequenz != 0
;KeyOn und Sustain nicht erforderlich

code 4
EXP ReadSID27,near
ReadSID27 proc near
  mov AL,00000100b
  test SID[18],11110000b
  je @@NoNoise
  out 43h,AL
  in AL,40h
  mov AH,AL
  in AL,40h
  xor AX,BP
  xor AL,AH
@@NoNoise:
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      INFO "Frequenzgenerator Stimme 3 lesen (%02X)",<AX>
    else
      INFO "Read sound 3 oscillator value (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
ReadSID27 endp

code 4
EXP WriteSID27,near
WriteSID27 proc near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      WARN "Frequenzgenerator Stimme 3 schreiben (%02X)",<AX>
    else
      WARN "Write sound 3 oscillator value (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
WriteSID27 endp

;SID Register 28

ifdef DEBUG
const
extrn adAttack:dword
extrn adDecay:dword
extrn adRelease:dword
else
const 4
adAttack label dword
  public adAttack
  dd 2324,8189,16034,24254,38024,56129,68114,79544
  dd 99989,249164,498299,731623,930778,2988629,4980689,7937789
adDecay label dword
  public adDecay
  dd 6712,24079,46675,67689,111180,164156,197700,232371
  dd 292186,736567,1472869,2358712,2947958,8834363,14738821,23588704
adRelease label dword
  public adRelease
  dd 6814,24195,47638,71830,112507,166330,201855,236638
  dd 296362,737649,1475281,2360144,2888166,8860330,14766202,23625759
endif

code 4
EXP ReadSID28,near
ReadSID28 proc near
  push BX
  mov EAX,dADSR3
  test SID[18],00000001b                ;ADS- oder R-Phase?
  je @@Release
  mov BL,SID[19]                        ;Wert fr Attack holen
  and BX,0000000011110000b
  shr BX,2
  cmp EAX,adAttack[BX]
  jb @@Attack
  sub EAX,adAttack[BX]
  mov BL,SID[19]                        ;Wert fr Decay holen
  and BL,00001111b
  shl BX,2
  cmp EAX,adDecay[BX]
  jb @@Decay
@@Sustain:
  mov AL,SID[20]                        ;In der Sustain-Phase
  and EAX,0000000011110000b
  shr AX,4
  imul AX,11h
  jmp @@Return
@@Attack:
  mov DI,256
  push EDX
  mul EDI
  div adAttack[BX]
  pop EDX
  jmp @@Return
@@Decay:
  mov DI,word ptr SID[20]
  and DI,0000000011110000b
  shr DI,4
  neg DI
  add DI,15
  imul DI,11h
  push EDX
  mul EDI
  div adDecay[BX]
  pop EDX
  not AL
  jmp @@Return
@@Release:
  mov BL,SID[20]
  and BX,0000000000001111b
  shl BX,2
  cmp EAX,adRelease[BX]
  jae @@Zero
  mov DI,word ptr SID[20]
  and DI,0000000011110000b
  shr DI,4
  imul DI,11h
  push EDX
  mul EDI
  div adRelease[BX]
  pop EDX
  neg AX
  add AX,DI
  jmp @@Return
@@Zero:
  xor EAX,EAX
@@Return:
  ifdef DEBUG
    TBEG SID
    if GERMAN
      INFO "Hllkurvengenerator Stimme 3 lesen (%02X)",<AX>
    else
      INFO "Read Sound 3 envelope generator value (%02X)",<AX>
    endif
    TEND
  endif
  pop BX
  jmp CX
ReadSID28 endp

code 4
EXP WriteSID28,near
WriteSID28 proc near
  ifdef DEBUG
    TBEG SID
    xor AH,AH
    if GERMAN
      WARN "Hllkurvengenerator Stimme 3 schreiben (%02X)",<AX>
    else
      WARN "Write Sound 3 envelope generator value (%02X)",<AX>
    endif
    TEND
  endif
  jmp CX
WriteSID28 endp

comment @  Funktionsweise der verzgerten Lautstrkeregelung
           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
1) Das C64-Programm ndert die Lautstrke durch Beschreiben von SID[24].
   Die einzelnen Lautstrken werden in dVolVal und die Anzahl in wVolCount
   aufsummiert.

2) In UpdateSID() wird der Zhler wVolCounter um die verstrichenen C64-Takte
   in awUpdate[0] verringert. Ist das Ergebnis kleiner 0, so sind 10 ms seit
   der letzten nderung verstrichen. Dann wird die Durchschnittslautstrke
   berechnet und in die Register der Adlib-Karte geschrieben.
@

;Periodische Arbeiten alle 64 us durchfhren
code 4
EXP UpdateSID,near
UpdateSID proc near
  movzx EAX,awUpdate[0]                 ;Zhler fr Stimme 3 seit dem letzten
  add dADSR3,EAX                        ;  Wechsel von KeyOn weiterzhlen
  mov AX,awUpdate[0]                    ;Verstrichene Zeit abziehen
  sub wVolCounter,AX
  jnc EndUpdate
  mov wVolCounter,9853                  ;nchste Abfrage in 10 ms
  mov AX,word ptr dVolVal+0             ;Durchschnitt berechnen
  mov DX,word ptr dVolVal+2
  div wVolCount
  mov BX,AX
  mov AL,SID[24]
  and EAX,0Fh
  mov dVolVal,EAX
  mov wVolCount,1
  mov AL,abFactor[BX]                   ;Lautstrke neu berechnen und setzen
  mul bVolAdlib
  push offset EndUpdate                 ;Ein "ret" eingespart :-)
  jmp SetVolume
UpdateSID endp

ende
