// Dialog Adresse suchen

#include "pc64.h"

void SetDlgItemHex(HWND hwnd, int iItem, long lValue, int iLength) {
  char ac[9];
  wsprintf(ac, "%08lX", lValue);
  assert(iLength >= 0);
  assert(iLength <= 8);
  SetDlgItemText(hwnd, iItem, ac + 8 - iLength);
}

long GetDlgItemHex(HWND hwnd, int iItem) {
  char ac[40];
  GetDlgItemText (hwnd, iItem, ac, 40);
  return strtol(ac, NULL, 16);
}

BOOL FAR PASCAL SearchAdrDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    assert(pfw);
    SetDlgItemHex(hwnd, IDE_SEARCHFROM, wSearchFrom, 4);
    SetDlgItemHex(hwnd, IDE_SEARCHTO, wSearchTo, 4);
    wDialogHelp = IDM_SEARCHADR;
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDE_SEARCHFROM:
      if (HIWORD(lParam) == EN_UPDATE) {
        SetDlgItemHex(hwnd, IDE_SEARCHTO, GetDlgItemHex(hwnd, IDE_SEARCHFROM), 4);
      }
      return TRUE;
    case IDOK:
      {
        word wFrom = (word)GetDlgItemHex(hwnd, IDE_SEARCHFROM);
        word wTo = (word)GetDlgItemHex(hwnd, IDE_SEARCHTO);
        if (wTo < wFrom) {
          ErrorBox(NULL, acEndIsLessThanStart);
          return TRUE;
        }
        wSearchFrom = wFrom;
        wSearchTo = wTo;
      }
      fSearchAdr = TRUE;
      fSearchBack = IsDlgButtonChecked(hwnd, IDB_BACKADR);
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, wParam == IDOK);
      return TRUE;
    }
  }
  return FALSE;
}
