// Klassendefinitionen fr einen Drucker

class CPrinter : public CDevice {
  char acFileName[80];
  int hFile;
  byte abBuffer[256];
  word wIndex;
  word wConvert;
  flag fIsATTY;
public:
  // Konstruktor
  CPrinter();
  // Destruktor
  ~CPrinter();
  // Typ liefern
  word GetType();
  // Puffer schreiben
  flag Flush(flag fClose);
  // Datei ffnen
  flag OpenFile();
  // Ein Zeichen auf dem Drucker ausgeben
  flag Print(byte bValue);
  // Neuen Dateinamen setzen
  flag SetDir(char* pDir);
  // Aktuellen Dateinamen auslesen
  void GetDir(char* pDir, word wMax);
  // Zeichenumsetzung setzen
  void SetConvert(word w);
  // Zeichenumsetzung auslesen
  word GetConvert();
  // Drucker zurcksetzen
  word Reset();
  // Befehl abschicken
  word Command(char* sCommand, word wLength);
  // Fehlermeldung holen
  word GetError(char* pBuffer, word wMax);
  // Status in Image schreiben
  flag Save(int hFile);
  // Status aus Image lesen
  flag Load(int hFile);
  // C64-Dateien unter DOS ffnen
  word Start();
  // C64-Dateien unter DOS schlieen
  word Stop();
  // Datei oder Verzeichnis ffnen
  word Open(word wChannel, char* acName, word wLength);
  // Zeichen in Datei schreiben
  word Put(word wChannel, byte bValue);
  // Ende Schreiben
  word Unlisten();
  // Zeichen aus Datei lesen
  word Get(word wChannel);
  // Block schreiben
  word Write(word wChannel, byte* pbBuffer, word* pwCount);
  // Block lesen
  word Read(word wChannel, byte* pbBuffer, word* pwCount);
  // Datei schliessen
  word Close(word wChannel);
  // Satzlnge einer relativen Datei liefern
  byte GetRelLength(word wChannel);
  // Disketten kopieren
  flag BeginTrack(flag fWrite);
  word ReadNextTrack(byte* pbBuffer);
  flag WriteNextTrack(byte* pbBuffer, word wLength);
  flag EndTrack();
};
