;Include-Datei fr alle Module, Segmentdefinitionen und Macros

option proc:private
option scoped

.386
DGROUP group CONST,_DATA,_BSS
assume DS:DGROUP

;Import und Export ffentlicher Labels
ifdef DEBUG
  IMP macro Name,Type
    extrn c Name&_D:Type
    Name equ Name&_D
  endm
  EXP macro Name,Type
    Name&_D label Type
    public c Name&_D
  endm
else
  IMP macro Name,Type
    extrn c Name&_R:Type
    Name equ Name&_R
  endm
  EXP macro Name,Type
    Name&_R label Type
    public c Name&_R
  endm
endif

;Segment fr Konstanten, darf nur gelesen werden
const macro Align
  @CurSeg ends
  CONST segment dword readonly public use16 'CONST'
  align Align
endm

;Segment fr initialisierte Variablen
data macro Align
  @CurSeg ends
  _DATA segment dword public use16 'DATA'
  align Align
endm

;Segment fr nicht initialisierte Variablen
data? macro Align
  @CurSeg ends
  _BSS segment dword public use16 'BSS'
  align Align
endm

;Segment fr den Programmcode
code macro Align
  @CurSeg ends
  ifdef DEBUG
    EMULATOR_D_TEXT segment dword readonly public use16 'CODE'
    assume CS:EMULATOR_D_TEXT
  else
    EMULATOR_R_TEXT segment dword readonly public use16 'CODE'
    assume CS:EMULATOR_R_TEXT
  endif
  align Align
endm

;Segment fr die Textausgabe im Aufzeichnungsmodus
traceseg macro Align
  @CurSeg ends
  TRACESEG_TEXT segment dword public use16 'CODE'
  assume CS:TRACESEG_TEXT
  align Align
endm

;Segment fr die Interrupt-Routinen
intseg macro Align
  @CurSeg ends
  INTSEG_TEXT segment dword public use16 'CODE'
  assume CS:INTSEG_TEXT
  align Align
endm

;Dummy-Definition wegen Gruppe
INTSEG_TEXT segment dword public use16 'CODE'
traceseg
const
data
data?

;Offenes Segment abschlieen und Dateiende
ende macro
  @CurSeg ends
  end
endm

;Nchsten Befehl holen und ausfhren
NEXTCMD macro
  ifdef DEBUG
    jmp NextCmd
  else
    lods byte ptr FS:[SI]               ;Nchstes Befehlsbyte nach AX
    xor AH,AH
    jmp CommandTable[EAX*2]             ;Befehl ausfhren
  endif
endm

;FS an Sprungadresse in SI anpassen (ndert BX,FS)
JUMP macro
  local NoIO
  shld BX,SI,5                          ;Segmentbasis nach FS
  and BX,0000000000011110b
  mov BX,ReadTable[BX]
  and BX,BX
  jne NoIO
  call JumpToIO
NoIO:
  mov FS,BX
endm

;Flags nach AL holen (ndert AX,CX)
GETFLAGS macro
  mov AX,Flags_SignZero                 ;nz********1bdi**
  shld CX,AX,3                          ;**************z*
  mov CH,Overflow                       ;*******v******z*
  shl CH,6                              ;*v************z*
  and AX,1000000000111100b              ;n---------1bdi--
  and CX,0100000000000010b              ;-v------------z-
  and DL,00000001b                      ;-------c
  or AX,CX                              ;nv--------1bdiz-
  or AL,AH                              ;nv1bdiz-
  or AL,DL                              ;nv1bdizc
endm

;Flags in AL setzen (ndert AX,CX)
SETFLAGS macro
  mov DL,AL                             ;*******c
  shrd CX,AX,14                         ;******nv****z***
  mov Overflow,CH                       ;*******v
  mov AH,AL                             ;n*****z*n*****z*
  and AH,10000010b                      ;n-----z-
  shld CX,AX,13                         ;***n-----z-*****
  or AH,CL                              ;nz-*****
  or AL,00110000b                       ;**11di** Break-Flag ist immer gesetzt
  mov Flags_SignZero,AX                 ;nz-*******1bdi**
endm

;BRK, IRQ oder NMI (ndert AX,BX,CX,SI,ES,FS)
INTERRUPT macro Adr,BreakFlag
  mov BX,StackPtr                       ;Aktuellen PC auf Stack
  mov AX,SI
  mov GS:[BX],AH
  dec BL
  mov GS:[BX],AL
  dec BL
  GETFLAGS
  if BreakFlag eq 0
    and AL,11101111b                    ;Bei richtigem IRQ Break-Flag lschen
  endif
  mov GS:[BX],AL                        ;Flags auf Stack
  dec BL
  mov StackPtr,BX
  mov ES,ReadTable[0Fh*2]               ;Basissegment mit Vektoren holen
  mov SI,ES:[Adr]                       ;Sprungadresse laden
  JUMP                                  ;FS korrigieren
endm

;Infos, Warnings und Errors in der Debug-Version ausgeben
ifdef DEBUG

MSG_TRA equ 0001h
MSG_REM equ 0002h
MSG_VIC equ 0004h
MSG_SID equ 0008h
MSG_CIA equ 0010h
MSG_IEC equ 0020h
MSG_DEV equ 0040h
MSG_INT equ 0080h

ClassStr equ <>

TBEG macro Class
  local L1,L2
  ifndef DEBUG
    .err TBEG ausserhalb von DEBUG!
  endif
  ifnb ClassStr
    .err TBEG bei offenem TEND!
  endif
  TraceSkip equ <L1>
  TraceFunc equ <L2>
  ClassStr catstr <">,<Class>,<">
  test wRunDebug,MSG_&Class
  je TraceSkip
  call far ptr TraceFunc
  traceseg 1
  TraceFunc proc far
endm

TEND macro
  ifndef DEBUG
    .err TEND ausserhalb von DEBUG!
  endif
  ifb ClassStr
    .err TEND ohne zugehoeriges TBEG!
  endif
  ClassStr equ <>
  ret
  TraceFunc endp
  code 1
  TraceSkip:
endm

INFO macro Text,List
  local i,Continue
  ifndef DEBUG
    .err INFO ausserhalb von DEBUG!
  endif
  ifb ClassStr
    .err INFO ausserhalb von TBEG!
  endif
  i=0
  irp x,<List>
    mov wParam[i],x
    i=i+2
  endm
  mov fnContinue,offset Continue
  call DumpText
  db 32,ClassStr," ",Text,0
Continue:
endm

INFO2 macro Text,List
  local i,Continue
  ifndef DEBUG
    .err INFO ausserhalb von DEBUG!
  endif
  ifb ClassStr
    .err INFO ausserhalb von TBEG!
  endif
  i=0
  irp x,<List>
    mov wParam[i],x
    i=i+2
  endm
  mov fnContinue,offset Continue
  call DumpText
  db 32,"    ",Text,0
Continue:
endm

WARN macro Text,List
  local i,Continue
  ifndef DEBUG
    .err WARN ausserhalb von DEBUG!
  endif
  ifb ClassStr
    .err WARN ausserhalb von TBEG!
  endif
  i=0
  irp x,<List>
    mov wParam[i],x
    i=i+2
  endm
  mov fnContinue,offset Continue
  call DumpText
  db 255,ClassStr," ",Text,0
Continue:
endm

WARN2 macro Text,List
  local i,Continue
  ifndef DEBUG
    .err WARN2 ausserhalb von DEBUG!
  endif
  ifb ClassStr
    .err WARN2 ausserhalb von TBEG!
  endif
  i=0
  irp x,<List>
    mov wParam[i],x
    i=i+2
  endm
  mov fnContinue,offset Continue
  call DumpText
  db 255,"    ",Text,0
Continue:
endm

ERROR macro Text,List
  local i,Message
  mov awError[0],offset Message
  mov awError[2],CS
  i=0
  irp x,<List>
    mov wParam[i],x
    mov awError[4+i],x
    i=i+2
  endm
  mov fnContinue,offset Stop
  call DumpText
  db 255
Message db Text,0
endm

else

ERROR macro Text,List
  local i,Message
  mov awError[0],offset Message
  mov awError[2],CS
  i=0
  irp x,<List>
    mov awError[4+i],x
    i=i+2
  endm
  jmp Stop
Message db Text,0
endm

endif

;Maske fr CPU Ereignisse
evSTOP     equ 00000001b                ;Emulator beenden
evNMI      equ 00000010b                ;NMI aufgetreten
evIRQCIA   equ 00000100b                ;IRQ von CIA1 ist aktiv
evIRQVIC   equ 00001000b                ;IRQ vom VIC ist aktiv
evIRQ      equ 00001100b                ;Irgendein IRQ liegt an
