// C64-Emulator Hauptmodul

#include "pc64.h"

#if MASTER
  #ifdef _DEBUG
    #error Please set the Build Options to RELEASE!
  #endif
#endif

DEFAULT def = {
  1, // wSave
  "(none)", "ORIGINAL.64K", "ORIGINAL.64B", "ORIGINAL.64C", // aacName[4]
  TRUE, // fNationalKeys
  TRUE, // fTabSwitch
  1, 1, // awPort[2]
  2, 2, // awFire[2]
  49262, 49262, // alStart[2]
  49262, 49262, // alCount[2]
  0, 0, // awFlags[2]
  ".", "", "", "", "", "", "", "", // aacName[8]
  0, // bDevice
  0, // bChannel
  IEC_FREE, // eMode;
  "", // acName
  0, // wName
  "", // acCommand
  0, // wCommand
  "", // acError[64]
  0, // wError
  0xFFFF, // wFlags
  2, // wRefresh
  100, // wPerformance
  1, // wAlgorithm
  -3, // iClocksPerInt
  80, // wNewLine
  FALSE, // fVICDelay
  FALSE, // fNTSC
  0x0000, // wRealTime
  15, // abVolume[0] (Adlib)
  7, // abVolume[1] (DSP)
  9, // abVolume[2] (Master)
  9, // abVolume[3] (FM)
  9, // abVolume[4] (Voice)
  1, // abEnable[0] (FM)
  1, // abEnable[1] (Voice)

  FALSE, // f28Lines
  TRUE, // fLocalBus
  TRUE, // fAutoArrange
  IDM_WINDOWHTILE, // wAutoArrange
  TRUE, // fMaximizeSingle
  FALSE, // fSaveNoName
  FALSE, // fReplace
  0, // awColor[DTC_FILEWNDBACK]
  8, // awColor[DTC_FILESELBACK]
  7, // awColor[DTC_TRACE]
  2, // awColor[DTC_REM]
  6, // awColor[DTC_INFO]
  12, // awColor[DTC_WARNING]
  0, // awColor[DTC_DIRTREEBACK]
  7, // awColor[DTC_DIRTREEFORE]
  0, // awColor[DTC_LISTBOXBACK]
  7, // awColor[DTC_LISTBOXFORE]
  0, // awColor[DTC_HELPBACK]
  7, // awColor[DTC_HELPNORMAL]
  15, // awColor[DTC_HELPBOLD]
  12, // awColor[DTC_HELPUNDERLINE]
  2, // awColor[DTC_HELPITALICS]
  3, // awColor[DTC_HELPBOLDITALICS]
  0, 0, 0, 0, // awLinkWaits[4]
  1, 1, 1, 1, // awJoyWaits[4]
  FALSE, // fScreenOn
  2, // wLpt
  TRUE, // fSwapEMS
  TRUE, // fSwapXMS
  TRUE, // fWinSound
  "PRINT.OUT", "", "", "", // aacPrinterFile[4][80]
  0, 0, 0, 0, // awPrinterConvert[4];
};

HANDLE hInst;
HWND hwndFrame;
HWND hwndClient;
HWND hwndChild;
FILEWND* pfw;
HANDLE hAccel;
HMENU hmenu;
char acStart[80];
char* pcStart;
char acConfig[80];
char acDatabase[80];
char acShellDir[80];
char acDestDir[80];
char acImportDir[80];
word awUpdate[2];
byte bModule;
word wChildren;
flag fDoArrange;
long lSetWindowLong;
IECs iec;
CDevice* apDevice[16];
FILEWND* pfwLast;
flag fRunDebug;
int iFrameWidth;
int iFrameHeight;
flag fLocalBus;
flag fErase = TRUE;
char __near acHelpFile[] = "PC64.HLP";
word wDialogHelp = 0;
flag fCtrlBreak;
flag fNationalKeys;
flag fTabSwitch;
word wCtrlTab;
HWND hwndPassKeys;
HWND hwndEnterIdle;
HANDLE hDrives;
char __near acLoad[60];
char __near acC64Version[] = "Personal C64 Version " VERSION BETA "\r" COPYRIGHT;
long lVersion = 'P' * 65536 + HEXVER;
char acDir[80];
HANDLE hVirusTimer;
HWND hwndMultiLineEdit;
flag fWindowsNT;
HWND hwndMsgFilter;
word wRealTime;
word wNewLine;
dword adPCTicks[2];
dword adC64Ticks[2];
dword adUpdates[2];
word wAdlib;
word wDSPBase;
byte bAdlib;
word wDSPCommand;
byte bVolAdlib;
byte bVolDSP;
byte bVolMaster;
byte bVolFM;
byte bVolVoice;
char acSearchText[80];
word wSearchFrom;
word wSearchTo;
flag fSearchBack;
flag fSearchAdr;
word wRefresh;
dword dClocksPerRefresh;
dword dTicksPerRefresh;
dword dRealTicksPerRefresh;
dword dSIDtoAdlib;
word wLinesPerFrame;
dword adTimeAdd[2];
int iClocksPerInt;
word wPerformance;
word wLineDelay;
word wSpriteDelay;
flag fTotalReset;
word wResume;
word wAlgorithm;
byte __far* gpbError;
CPrinter aPrinter[4];
extern "C" void __far* __cdecl UIReadDD00 = NULL;
extern "C" void __far* __cdecl UIWriteDD00 = NULL;
extern "C" void __far* __cdecl UIWriteDD02 = NULL;
extern "C" void __far* __cdecl UIReadDD01 = NULL;
extern "C" void __far* __cdecl UIWriteDD01 = NULL;
extern "C" void __far* __cdecl UIWriteDD03 = NULL;
extern "C" void __far* __cdecl UIReadIO = NULL;
extern "C" void __far* __cdecl UIWriteIO = NULL;
flag fVirus = TRUE;
char __far acRunDir[80];
char __far acRunName[19];
long lRunStart;
flag fQuit;
flag fNoSound;
char __near gacAutotype[80];
flag gfCopySlow;


flag IsNoSound(char* pc) {
  if (pc[0] != '/' && pc[0] != '-') {
    return FALSE;
  }
  return _stricmp(pc + 1, "nosound") == 0;
}


extern "C" void FAR PASCAL WinGetIntlMessageBoxStrings(void);
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int iCmdShow) {
  AnsiUpper(acC64Version);
  _getcwd(::acDir, 80);
  strcpy(::acShellDir, ::acDir);
  hInst = hInstance;
  if (!hPrevInstance) {
    static WNDCLASS wc;
    wc.lpfnWndProc = FrameWndProc;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = COLOR_APPWORKSPACE + 1;
    wc.lpszMenuName = MAKEINTRESOURCE(1);
    wc.lpszClassName = "PC64Frame";
    ATOM aResult = RegisterClass(&wc);
    assert(aResult);
    wc.lpfnWndProc = FileWndProc;
    wc.cbWndExtra = 4;
    wc.hbrBackground = NULL;
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "PC64File";
    aResult = RegisterClass(&wc);
    assert(aResult);
    wc.lpfnWndProc = LinkWndProc;
    wc.cbWndExtra = 4;
    wc.hbrBackground = NULL;
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "PC64Link";
    aResult = RegisterClass(&wc);
    assert(aResult);
    WinGetIntlMenuStrings();  // Verhindert Fragmentierung
    WinGetIntlMessageBoxStrings();
  }
  SetWindowsHook(WH_MSGFILTER, (FARPROC)MsgFilter);
  hwndFrame = CreateWindow("PC64Frame", "Personal C64" BETA, WS_OVERLAPPED | WS_CAPTION, -1, 0, GetSystemMetrics(SM_CXSCREEN) + 2, GetSystemMetrics(SM_CYSCREEN) + 1, NULL, NULL, hInst, NULL);
  assert(hwndFrame);
  {
    HDC hdc1 = GetDC(hwndFrame);  // Verhindert Fragmentierung des Speichers
    HDC hdc2 = GetDC(hwndFrame);
    ReleaseDC(hwndFrame, hdc2);
    ReleaseDC(hwndFrame, hdc1);
  }
  hmenu = GetMenu(hwndFrame);
  assert(hmenu);
  CLIENTCREATESTRUCT ccs;
  ccs.hWindowMenu = GetSubMenu(hmenu, WINDOWMENUPOS);
  ccs.idFirstChild = IDM_WINDOWCHILDREN;
  hwndClient = CreateWindow("MDIClient", NULL, WS_CHILD | WS_CLIPCHILDREN, 0, 0, 0, 0, hwndFrame, NULL, hInst, &ccs);
  assert(hwndClient);
  ShowWindow(hwndFrame, iCmdShow);
  UpdateWindow(hwndFrame);
  WinDrawAllWindows();
  hAccel = LoadAccelerators(hInst, MAKEINTRESOURCE(1));
  assert(hAccel);
  SetLinkAndHelpColors();
  *(dword*)L64LinkWaits = *(dword*)def.abLinkWaits;
  *(dword*)L64JoyWaits = *(dword*)def.abJoyWaits;
  RegisterDirTreeClass(hInst);
  char* pc = strtok(lpszCmdLine, " \t");
  while (pc != NULL && IsNoSound(pc)) {
    pc = strtok(NULL, " \t");
  }
  if (pc != NULL) {
    fDoArrange = TRUE;
    flag fRun = FALSE;
    while (pc != NULL) {
      char acBuffer[32];
      FILEWND* pfw;
      int hFile;
      if (stricmp(pc, "-autotype") == 0) {
        pc = strtok(NULL, " \t");
        if (pc != NULL) {
          strncpy(gacAutotype, pc, sizeof gacAutotype);
        }
        goto NextFile;
      }
      strncpy(acRunDir, pc, sizeof acRunDir);
      strupr(acRunDir);
      strcpy(acRunName, "*");
      lRunStart = -1;
      hFile = _lopen(acRunDir, OF_READ | OF_SHARE_DENY_NONE);
      if (hFile == -1) {
        if (_access(acRunDir, 0) == 0) {
          fRun = TRUE;
          fQuit = TRUE;
          goto NextFile;
        }
        ErrorBox(acRunDir, NULL);
        goto NextFile;
      }
      if (_filelength(hFile) >= 174848) {
        int i;
        _llseek(hFile, 17 * 21 * 256L, SEEK_SET);
        if (_lread(hFile, acBuffer, 4) != 4) {
          ErrorBox(acRunDir, NULL);
          _lclose(hFile);
          goto NextFile;
        }
        if (acBuffer[2] == 'A') {
          for (i = 0; i < 8; i++) {
            _llseek(hFile, 17 * 21 * 256L + 256 + 2 + i * 32, SEEK_SET);
            if (_lread(hFile, acBuffer, 30) != 30) {
              ErrorBox(acRunDir, NULL);
              _lclose(hFile);
              goto NextFile;
            }
            if ((acBuffer[0] & 0x07) == 2) { // Programm?
              acBuffer[19] = 0;
              for (int i = 18; i > 3 && (byte)acBuffer[i] == 160; i--) {
                acBuffer[i] = 0;
              }
              strcpy(acRunName, acBuffer + 3);
              long lPos = 0;
              while (acBuffer[1] > 1) {
                if (acBuffer[1] > 31) {
                  lPos += 17 * 256;
                } else if (acBuffer[1] > 25) {
                  lPos += 18 * 256;
                } else if (acBuffer[1] > 18) {
                  lPos += 19 * 256;
                } else {
                  lPos += 21 * 256;
                }
                acBuffer[1]--;
              }
              _llseek(hFile, lPos + acBuffer[2] * 256, SEEK_SET);
              if (_lread(hFile, acBuffer, 4) != 4) {
                ErrorBox(acRunDir, NULL);
                _lclose(hFile);
                goto NextFile;
              }
              lRunStart = (word)acBuffer[2] | ((word)acBuffer[3] << 8);
              break;
            }
          }
        }
        _lclose(hFile);
        fQuit = TRUE;
        fRun = TRUE;
        goto NextFile;
      }
      if (_lread(hFile, acBuffer, 28) != 28) {
        ErrorBox(acRunDir, NULL);
        _lclose(hFile);
        break;
      }
      _lclose(hFile);
      if (!strcmp(acBuffer, "C64File")) {
        char* pcName = strrchr(acRunDir, '\\');
        if (pcName == acRunDir + 2) {
          pcName++;
        }
        *pcName = 0;
        strcpy(acRunName, acBuffer + 8);
        lRunStart = (word)acBuffer[26] | ((word)acBuffer[27] << 8);
        fQuit = TRUE;
        fRun = TRUE;
        goto NextFile;
      }
      pfw = AllocFileWnd();
      assert(pfw);
      strcpy(pfw->acFileName, acRunDir);
      if (CreateFileWnd(pfw, NULL)) {
        fQuit = TRUE;
        PostMessage(hwndFrame, WM_COMMAND, IDM_RUNSTART, 0);
        break;
      } else {
        free(pfw);
      }
    NextFile:
      pc = strtok(NULL, " \t");
      while (pc != NULL && IsNoSound(pc)) {
        pc = strtok(NULL, " \t");
      }
    }
    if (fRun) {
      RunC64Program();
    }
  } else {
    int hFile = _lopen(acConfig, OF_READ | OF_SHARE_DENY_NONE);
    if (hFile != -1) {
      _llseek(hFile, sizeof DEFAULT, 0);
      WNDPOS wp;
      while (_lread(hFile, &wp, sizeof WNDPOS) == sizeof WNDPOS) {
        if (!wp.fIsLinkWnd) {
          FILEWND* pfw = AllocFileWnd();
          assert(pfw);
          strcpy(pfw->acFileName, wp.acName);
          if (CreateFileWnd(pfw, &wp)) {
            fDoArrange = TRUE;
          } else {
            free(pfw);
          }
        } else {
          CreateLinkWnd(&wp);
        }
      }
      _lclose(hFile);
      fDoArrange = TRUE;
    }
  }
  PostMessage(hwndFrame, WM_MOUSEMOVE, 0, 0);
  return MessageLoop();
}

#pragma optimize("leg", off)
static flag IsWindowsNT() {
  if (_osmajor < 5) {
    return FALSE;
  }
  word wTrueVer;
  __asm {
    mov AX, 3306h
    int 21h
    xchg BL, BH
    mov wTrueVer, BX
  }
  return wTrueVer >= 0x0532 && wTrueVer < 0x0600;
}
#pragma optimize("", on)

#pragma optimize("leg", off)
static flag IsEnhancedWindows() {
  word wAX;
  __asm {
    mov AX, 1600h
    int 2Fh
    mov wAX, AX
  }
  return wAX & 0x007F;
}
#pragma optimize("", on)

static void SetWait(unsigned uCycles) {
  _outp(0x61, _inp(0x61) & ~2 | 1);
  _outp(0x43, 0xB0);
  _outp(0x42, uCycles);
  _outp(0x42, uCycles >> 8);
}

static void Wait() {
  if (_inp(0x61) & 1) {
    while (!(_inp(0x61) & 0x20));
  }
}

static void WriteAdlib(int iIndex, int iData) {
  Wait();
  _disable();
  _outp(wAdlib + 0, iIndex);
  SetWait(28);
  _outp(wAdlib + 1, iData);
  _enable();
}

static flag IsAdlib() {
  SetWait(1);
  WriteAdlib(0x04, 0x60);
  WriteAdlib(0x04, 0x80);
  int iStatus1 = _inp(0x0388) & 0xE0;
  WriteAdlib(0x02, 0xFF);
  WriteAdlib(0x04, 0x21);
  SetWait(179);
  Wait();
  int iStatus2 = _inp(0x0388) & 0xE0;
  WriteAdlib(0x04, 0x60);
  WriteAdlib(0x04, 0x80);
  return iStatus1 == 0x00 && iStatus2 == 0xC0;
}

static flag CheckDSP(word wBase) {
  _outp(wBase + 6, 1);
  SetWait(3);
  Wait();
  _outp(wBase + 6, 0);
  SetWait(119);
  Wait();
  return ((_inp(wBase + 14) & 0x80) != 0) && (_inp(wBase + 10) == 0xAA);
}

static word GetDSPBase() {
  char* pcBlaster = getenv("BLASTER");
  if (pcBlaster) {
    pcBlaster = strdup(pcBlaster);
    assert(pcBlaster);
    char* pc = strtok(pcBlaster, " ,");
    do {
      if (toupper(pc[0]) == 'A') {
        word wBase;
        if (sscanf(pc + 1, "%x", &wBase)) {
          if (wBase >= 0x0200) {
            free(pcBlaster);
            if (CheckDSP(wBase)) {
              return wBase;
            } else {
              return 0;
            }
          }
        }
      }
    } while ((pc = strtok(NULL, " ,")) != NULL);
    free(pcBlaster);
    return 0;
  }
  static const word awBase[6] = {
    0x0220, 0x0240, 0x0260, 0x0210, 0x0230, 0x0250
  };
  for (int i = 0; i < 6; i++) {
    if (CheckDSP(awBase[i])) {
      return awBase[i];
    }
  }
  return 0;
}

void InitSound() {
  if (fNoSound || fWindowsNT || IsEnhancedWindows() && !def.fWinSound) {
    wAdlib = 0;
    wDSPBase = 0;
  } else {
    #if GERMAN
      printf("/nosound erforderlich"); // 21
    #else
      printf("use /nosound");
    #endif
    SetWait(1);
    wDSPBase = GetDSPBase();
    if (wDSPBase) {
      while (_inp(wDSPBase + 12) & 0x80);
      _outp(wDSPBase + 12, 0xD1);
      wAdlib = wDSPBase + 8;
    } else {
      wAdlib = IsAdlib();
    }
    printf("\r%22c", '\r');
  }
}

#pragma optimize("leg", off)
static word GetCodePage() {
  word wCodePage;
  __asm {
    mov AX, 6601h
    mov BX, 437
    int 21h
    jc Error
    mov wCodePage, BX
  }
  return wCodePage;
Error:
  return 437;
}
#pragma optimize("", on)

#pragma optimize("leg", off)
static flag SetCodePage(word wCodePage) {
  if (wCodePage == GetCodePage()) {
    return TRUE;
  }
  __asm {
    mov AX, 6602h
    mov BX, wCodePage
    int 21h
    jc Error
  }
  return GetCodePage() == wCodePage;
Error:
  return FALSE;
}
#pragma optimize("", on)

static WORD wCursor;
static WORD wBuffer;
static BOOL f28LinesOn;
static BYTE* pbBuffer;

static void PressKey() {
  #if GERMAN
    fprintf(stderr, "Zurck zu DOS mit beliebiger Taste...");
  #else
    fprintf(stderr, "Back to DOS with any key...");
  #endif
  _getch();
  fprintf(stderr, "\r%70c", '\r');
}

#pragma optimize("leg", off)
static void cdecl RestoreScreen(void) {
  if (f28LinesOn) __asm {
    mov AX, SysGDIInfo.StartingVideoMode;
    int 10h
  } else __asm {
    mov AX,1000h
    mov BX,1406h
    int 10h
  }
  if (pbBuffer) {
    memcpy((BYTE*)((long)VideoInfo.segment << 16), pbBuffer, wBuffer);
    free(pbBuffer);
    pbBuffer = NULL;
    __asm {
      mov AH,0Fh
      int 10h
      mov AH,02h
      mov DX,wCursor
      int 10h
    }
  }
}
#pragma optimize("", on)

static void AskCont() {
  #if GERMAN
    fprintf(stderr, "\nWollen Sie trotzdem weitermachen? ");
  #else
    fprintf(stderr, "\nDo you want to continue anyway? ");
  #endif
  flag fYes;
  for (;;) {
    char cKey = (char)_getch();
    if (strchr("jJyYsSdDoO+1", cKey)) {
      fYes = TRUE;
      break;
    }
    if (strchr("nN-0\x1B", cKey)) {
      fYes = FALSE;
      break;
    }
  }
  if (fYes) {
    #if GERMAN
      fprintf(stderr, "Ja\n");
    #else
      fprintf(stderr, "Yes\n");
    #endif
  } else {
    #if GERMAN
      fprintf(stderr, "Nein\n");
    #else
      fprintf(stderr, "No\n");
    #endif
    exit(1);
  }
}

extern "C" char __far __cdecl szModuleName[];

#pragma optimize("leg", off)
int __cdecl main(int argn, char** argv) {
  printf(acCopyright);
  #ifdef _DEBUG
    __asm {
      mov AH,0Dh
      int 21h
    }
  #endif
  for (int i = 1; i < argn; i++) {
    if (IsNoSound(argv[i])) {
      fNoSound = TRUE;
    }
  }
  static flag fOK = FALSE;
  __asm {
    pushf
    xor AX,AX
    push AX
    popf
    pushf
    pop AX
    and AX,0F000h
    cmp AX,0F000h
    je No386
    mov AX,7000h
    push AX
    popf
    pushf
    pop AX
    and AX,7000h
    je No386
    mov fOK,TRUE
  No386:
    popf
  }
  if (!fOK) {
    fprintf(stderr, acNoCPU);
    AskCont();
  }
  fOK = FALSE;
  __asm {
    mov AX,1A00h
    int 10h
    cmp AL,1Ah
    jne NoVGA
    mov fOK,TRUE
  NoVga:
  }
  if (!fOK) {
    fprintf(stderr, acNoVGA);
    AskCont();
  }
  if (_osmajor < 3 || _osmajor == 3 && _osminor < 30) {
    fprintf(stderr, acNoDos);
    AskCont();
  }
  word wOldCodePage = GetCodePage();
  SetCodePage(437);
  word wFree;
  __asm {
    int 12h
    mov CL,6
    shl AX,CL
    sub AX,_psp
    shr AX,CL
    mov wFree, AX
  }
  if (wFree < MEMORY) {
    fprintf(stderr, acNotEnoughMemory, wFree, MEMORY);
    AskCont();
  }
  RelocateSegments();
  for (i = 0; i < 512; i++) {
    if (awCharTab[i] >= 'a' && awCharTab[i] <= 'z') {
      awCharTab[i] += 193 - 'a';
    }
  }
  //*(int __far*)0x00000417L &= ~0x20; // Num-Lock off
  _fullpath(acStart, argv[0], 80);
  _strupr(acStart);
  pcStart = strrchr(acStart, '\\');
  assert(pcStart);
  pcStart++;
  strcpy(szModuleName, acStart);
  OFSTRUCT of;
  int hFile = OpenFile("PC64.CFG", &of, OF_READWRITE | OF_SHARE_DENY_NONE);
  if (hFile > 0) {
    strcpy(acConfig, of.szPathName);
    assert(acConfig[0]);
    assert(strlen(acConfig) < 80);
  } else {
    #if GERMAN
      fprintf(stderr, "\nLege neue Konfigurationsdatei im Startverzeichnis an\n");
    #else
      fprintf(stderr, "\nCreating new config file in the program directory\n");
    #endif
    strcpy(pcStart, "PC64.CFG");
    hFile = _lcreat(acStart, 0);
    if (hFile > 0) {
      strcpy(acConfig, acStart);
    } else {
      perror(acStart);
      #if GERMAN
        fprintf(stderr, "\nFehler aufgetreten, versuche es im aktuellen Verzeichnis nochmal\n");
      #else
        fprintf(stderr, "\nError occured, trying again in the current directory\n");
      #endif
      _fullpath(acConfig, "PC64.CFG", 80);
      hFile = _lcreat(acConfig, 0);
      if (hFile > 0) {
        _lwrite(hFile, &def, sizeof DEFAULT);
        _lclose(hFile);
        #if GERMAN
          fprintf(stderr, "\nBitte %s in ein lokales Verzeichnis mit Pfadzugriff verschieben!\n", acConfig);
        #else
          fprintf(stderr, "\nPlease move %s to a local directory which is in your PATH!\n", acConfig);
        #endif
      } else {
        perror(acConfig);
        #if GERMAN
          fprintf(stderr, "\nEbenfalls nicht mglich, beende das Programm\n");
        #else
          fprintf(stderr, "\nAlso impossible, aborting program\n");
        #endif
      }
      PressKey();
      return 1;
    }
    _lwrite(hFile, &def, sizeof DEFAULT);
    _llseek(hFile, 0, 0);
  }
  assert(hFile > 0);
  _lread(hFile, &def, sizeof DEFAULT);
  _lclose(hFile);
  hFile = OpenFile("PC64.PDB", &of, OF_READWRITE | OF_SHARE_DENY_NONE);
  if (hFile > 0) {
    strcpy(acDatabase, of.szPathName);
    assert(acDatabase[0]);
    assert(strlen(acDatabase) < 80);
  } else {
    #if GERMAN
      fprintf(stderr, "\nLege neue Programmdatenbank im Startverzeichnis an\n");
    #else
      fprintf(stderr, "\nCreating new program data base in the program directory\n");
    #endif
    strcpy(pcStart, "PC64.PDB");
    hFile = _lcreat(acStart, 0);
    if (hFile > 0) {
      strcpy(acDatabase, acStart);
    } else {
      perror(acStart);
      #if GERMAN
        fprintf(stderr, "\nFehler aufgetreten, versuche es im aktuellen Verzeichnis nochmal\n");
      #else
        fprintf(stderr, "\nError occured, trying again in the current directory\n");
      #endif
      _fullpath(acDatabase, "PC64.PDB", 80);
      hFile = _lcreat(acDatabase, 0);
      if (hFile > 0) {
        _lclose(hFile);
        #if GERMAN
          fprintf(stderr, "\nBitte %s in ein lokales Verzeichnis mit Pfadzugriff verschieben!\n", acDatabase);
        #else
          fprintf(stderr, "\nPlease move %s to a local directory which is in your PATH!\n", acDatabase);
        #endif
      } else {
        perror(acDatabase);
        #if GERMAN
          fprintf(stderr, "\nEbenfalls nicht mglich, beende das Programm\n");
        #else
          fprintf(stderr, "\nAlso impossible, aborting program\n");
        #endif
      }
      PressKey();
      return 1;
    }
  }
  assert(hFile > 0);
  _lclose(hFile);
  for (i = 0; i < 4; i++) {
    aPrinter[i].SetDir(def.aacPrinterFile[i]);
    aPrinter[i].SetConvert(def.awPrinterConvert[i]);
  }
  word __far* pwFunctions;
  __asm {
    mov AX,0C640h
    mov DX,'UI'
    int 2Fh
    mov word ptr pwFunctions[0],AX
    mov word ptr pwFunctions[2],DX
  }
  if (!_fstrcmp((char __far*)_MK_FP((__segment)pwFunctions, pwFunctions[0]), "C64 Emulator Userport Interface")) {
    UIReadDD00 = _MK_FP((__segment)pwFunctions, pwFunctions[1]);
    UIWriteDD00 = _MK_FP((__segment)pwFunctions, pwFunctions[2]);
    UIWriteDD02 = _MK_FP((__segment)pwFunctions, pwFunctions[3]);
    UIReadDD01 = _MK_FP((__segment)pwFunctions, pwFunctions[4]);
    UIWriteDD01 = _MK_FP((__segment)pwFunctions, pwFunctions[5]);
    UIWriteDD03 = _MK_FP((__segment)pwFunctions, pwFunctions[6]);
    UIReadIO = _MK_FP((__segment)pwFunctions, pwFunctions[7]);
    UIWriteIO = _MK_FP((__segment)pwFunctions, pwFunctions[8]);
    if (pwFunctions[9]) {
      fprintf(stderr, "Warning: PC64 doesn't support the \"%Fs\" extension!\n", _MK_FP((__segment)pwFunctions, pwFunctions[9]));
    }
  }
  fWindowsNT = IsWindowsNT();
  InitSound();
  _outp(0x0201, 0); // einige BIOS-Versionen initialisieren den Joystick nicht
  SysGDIInfo.StartingVideoMode = VidGetMode();
  if (!VID_IN_GRAPHICS_MODE()) {
    __asm {
      mov AH,0Fh
      int 10h
      mov AH,03h
      int 10h
      mov wCursor,DX
    }
    wBuffer = (WORD)((HIBYTE(wCursor) * VideoInfo.width + LOBYTE(wCursor)) * 2);
    pbBuffer = (BYTE*)malloc(wBuffer);
    assert(pbBuffer);
    if (pbBuffer) {
      memcpy(pbBuffer, (BYTE*)((long)VideoInfo.segment << 16), wBuffer);
    }
    f28LinesOn = def.f28Lines && VideoInfo.yFontHeight == 16 && *(word __far*)0x0000044AL == 80;
    if (f28LinesOn) {
      __asm {
        mov AX,SysGDIInfo.StartingVideoMode
        int 10h
        mov AX,1111h
        xor BL,BL
        int 10h
      }
      SysGDIInfo.StartingVideoMode = -1;
    }
  }
  atexit(RestoreScreen);
  __asm {
    mov AX,1000h
    mov BX,0606h
    int 10h
  }
  WinSetSysColor(NULL, SYSCLR_BACKGROUND, 0x07);
  WinSetSysColor(NULL, SYSCLR_MESSAGEBOX, 0x70);
  WinInit();
  MDIInitialize();
  WinUseSysColors(NULL, TRUE);
  SetWindowsCompatibility(WC_MAXCOMPATIBILITY);
  VidSetBlinking(FALSE);
  __asm {
    mov AX,4400h
    mov BX,4
    int 21h
    and DL,DL
    jns NoDevice
    or DL,00100000b
    xor DH,DH
    mov AX,4401h
    int 21h
  NoDevice:
  }
  tracefile("trace.log");
  LPSTR lpszCmdLine = (LPSTR)(((long)_psp << 16) + 129);
  lpszCmdLine[lpszCmdLine[-1]] = 0;
  int iReturn = WinMain(OpenResourceFile(NULL), NULL, lpszCmdLine, SW_SHOWNORMAL);
  GlobalFree(hDrives);
  SetCodePage(wOldCodePage);
  return iReturn;
}
#pragma optimize("", on)
