// Fortschrittsbalken setzen

#include "pc64.h"

void SetDlgItemProgress(HWND hwndDialog, word wID, long lValue, long lMax) {
  const int MAXLEN = 80;
  const char DONE = '';
  const char HALF = '';
  const char TODO = '';
  assert(IsWindow(hwndDialog));
  HWND hwndStaticText = GetDlgItem(hwndDialog, wID);
  assert(IsWindow(hwndStaticText));
  assert(lMax >= 0);
  assert(lValue >= 0);
  assert(lValue <= lMax);
  char acText[MAXLEN + 1];
  int iWidth = GetWindowText(hwndStaticText, acText, MAXLEN + 1);
  assert(iWidth <= MAXLEN);
  if (!iWidth) {
    RECT rc;
    GetClientRect(hwndStaticText, &rc);
    assert(rc.top == 0);
    assert(rc.bottom == 1);
    assert(rc.left == 0);
    assert(rc.right > 0);
    assert(rc.right <= MAXLEN);
    iWidth = rc.right;
    acText[iWidth] = 0;
    memset(acText, 0, iWidth);
  }
  if (lMax == 0) {
    lMax = 1;
  }
  int iPos = (int)(2 * iWidth * lValue / lMax);
  assert(iPos >= 0);
  assert(iPos <= iWidth * 2);
  flag fHalf = iPos & 1;
  iPos /= 2;
  if (fHalf && acText[iPos] != HALF || !fHalf &&
      ((iPos != 0 && acText[iPos - 1] != DONE) ||
       (iPos != iWidth && acText[iPos] != TODO)))
  {
    memset(acText, DONE, iPos);
    memset(acText + iPos, TODO, iWidth - iPos);
    if (fHalf) acText[iPos] = HALF;
    assert((int)strlen(acText) == iWidth);
    SetWindowText(hwndStaticText, acText);
  }
  MSG msg;
  while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
    assert(IsWindow(hwndDialog));
    if (!IsDialogMessage(hwndDialog, &msg)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }
}
