// Zuordnung von Druckern

#include "pc64.h"

static word wPrinter;
static char aacPrinterFile[4][80];
static word awPrinterConvert[4];

static void GetPrinter(HWND hwnd) {
  flag fEnable = FALSE;
  flag fFullPath = FALSE;
  char ac[80];
  GetDlgItemText(hwnd, IDE_PRINTER, ac, 80);
  int hFile = _open(ac, _O_BINARY | _O_RDONLY);
  if (hFile != -1) {
    if (!_isatty(hFile)) {
      fEnable = TRUE;
      fFullPath = TRUE;
    }
    _lclose(hFile);
  } else {
    fFullPath = ac[0] != 0;
  }
  EnableWindow(GetDlgItem(hwnd, IDB_PRINTERDELETE), fEnable);
  if (fFullPath) {
    _fullpath(aacPrinterFile[wPrinter], ac, 80);
  } else {
    strcpy(aacPrinterFile[wPrinter], ac);
  }
  for (word i = 0; i < 3; i++) {
    if (IsDlgButtonChecked(hwnd, IDB_CONVERT + i)) {
      break;
    }
  }
  awPrinterConvert[wPrinter] = i;
}

static void SetPrinter(HWND hwnd) {
  SetDlgItemText(hwnd, IDE_PRINTER, aacPrinterFile[wPrinter]);
  CheckRadioButton(hwnd, IDB_CONVERT, IDB_CONVERT + 3, IDB_CONVERT + awPrinterConvert[wPrinter]);
  GetPrinter(hwnd);
}

BOOL FAR PASCAL PrintersDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    memcpy(aacPrinterFile, def.aacPrinterFile, sizeof aacPrinterFile);
    memcpy(awPrinterConvert, def.awPrinterConvert, sizeof awPrinterConvert);
    CheckRadioButton(hwnd, IDB_PRINTERS, IDB_PRINTERS + 3, IDB_PRINTERS);
    wPrinter = 0;
    SetPrinter(hwnd);
    wDialogHelp = IDM_OPTIONSPRINTERS;
    SetFocus(GetDlgItem(hwnd, IDE_PRINTER));
    return FALSE;
  case WM_COMMAND:
    switch (wParam) {
    case IDB_PRINTERS + 0:
    case IDB_PRINTERS + 1:
    case IDB_PRINTERS + 2:
    case IDB_PRINTERS + 3:
      if (HIWORD(lParam) == BN_CLICKED) {
        GetPrinter(hwnd);
        wPrinter = wParam - IDB_PRINTERS;
        SetPrinter(hwnd);
      }
      return TRUE;
    case IDE_PRINTER:
      if (HIWORD(lParam) == EN_UPDATE) {
        GetPrinter(hwnd);
      }
      return TRUE;
    case IDB_PRINTERDELETE:
      {
        char ac[128];
        #if GERMAN
          sprintf(ac, "Wollen Sie die Datei %s wirklich lschen?", aacPrinterFile[wPrinter]);
        #else
          sprintf(ac, "Do you really want to delete %s?", aacPrinterFile[wPrinter]);
        #endif
        MessageBeep(MB_ICONQUESTION);
        if (MessageBox(hwndFrame, ac, acConfirm, MB_ICONQUESTION | MB_OKCANCEL) == IDOK) {
          remove(aacPrinterFile[wPrinter]);
          SetFocus(GetDlgItem(hwnd, IDE_PRINTER));
          GetPrinter(hwnd);
        }
      }
      return TRUE;
    case IDOK:
      GetPrinter(hwnd);
      memcpy(def.aacPrinterFile, aacPrinterFile, sizeof def.aacPrinterFile);
      memcpy(def.awPrinterConvert, awPrinterConvert, sizeof def.awPrinterConvert);
      for (i = 0; i < 4; i++) {
        aPrinter[i].SetDir(def.aacPrinterFile[i]);
        aPrinter[i].SetConvert(def.awPrinterConvert[i]);
      }
      SaveDefault();
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}
