// Meldungen

#include "pc64.h"

#if GERMAN

  char acCopyright[] =
    "\rPersonal C64 Version " VERSION BETA " - " COPYRIGHT "\n";
  char acNoCPU[] = "\n\
Dieser Rechner ist nicht mit einem 386-Prozessor oder hher ausgestattet. Wenn\n\
Sie jetzt weitermachen, wird die Oberflche vermutlich laufen, die Emulation\n\
aber abstrzen.\n";
  char acNoVGA[] = "\n\
Dieser Rechner ist nicht mit einer VGA-Grafikkarte ausgestattet. Wenn Sie jetzt\n\
weitermachen, wird die Oberflche zwar laufen, die eigentliche C64-Emulation im\n\
VGA-Modus 13h aber nicht.\n";
  char acNoDos[] = "\n\
Ihr Betriebssystem ist lter als DOS 3.3. Der Emulator wurde nicht mit so\n\
frhen Versionen von DOS getestet.\n";
  char acNotEnoughMemory[] = "\n\
Es sind nur %d KByte Hauptspeicher verfgbar, der Emulator bentigt aber\n\
mindestens %d KByte. Wenn Sie jetzt weitermachen, luft die Oberflche viel\n\
langsamer und strzt eventuell sogar ab.\n";
  char* apcDOSError[0x66] = {
    "Unbekannter DOS-Fehler Nummer %04Xh!",
    "Ungltige Funktionsnummer!",
    "Datei nicht gefunden!",
    "Verzeichnis nicht gefunden!",
    "Zu viele Dateien gleichzeitig geffnet!\n\n"
      "Erhhen Sie den Eintrag FILES=xx in der CONFIG.SYS",
    "Zugriff verweigert!"
      "\n\nDie Datei ist entweder schreibgeschtzt, "
      "oder es existiert ein Verzeichnis/Diskettenname mit demselben Namen",
    "Ungltige Dateinummer!",
    "Kette der Speicherblcke ist zerstrt!",
    "Nicht gengend DOS-Speicher vorhanden!"
      "\n\nEntfernen Sie berflssige residente Programme "
      "und starten Sie das Programm neu",
    "Adresse zeigt nicht auf Speicherblock!",
    "Umgebungsvariablen sind zerstrt!",
    "Ungltiges Format!",
    "Ungltiger Zugriffscode!",
    "Ungltige Daten!",
    "Unbekanntes Gert!",
    "Ungltiges Laufwerk!",
    "Aktuelles Verzeichnis kann nicht entfernt werden!",
    "Quell- und Ziellaufwerk stimmen nicht berein!",
    "Keine weiteren Verzeichniseintrge vorhanden!",
    "Diskette ist schreibgeschtzt!"
      "\n\nEntfernen Sie den Aufkleber oder schieben Sie den "
      "Schreibschutzschalter in die andere Position",
    "Unbekanntes Laufwerk!",
    "Laufwerk nicht bereit!"
      "\n\nLegen Sie eine formatierte Diskette ein",
    "Unbekannter Befehl!",
    "Prfsummenfehler!"
      "\n\nVerwenden Sie eine andere Diskette",
    "Falsche Parameterlnge!",
    "Fehler beim Suchen!"
      "\n\nDas deutet auf ein kaputtes Laufwerk hin",
    "Unbekanntes Medium!"
      "\n\nVerwenden Sie eine andere Diskette",
    "Sektor nicht gefunden!"
      "\n\nVerwenden Sie eine andere Diskette",
    "Drucker hat kein Papier mehr!",
    "Schreibfehler!"
      "\n\nVerwenden Sie eine andere Diskette",
    "Lesefehler!"
      "\n\nVerwenden Sie eine andere Diskette",
    "Allgemeiner Fehler",
    "Datei ist gesperrt!"
      "\n\nBeenden Sie andere Programme und versuchen Sie es erneut",
    "Datensatz gesperrt!"
      "\n\nBeenden Sie andere Programme und versuchen Sie es erneut",
    "Unerlaubter Diskettenwechsel!",
    "FCB nicht verfgbar!",
    "Kein Speicher fr Share mehr vorhanden!"
      "\n\nBeenden Sie andere Programme und versuchen Sie es erneut",
    "Falsche Zeichensatztabelle!"
      "\n\nSchalten Sie mit CHCP 437 den IBM Standardzeichensatz ein",
    "Letzter Dateizugriff nicht erfolgreich!",
    "Kein Platz auf dem Datentrger!",
    "Das Dateiende wurde erreicht!",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "Befehl wird vom Netzwerk nicht untersttzt!",
    "Netzlaufwerk nicht bereit!",
    "Netzname bereits vorhanden!",
    "Netznamen nicht gefunden!",
    "Netzwerk ist beschftigt!",
    "Netzlaufwerk ist nicht mehr verfgbar!",
    "NetBIOS kann keine zustzlichen Befehle mehr verarbeiten!",
    "Netzwerkhardware ist fehlerhaft!",
    "Ungltige Antwort vom Netzwerk!",
    "Unerwarteter Fehler auf dem Netzwerk!",
    "Falsche Netzwerkkarte auf dem Fremdrechner!",
    "In der Warteschlange des Druckerspoolers ist kein Platz mehr!",
    "Auf dem Datentrger des Druckerspoolers ist kein Platz mehr!",
    "Auszudruckende Datei wurde gelscht!",
    "Netzname wurde gelscht!",
    "Netzwerk verweigert den Zugriff!",
    "Ungltiges Netzlaufwerk!",
    "Netzname nicht gefunden!",
    "Kein Platz fr neuen Netznamen verfgbar!",
    "NetBIOS kann keine zustzliche Sitzung mehr verarbeiten!",
    "Zeitlich befristete Pause auf dem Netzwerk!",
    "Angefordertes Netzwerk nicht verfgbar!",
    "Drucker- oder Laufwerksumleitung angehalten!",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "Eine Datei mit diesem Namen existiert bereits!",
    "Doppelt vorhandener FCB!",
    "Kann das Verzeichnis nicht anlegen!",
    "Fehler beim Ausfhren des Interrupt 24h!",
    "Zu viele Umleitungen vorhanden!",
    "Doppelte Umleitung!",
    "Falsches Pawort!",
    "Ungltiger Parameter!",
    "Schreibfehler auf dem Netzwerk!",
    "Befehl wird vom Netzwerk nicht untersttzt!",
    "Angefordertes Gert ist nicht im Netzwerk installiert!",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "Laufwerk ist nicht angewhlt!"
  };
  char __near acNone[] = "(keins)";
  char __near acUnknown[] = "(unbekannt)";
  char __near acUntitled[] = "Ohne Namen";
  char acROMLength[] = "Dateilnge stimmt nicht!"
    "\n\nModule sind 8 oder 16 KByte gro, Kernal und Basic jeweils 8 KByte "
    "und Zeichenstze 4 KByte";
  char acUseBIOS[] = "Unbekannter Code an Kernal Adresse EA87h!"
    "\n\nEs ist nur die original amerikanische Tastenbelegung im Emulator "
    "verfgbar, nationale Tastaturtreiber werden nicht untersttzt";
  char acNoIEC[] = "Sprungadressen fr den IEC-Bus stimmen nicht!"
    "\n\nMit diesem Kernal knnen Sie keine Dateioperationen ausfhren";
  char acNoImage[] = "Das ist keine gltige C64 Datei!"
    "\n\nWie Sie D64, P00 und T64 Dateien laden knnen, steht in"
    "\n<Hilfe / bersicht>";
  char acNoCurrent[] = "Wollen Sie die aktuellen Einstellungen speichern?";
  char acConfirm[] = "Besttigung";
  char acNoDevice1[] = "Folgende C64-Laufwerke "
    "konnten nicht initialisiert werden:\n\n";
  char acNoDevice2[] = "\nBerichtigen Sie die Eintrge "
    "unter Optionen Laufwerke";
  char __near acError[] = "Fehler";
  char acImageFilter[] = "C64 Dateien\0*.C64\0Alle Dateien\0*.*\0";
  char acFileOpen[] = "Emulator ffnen";
  char acFileSave[] = "Emulator speichern";
  char acFileHasChanged[] = "Wollen Sie die nderungen "
    "an der Datei %s speichern?";
  char acReloadFile[] = "Wollen Sie die in der Zwischenzeit "
    "vorgenommenen nderungen verwerfen?";
  char* apcColor[DTC_COUNT] = {
  // 12345678901234567890123456789012345678
    "Emulator: Normaler Hintergrund",
    "Emulator: Hintergrund bei Markierung",
    "Emulator: Trace (Befehle und Register)",
    "Emulator: Anmerkungen (REM)",
    "Emulator: Ereignisse (VIC, SID, CIA)",
    "Emulator: Warnungen und Fehler",
    "Manager: Hintergrund Verzeichnisbaum",
    "Manager: Vordergrund Verzeichnisbaum",
    "Manager: Hintergrund Dateiliste",
    "Manager: Vordergrund Dateiliste",
    "Hilfe: Hintergrund",
    "Hilfe: Normaler Text",
    "Hilfe: Fetter Text",
    "Hilfe: Zwischenberschriften",
    "Hilfe: Marker fr Verweise",
    "Hilfe: Trennstrich"
  };
  char acNoHelp[] = "Zu dieser Situation ist kein Hilfetext verfgbar";
  char acCantFindL64[] = "\n\nFr das Klonen mu sich die Datei L64.P00 "
    "im Startverzeichnis des Emulators befinden!";
  char acNoLptPorts[] = "Es ist keine parallele Schnittstelle "
    "in Ihrem Rechner verfgbar!";
  char acErrorReadingL64[] = "\n\nDie Datei L64.P00 kann nicht gelesen werden!";
  char acCloneStopped[] = "Die bertragung wurde abgebrochen!\n\n"
    "Halten Sie das Programm auf dem C64 mit STOP+RESTORE an";
  char acCloneSuccess[] = "bertragung erfolgreich";
  char acEnterClose1[] = "Unterbrechen Sie jetzt das bertragungsprogramm "
    "auf dem C64 mit STOP+RESTORE und geben Sie CLOSE 1 ein. "
    "Danach knnen Sie das Link mit LOAD \"L64\",8 laden "
    "und mit RUN ausfhren.";
  char acUnrecovered[] = "Unentdeckter bertragungsfehler!\n\n"
    "Die bertragung war so fehlerhaft, da eine Prfsumme von 8 Bit "
    "zur Erkennung nicht mehr ausreicht. Bitte erhhen Sie die Anzahl "
    "der Wartezyklen, sonst werden Ihre Daten spter beim Kopieren "
    "verflscht!";
  char acMoving[] = "Verschieben luft";
  char acCopying[] = "Kopieren luft";
  char acSameDest[] = "Quellverzeichnis und Zielverzeichnis sind identisch!";
  char acDeviceNotPresent[] = "Laufwerk nicht vorhanden!";
  char acOutput[] = "Zeitberschreitung auf dem seriellen Bus bei der Ausgabe";
  char acInput[] = "Zeitberschreitung auf dem seriellen Bus bei der Eingabe";
  char acUnknownBusError[] = "Unbekannter Fehler auf dem seriellen Bus";
  char acNotEmpty[] = "Verzeichnis ist aktuelles Verzeichnis "
    "oder enthlt noch Dateien!";
  char acDelete[] = "Wollen Sie wirklich %d Datei(en) lschen?";
  char acDrivesFound[] = "Die neuen L64-Laufwerke sind jetzt verfgbar";
  char acDrivesNotFound[] = "Es wurden keine neuen L64-Laufwerke gefunden!";
  char acImportFilter[] = "Alle Dateien\0*.*\0Programme\0*.PRG\0Daten\0*.SEQ\0";
  char acImport[] = "Datei importieren";
  char acOverwrite[] = "Die Datei gibt es schon. Soll sie berschrieben werden?";
  char acIsAlreadyC64[] = "Die Datei liegt bereits im C64-Format vor!";
  char acReset[] = "Wollen Sie wirklich einen Reset durchfhren?";
  char acScanDrives[] = "L64-Laufwerke hinzufgen";
  char acWindowsNT[] = "Sie befinden sich in der DOS-Emulation von Windows NT. "
    "Wenn Sie trotzdem direkte Portzugriffe ausfhren wollen, "
    "dann besttigen Sie bitte mit OK.";
  char acPerformance[] = "Es wurden %.2f Prozent CPU-Rechenleistung gemessen";
  char* apcPresent[2] = {
    "Nein", "Ja"
  };
  char acEndIsLessThanStart[] = "Die Endadresse ist kleiner "
    "als die Startadresse!";
  char acQuerySave[] = "Um die Option \"nderungen verwerfen\" dauerhaft "
    "zu machen, mssen Sie die Datei speichern. Mchten Sie das jetzt tun?";
  char acWrongRecordLen[] = "Die Recordlnge bei relativen Dateien mu "
    "zwischen 1 und 255 liegen!";
  char acDelImage[] = "Wollen Sie %s einschlielich aller darin enthaltenen "
    "Dateien wirklich lschen?";
  char acOverwriteImage[] = "Wollen Sie %s einschlielich aller darin "
    "enthaltenen Dateien wirklich berschreiben?";
  char acWantFormat[] = "Diskette ist vermutlich neu. Soll sie formatiert "
    "werden?";
  char acNoL64[] = "Es ist kein externer C64 an einer der parallelen "
    "Schnittstellen angeschlossen, oder das Programm L64 luft nicht!";

#else

  char acCopyright[] =
    "\rPersonal C64 Version " VERSION BETA " - " COPYRIGHT "\n";
  char acNoCPU[] = "\n\
This computer doesn't have a 386 compatible CPU. If you continue, the desktop\n\
will probably work but the emulation will crash.\n";
  char acNoVGA[] = "\n\
This computer doesn't have a VGA card. If you continue, the desktop will work\n\
but the C64 screen in mode 13h will be invisible.\n";
  char acNoDos[] = "\n\
Your operating system is older than DOS 3.3. The emulator hasn't been tested\n\
with such early versions.\n";
  char acNotEnoughMemory[] = "\n\
You have only %d kB of memory but the emulator needs at least %d kB.\n\
If you continue, the desktop will run slower and eventually crash.\n";
  char* apcDOSError[0x66] = {
    "Unknown DOS error %04Xh",
    "Function number invalid",
    "File not found",
    "Path not found",
    "Too many open files",
    "Access denied",
    "File handle invalid",
    "Memory Control Blocks destroyed",
    "Insufficient memory",
    "Memory block address invalid",
    "Environment invalid",
    "Format invalid",
    "Access code invalid",
    "Data invalid",
    "Unknown unit",
    "Drive invalid",
    "Attempted to remove current directory",
    "Not same device",
    "No more files",
    "Disk is write-protected",
    "Unknown unit",
    "Drive not ready",
    "Unknown command",
    "Data CRC error",
    "Bad request structure length",
    "Seek error",
    "Unknown media type",
    "Sector not found",
    "Printer out of paper",
    "Write fault",
    "Read fault",
    "General failure",
    "Sharing violation",
    "Lock violation",
    "Disk change invalid",
    "FCB unavailable",
    "Sharing buffer exceeded",
    "Code page mismatched",
    "Handle end of file operation not completed",
    "Disk full",
    "End of file encountered",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "Unsupported network request",
    "Remote machine not listening",
    "Duplicate name on network",
    "Network name not found",
    "Network busy",
    "Device no longer exists on network",
    "NetBIOS command limit exceeded",
    "Error in network adapter hardware",
    "Incorrect response from network",
    "Unexpected network error",
    "Remote adapter incompatible",
    "Print queue full",
    "Not enough room for print file",
    "Print file was deleted",
    "Network name deleted",
    "Network access denied",
    "Incorrect network device type",
    "Network name not found",
    "Network name limit exceeded",
    "NetBIOS session limit exceeded",
    "Temporary pause",
    "Network requested not accepted",
    "Print or disk redirection paused",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "File already exists",
    "Duplicate FCB",
    "Cannot create directory",
    "Fail on Int 24h (critical interrupt)",
    "Too many redirections",
    "Duplicate redirection",
    "Invalid password",
    "Invalid parameter",
    "Net write fault",
    "Function not supported by network",
    "Required system component not installed",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "Device not selected"
  };
  char __near acNone[] = "(none)";
  char __near acUnknown[] = "(unknown)";
  char __near acUntitled[] = "No name";
  char acROMLength[] = "Wrong file size!"
    "\n\nCartridge files are 8 or 16 KByte, KERNAL and BASIC files 8 KByte "
    "and Charset files 4 KByte";
  char acUseBIOS[] = "Unknown code at KERNAL address EA87h!"
    "\n\nYou can only use the US original keyboard layout, national "
    "keyboard drivers aren't supported";
  char acNoIEC[] = "Wrong IEC bus jump table!"
    "\n\nYou cannot use file operations with this Kernal";
  char acNoImage[] = "This is not a valid C64 image file!"
    "\n\nHow to run D64, P00 and T64 Files is described in"
    "\n<Help / Contents>";
  char acNoCurrent[] = "Do you want to save the current settings?";
  char acConfirm[] = "Confirmation";
  char acNoDevice1[] = "The following C64 drives "
    "couldn't be initialized:\n\n";
  char acNoDevice2[] = "\nPlease correct the settings "
    "under <Options / Drives>";
  char __near acError[] = "Error";
  char acImageFilter[] = "C64 image files\0*.C64\0All files\0*.*\0";
  char acFileOpen[] = "Emulator open";
  char acFileSave[] = "Emulator save as";
  char acFileHasChanged[] = "%s has changed. Save changes?";
  char acReloadFile[] = "Do you want to reject the current changes?";
  char* apcColor[DTC_COUNT] = {
  // 12345678901234567890123456789012345678
    "Emulator: Background",
    "Emulator: Selection bar background",
    "Emulator: Trace",
    "Emulator: Remarks",
    "Emulator: Events (VIC, SID, CIA)",
    "Emulator: Warnings and errors",
    "Manager: Directory tree background",
    "Manager: Directory tree foreground",
    "Manager: File list background",
    "Manager: File list foreground",
    "Help: Background",
    "Help: Standard text",
    "Help: Bold text",
    "Help: Headlines",
    "Help: Hypertext markers",
    "Help: Line"
  };
  char acNoHelp[] = "No help information available for this situation";
  char acCantFindL64[] = "\n\nCloning requires L64.P00 to be "
    "in the program directory!";
  char acNoLptPorts[] = "There is no LPT port in this computer!";
  char acErrorReadingL64[] = "\n\nError reading L64.P00!";
  char acCloneStopped[] = "Transmission stopped!\n\n"
    "Press STOP+RESTORE on the C64";
  char acCloneSuccess[] = "Transmission OK";
  char acEnterClose1[] = "Now stop the program on the C64 with  "
    "STOP+RESTORE and type CLOSE 1. "
    "Then start the server program by LOAD \"L64\",8 and "
    "RUN.";
  char acUnrecovered[] = "Unrecoverable transmission error!\n\n"
    "The 8 bit checksum couldn't detect this error. Please increment "
    "the waitstates or your transmitted data can be damaged!";
  char acMoving[] = "Moving";
  char acCopying[] = "Copying";
  char acSameDest[] = "Source and target directory are identical!";
  char acDeviceNotPresent[] = "Drive not present!";
  char acOutput[] = "IEC timeout at output";
  char acInput[] = "IEC timeout at input";
  char acUnknownBusError[] = "Unknown IEC error";
  char acNotEmpty[] = "You cannot remove the current directory or a non-empty directory!";
  char acDelete[] = "Do you really want to delete %d file(s)?";
  char acDrivesFound[] = "New external L64 drives are now available";
  char acDrivesNotFound[] = "There are no new external L64 drives!";
  char acImportFilter[] = "All files\0*.*\0Programs\0*.PRG\0Data files\0*.SEQ\0";
  char acImport[] = "Importing";
  char acOverwrite[] = "File exists. Overwrite?";
  char acIsAlreadyC64[] = "This file is already in PC64 format!";
  char acReset[] = "Do you really want to reset?";
  char acScanDrives[] = "Add L64 drives";
  char acWindowsNT[] = "You are in a DOS box of Windows NT. "
    "If you nevertheless want to access the hardware directly, "
    "please confirm with OK.";
  char acPerformance[] = "Performance compared to a real C64 is %.2f percent";
  char* apcPresent[2] = {
    "No", "Yes"
  };
  char acEndIsLessThanStart[] = "End address is smaller than start address!";
  char acQuerySave[] = "To make the option \"Don't save at exit\" permanent, "
    "you must save the file once. Do you want to do it now?";
  char acWrongRecordLen[] = "Record length must be within 1 and 255!";
  char acDelImage[] = "Do you really want to delete %s and all the "
    "included files?";
  char acOverwriteImage[] = "Do you really want to overwrite %s and all the "
    "included files?";
  char acWantFormat[] = "This disk is probably unformatted. Do you want to format it?";
  char acNoL64[] = "There is no C64 on any LPT port or the "
    "server program L64 isn't running!";

#endif

// Fehlermeldung setzen
#pragma optimize("leg", off)
void SetError(word wError) {
  static word near aw[11];
  aw[0] = wError;
  __asm {
    push DS
    mov AX,5D0Ah
    mov DX,offset aw
    int 21h
    pop DS
  }
}
#pragma optimize("", on)

// Fehlermeldung ausgeben
flag ErrorBox(char* pcFile, char* pcMessage) {
  char ac[1024];
  char* pc = ac;
  if (pcFile && *pcFile) {
    if (_fullpath(ac, pcFile, 80) == NULL) {
      strcpy(ac, pcFile);
    }
    AnsiUpper(ac);
    pc = ac + strlen(ac);
    *(word*)pc = '\n\n';
    pc += 2;
  }
  if (!pcMessage) {
    int iError = _dosexterr(NULL);
    if (iError > 0 && iError < 0x66 && apcDOSError[iError]) {
      strcpy(pc, apcDOSError[iError]);
    } else {
      wsprintf(pc, apcDOSError[0], iError);
    }
  } else {
    strcpy(pc, pcMessage);
  }
  MessageBeep(MB_ICONEXCLAMATION);
  MessageBox(hwndFrame, ac, acError, MB_ICONEXCLAMATION | MB_OK);
  return FALSE;
}
