comment # Vom Emulator verwendete Register
  AL    = Datum lesen/schreiben
  BX    = Adresse lesen/schreiben
  DL    = Bit 0: Carry Flag
  DS    = Datensegment
  ES    = 2 KByte RAM und 16 Byte Prozessorregister
  FS:SI = Program Counter
  HIWORD von ECX ist 0, DF ist gelscht, IF gesetzt
#

option proc:private
option scoped

.386
DGROUP group _DATA
assume DS:DGROUP

ProgCounter     equ word ptr ES:[0800h]
StackPtr        equ word ptr ES:[0802h]
XWord           equ word ptr ES:[0804h]
XReg            equ byte ptr ES:[0804h]
YWord           equ word ptr ES:[0806h]
YReg            equ byte ptr ES:[0806h]
Flags_SignZero  equ word ptr ES:[0808h]
Flags           equ byte ptr ES:[0808h]
SignZero        equ byte ptr ES:[0809h]
Overflow        equ byte ptr ES:[080Ah]
Akku            equ byte ptr ES:[080Bh]
Carry           equ byte ptr ES:[080Ch]
hImageFile      equ word ptr ES:[080Eh]
pbError         equ dword ptr ES:[0810h]

_DATA segment dword public use16 'DATA'
extrn c fCtrlBreak:word
wROMSeg dw ?
wAbsoluteSector dw ?
_DATA ends

VC1541ROM segment para public use16 'BSS'
abROM label byte
public c abROM
  db 151,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 120,169,247,45,0,28,72,165,127,240,5,104,9,0,208,3
  db 104,9,8,141,0,28,88,96,120,169,8,13,0,28,141,0
  db 28,88,96,169,0,141,108,2,141,109,2,96,120,138,72,169
  db 80,141,108,2,162,0,189,202,254,141,109,2,13,0,28,141
  db 0,28,104,170,88,96,169,0,141,249,2,173,142,2,133,127
  db 32,188,230,165,132,16,9,41,15,201,15,240,3,76,180,215
  db 32,179,194,177,163,141,117,2,162,11,189,137,254,205,117,2
  db 240,8,202,16,245,169,49,76,200,193,142,42,2,224,9,144
  db 3,32,238,193,174,42,2,189,149,254,133,111,189,161,254,133
  db 112,108,111,0,169,0,141,249,2,173,108,2,208,42,160,0
  db 152,132,128,132,129,132,163,32,199,230,32,35,193,165,127,141
  db 142,2,170,169,0,149,255,32,189,193,76,218,212,160,40,169
  db 0,153,0,2,136,16,250,96,160,0,132,128,132,129,76,69
  db 230,162,0,142,122,2,169,58,32,104,194,240,5,136,136,140
  db 122,2,76,104,195,160,0,162,0,169,58,76,104,194,32,229
  db 193,208,5,169,52,76,200,193,136,136,140,122,2,138,208,243
  db 169,61,32,104,194,138,240,2,169,64,9,33,141,139,2,232
  db 142,119,2,142,120,2,173,138,2,240,13,169,128,13,139,2
  db 141,139,2,169,0,141,138,2,152,240,41,157,122,2,173,119
  db 2,141,121,2,169,141,32,104,194,232,142,120,2,202,173,138
  db 2,240,2,169,8,236,119,2,240,2,9,4,9,3,77,139
  db 2,141,139,2,173,139,2,174,42,2,61,165,254,208,1,96
  db 141,108,2,169,48,76,200,193,141,117,2,204,116,2,176,46
  db 177,163,200,205,117,2,240,40,201,42,240,4,201,63,208,3
  db 238,138,2,201,44,208,228,152,157,123,2,173,138,2,41,127
  db 240,7,169,128,149,231,141,138,2,232,224,4,144,205,160,0
  db 173,116,2,157,123,2,173,138,2,41,127,240,4,169,128,149
  db 231,152,96,164,163,240,20,136,240,16,185,0,2,201,13,240
  db 10,136,185,0,2,201,13,240,2,200,200,140,116,2,192,42
  db 160,255,144,8,140,42,2,169,50,76,200,193,160,0,152,133
  db 163,141,88,2,141,74,2,141,150,2,133,211,141,121,2,141
  db 119,2,141,120,2,141,138,2,141,108,2,162,5,157,121,2
  db 149,215,149,220,149,225,149,230,157,127,2,157,132,2,202,208
  db 236,96,173,120,2,141,119,2,169,1,141,120,2,141,121,2
  db 172,142,2,162,0,134,211,189,122,2,32,60,195,166,211,157
  db 122,2,152,149,226,232,236,120,2,144,234,96,170,160,0,169
  db 58,221,1,2,240,12,221,0,2,208,22,232,152,41,1,168
  db 138,96,189,0,2,232,232,201,48,240,242,201,49,240,238,208
  db 235,152,9,128,41,129,208,231,169,0,141,139,2,172,122,2
  db 177,163,32,189,195,16,17,200,204,116,2,176,6,172,116,2
  db 136,208,237,206,139,2,169,0,41,1,133,127,76,0,193,165
  db 127,73,1,41,1,133,127,96,160,0,173,119,2,205,120,2
  db 240,22,206,120,2,172,120,2,185,122,2,168,177,163,160,4
  db 217,187,254,240,3,136,208,248,152,141,150,2,96,201,48,240
  db 6,201,49,240,2,9,128,41,129,96,169,0,133,111,141,141
  db 2,72,174,120,2,104,5,111,72,169,1,133,111,202,48,15
  db 181,226,16,4,6,111,6,111,74,144,234,6,111,208,230,104
  db 170,189,63,196,72,41,3,141,140,2,104,10,16,62,165,226
  db 41,1,133,127,173,140,2,240,43,32,61,198,240,18,32,143
  db 195,169,0,141,140,2,32,61,198,240,30,169,116,32,200,193
  db 32,143,195,32,61,198,8,32,143,195,40,240,12,169,0,141
  db 140,2,240,5,32,61,198,208,226,76,0,193,42,76,0,196
  db 0,128,65,1,1,1,1,129,129,129,129,66,66,66,66,32
  db 202,195,169,0,141,146,2,32,172,197,208,25,206,140,2,16
  db 1,96,169,1,141,141,2,32,143,195,32,0,193,76,82,196
  db 32,23,198,240,16,32,216,196,173,143,2,240,1,96,173,83
  db 2,48,237,16,240,173,143,2,240,210,96,32,4,198,240,26
  db 208,40,169,1,141,141,2,32,143,195,32,0,193,169,0,141
  db 146,2,32,172,197,208,19,141,143,2,173,143,2,208,40,206
  db 140,2,16,222,96,32,23,198,240,240,32,216,196,174,83,2
  db 16,7,173,143,2,240,238,208,14,173,150,2,240,9,181,231
  db 41,7,205,150,2,208,222,96,162,255,142,83,2,232,142,138
  db 2,32,137,197,240,6,96,32,148,197,208,250,165,127,85,226
  db 74,144,11,41,64,240,240,169,2,205,140,2,240,233,189,122
  db 2,170,32,166,198,160,3,76,29,197,189,0,2,209,148,240
  db 10,201,63,208,210,177,148,201,160,240,204,232,200,236,118,2
  db 176,9,189,0,2,201,42,240,12,208,223,192,19,176,6,177
  db 148,201,160,208,178,174,121,2,142,83,2,181,231,41,128,141
  db 138,2,173,148,2,149,221,165,129,149,216,160,0,177,148,200
  db 72,41,64,133,111,104,41,223,48,2,9,32,41,39,5,111
  db 133,111,169,128,53,231,5,111,149,231,181,226,41,128,5,127
  db 149,226,177,148,157,128,2,200,177,148,157,133,2,173,88,2
  db 208,7,160,21,177,148,141,88,2,169,255,141,143,2,173,120
  db 2,141,121,2,206,121,2,16,1,96,174,121,2,181,231,48
  db 5,189,128,2,208,238,169,0,141,143,2,96,160,0,140,145
  db 2,136,140,83,2,173,133,254,133,128,169,1,133,129,141,147
  db 2,32,117,212,173,147,2,208,1,96,169,7,141,149,2,169
  db 0,32,246,212,141,147,2,32,232,212,206,149,2,160,0,177
  db 148,208,24,173,145,2,208,47,32,59,222,165,129,141,145,2
  db 165,148,174,146,2,141,146,2,240,29,96,162,1,236,146,2
  db 208,45,240,19,173,133,254,133,128,173,144,2,133,129,32,117
  db 212,173,148,2,32,200,212,169,255,141,83,2,173,149,2,48
  db 8,169,32,32,198,209,76,215,197,32,77,212,76,196,197,165
  db 148,141,148,2,32,59,222,165,129,141,144,2,96,165,104,208
  db 40,166,127,86,28,144,34,169,255,141,152,2,32,14,208,160
  db 255,201,2,240,10,201,3,240,6,201,15,240,2,160,0,166
  db 127,152,149,255,208,3,32,66,208,166,127,181,255,96,72,32
  db 166,198,32,136,198,104,56,237,75,2,170,240,10,144,8,169
  db 160,145,148,200,202,208,250,96,152,10,168,185,153,0,133,148
  db 185,154,0,133,149,160,0,189,0,2,145,148,200,240,6,232
  db 236,118,2,144,242,96,169,0,141,75,2,138,72,189,0,2
  db 201,44,240,20,201,61,240,16,238,75,2,232,169,15,205,75
  db 2,144,5,236,116,2,144,229,142,118,2,104,170,96,165,131
  db 72,165,130,72,32,222,198,104,133,130,104,133,131,96,169,17
  db 133,131,32,235,208,32,232,212,173,83,2,16,10,173,141,2
  db 208,10,32,6,200,24,96,173,141,2,240,31,206,141,2,208
  db 13,206,141,2,32,143,195,32,6,200,56,76,143,195,169,0
  db 141,115,2,141,141,2,32,183,199,56,96,162,24,160,29,177
  db 148,141,115,2,240,2,162,22,136,177,148,141,114,2,224,22
  db 240,10,201,10,144,6,202,201,100,144,1,202,32,172,199,177
  db 148,72,10,16,5,169,60,157,178,2,104,41,15,168,185,197
  db 254,157,177,2,202,185,192,254,157,177,2,202,185,187,254,157
  db 177,2,202,202,176,5,169,42,157,178,2,169,160,157,177,2
  db 202,160,18,177,148,157,177,2,202,136,192,3,176,245,169,34
  db 157,177,2,232,224,32,176,11,189,177,2,201,34,240,4,201
  db 160,208,240,169,34,157,177,2,232,224,32,176,10,169,127,61
  db 177,2,157,177,2,16,241,32,181,196,56,96,160,27,169,32
  db 153,176,2,136,208,250,96,32,25,241,32,223,240,32,172,199
  db 169,255,133,111,166,127,142,114,2,169,0,141,115,2,166,249
  db 189,224,254,133,149,173,136,254,133,148,160,22,177,148,201,160
  db 208,11,169,49,44,177,148,201,160,208,2,169,32,153,179,2
  db 136,16,242,169,18,141,177,2,169,34,141,178,2,141,195,2
  db 169,32,141,196,2,96,32,172,199,160,11,185,23,200,153,177
  db 2,136,16,247,76,77,239,66,76,79,67,75,83,32,70,82
  db 69,69,46,32,152,195,32,32,195,32,202,195,169,0,133,134
  db 32,157,196,48,61,32,183,221,144,51,160,0,177,148,41,64
  db 208,43,32,182,200,160,19,177,148,240,10,133,128,200,177,148
  db 133,129,32,125,200,174,83,2,169,32,53,231,208,13,189,128
  db 2,133,128,189,133,2,133,129,32,125,200,230,134,32,139,196
  db 16,195,165,134,133,128,169,1,160,0,76,163,193,32,95,239
  db 32,117,212,32,25,241,181,167,201,255,240,8,173,249,2,9
  db 64,141,249,2,169,0,32,200,212,32,86,209,133,128,32,86
  db 209,133,129,165,128,208,6,32,244,238,76,39,210,32,95,239
  db 32,77,212,76,148,200,160,0,152,145,148,32,94,222,76,153
  db 213,169,49,76,200,193,169,76,141,0,6,169,199,141,1,6
  db 169,250,141,2,6,169,3,32,211,214,165,127,9,224,133,3
  db 165,3,48,252,201,2,144,7,169,3,162,0,76,10,230,96
  db 169,224,141,79,2,32,209,240,32,25,241,169,255,149,167,169
  db 15,141,86,2,32,229,193,208,3,76,193,200,32,248,193,32
  db 32,195,173,139,2,41,85,208,15,174,122,2,189,0,2,201
  db 42,208,5,169,48,76,200,193,173,139,2,41,217,208,244,76
  db 82,201,169,0,141,88,2,141,140,2,141,128,2,141,129,2
  db 165,227,41,1,133,127,9,1,141,145,2,173,123,2,141,122
  db 2,96,32,79,196,173,120,2,201,3,144,69,165,226,197,227
  db 208,63,165,221,197,222,208,57,165,216,197,217,208,51,32,204
  db 202,169,1,141,121,2,32,250,201,32,37,209,240,4,201,2
  db 208,5,169,100,32,200,193,169,18,133,131,173,60,2,141,61
  db 2,169,255,141,60,2,32,42,218,162,2,32,185,201,76,148
  db 193,32,167,201,76,148,193,32,231,202,165,226,41,1,133,127
  db 32,134,212,32,228,214,174,119,2,142,121,2,32,250,201,169
  db 17,133,131,32,235,208,32,37,209,208,3,32,83,202,169,8
  db 133,248,76,216,201,32,155,207,32,53,202,169,128,32,166,221
  db 240,243,32,37,209,240,3,32,155,207,174,121,2,232,236,120
  db 2,144,198,169,18,133,131,76,2,219,174,121,2,181,226,41
  db 1,133,127,173,133,254,133,128,181,216,133,129,32,117,212,174
  db 121,2,181,221,32,200,212,174,121,2,181,231,41,7,141,74
  db 2,169,0,141,88,2,32,160,217,160,1,32,37,209,240,1
  db 200,152,76,200,212,169,17,133,131,32,155,211,133,133,166,130
  db 181,242,41,8,133,248,208,10,32,37,209,240,5,169,128,32
  db 151,221,96,32,211,209,32,203,225,165,214,72,165,213,72,169
  db 18,133,131,32,7,209,32,211,209,32,203,225,32,156,226,165
  db 214,133,135,165,213,133,134,169,0,133,136,133,212,133,215,104
  db 133,213,104,133,214,76,59,227,32,32,195,165,227,41,1,133
  db 227,197,226,240,2,9,128,133,226,32,79,196,32,231,202,165
  db 227,41,1,133,127,165,217,133,129,32,87,222,32,153,213,165
  db 222,24,105,3,32,200,212,32,147,223,168,174,122,2,169,16
  db 32,110,198,32,94,222,32,153,213,76,148,193,165,232,41,7
  db 141,74,2,174,120,2,202,236,119,2,144,10,189,128,2,208
  db 245,169,98,76,200,193,96,32,204,202,189,128,2,240,5,169
  db 99,76,200,193,202,16,243,96,173,1,2,201,45,208,76,173
  db 3,2,133,111,173,4,2,133,112,160,0,173,2,2,201,82
  db 240,14,32,88,242,201,87,240,55,201,69,208,46,108,111,0
  db 177,111,133,133,173,116,2,201,6,144,26,174,5,2,202,240
  db 20,138,24,101,111,230,111,141,73,2,165,111,133,165,165,112
  db 133,166,76,67,212,32,235,208,76,58,212,169,49,76,200,193
  db 185,6,2,145,111,200,204,5,2,144,245,96,172,1,2,192
  db 48,208,9,169,234,133,107,169,255,133,108,96,32,114,203,76
  db 148,193,136,152,41,15,10,168,177,107,133,117,200,177,107,133
  db 118,108,117,0,173,142,2,133,127,165,131,72,32,61,198,104
  db 133,131,174,116,2,202,208,13,169,1,32,226,209,76,241,203
  db 169,112,76,200,193,160,1,32,124,204,174,133,2,224,5,176
  db 239,169,0,133,111,133,112,56,38,111,38,112,202,16,249,165
  db 111,45,79,2,208,218,165,112,45,80,2,208,211,165,111,13
  db 79,2,141,79,2,165,112,13,80,2,141,80,2,169,0,32
  db 226,209,166,130,173,133,2,149,167,170,165,127,149,0,157,91
  db 2,166,131,189,43,2,9,64,157,43,2,164,130,169,255,153
  db 68,2,169,137,153,242,0,185,167,0,153,62,2,10,170,169
  db 1,149,153,169,14,153,236,0,76,148,193,160,0,162,0,169
  db 45,32,104,194,208,10,169,49,76,200,193,169,48,76,200,193
  db 138,208,248,162,5,185,0,2,221,93,204,240,5,202,16,248
  db 48,228,138,9,128,141,42,2,32,111,204,173,42,2,10,170
  db 189,100,204,133,112,189,99,204,133,111,108,111,0,65,70,82
  db 87,69,80,3,205,245,204,86,205,115,205,163,205,189,205,160
  db 0,162,0,169,58,32,104,194,208,2,160,3,185,0,2,201
  db 32,240,8,201,29,240,4,201,44,208,7,200,204,116,2,144
  db 235,96,32,161,204,238,119,2,172,121,2,224,4,144,236,176
  db 138,169,0,133,111,133,112,133,114,162,255,185,0,2,201,64
  db 176,24,201,48,144,20,41,15,72,165,112,133,113,165,111,133
  db 112,104,133,111,200,204,116,2,144,225,140,121,2,24,169,0
  db 232,224,3,176,15,180,111,136,48,246,125,242,204,144,248,24
  db 230,114,208,243,72,174,119,2,165,114,157,128,2,104,157,133
  db 2,96,1,10,100,32,245,205,32,95,239,76,148,193,169,1
  db 141,249,2,32,245,205,165,129,72,32,250,241,240,11,104,197
  db 129,208,25,32,144,239,76,148,193,104,169,0,133,129,230,128
  db 165,128,205,215,254,176,10,32,250,241,240,238,169,101,32,69
  db 230,169,101,32,200,193,32,242,205,76,96,212,32,47,209,161
  db 153,96,32,54,205,169,0,32,200,212,32,60,205,153,68,2
  db 169,137,153,242,0,96,32,66,205,32,236,211,76,148,193,32
  db 111,204,32,66,205,185,68,2,153,62,2,169,255,153,68,2
  db 76,148,193,32,242,205,32,232,212,168,136,201,2,176,2,160
  db 1,169,0,32,200,212,152,32,241,207,138,72,32,100,212,104
  db 170,32,238,211,76,148,193,32,111,204,32,242,205,32,100,212
  db 76,148,193,32,88,242,32,54,205,169,0,133,111,166,249,189
  db 224,254,133,112,32,186,205,76,148,193,108,111,0,32,210,205
  db 165,249,10,170,173,134,2,149,153,32,47,209,32,238,211,76
  db 148,193,166,211,230,211,189,133,2,168,136,136,192,12,144,5
  db 169,112,76,200,193,133,131,32,235,208,176,244,32,147,223,133
  db 249,96,32,210,205,166,211,189,133,2,41,1,133,127,189,135
  db 2,133,129,189,134,2,133,128,32,95,213,76,0,193,32,44
  db 206,32,110,206,165,144,133,215,32,113,206,230,215,230,215,165
  db 139,133,213,165,144,10,24,105,16,133,214,96,32,217,206,133
  db 146,166,130,181,181,133,144,181,187,133,145,208,4,165,144,240
  db 11,165,144,56,233,1,133,144,176,2,198,145,181,199,133,111
  db 70,111,144,3,32,237,206,32,229,206,165,111,208,242,165,212
  db 24,101,139,133,139,144,6,230,140,208,2,230,141,96,169,254
  db 44,169,120,133,111,162,3,181,143,72,181,138,149,143,104,149
  db 138,202,208,243,32,217,206,162,0,181,144,149,143,232,224,4
  db 144,247,169,0,133,146,36,111,48,9,6,143,8,70,143,40
  db 32,230,206,32,237,206,32,229,206,36,111,48,3,32,226,206
  db 165,143,24,101,144,133,144,144,6,230,145,208,2,230,146,165
  db 146,5,145,208,194,165,144,56,229,111,144,12,230,139,208,6
  db 230,140,208,2,230,141,133,144,96,169,0,133,139,133,140,133
  db 141,96,32,229,206,24,38,144,38,145,38,146,96,24,162,253
  db 181,142,117,147,149,142,232,208,247,96,162,0,138,149,250,232
  db 224,4,208,248,169,6,149,250,96,160,4,166,130,185,250,0
  db 150,250,197,130,240,7,136,48,225,170,76,13,207,96,32,9
  db 207,32,183,223,208,70,32,211,209,32,142,210,48,72,32,194
  db 223,165,128,72,165,129,72,169,1,32,246,212,133,129,169,0
  db 32,246,212,133,128,240,31,32,37,209,240,11,32,171,221,208
  db 6,32,140,207,76,93,207,32,140,207,32,87,222,104,133,129
  db 104,133,128,76,111,207,104,133,129,104,133,128,32,140,207,32
  db 147,223,170,76,153,213,169,112,76,200,193,32,9,207,32,183
  db 223,208,8,32,142,210,48,238,32,194,223,96,166,130,181,167
  db 73,128,149,167,181,174,73,128,149,174,96,162,18,134,131,32
  db 7,209,32,0,193,32,37,209,144,5,169,32,32,157,221,165
  db 131,201,15,240,35,208,8,165,132,41,143,201,15,176,25,32
  db 37,209,176,5,165,133,76,157,209,208,3,76,171,224,165,133
  db 32,241,207,164,130,76,238,211,169,4,133,130,32,232,212,201
  db 42,240,5,165,133,32,241,207,165,248,240,1,96,238,85,2
  db 96,72,32,147,223,16,6,104,169,97,76,200,193,10,170,104
  db 129,153,246,153,96,32,209,193,32,66,208,76,148,193,32,15
  db 241,168,182,167,224,255,208,20,72,32,142,210,170,16,5,169
  db 112,32,72,230,104,168,138,9,128,153,167,0,138,41,15,133
  db 249,162,0,134,129,174,133,254,134,128,32,211,214,169,176,76
  db 140,213,32,209,240,32,19,211,32,14,208,166,127,169,0,157
  db 81,2,138,10,170,165,22,149,18,165,23,149,19,32,134,213
  db 165,249,10,170,169,2,149,153,161,153,166,127,157,1,1,169
  db 0,149,28,149,255,32,58,239,160,4,169,0,170,24,113,109
  db 144,1,232,200,200,200,200,192,72,240,248,192,144,208,238,72
  db 138,166,127,157,252,2,104,157,250,2,96,32,208,214,32,195
  db 208,32,153,213,32,55,209,133,128,32,55,209,133,129,96,32
  db 155,208,165,128,208,1,96,32,30,207,32,208,214,32,195,208
  db 76,30,207,169,128,208,2,169,144,141,77,2,32,147,223,170
  db 32,6,213,138,72,10,170,169,0,149,153,32,37,209,201,4
  db 176,6,246,181,208,2,246,187,104,170,96,165,131,201,19,144
  db 2,41,15,201,15,208,2,169,16,170,56,189,43,2,48,6
  db 41,15,133,130,170,24,96,165,131,201,19,144,2,41,15,170
  db 189,43,2,168,10,144,10,48,10,152,41,15,133,130,170,24
  db 96,48,246,56,96,166,130,181,236,74,41,7,201,4,96,32
  db 147,223,10,170,164,130,96,32,47,209,185,68,2,240,18,161
  db 153,72,181,153,217,68,2,208,4,169,255,149,153,104,246,153
  db 96,161,153,246,153,96,32,55,209,208,54,133,133,185,68,2
  db 240,8,169,128,153,242,0,165,133,96,32,30,207,169,0,32
  db 200,212,32,55,209,201,0,240,25,133,128,32,55,209,133,129
  db 32,30,207,32,211,209,32,208,214,32,195,208,32,30,207,165
  db 133,96,32,55,209,164,130,153,68,2,165,133,96,32,241,207
  db 240,1,96,32,211,209,32,30,241,169,0,32,200,212,165,128
  db 32,241,207,165,129,32,241,207,32,199,208,32,30,207,32,208
  db 214,169,2,76,200,212,133,111,32,232,212,24,101,111,149,153
  db 133,148,96,32,147,223,170,189,91,2,41,1,133,127,96,56
  db 176,1,24,8,133,111,32,39,210,32,127,211,133,130,166,131
  db 40,144,2,9,128,157,43,2,41,63,168,169,255,153,167,0
  db 153,174,0,153,205,0,198,111,48,28,32,142,210,16,8,32
  db 90,210,169,112,76,200,193,153,167,0,198,111,48,8,32,142
  db 210,48,236,153,174,0,96,165,131,201,15,208,1,96,166,131
  db 189,43,2,201,255,240,34,41,63,133,130,169,255,157,43,2
  db 166,130,169,0,149,242,32,90,210,166,130,169,1,202,48,3
  db 10,208,250,13,86,2,141,86,2,96,166,130,181,167,201,255
  db 240,9,72,169,255,149,167,104,32,243,210,166,130,181,174,201
  db 255,240,9,72,169,255,149,174,104,32,243,210,166,130,181,205
  db 201,255,240,9,72,169,255,149,205,104,32,243,210,96,152,72
  db 160,1,32,186,210,16,12,136,32,186,210,16,6,32,57,211
  db 170,48,19,181,0,48,252,165,127,149,0,157,91,2,138,10
  db 168,169,2,153,153,0,104,168,138,96,162,7,185,79,2,61
  db 233,239,240,4,202,16,245,96,185,79,2,93,233,239,153,79
  db 2,138,136,48,3,24,105,8,170,96,166,130,181,167,48,9
  db 138,24,105,7,170,181,167,16,240,201,255,240,236,72,169,255
  db 149,167,104,41,15,168,200,162,16,110,80,2,110,79,2,136
  db 208,1,24,202,16,243,96,169,14,133,131,32,39,210,198,131
  db 208,249,96,169,14,133,131,166,131,189,43,2,201,255,240,20
  db 41,63,133,130,32,147,223,170,189,91,2,41,1,197,127,208
  db 3,32,39,210,198,131,16,223,96,165,111,72,160,0,182,250
  db 181,167,16,4,201,255,208,22,138,24,105,7,170,181,167,16
  db 4,201,255,208,9,200,192,5,144,228,162,255,208,28,134,111
  db 41,63,170,181,0,48,252,201,2,144,8,166,111,224,7,144
  db 215,176,226,164,111,169,255,153,167,0,104,133,111,138,96,160
  db 0,169,1,44,86,2,208,9,200,10,208,247,169,112,76,200
  db 193,73,255,45,86,2,141,86,2,152,96,32,235,208,32,0
  db 193,32,170,211,166,130,189,62,2,96,166,130,32,37,209,208
  db 3,76,32,225,165,131,201,15,240,90,181,242,41,8,208,19
  db 32,37,209,201,7,208,7,169,137,149,242,76,222,211,169,0
  db 149,242,96,165,131,240,50,32,37,209,201,4,144,34,32,47
  db 209,181,153,217,68,2,208,4,169,0,149,153,246,153,161,153
  db 153,62,2,181,153,217,68,2,208,5,169,129,153,242,0,96
  db 32,86,209,166,130,157,62,2,96,173,84,2,240,242,32,103
  db 237,76,3,212,32,232,212,201,212,208,24,165,149,201,2,208
  db 18,169,13,133,133,32,35,193,169,0,32,193,230,198,165,169
  db 128,208,18,32,55,209,133,133,208,9,169,212,32,200,212,169
  db 2,149,154,169,136,133,247,165,133,141,67,2,96,32,147,223
  db 10,170,169,0,149,153,161,153,240,5,214,153,76,86,209,96
  db 169,128,208,2,169,144,5,127,141,77,2,165,249,32,211,214
  db 166,249,76,147,213,169,1,141,74,2,169,17,133,131,32,70
  db 220,169,2,76,200,212,169,18,133,131,76,218,220,32,59,222
  db 169,1,133,111,165,105,72,169,3,133,105,32,45,241,104,133
  db 105,169,0,32,200,212,165,128,32,241,207,165,129,32,241,207
  db 32,199,208,32,153,213,169,0,32,200,212,32,241,207,208,251
  db 32,241,207,169,255,76,241,207,133,111,32,147,223,10,170,181
  db 154,133,149,165,111,149,153,133,148,96,169,17,133,131,32,39
  db 210,169,18,133,131,76,39,210,32,147,223,10,170,181,154,133
  db 149,181,153,133,148,96,133,113,32,147,223,170,189,224,254,133
  db 114,160,0,177,113,96,189,91,2,41,1,13,77,2,72,134
  db 249,138,10,170,181,7,141,77,2,181,6,240,45,205,215,254
  db 176,40,170,104,72,41,240,201,144,208,79,104,72,74,176,5
  db 173,1,1,144,3,173,2,1,240,5,205,213,254,208,51,138
  db 32,75,242,205,77,2,240,2,176,48,32,82,213,169,102,76
  db 69,230,165,249,10,170,181,6,133,128,181,7,133,129,96,165
  db 128,240,234,205,215,254,176,229,32,75,242,197,129,240,222,144
  db 220,96,32,82,213,169,115,76,69,230,166,249,104,141,77,2
  db 149,0,157,91,2,96,169,128,208,2,169,144,5,127,166,249
  db 141,77,2,173,77,2,32,14,213,32,166,213,176,251,72,169
  db 0,141,152,2,104,96,181,0,48,26,201,2,144,20,201,8
  db 240,8,201,11,240,4,201,15,208,12,44,152,2,48,3,76
  db 63,214,24,96,56,96,152,72,165,127,72,189,91,2,41,1
  db 133,127,168,185,202,254,141,109,2,32,166,214,201,2,176,3
  db 76,109,214, 20h,0Ah,0E6h, 4Ch,6Dh,0D6h, 201,144,208,7,165,127,9
  ;Jobfehler weitergeben, vorher Halbspurwiederholung: 189,91,2, 41,240,72,
  db 184,157,91,2,36,106,112,57,169,0,141,153,2,141,154,2
  db 172,153,2,173,154,2,56,249,219,254,141,154,2,185,219,254
  db 32,118,214,238,153,2,32,166,214,201,2,144,8,172,153,2
  db 185,219,254,208,219,173,154,2,32,118,214,181,0,201,2,144
  db 43,36,106,16,15,104,201,144,208,5,5,127,157,91,2,181
  db 0,32,10,230,104,44,152,2,48,35,72,169,192,5,127,149
  db 0,181,0,48,252,32,166,214,201,2,176,217,104,201,144,208
  db 12,5,127,157,91,2,32,166,214,201,2,176,210,104,133,127
  db 104,168,181,0,24,96,201,0,240,24,48,12,160,1,32,147
  db 214,56,233,1,208,246,240,10,160,255,32,147,214,24,105,1
  db 208,246,96,72,152,164,127,153,254,2,217,254,2,240,251,169
  db 0,153,254,2,104,96,165,106,41,63,168,173,109,2,77,0
  db 28,141,0,28,189,91,2,149,0,181,0,48,252,201,2,144
  db 3,136,208,231,72,173,109,2,13,0,28,141,0,28,104,96
  db 32,147,223,10,168,165,128,153,6,0,165,129,153,7,0,165
  db 127,10,170,96,165,131,72,165,130,72,165,129,72,165,128,72
  db 169,17,133,131,32,59,222,173,74,2,72,165,226,41,1,133
  db 127,166,249,93,91,2,74,144,12,162,1,142,146,2,32,172
  db 197,240,29,208,40,173,145,2,240,12,197,129,240,31,133,129
  db 32,96,212,76,61,215,169,1,141,146,2,32,23,198,208,13
  db 32,141,212,165,129,141,145,2,169,2,141,146,2,173,146,2
  db 32,200,212,104,141,74,2,201,4,208,2,9,128,32,241,207
  db 104,141,128,2,32,241,207,104,141,133,2,32,241,207,32,147
  db 223,168,173,122,2,170,169,16,32,110,198,160,16,169,0,145
  db 148,200,192,27,144,249,173,74,2,201,4,208,19,160,16,173
  db 89,2,145,148,200,173,90,2,145,148,200,173,88,2,145,148
  db 32,100,212,104,133,130,170,104,133,131,173,145,2,133,216,157
  db 96,2,173,146,2,133,221,157,102,2,173,74,2,133,231,165
  db 127,133,226,96,165,131,141,76,2,32,179,194,142,42,2,174
  db 0,2,173,76,2,208,44,224,42,208,40,165,126,240,77,133
  db 128,173,110,2,133,127,133,226,169,2,133,231,173,111,2,133
  db 129,32,0,193,32,70,220,169,4,5,127,166,130,153,236,0
  db 76,148,193,224,36,208,30,173,76,2,208,3,76,85,218,32
  db 209,193,173,133,254,133,128,169,0,133,129,32,70,220,165,127
  db 9,2,76,235,215,224,35,208,18,76,132,203,169,2,141,150
  db 2,169,0,133,127,141,142,2,32,66,208,32,229,193,208,4
  db 162,0,240,12,138,240,5,169,48,76,200,193,136,240,1,136
  db 140,122,2,169,141,32,104,194,232,142,120,2,32,18,195,32
  db 202,195,32,157,196,162,0,142,88,2,142,151,2,142,74,2
  db 232,236,119,2,176,16,32,9,218,232,236,119,2,176,7,192
  db 4,240,62,32,9,218,174,76,2,134,131,224,2,176,18,142
  db 151,2,169,64,141,249,2,173,74,2,208,27,169,2,141,74
  db 2,173,74,2,208,17,165,231,41,7,141,74,2,173,128,2
  db 208,5,169,1,141,74,2,173,151,2,201,1,240,24,76,64
  db 217,188,122,2,185,0,2,141,88,2,173,128,2,208,183,169
  db 1,141,151,2,208,176,165,231,41,128,170,208,20,169,32,36
  db 231,240,6,32,182,200,76,227,217,173,128,2,208,3,76,227
  db 217,173,0,2,201,64,240,13,138,208,5,169,99,76,200,193
  db 169,51,76,200,193,165,231,41,7,205,74,2,208,103,201,4
  db 240,99,32,218,220,165,130,141,112,2,169,17,133,131,32,235
  db 208,173,148,2,32,200,212,160,0,177,148,9,32,145,148,160
  db 26,165,128,145,148,200,165,129,145,148,174,112,2,165,216,157
  db 96,2,165,221,157,102,2,32,59,222,32,100,212,76,239,217
  db 173,128,2,208,5,169,98,76,200,193,173,151,2,201,3,240
  db 11,169,32,36,231,240,5,169,96,76,200,193,165,231,41,7
  db 205,74,2,240,5,169,100,76,200,193,160,0,140,121,2,174
  db 151,2,224,2,208,26,201,4,240,235,177,148,41,79,145,148
  db 165,131,72,169,17,133,131,32,59,222,32,100,212,104,133,131
  db 32,160,217,173,151,2,201,2,208,85,32,42,218,76,148,193
  db 160,19,177,148,141,89,2,200,177,148,141,90,2,200,177,148
  db 174,88,2,141,88,2,138,240,10,205,88,2,240,5,169,80
  db 32,200,193,174,121,2,189,128,2,133,128,189,133,2,133,129
  db 32,70,220,164,130,174,121,2,181,216,153,96,2,181,221,153
  db 102,2,96,165,226,41,1,133,127,32,218,220,32,228,214,165
  db 131,201,2,176,17,32,62,222,165,128,133,126,165,127,141,110
  db 2,165,129,141,111,2,76,153,193,188,122,2,185,0,2,160
  db 4,136,48,8,217,178,254,208,248,140,151,2,160,5,136,48
  db 8,217,182,254,208,248,140,74,2,96,32,57,202,169,128,32
  db 166,221,240,246,32,149,222,166,129,232,138,208,5,32,163,209
  db 169,2,32,200,212,166,130,169,1,149,242,169,128,5,130,166
  db 131,157,43,2,96,169,12,141,42,2,169,0,174,116,2,202
  db 240,11,202,208,33,173,1,2,32,189,195,48,25,133,226,238
  db 119,2,238,120,2,238,122,2,169,128,133,231,169,42,141,0
  db 2,141,1,2,208,24,32,229,193,208,5,32,220,194,160,3
  db 136,136,140,122,2,32,0,194,32,152,195,32,32,195,32,202
  db 195,32,183,199,32,157,196,32,158,236,32,55,209,166,130,157
  db 62,2,165,127,141,142,2,9,4,149,236,169,0,133,163,96
  db 169,0,141,249,2,165,131,208,11,169,0,141,84,2,32,39
  db 210,76,218,212,201,15,240,20,32,2,219,165,131,201,2,144
  db 240,173,108,2,208,3,76,148,193,76,173,193,169,14,133,131
  db 32,2,219,198,131,16,249,173,108,2,208,3,76,148,193,76
  db 173,193,166,131,189,43,2,201,255,208,1,96,41,15,133,130
  db 32,37,209,201,7,240,15,201,4,240,17,32,7,209,176,9
  db 32,98,219,32,165,219,32,244,238,76,39,210,32,241,221,32
  db 30,207,32,203,225,166,213,134,115,230,115,169,0,133,112,133
  db 113,165,214,56,233,14,133,114,32,81,223,166,130,165,112,149
  db 181,165,113,149,187,169,64,32,166,221,240,3,32,165,219,76
  db 39,210,166,130,181,181,21,187,208,12,32,232,212,201,2,208
  db 5,169,13,32,241,207,32,232,212,201,2,208,15,32,30,207
  db 166,130,181,181,208,2,214,187,214,181,169,0,56,233,1,72
  db 169,0,32,200,212,32,241,207,104,32,241,207,32,199,208,32
  db 153,213,76,30,207,166,130,142,112,2,165,131,72,189,96,2
  db 133,129,189,102,2,141,148,2,181,236,41,1,133,127,173,133
  db 254,133,128,32,147,223,72,133,249,32,96,212,160,0,189,224
  db 254,133,135,173,148,2,133,134,177,134,41,32,240,67,32,37
  db 209,201,4,240,68,177,134,41,143,145,134,200,177,134,133,128
  db 132,113,160,27,177,134,72,136,177,134,208,10,133,128,104,133
  db 129,169,103,32,69,230,72,169,0,145,134,200,145,134,104,164
  db 113,145,134,200,177,134,133,129,104,145,134,32,125,200,76,41
  db 220,177,134,41,15,9,128,145,134,174,112,2,160,28,181,181
  db 145,134,200,181,187,145,134,104,170,169,144,5,127,32,144,213
  db 104,133,131,76,7,209,169,1,32,226,209,32,182,220,173,74
  db 2,72,10,5,127,149,236,32,155,208,166,130,165,128,208,5
  db 165,129,157,68,2,104,201,4,208,63,164,131,185,43,2,9
  db 64,153,43,2,173,88,2,149,199,32,142,210,16,3,76,15
  db 210,166,130,149,205,172,89,2,132,128,172,90,2,132,129,32
  db 211,214,32,115,222,32,153,213,166,130,169,2,149,193,169,0
  db 32,200,212,32,83,225,76,62,222,32,86,209,166,130,157,62
  db 2,169,136,149,242,96,166,130,181,167,10,168,169,2,153,153
  db 0,181,174,9,128,149,174,10,168,169,2,153,153,0,169,0
  db 149,181,149,187,169,0,157,68,2,96,32,169,241,169,1,32
  db 223,209,32,208,214,32,182,220,166,130,173,74,2,72,10,5
  db 127,149,236,104,201,4,240,5,169,1,149,242,96,164,131,185
  db 43,2,41,63,9,64,153,43,2,173,88,2,149,199,32,142
  db 210,16,3,76,15,210,166,130,149,205,32,193,222,32,30,241
  db 165,128,141,89,2,165,129,141,90,2,166,130,181,205,32,211
  db 214,169,0,32,233,222,169,0,32,141,221,169,17,32,141,221
  db 169,0,32,141,221,173,88,2,32,141,221,165,128,32,141,221
  db 165,129,32,141,221,169,16,32,233,222,32,62,222,165,128,32
  db 141,221,165,129,32,141,221,32,108,222,32,153,213,169,2,32
  db 200,212,166,130,56,169,0,245,199,149,193,32,226,226,32,25
  db 222,32,94,222,32,153,213,32,244,238,76,152,220,72,166,130
  db 181,205,76,253,207,144,6,166,130,21,236,208,6,166,130,73
  db 255,53,236,149,236,96,166,130,53,236,96,32,147,223,170,189
  db 91,2,41,240,201,144,96,162,0,134,113,189,43,2,201,255
  db 208,8,166,113,232,224,16,144,240,96,134,113,41,63,168,185
  db 236,0,41,1,133,112,174,83,2,181,226,41,1,197,112,208
  db 225,185,96,2,213,216,208,218,185,102,2,213,221,208,211,24
  db 96,32,158,223,80,6,32,94,222,32,153,213,96,32,43,222
  db 165,128,145,148,200,165,129,145,148,76,5,225,32,43,222,177
  db 148,133,128,200,177,148,133,129,96,32,43,222,169,0,145,148
  db 200,166,130,181,193,170,202,138,145,148,96,32,147,223,10,170
  db 181,154,133,149,169,0,133,148,160,0,96,32,235,208,32,147
  db 223,133,249,10,168,185,6,0,133,128,185,7,0,133,129,96
  db 169,144,141,77,2,208,40,169,128,141,77,2,208,33,169,144
  db 141,77,2,208,38,169,128,141,77,2,208,31,169,144,141,77
  db 2,208,2,169,128,141,77,2,166,130,181,205,170,16,19,32
  db 208,214,32,147,223,170,165,127,157,91,2,32,21,225,32,147
  db 223,170,76,6,213,169,0,32,200,212,32,55,209,133,128,32
  db 55,209,133,129,96,72,169,0,133,111,133,113,185,224,254,133
  db 112,189,224,254,133,114,104,168,136,177,111,145,113,136,16,249
  db 96,168,185,224,254,133,112,169,0,133,111,168,145,111,200,208
  db 251,96,169,0,32,220,222,160,2,177,148,96,133,148,166,130
  db 181,205,170,189,224,254,133,149,96,72,32,220,222,72,138,10
  db 170,104,149,154,104,149,153,96,32,102,223,48,14,80,19,166
  db 130,181,205,32,27,223,32,102,223,16,7,32,203,225,44,206
  db 254,96,165,214,32,233,222,44,205,254,96,133,249,169,128,208
  db 4,133,249,169,144,72,181,236,41,1,133,127,104,5,127,141
  db 77,2,177,148,133,128,200,177,148,133,129,165,249,32,211,214
  db 166,249,76,147,213,166,130,181,205,76,235,212,169,120,32,92
  db 223,202,16,248,165,114,74,32,92,223,165,115,24,101,112,133
  db 112,144,2,230,113,96,32,210,222,197,213,208,14,164,214,177
  db 148,240,4,44,205,254,96,44,207,254,96,165,213,201,6,176
  db 10,10,168,169,4,133,148,177,148,208,4,44,208,254,96,44
  db 206,254,96,166,130,181,167,16,2,181,174,41,191,96,166,130
  db 142,87,2,181,167,16,9,138,24,105,7,141,87,2,181,174
  db 133,112,41,31,36,112,96,166,130,181,167,48,2,181,174,201
  db 255,96,166,130,9,128,180,167,16,3,149,167,96,149,174,96
  db 169,32,32,157,221,169,128,32,166,221,208,65,166,130,246,181
  db 208,2,246,187,166,130,181,193,240,46,32,232,212,166,130,213
  db 193,144,3,32,60,224,166,130,181,193,32,200,212,161,153,133
  db 133,169,32,32,157,221,32,4,227,72,144,40,169,0,32,246
  db 212,208,33,104,201,2,240,18,169,128,32,151,221,32,47,209
  db 181,153,153,68,2,169,13,133,133,96,32,53,224,166,130,169
  db 0,149,193,96,104,166,130,149,193,76,110,225,32,211,209,32
  db 149,222,32,158,223,80,22,32,94,222,32,30,207,169,2,32
  db 200,212,32,171,221,208,36,32,87,222,76,153,213,32,30,207
  db 32,171,221,208,6,32,87,222,32,153,213,32,149,222,165,128
  db 240,9,32,30,207,32,87,222,32,30,207,96,32,5,225,32
  db 147,223,10,170,165,133,129,153,180,153,200,208,9,164,130,185
  db 193,0,240,10,160,2,152,164,130,217,193,0,208,5,169,32
  db 76,151,221,246,153,208,3,32,60,224,96,169,160,32,166,221
  db 208,39,165,133,32,124,224,165,248,240,13,96,169,32,32,166
  db 221,240,5,169,81,141,108,2,32,243,224,32,83,225,173,108
  db 2,240,3,76,200,193,76,188,230,41,128,208,5,165,248,240
  db 219,96,165,133,72,32,28,227,104,133,133,169,128,32,157,221
  db 76,178,224,169,32,32,166,221,208,10,169,0,133,133,32,124
  db 224,76,243,224,96,169,64,32,151,221,32,158,223,9,64,174
  db 87,2,149,167,96,32,158,223,41,191,174,87,2,149,167,96
  db 169,128,32,166,221,208,55,32,47,209,181,153,217,68,2,240
  db 34,246,153,208,6,32,60,224,32,47,209,161,153,153,62,2
  db 169,137,153,242,0,181,153,217,68,2,240,1,96,169,129,153
  db 242,0,96,32,208,223,32,47,209,165,133,76,61,225,166,130
  db 169,13,157,62,2,169,129,149,242,169,80,32,200,193,166,130
  db 181,193,133,135,198,135,201,2,208,4,169,255,133,135,181,199
  db 133,136,32,232,212,166,130,197,135,144,25,240,23,32,30,207
  db 32,178,225,144,8,166,130,157,68,2,76,30,207,32,30,207
  db 169,255,133,135,32,178,225,176,3,32,232,212,166,130,157,68
  db 2,96,32,43,222,164,135,177,148,208,13,136,192,2,144,4
  db 198,136,208,243,198,136,24,96,152,56,96,32,210,222,133,213
  db 169,4,133,148,160,10,208,4,136,136,48,38,177,148,240,248
  db 152,74,197,213,240,9,133,213,166,130,181,205,32,27,223,160
  db 0,132,148,177,148,208,11,200,177,148,168,136,132,214,152,76
  db 233,222,169,103,32,69,230,32,179,194,173,1,2,133,131,32
  db 235,208,144,5,169,112,32,200,193,169,160,32,157,221,32,37
  db 209,240,5,169,100,32,200,193,181,236,41,1,133,127,173,2
  db 2,149,181,173,3,2,149,187,166,130,169,137,149,242,173,4
  db 2,240,16,56,233,1,240,11,213,199,144,7,169,81,141,108
  db 2,169,0,133,212,32,14,206,32,248,222,80,8,169,128,32
  db 151,221,76,94,225,32,117,226,169,128,32,166,221,240,3,76
  db 94,225,76,148,193,32,156,226,165,215,32,200,212,166,130,181
  db 199,56,229,212,176,3,76,2,226,24,101,215,144,3,105,1
  db 56,32,9,224,76,56,225,169,81,32,200,193,165,148,133,137
  db 165,149,133,138,32,208,226,208,1,96,32,241,221,32,12,222
  db 165,128,240,14,32,211,226,208,6,32,30,207,76,218,210,32
  db 218,210,160,0,177,137,133,128,200,177,137,133,129,76,175,208
  db 32,62,222,160,0,177,137,197,128,240,1,96,200,177,137,197
  db 129,96,32,43,222,160,2,169,0,145,148,200,208,251,32,4
  db 227,149,193,168,169,255,145,148,32,4,227,144,244,208,4,169
  db 0,149,193,96,166,130,181,193,56,240,13,24,117,199,144,11
  db 208,6,169,2,44,204,254,96,105,1,56,96,32,211,209,32
  db 203,225,32,156,226,32,123,207,165,214,133,135,165,213,133,134
  db 169,0,133,136,169,0,133,212,32,14,206,32,77,239,164,130
  db 182,199,202,138,24,101,215,144,12,230,214,230,214,208,6,230
  db 213,169,16,133,214,165,135,24,105,2,32,233,222,165,213,201
  db 6,144,5,169,82,32,200,193,165,214,56,229,135,176,3,233
  db 15,24,133,114,165,213,229,134,133,115,162,0,134,112,134,113
  db 170,32,81,223,165,113,208,7,166,112,202,208,2,230,136,205
  db 115,2,144,9,208,205,173,114,2,197,112,144,198,169,1,32
  db 246,212,24,105,1,166,130,149,193,32,30,241,32,253,221,165
  db 136,208,21,32,94,222,32,30,207,32,208,214,32,30,241,32
  db 253,221,32,226,226,76,212,227,32,30,207,32,208,214,32,226
  db 226,32,25,222,32,94,222,32,12,222,165,128,72,165,129,72
  db 32,62,222,165,129,72,165,128,72,32,69,223,170,208,10,32
  db 78,228,169,16,32,233,222,230,134,104,32,141,221,104,32,141
  db 221,104,133,129,104,133,128,240,15,165,134,197,213,208,167,32
  db 69,223,197,214,144,160,240,176,32,69,223,72,169,0,32,220
  db 222,169,0,168,145,148,200,104,56,233,1,145,148,32,108,222
  db 32,153,213,32,244,238,32,14,206,32,30,207,32,248,222,112
  db 3,76,117,226,169,128,32,151,221,169,80,32,200,193,32,30
  db 241,32,30,207,32,241,221,32,147,223,72,32,193,222,166,130
  db 181,205,168,104,170,169,16,32,165,222,169,0,32,220,222,160
  db 2,177,148,72,169,0,32,200,212,104,24,105,1,145,148,10
  db 105,4,133,137,168,56,233,2,133,138,165,128,133,135,145,148
  db 200,165,129,133,136,145,148,160,0,152,145,148,200,169,17,145
  db 148,169,16,32,200,212,32,80,222,32,153,213,166,130,181,205
  db 72,32,158,223,166,130,149,205,104,174,87,2,149,167,169,0
  db 32,200,212,160,0,165,128,145,148,200,165,129,145,148,76,222
  db 228,32,147,223,166,130,32,27,223,169,0,32,200,212,198,138
  db 198,138,164,137,165,135,145,148,200,165,136,145,148,32,94,222
  db 32,153,213,164,138,192,3,176,216,76,30,207,0,160,79,203
  db 32,33,34,35,36,39,210,69,65,68,137,82,131,32,84,79
  db 79,32,76,65,82,71,197,80,139,6,32,80,82,69,83,69
  db 78,212,81,207,86,69,82,70,76,79,87,32,73,78,139,37
  db 40,138,137,38,138,32,80,82,79,84,69,67,84,32,79,206
  db 41,136,32,73,68,133,48,49,50,51,52,211,89,78,84,65
  db 88,137,96,138,3,132,99,131,32,69,88,73,83,84,211,100
  db 131,32,84,89,80,69,133,101,206,79,32,66,76,79,67,203
  db 102,103,201,76,76,69,71,65,76,32,84,82,65,67,75,32
  db 79,82,32,83,69,67,84,79,210,97,131,6,132,57,98,131
  db 6,135,1,131,83,32,83,67,82,65,84,67,72,69,196,112
  db 206,79,32,67,72,65,78,78,69,204,113,196,73,82,137,114
  db 136,32,70,85,76,204,115

  ;copyright message
  db 195,66,77,32,68,79,83,32,86
  db 50,46,54,32,49,53,53,177

  db 116,196,82,73,86,69,6,32
  db 82,69,65,68,217,9,197,82,82,79,210,10,215,82,73,84
  db 197,3,198,73,76,197,4,207,80,69,206,5,205,73,83,77
  db 65,84,67,200,6,206,79,212,7,198,79,85,78,196,8,196
  db 73,83,203,11,210,69,67,79,82,196,72,134,249,138,10,170
  db 181,6,133,128,181,7,133,129,104,41,15,240,8,201,15,208
  db 6,169,116,208,8,169,6,9,32,170,202,202,138,72,173,42
  db 2,201,0,208,15,169,255,141,42,2,104,32,199,230,32,66
  db 208,76,72,230,104,32,199,230,32,189,193,169,0,141,249,2
  db 32,44,193,32,218,212,169,0,133,163,162,69,154,165,132,41
  db 15,133,131,201,15,240,49,120,165,121,208,28,165,122,208,16
  db 166,131,189,43,2,201,255,240,31,41,15,133,130,76,142,230
  db 32,235,208,234,234,234,208,6,32,7,209,234,234,234,32,37
  db 209,201,4,176,3,32,39,210,76,231,235,170,169,0,248,224
  db 0,240,7,24,105,1,202,76,159,230,216,170,74,74,74,74
  db 32,180,230,138,41,15,9,48,145,165,200,96,32,35,193,169
  db 0,160,0,132,128,132,129,160,0,162,213,134,165,162,2,134
  db 166,32,171,230,169,44,145,165,200,173,213,2,141,67,2,138
  db 32,6,231,169,44,145,165,200,165,128,32,155,230,169,44,145
  db 165,200,165,129,32,155,230,136,152,24,105,213,141,73,2,230
  db 165,169,136,133,247,96,170,165,134,72,165,135,72,169,252,133
  db 134,169,228,133,135,138,162,0,193,134,240,33,72,32,117,231
  db 144,5,32,117,231,144,251,165,135,201,230,144,8,208,10,169
  db 10,197,134,144,4,104,76,24,231,104,76,77,231,32,103,231
  db 144,251,32,84,231,32,103,231,144,248,32,84,231,104,133,135
  db 104,133,134,96,201,32,176,11,170,169,32,145,165,200,138,32
  db 6,231,96,145,165,200,96,230,134,208,2,230,135,161,134,10
  db 161,134,41,127,96,32,109,231,230,134,208,2,230,135,96,96
  db 96,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,96,169,141,32,104,194,32,88,242,173,120,2,72,169
  db 1,141,120,2,169,255,133,134,32,79,196,173,128,2,208,5
  db 169,57,32,200,193,104,141,120,2,173,128,2,133,128,173,133
  db 2,133,129,169,3,32,119,212,169,0,133,135,32,57,232,133
  db 136,32,75,232,32,57,232,133,137,32,75,232,165,134,240,10
  db 165,136,72,165,137,72,169,0,133,134,32,57,232,133,138,32
  db 75,232,32,57,232,160,0,145,136,32,75,232,165,136,24,105
  db 1,133,136,144,2,230,137,198,138,208,231,32,53,202,165,133
  db 197,135,240,8,32,62,222,169,80,32,69,230,165,248,208,168
  db 104,133,137,104,133,136,108,136,0,32,53,202,165,248,208,8
  db 32,62,222,169,81,32,69,230,165,133,96,24,101,135,105,0
  db 133,135,96,173,1,24,169,1,133,124,96,120,169,0,133,124
  db 133,121,133,122,162,69,154,169,128,133,248,133,125,32,183,233
  db 32,165,233,173,0,24,9,16,141,0,24,173,0,24,16,87
  db 41,4,208,247,32,201,233,201,63,208,6,169,0,133,121,240
  db 113,201,95,208,6,169,0,133,122,240,103,197,120,208,10,169
  db 1,133,122,169,0,133,121,240,41,197,119,208,10,169,1,133
  db 121,169,0,133,122,240,27,170,41,96,201,96,208,63,138,133
  db 132,41,15,133,131,165,132,41,240,201,224,208,53,88,32,192
  db 218,0,44,0,24,48,173,169,0,133,125,173,0,24,41,239
  db 141,0,24,165,121,240,6,32,46,234,76,231,235,165,122,240
  db 9,32,156,233,32,174,233,32,9,233,76,78,234,169,16,141
  db 0,24,44,0,24,16,208,48,249

;120,32,235,208,176,6,166,130,181,242,48,1,0,133,122,189
;62,2,72,32,170,211,104,133,133,0,0,18,32,89,234,32
;192,233

  db 078h
  db 020h,0EBh,0D0h
  db 0B0h,013h
  db 0A6h,082h
  db 0B5h,0F2h
  db 010h,00Dh
  db 085h,07Ah
  db 0BDh,03Eh,002h
  db 048h
  db 020h,0AAh,0D3h
  db 068h
  db 085h,085h
  db 000h
  db 0A9h,000h
  db 085h,07Ah
  db 0A9h,0C3h
  db 085h,085h
  db 000h

  db 41,1,208,246,166
  db 130,181,242,41,8,208,20,32,89,234,32,192,233,41,1,208
  db 246,32,89,234,32,192,233,41,1,240,246,32,174,233,32,89
  db 234,32,192,233,41,1,208,243,169,8,133,152,32,192,233,41
  db 1,208,54,166,130,189,62,2,106,157,62,2,176,5,32,165
  db 233,208,3,32,156,233,32,183,233,165,35,208,3,32,243,254
  db 32,251,254,198,152,208,213,32,89,234,32,192,233,41,1,240
  db 246,88,32,170,211,120,76,15,233,76,78,234,173,0,24,41
  db 253,141,0,24,96,173,0,24,9,2,141,0,24,96,173,0
  db 24,9,8,141,0,24,96,173,0,24,41,247,141,0,24,96
  db 173,0,24,205,0,24,208,248,96,169,8,133,152,32,89,234
  db 32,192,233,41,4,208,246,32,156,233,169,1,76,32,255,32
  db 89,234,173,13,24,41,64,208,9,32,192,233,41,4,240,239
  db 208,25,32,165,233,162,10,202,208,253,32,156,233,32,89,234
  db 32,192,233,41,4,240,246,169,0,133,248,173,0,24,73,1
  db 74,41,2,208,246,234,234,234,102,133,32,89,234,32,192,233
  db 41,4,240,246,198,152,208,227,32,165,233,165,133,96,0,32
  db 7,209,176,5,181,242,106,176,11,165,132,41,240,201,240,240
  db 3,76,78,234,165,133,234,88,32,183,207,76,46,234,169,0
  db 141,0,24,76,231,235,76,91,232,165,125,240,6,173,0,24
  db 16,9,96,173,0,24,16,250,76,91,232,76,215,232,162,0
  db 44,166,111,154,186,169,8,13,0,28,76,234,254,152,24,105
  db 1,208,252,136,208,248,173,0,28,41,247,141,0,28,152,24
  db 105,1,208,252,136,208,248,202,16,219,224,252,208,240,240,212
  db 120,216,169,0,170,149,0,157,0,1,157,0,2,157,0,3
  db 157,0,4,157,0,5,157,0,6,157,0,7,232,208,230,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234
  db 234,234,162,69,154,173,0,28,41,247,141,0,28,169,1,141
  db 12,24,169,130,141,13,24,141,14,24,173,0,24,41,96,10
  db 42,42,42,9,72,133,120,73,96,133,119,162,0,160,0,169
  db 0,149,153,232,185,224,254,149,153,232,200,192,5,208,240,169
  db 0,149,153,232,169,2,149,153,232,169,213,149,153,232,169,2
  db 149,153,169,255,162,18,157,43,2,202,16,250,162,5,149,167
  db 149,174,149,205,202,16,247,169,5,133,171,169,6,133,172,169
  db 255,133,173,133,180,169,5,141,59,2,169,132,141,58,2,169
  db 15,141,86,2,169,1,133,246,169,136,133,247,169,224,141,79
  db 2,169,255,141,80,2,169,1,133,28,133,29,32,99,203,32
  db 250,206,32,89,242,169,34,133,101,169,235,133,102,169,10,133
  db 105,169,5,133,106,169,115,32,193,230,169,0,141,0,24,169
  db 26,141,2,24,32,128,231,88,173,0,24,41,229,141,0,24
  db 173,85,2,240,10,169,0,141,85,2,133,103,32,70,193,0
  db 165,124,240,3,76,91,232,88,169,14,133,114,169,0,133,111
  db 133,112,166,114,189,43,2,201,255,240,16,41,63,133,130,32
  db 147,223,170,189,91,2,41,1,170,246,111,198,114,16,227,160
  db 4,185,0,0,16,5,41,1,170,246,111,136,16,243,120,173
  db 0,28,41,247,72,165,127,133,134,169,0,133,127,165,111,240
  db 11,165,28,240,3,32,19,211,104,9,8,72,230,127,165,112
  db 240,11,165,29,240,3,32,19,211,104,9,0,72,165,134,133
  db 127,104,174,108,2,240,33,173,0,28,224,128,208,3,76,139
  db 236,174,5,24,48,18,162,160,142,5,24,206,108,2,208,8
  db 77,109,2,162,16,142,108,2,141,0,28,76,255,235,169,0
  db 133,131,169,1,32,226,209,169,0,32,200,212,166,130,169,0
  db 157,68,2,32,147,223,170,165,127,157,91,2,169,1,32,241
  db 207,169,4,32,241,207,169,1,32,241,207,32,241,207,173,114
  db 2,32,241,207,169,0,32,241,207,32,89,237,32,147,223,10
  db 170,214,153,214,153,169,0,32,241,207,169,1,32,241,207,32
  db 241,207,32,206,198,144,44,173,114,2,32,241,207,173,115,2
  db 32,241,207,32,89,237,169,0,32,241,207,208,221,32,147,223
  db 10,170,169,0,149,153,169,136,164,130,141,84,2,153,242,0
  db 165,133,96,173,114,2,32,241,207,173,115,2,32,241,207,32
  db 89,237,32,147,223,10,170,214,153,214,153,169,0,32,241,207
  db 32,241,207,32,241,207,32,147,223,10,168,185,153,0,166,130
  db 157,68,2,222,68,2,76,13,237,160,0,185,177,2,32,241
  db 207,200,192,27,208,245,96,32,55,209,240,1,96,133,133,164
  db 130,185,68,2,240,8,169,128,153,242,0,165,133,96,72,32
  db 234,236,104,96,32,209,193,32,66,208,169,64,141,249,2,32
  db 183,238,169,0,141,146,2,32,172,197,208,61,169,0,133,129
  db 173,133,254,133,128,32,229,237,169,0,141,249,2,32,255,238
  db 76,148,193,200,177,148,72,200,177,148,72,160,19,177,148,240
  db 10,133,128,200,177,148,133,129,32,229,237,104,133,129,104,133
  db 128,32,229,237,32,4,198,240,195,160,0,177,148,48,212,32
  db 182,200,76,212,237,32,95,213,32,144,239,32,117,212,169,0
  db 32,200,212,32,55,209,133,128,32,55,209,133,129,165,128,208
  db 3,76,39,210,32,144,239,32,77,212,76,238,237,32,18,195
  db 165,226,16,5,169,51,76,200,193,41,1,133,127,32,0,193
  db 165,127,10,170,172,123,2,204,116,2,240,26,185,0,2,149
  db 18,185,1,2,149,19,32,7,211,169,1,133,128,32,198,200
  db 32,5,240,76,86,238,32,66,208,166,127,189,1,1,205,213
  db 254,240,3,76,114,213,32,183,238,165,249,168,10,170,173,136
  db 254,149,153,174,122,2,169,27,32,110,198,160,18,166,127,173
  db 213,254,157,1,1,138,10,170,181,18,145,148,200,181,19,145
  db 148,200,200,169,50,145,148,200,173,213,254,145,148,160,2,145
  db 109,173,133,254,133,128,32,147,239,169,1,133,129,32,147,239
  db 32,255,238,32,5,240,160,1,169,255,145,109,32,100,212,198
  db 129,32,96,212,76,148,193,32,209,240,160,0,169,18,145,109
  db 200,152,145,109,200,200,200,169,0,133,111,133,112,133,113,152
  db 74,74,32,75,242,145,109,200,170,56,38,111,38,112,38,113
  db 202,208,246,181,111,145,109,200,232,224,3,144,246,192,144,144
  db 214,76,117,208,32,147,223,170,189,91,2,41,1,133,127,164
  db 127,185,81,2,208,1,96,169,0,153,81,2,32,58,239,165
  db 127,10,72,32,165,240,104,24,105,1,32,165,240,165,128,72
  db 169,1,133,128,10,10,133,109,32,32,242,230,128,165,128,205
  db 215,254,144,240,104,133,128,76,138,213,32,15,241,170,32,223
  db 240,166,249,189,224,254,133,110,169,0,133,109,96,166,127,189
  db 250,2,141,114,2,189,252,2,141,115,2,96,32,241,239,32
  db 207,239,56,208,34,177,109,29,233,239,145,109,32,136,239,164
  db 111,24,177,109,105,1,145,109,165,128,205,133,254,240,59,254
  db 250,2,208,3,254,252,2,96,166,127,169,1,157,81,2,96
  db 32,241,239,32,207,239,240,54,177,109,93,233,239,145,109,32
  db 136,239,164,111,177,109,56,233,1,145,109,165,128,205,133,254
  db 240,11,189,250,2,208,3,222,252,2,222,250,2,189,252,2
  db 208,12,189,250,2,201,3,176,5,169,114,32,199,230,96,32
  db 17,240,152,133,111,165,129,74,74,74,56,101,111,168,165,129
  db 41,7,170,177,109,61,233,239,96,1,2,4,8,16,32,64
  db 128,169,255,44,249,2,240,12,16,10,112,8,169,0,141,249
  db 2,76,138,213,96,32,58,239,160,0,152,145,109,200,208,251
  db 96,165,111,72,165,112,72,166,127,181,255,240,5,169,116,32
  db 72,230,32,15,241,133,111,138,10,133,112,170,165,128,221,157
  db 2,240,11,232,134,112,221,157,2,240,3,32,91,240,165,112
  db 166,127,157,155,2,10,10,24,105,161,133,109,169,2,105,0
  db 133,110,160,0,104,133,112,104,133,111,96,166,111,32,223,240
  db 165,127,170,10,29,155,2,73,1,41,3,133,112,32,165,240
  db 165,249,10,170,165,128,10,10,149,153,165,112,10,10,168,161
  db 153,153,161,2,169,0,129,153,246,153,200,152,41,3,208,239
  db 166,112,165,128,157,157,2,173,249,2,208,3,76,138,213,9
  db 128,141,249,2,96,168,185,157,2,240,37,72,169,0,153,157
  db 2,165,249,10,170,104,10,10,149,153,152,10,10,168,185,161
  db 2,129,153,169,0,153,161,2,246,153,200,152,41,3,208,238
  db 96,165,127,10,170,169,0,157,157,2,232,157,157,2,96,181
  db 167,201,255,208,37,138,72,32,142,210,170,16,5,169,112,32
  db 200,193,134,249,104,168,138,9,128,153,167,0,10,170,173,133
  db 254,149,6,169,0,149,7,76,134,213,41,15,133,249,96,169
  db 6,166,127,208,3,24,105,7,96,32,15,241,170,96,32,62
  db 222,169,3,133,111,169,1,13,249,2,141,249,2,165,111,72
  db 32,17,240,104,133,111,177,109,208,57,165,128,205,133,254,240
  db 25,144,28,230,128,165,128,205,215,254,208,225,174,133,254,202
  db 134,128,169,0,133,129,198,111,208,211,169,114,32,200,193,198
  db 128,208,202,174,133,254,232,134,128,169,0,133,129,198,111,208
  db 188,240,231,165,129,24,101,105,133,129,165,128,32,75,242,141
  db 78,2,141,77,2,197,129,176,12,56,165,129,237,78,2,133
  db 129,240,2,198,129,32,250,241,240,3,76,144,239,169,0,133
  db 129,32,250,241,208,244,76,245,241,169,1,13,249,2,141,249
  db 2,165,134,72,169,1,133,134,173,133,254,56,229,134,133,128
  db 144,9,240,7,32,17,240,177,109,208,27,173,133,254,24,101
  db 134,133,128,230,134,205,215,254,144,5,169,103,32,69,230,32
  db 17,240,177,109,240,210,104,133,134,169,0,133,129,32,250,241
  db 240,3,76,144,239,169,113,32,69,230,32,17,240,152,72,32
  db 32,242,165,128,32,75,242,141,78,2,104,133,111,165,129,205
  db 78,2,176,9,32,213,239,208,6,230,129,208,240,169,0,96
  db 165,111,72,169,0,133,111,172,134,254,136,162,7,177,109,61
  db 233,239,240,2,230,111,202,16,244,136,208,239,177,109,197,111
  db 208,4,104,133,111,96,169,113,32,69,230,174,214,254,221,214
  db 254,202,176,250,189,209,254,96,96,169,111,141,2,28,41,240
  db 141,0,28,173,12,28,41,254,9,14,9,224,141,12,28,169
  db 65,141,11,28,169,0,141,6,28,169,58,141,7,28,141,5
  db 28,169,127,141,14,28,169,192,141,13,28,141,14,28,169,255
  db 133,62,133,81,169,8,133,57,169,7,133,71,169,5,133,98
  db 169,250,133,99,169,200,133,100,169,4,133,94,169,4,133,95
  db 186,134,73,173,4,28,173,12,28,9,14,141,12,28,160,5
  db 185,0,0,16,46,201,208,208,4,152,76,112,243,41,1,240
  db 7,132,63,169,15,76,105,249,170,133,61,197,62,240,10,32
  db 126,249,165,61,133,62,76,156,249,165,32,48,3,10,16,9
  db 76,156,249,136,16,202,76,156,249,169,32,133,32,160,5,132
  db 63,32,147,243,48,26,198,63,16,247,164,65,32,149,243,165
  db 66,133,74,6,74,169,96,133,32,177,50,133,34,76,156,249
  db 41,1,197,61,208,224,165,34,240,18,56,241,50,240,13,73
  db 255,133,66,230,66,165,63,133,65,76,6,243,162,4,177,50
  db 133,64,221,214,254,202,176,250,189,209,254,133,67,138,10,10
  db 10,10,10,133,68,173,0,28,41,159,5,68,141,0,28,166
  db 61,165,69,201,64,240,21,201,96,240,3,76,177,243,165,63
  db 24,105,3,133,49,169,0,133,48,108,48,0,169,96,133,32
  db 173,0,28,41,252,141,0,28,169,164,133,74,169,1,133,34
  db 76,105,249,164,63,185,0,0,72,16,16,41,120,133,69,152
  db 10,105,6,133,50,152,24,105,3,133,49,160,0,132,48,104
  db 96,162,90,134,75,162,0,169,82,133,36,32,86,245,80,254
  db 184,173,1,28,197,36,208,63,80,254,184,173,1,28,149,37
  db 232,224,7,208,243,32,151,244,160,4,169,0,89,22,0,136
  db 16,250,201,0,208,56,166,62,165,24,149,34,165,69,201,48
  db 240,30,165,62,10,168,185,18,0,197,22,208,30,185,19,0
  db 197,23,208,23,76,35,244,198,75,208,176,169,2,32,105,249
  db 165,22,133,18,165,23,133,19,169,1,44,169,11,44,169,9
  db 76,105,249,169,127,133,76,165,25,24,105,2,197,67,144,2
  db 229,67,133,77,162,5,134,63,162,255,32,147,243,16,68,133
  db 68,41,1,197,62,208,60,160,0,177,50,197,64,208,52,165
  db 69,201,96,240,12,160,1,56,177,50,229,77,16,3,24,101
  db 67,197,76,176,30,72,165,69,240,20,104,201,9,144,20,201
  db 12,176,16,133,76,165,63,170,105,3,133,49,208,5,104,201
  db 6,144,240,198,63,16,179,138,16,3,76,156,249,134,63,32
  db 147,243,165,69,76,202,244,165,48,72,165,49,72,169,36,133
  db 48,169,0,133,49,169,0,133,52,32,230,247,165,85,133,24
  db 165,84,133,25,165,83,133,26,32,230,247,165,82,133,23,165
  db 83,133,22,104,133,49,104,133,48,96,201,0,240,3,76,110
  db 245,32,10,245,80,254,184,173,1,28,145,48,200,208,245,160
  db 186,80,254,184,173,1,28,153,0,1,200,208,244,32,224,248
  db 165,56,197,71,240,5,169,4,76,105,249,32,233,245,197,58
  db 240,3,169,5,44,169,1,76,105,249,32,16,245,76,86,245
  db 165,61,10,170,181,18,133,22,181,19,133,23,160,0,177,50
  db 133,24,200,177,50,133,25,169,0,69,22,69,23,69,24,69
  db 25,133,26,32,52,249,162,90,32,86,245,160,0,80,254,184
  db 173,1,28,217,36,0,208,6,200,192,8,208,240,96,202,208
  db 231,169,2,76,105,249,169,208,141,5,24,169,3,44,5,24
  db 16,241,44,0,28,48,246,173,1,28,184,160,0,96,201,16
  db 240,3,76,145,246,32,233,245,133,58,173,0,28,41,16,208
  db 5,169,8,76,105,249,32,143,247,32,16,245,162,9,80,254
  db 184,202,208,250,169,255,141,3,28,173,12,28,41,31,9,192
  db 141,12,28,169,255,162,5,141,1,28,184,80,254,184,202,208
  db 250,160,187,185,0,1,80,254,184,141,1,28,200,208,244,177
  db 48,80,254,184,141,1,28,200,208,245,80,254,173,12,28,9
  db 224,141,12,28,169,0,141,3,28,32,242,245,164,63,185,0
  db 0,73,48,153,0,0,76,177,243,169,0,168,81,48,200,208
  db 251,96,169,0,133,46,133,48,133,79,165,49,133,78,169,1
  db 133,49,133,47,169,187,133,52,133,54,32,230,247,165,82,133
  db 56,164,54,165,83,145,46,200,165,84,145,46,200,165,85,145
  db 46,200,132,54,32,230,247,164,54,165,82,145,46,200,165,83
  db 145,46,200,240,14,165,84,145,46,200,165,85,145,46,200,132
  db 54,208,225,165,84,145,48,200,165,85,145,48,200,132,54,32
  db 230,247,164,54,165,82,145,48,200,165,83,145,48,200,165,84
  db 145,48,200,165,85,145,48,200,132,54,192,187,144,225,169,69
  db 133,46,165,49,133,47,160,186,177,48,145,46,136,208,249,177
  db 48,145,46,162,187,189,0,1,145,48,200,232,208,247,134,80
  db 96,201,32,240,3,76,202,246,32,233,245,133,58,32,143,247
  db 32,10,245,160,187,185,0,1,80,254,184,77,1,28,208,21
  db 200,208,242,177,48,80,254,184,77,1,28,208,8,200,192,253
  db 208,241,76,24,244,169,7,76,105,249,32,16,245,76,24,244
  db 169,0,133,87,133,90,164,52,165,82,41,240,74,74,74,74
  db 170,189,127,247,10,10,10,133,86,165,82,41,15,170,189,127
  db 247,106,102,87,106,102,87,41,7,5,86,145,48,200,165,83
  db 41,240,74,74,74,74,170,189,127,247,10,5,87,133,87,165
  db 83,41,15,170,189,127,247,42,42,42,42,133,88,42,41,1
  db 5,87,145,48,200,165,84,41,240,74,74,74,74,170,189,127
  db 247,24,106,5,88,145,48,200,106,41,128,133,89,165,84,41
  db 15,170,189,127,247,10,10,41,124,5,89,133,89,165,85,41
  db 240,74,74,74,74,170,189,127,247,106,102,90,106,102,90,106
  db 102,90,41,3,5,89,145,48,200,208,4,165,47,133,49,165
  db 85,41,15,170,189,127,247,5,90,145,48,200,132,52,96,10
  db 11,18,19,14,15,22,23,9,25,26,27,13,29,30,21,169
  db 0,133,48,133,46,133,54,169,187,133,52,133,80,165,49,133
  db 47,169,1,133,49,165,71,133,82,164,54,177,46,133,83,200
  db 177,46,133,84,200,177,46,133,85,200,132,54,32,208,246,164
  db 54,177,46,133,82,200,240,17,177,46,133,83,200,177,46,133
  db 84,200,177,46,133,85,200,208,225,165,58,133,83,169,0,133
  db 84,133,85,76,208,246,164,52,177,48,41,248,74,74,74,133
  db 86,177,48,41,7,10,10,133,87,200,208,6,165,78,133,49
  db 164,79,177,48,41,192,42,42,42,5,87,133,87,177,48,41
  db 62,74,133,88,177,48,41,1,10,10,10,10,133,89,200,177
  db 48,41,240,74,74,74,74,5,89,133,89,177,48,41,15,10
  db 133,90,200,177,48,41,128,24,42,42,41,1,5,90,133,90
  db 177,48,41,124,74,74,133,91,177,48,41,3,10,10,10,133
  db 92,200,208,6,165,78,133,49,164,79,177,48,41,224,42,42
  db 42,42,5,92,133,92,177,48,41,31,133,93,200,132,52,166
  db 86,189,160,248,166,87,29,192,248,133,82,166,88,189,160,248
  db 166,89,29,192,248,133,83,166,90,189,160,248,166,91,29,192
  db 248,133,84,166,92,189,160,248,166,93,29,192,248,133,85,96
  db 255,255,255,255,255,255,255,255,255,128,0,16,255,192,64,80
  db 255,255,32,48,255,240,96,112,255,144,160,176,255,208,224,255
  db 255,255,255,255,255,255,255,255,255,8,0,1,255,12,4,5
  db 255,255,2,3,255,15,6,7,255,9,10,11,255,13,14,255
  db 169,0,133,52,133,46,133,54,169,1,133,78,169,186,133,79
  db 165,49,133,47,32,230,247,165,82,133,56,164,54,165,83,145
  db 46,200,165,84,145,46,200,165,85,145,46,200,132,54,32,230
  db 247,164,54,165,82,145,46,200,240,17,165,83,145,46,200,165
  db 84,145,46,200,165,85,145,46,200,208,225,165,83,133,58,165
  db 47,133,49,96,165,49,133,47,169,0,133,49,169,36,133,52
  db 165,57,133,82,165,26,133,83,165,25,133,84,165,24,133,85
  db 32,208,246,165,23,133,82,165,22,133,83,169,0,133,84,133
  db 85,32,208,246,165,47,133,49,96,164,63,153,0,0,165,80
  db 240,3,32,242,245,32,143,249,166,73,154,76,190,242,169,160
  db 133,32,173,0,28,9,4,141,0,28,169,60,133,72,96,166
  db 62,165,32,9,16,133,32,169,255,133,72,96,173,7,28,141
  db 5,28,173,0,28,41,16,197,30,133,30,240,4,169,1,133
  db 28,173,254,2,240,21,201,2,208,7,169,0,141,254,2,240
  db 10,133,74,169,2,141,254,2,76,46,250,166,62,48,7,165
  db 32,168,201,32,208,3,76,190,250,198,72,208,29,152,16,4
  db 41,127,133,32,41,16,240,18,173,0,28,41,251,141,0,28
  db 169,255,133,62,169,0,133,32,240,220,152,41,64,208,3,76
  db 190,250,108,98,0,165,74,16,5,73,255,24,105,1,197,100
  db 176,10,169,59,133,98,169,250,133,99,208,18,229,94,229,94
  db 133,97,165,94,133,96,169,123,133,98,169,250,133,99,165,74
  db 16,49,230,74,174,0,28,202,76,105,250,165,74,208,239,169
  db 78,133,98,169,250,133,99,169,5,133,96,76,190,250,198,96
  db 208,108,165,32,41,191,133,32,169,5,133,98,169,250,133,99
  db 76,190,250,198,74,174,0,28,232,138,41,3,133,75,173,0
  db 28,41,252,5,75,141,0,28,76,190,250,56,173,7,28,229
  db 95,141,5,28,198,96,208,12,165,94,133,96,169,151,133,98
  db 169,250,133,99,76,46,250,198,97,208,249,169,165,133,98,169
  db 250,133,99,208,239,173,7,28,24,101,95,141,5,28,198,96
  db 208,226,169,78,133,98,169,250,133,99,169,5,133,96,173,12
  db 28,41,253,141,12,28,96,165,81,16,42,166,61,169,96,149
  db 32,169,1,149,34,133,81,169,164,133,74,173,0,28,41,252
  db 141,0,28,169,10,141,32,6,169,160,141,33,6,169,15,141
  db 34,6,76,156,249,160,0,209,50,240,5,145,50,76,156,249
  db 173,0,28,41,16,208,5,169,8,76,211,253,32,163,253,32
  db 195,253,169,85,141,1,28,32,195,253,32,0,254,32,86,245
  db 169,64,13,11,24,141,11,24,169,98,141,6,24,169,0,141
  db 7,24,141,5,24,160,0,162,0,44,0,28,48,251,44,0
  db 28,16,251,173,4,24,44,0,28,16,17,173,13,24,10,16
  db 245,232,208,239,200,208,236,169,2,76,211,253,134,113,132,114
  db 162,0,160,0,173,4,24,44,0,28,48,17,173,13,24,10
  db 16,245,232,208,239,200,208,236,169,2,76,211,253,56,138,229
  db 113,170,133,112,152,229,114,168,133,113,16,11,73,255,168,138
  db 73,255,170,232,208,1,200,152,208,4,224,4,144,24,6,112
  db 38,113,24,165,112,109,33,6,141,33,6,165,113,109,34,6
  db 141,34,6,76,12,251,162,0,160,0,184,173,0,28,16,14
  db 80,249,184,232,208,245,200,208,242,169,3,76,211,253,138,10
  db 141,37,6,152,42,141,36,6,169,191,45,11,24,141,11,24
  db 169,102,141,38,6,166,67,160,0,152,24,109,38,6,144,1
  db 200,200,202,208,245,73,255,56,105,0,24,109,37,6,176,3
  db 206,36,6,170,152,73,255,56,105,0,24,109,36,6,16,5
  db 169,4,76,211,253,168,138,162,0,56,229,67,176,3,136,48
  db 3,232,208,245,142,38,6,224,4,176,5,169,5,76,211,253
  db 24,101,67,141,39,6,169,0,141,40,6,160,0,166,61,165
  db 57,153,0,3,200,200,173,40,6,153,0,3,200,165,81,153
  db 0,3,200,181,19,153,0,3,200,181,18,153,0,3,200,169
  db 15,153,0,3,200,153,0,3,200,169,0,89,250,2,89,251
  db 2,89,252,2,89,253,2,153,249,2,238,40,6,173,40,6
  db 197,67,144,187,152,72,232,138,157,0,5,232,208,250,169,3
  db 133,49,32,48,254,104,168,136,32,229,253,32,245,253,169,5
  db 133,49,32,233,245,133,58,32,143,247,169,0,133,50,32,14
  db 254,169,255,141,1,28,162,5,80,254,184,202,208,250,162,10
  db 164,50,80,254,184,185,0,3,141,1,28,200,202,208,243,162
  db 9,80,254,184,169,85,141,1,28,202,208,245,169,255,162,5
  db 80,254,184,141,1,28,202,208,247,162,187,80,254,184,189,0
  db 1,141,1,28,232,208,244,160,0,80,254,184,177,48,141,1
  db 28,200,208,245,169,85,174,38,6,80,254,184,141,1,28,202
  db 208,247,165,50,24,105,10,133,50,206,40,6,208,147,80,254
  db 184,80,254,184,32,0,254,169,200,141,35,6,169,0,133,48
  db 169,3,133,49,165,67,141,40,6,32,86,245,162,10,160,0
  db 80,254,184,173,1,28,209,48,208,14,200,202,208,242,24,165
  db 48,105,10,133,48,76,98,253,206,35,6,208,207,169,6,76
  db 211,253,32,86,245,160,187,80,254,184,173,1,28,217,0,1
  db 208,230,200,208,242,162,252,80,254,184,173,1,28,217,0,5
  db 208,214,200,202,208,241,206,40,6,208,174,230,81,165,81,201
  db 36,176,3,76,156,249,169,255,133,81,169,0,133,80,169,1
  db 76,105,249,173,12,28,41,31,9,192,141,12,28,169,255,141
  db 3,28,141,1,28,162,40,160,0,80,254,184,136,208,250,202
  db 208,247,96,174,33,6,172,34,6,80,254,184,202,208,250,136
  db 16,247,96,206,32,6,240,3,76,156,249,160,255,132,81,200
  db 132,80,76,105,249,185,0,3,153,69,3,136,208,247,173,0
  db 3,141,69,3,96,160,68,185,187,1,145,48,136,16,248,96
  db 173,12,28,9,224,141,12,28,169,0,141,3,28,96,173,12
  db 28,41,31,9,192,141,12,28,169,255,141,3,28,169,85,141
  db 1,28,162,40,160,0,80,254,184,136,208,250,202,208,247,96
  db 169,0,133,48,133,46,133,54,169,187,133,52,165,49,133,47
  db 169,1,133,49,164,54,177,46,133,82,200,177,46,133,83,200
  db 177,46,133,84,200,177,46,133,85,200,240,8,132,54,32,208
  db 246,76,68,254,76,208,246,72,138,72,152,72,173,13,24,41
  db 2,240,3,32,83,232,173,13,28,10,16,3,32,176,242,104
  db 168,104,170,104,64,18,4,4,144,86,73,68,77,66,85,80
  db 38,67,82,83,78,132,5,193,248,27,92,7,163,240,136,35
  db 13,237,208,200,202,204,203,226,231,200,202,200,238,81,221,28
  db 158,28,82,87,65,77,68,83,80,85,76,68,83,80,85,82
  db 69,69,82,83,69,76,81,71,82,76,8,0,0,63,127,191
  db 255,17,18,19,21,65,4,36,31,25,18,1,255,255,1,0
  db 3,4,5,6,7,7,62,108,101,0,141,0,28,141,2,28
  db 76,125,234,138,162,5,202,208,253,170,96,32,174,233,76,156
  db 233,173,2,2,201,45,240,5,56,233,43,208,218,133,35,96
  db 142,3,24,169,2,141,0,24,169,26,141,2,24,76,167,234
  db 173,0,24,41,1,208,249,169,1,141,5,24,76,223,233,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
  db 170,170,170,170,170,170,198,200,143,249,95,205,151,205,0,5
  db 3,5,6,5,9,5,12,5,15,5,1,255,160,234,103,254
VC1541ROM ends

IMAGE_TEXT segment para public use16 'CODE'
  assume CS:IMAGE_TEXT

;Adressierung implied
GETn macro
  READ equ <>
  WRITE equ <>
  DATA equ <Akku>
endm

;Adressierung Byte (immediate)
GETb macro
  READ equ <>
  WRITE equ <>
  DATA equ <AL>
  mov AL,FS:[SI]                        ;Nchstes Byte nach AL holen
  inc SI
endm

;Adressierung Zeropage
GETz macro
  READ equ <READz>
  WRITE equ <WRITEz>
  DATA equ <AL>
  mov BL,FS:[SI]                        ;Adresse nach BX holen
  xor BH,BH
  inc SI                                ;PC weiterzhlen
endm

;Adressierung Zeropage,X
GETzx macro
  READ equ <READz>
  WRITE equ <WRITEz>
  DATA equ <AL>
  mov BL,FS:[SI]                        ;Adresse nach BX holen
  xor BH,BH
  inc SI                                ;PC weiterzhlen
  add BL,XReg                           ;X-Register addieren
endm

;Adressierung Zeropage,Y
GETzy macro
  READ equ <READz>
  WRITE equ <WRITEz>
  DATA equ <AL>
  mov BL,FS:[SI]                        ;Adresse nach BX holen
  xor BH,BH
  inc SI                                ;PC weiterzhlen
  add BL,YReg                           ;Y-Register addieren
endm

;Adressierung absolute
GETa macro
  READ equ <READa>
  WRITE equ <WRITEa>
  DATA equ <AL>
  mov BX,FS:[SI]                        ;Adresse nach BX holen
  add SI,2                              ;PC weiterzhlen
endm

;Adressierung absolute,X
GETax macro
  READ equ <READa>
  WRITE equ <WRITEa>
  DATA equ <AL>
  mov BX,FS:[SI]                        ;Basisadresse nach BX holen
  add SI,2                              ;PC weiterzhlen
  add BX,XWord                          ;X-Register addieren
endm

;Adressierung absolute,Y
GETay macro
  READ equ <READa>
  WRITE equ <WRITEa>
  DATA equ <AL>
  mov BX,FS:[SI]                        ;Basisadresse nach BX holen
  add SI,2                              ;PC weiterzhlen
  add BX,YWord                          ;Y-Register addieren
endm

;Adressierung indirect
GETi macro
  local Continue
  READ equ <>
  WRITE equ <>
  DATA equ <>
  mov BX,FS:[SI]                        ;Zeiger nach BX holen
  add SI,2                              ;PC weiterzhlen
  mov GS,wROMSeg                        ;ROM als Vorgabe annehmen
  cmp BX,0C000h
  jae Continue
  mov AX,ES                             ;Zeiger im RAM
  mov GS,AX
Continue:
  mov AL,GS:[BX]                        ;Adresse nach BX holen
  inc BL
  mov BH,GS:[BX]
  mov BL,AL
endm

;Adressierung indirect,X
GETix macro
  READ equ <READa>
  WRITE equ <WRITEa>
  DATA equ <AL>
  mov BL,FS:[SI]                        ;Zeiger nach BX holen
  xor BH,BH
  inc SI                                ;PC weiterzhlen
  add BL,XReg                           ;X-Register addieren
  mov BX,ES:[BX]                        ;Adresse nach BX holen
endm

;Adressierung indirect,Y
GETiy macro
  READ equ <READa>
  WRITE equ <WRITEa>
  DATA equ <AL>
  mov BL,FS:[SI]                        ;Zeiger nach BX holen
  xor BH,BH
  inc SI                                ;PC weiterzhlen
  mov BX,ES:[BX]                        ;Basisadresse nach BX
  add BX,YWord                          ;Y-Register addieren
endm

;Adressierung relative
GETr macro
  READ equ <>
  WRITE equ <>
  DATA equ <>
  movsx AX,byte ptr FS:[SI]             ;Sprungdistanz nach AX holen
  inc SI                                ;PC weiterzhlen
endm

;Branch-Befehle anhand von ZF ausfhren
BRANCH macro Cond
  local Skip
  ifidni <Cond>,<set>
    je Skip                             ;Sprung nicht ausfhren
  elseifidni <Cond>,<clear>
    jne Skip                            ;Sprung nicht ausfhren
  else
    .err <BRANCH condition must be SET or CLEAR>
  endif
  add SI,AX                             ;Distanz zu PC addieren
Skip:
endm

;Byte an Adresse BX lesen
READa macro
  local Continue,ReadROM
  and BX,BX
  js ReadROM
  mov AL,ES:[BX]                        ;Lesen aus RAM
  cmp BX,0800h
  jb Continue
  xor AL,AL                             ;Lesen aus undefiniertem Bereich
  jmp Continue
ReadROM:
  mov DI,VC1541ROM
  mov GS,DI
  mov DI,BX
  and DI,3FFFh
  mov AL,GS:[DI]                        ;Lesen aus ROM
Continue:
endm

;Byte aus Zeropage lesen
READz macro
  mov AL,ES:[BX]                        ;Direkter Speicherzugriff ohne IO
endm

;Byte an Adresse BX schreiben
WRITEa macro
  local Continue
  cmp BX,0800h                          ;Auerhalb des RAM?
  jae Continue
  mov ES:[BX],AL                        ;Sonst Wert ganz normal schreiben
  cmp BX,5                              ;Ist ein Job zu erledigen?
  jae Continue
  call NewJob
Continue:
endm

;Byte in Zeropage schreiben
WRITEz macro
  local Continue
  mov ES:[BX],AL                        ;Wert ins RAM schreiben
  cmp BX,5                              ;Ist ein Job zu erledigen?
  jae Continue
  call NewJob
Continue:
endm

;Sign Flag und Zero Flag setzen
SETSZ macro
  lahf                                  ;Flags nach AH holen
  mov SignZero,AH                       ;SF und ZF setzen
endm

;Sign Flag, Zero Flag und Carry Flag setzen
SETSZC macro
  lahf                                  ;Flags nach AH holen
  mov SignZero,AH                       ;SF und ZF setzen
  mov DL,AH                             ;CF setzen (Bit 0)
endm

;Sign Flag, Zero Flag, Carry Flag und Overflow Flag setzen
SETSZCV macro
  lahf                                  ;Flags nach AH holen
  mov SignZero,AH                       ;SF und ZF setzen
  mov DL,AH                             ;CF setzen (Bit 0)
  seto Overflow                         ;VF setzen (Bit 0)
endm

;Nchsten Befehl holen und ausfhren
NEXTCMD macro
  cmp fCtrlBreak,0                      ;Auf Abbruch prfen
  jne ???
  mov CL,FS:[SI]                        ;Nchstes Befehlsbyte nach AX
  inc SI
  xor CH,CH
  jmp awCommands[ECX*2]                 ;Befehl ausfhren
endm

;FS an Sprungadresse in SI anpassen (ndert BX,FS)
JUMP macro
  local Continue
  mov FS,wROMSeg                        ;Als Vorgabe Code im ROM
  cmp SI,0C000h
  jae Continue
  cmp SI,0800h                          ;Falls nicht im RAM, dann Absturz
  jae ???
  mov BX,ES                             ;Code im RAM
  mov FS,BX
Continue:
endm

;Flags nach AL holen (ndert AX,CX)
GETFLAGS macro
  mov AX,Flags_SignZero                 ;nz********1bdi**
  shld CX,AX,3                          ;**************z*
  mov CH,Overflow                       ;*******v******z*
  shl CH,6                              ;*v************z*
  and AX,1000000000111100b              ;n---------1bdi--
  and CX,0100000000000010b              ;-v------------z-
  and DL,00000001b                      ;-------c
  or AX,CX                              ;nv--------1bdiz-
  or AL,AH                              ;nv1bdiz-
  or AL,DL                              ;nv1bdizc
endm

;Flags in AL setzen (ndert AX,CX)
SETFLAGS macro
  mov DL,AL                             ;*******c
  shrd CX,AX,14                         ;******nv****z***
  mov Overflow,CH                       ;*******v
  mov AH,AL                             ;n*****z*n*****z*
  and AH,10000010b                      ;n-----z-
  shld CX,AX,13                         ;***n-----z-*****
  or AH,CL                              ;nz-*****
  or AL,00110000b                       ;**11di** Break-Flag ist immer gesetzt
  mov Flags_SignZero,AX                 ;nz-*******1bdi**
endm

;Befehl mit verschiedenen Adressierungsarten definieren
CMD macro Name,AdrList
  Name1 substr <Name>,1,1
  Name2 substr <Name>,2,1
  Name3 substr <Name>,3,1
  NameStr catstr <'>,Name3,Name2,Name1,< '>
  irp i,<AdrList>
    Ticks substr <i>,1,1
    TicksStr catstr <'>,Ticks,<'>
    Adr substr <i>,2
    ProcName catstr <Name>,Adr
    GetAdr catstr <GET>,Adr
    ProcName proc near
      GetAdr
      ACTION                            ;Eigentliche Befehlsfolge ausfhren
      NEXTCMD                           ;Nchsten Befehl ausfhren
    ProcName endp
  endm
endm

;Adressen der emulierten Befehle
awCommands label word
  dw BRKn ,ORAix,???  ,???  ,???  ,ORAz ,ASLz ,???   ;00
  dw PHPn ,ORAb ,ASLn ,???  ,???  ,ORAa ,ASLa ,???
  dw BPLr ,ORAiy,???  ,???  ,???  ,ORAzx,ASLzx,???   ;10
  dw CLCn ,ORAay,???  ,???  ,???  ,ORAax,ASLax,???
  dw JSRa ,ANDix,???  ,???  ,BITz ,ANDz ,ROLz ,???   ;20
  dw PLPn ,ANDb ,ROLn ,???  ,BITa ,ANDa ,ROLa ,???
  dw BMIr ,ANDiy,???  ,???  ,???  ,ANDzx,ROLzx,???   ;30
  dw SECn ,ANDay,???  ,???  ,???  ,ANDax,ROLax,???
  dw RTIn ,EORix,???  ,???  ,???  ,EORz ,LSRz ,???   ;40
  dw PHAn ,EORb ,LSRn ,???  ,JMPa ,EORa ,LSRa ,???
  dw BVCr ,EORiy,???  ,???  ,???  ,EORzx,LSRzx,???   ;50
  dw CLIn ,EORay,???  ,???  ,???  ,EORax,LSRax,???
  dw RTSn ,ADCix,???  ,???  ,???  ,ADCz ,RORz ,???   ;60
  dw PLAn ,ADCb ,RORn ,???  ,JMPi ,ADCa ,RORa ,???
  dw BVSr ,ADCiy,???  ,???  ,???  ,ADCzx,RORzx,???   ;70
  dw SEIn ,ADCay,???  ,???  ,???  ,ADCax,RORax,???
  dw ???  ,STAix,???  ,???  ,STYz ,STAz ,STXz ,???   ;80
  dw DEYn ,???  ,TXAn ,???  ,STYa ,STAa ,STXa ,???
  dw BCCr ,STAiy,???  ,???  ,STYzx,STAzx,STXzy,???   ;90
  dw TYAn ,STAay,TXSn ,???  ,STYax,STAax,STXay,???
  dw LDYb ,LDAix,LDXb ,???  ,LDYz ,LDAz ,LDXz ,???   ;A0
  dw TAYn ,LDAb ,TAXn ,???  ,LDYa ,LDAa ,LDXa ,???
  dw BCSr ,LDAiy,???  ,???  ,LDYzx,LDAzx,LDXzy,???   ;B0
  dw CLVn ,LDAay,TSXn ,???  ,LDYax,LDAax,LDXay,???
  dw CPYb ,CMPix,???  ,???  ,CPYz ,CMPz ,DECz ,???   ;C0
  dw INYn ,CMPb ,DEXn ,???  ,CPYa ,CMPa ,DECa ,???
  dw BNEr ,CMPiy,???  ,???  ,???  ,CMPzx,DECzx,???   ;D0
  dw CLDn ,CMPay,???  ,???  ,???  ,CMPax,DECax,???
  dw CPXb ,SBCix,???  ,???  ,CPXz ,SBCz ,INCz ,???   ;E0
  dw INXn ,SBCb ,NOPn ,???  ,CPXa ,SBCa ,INCa ,???
  dw BEQr ,SBCiy,???  ,???  ,???  ,SBCzx,INCzx,???   ;F0
  dw SEDn ,SBCay,???  ,???  ,???  ,SBCax,INCax,???

;Addition Akkumulator mit bertrag
ACTION macro
  READ                                  ;Operand lesen
  test Flags,00001000b                  ;Auf Dezimalmodus prfen
  jne @@Dec
  shr DL,1                              ;CF holen
  adc Akku,DATA                         ;Addition ausfhren
  jmp @@NoDec
align 4
@@Dec:
  shr DL,1                              ;CF holen
  adc DATA,Akku                         ;Addition ausfhren
  daa                                   ;Ergebnis ins Dezimalformat wandeln
  mov Akku,DATA                         ;Ergebnis zurckschreiben
@@NoDec:
  SETSZCV                               ;Vernderte Flags setzen
  endm
CMD ADC,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;Und-Verknpfung Akkumulator
ACTION macro
  READ                                  ;Operand lesen
  and Akku,DATA                         ;Verknpfung ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD AND,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;Schieben um eine Stelle nach links
ACTION macro
  READ                                  ;Alten Wert lesen
  shl DATA,1                            ;Verschiebung ausfhren
  SETSZC                                ;Vernderte Flags setzen
  WRITE                                 ;Neuen Wert zurckschreiben
  endm
CMD ASL,<2n,5z,6zx,6a,7ax>

;Sprung wenn Carry gelscht
ACTION macro
  test DL,00000001b                     ;CF prfen
  BRANCH clear                          ;Sprung falls Flag gelscht
  endm
CMD BCC,<2r>

;Sprung wenn Carry gesetzt
ACTION macro
  test DL,00000001b                     ;CF prfen
  BRANCH set                            ;Sprung falls Flag gesetzt
  endm
CMD BCS,<2r>

;Sprung wenn gleich
ACTION macro
  test SignZero,01000000b               ;ZF prfen
  BRANCH set                            ;Sprung falls Flag gesetzt
  endm
CMD BEQ,<2r>

;Bits testen
ACTION macro
  READ                                  ;Operand leden
  test Akku,DATA                        ;Test ausfhren
  lahf                                  ;ZF nach AH holen
  test DATA,01000000b                   ;Datenbit 6 nach VF holen
  setne Overflow
  and DATA,10000000b                    ;Datenbit 7 nach SF holen
  and AH,01000000b
  or AH,DATA
  mov SignZero,AH                       ;SF und ZF setzen
  endm
CMD BIT,<3z,4a>

;Sprung wenn negativ
ACTION macro
  test SignZero,10000000b               ;SF prfen
  BRANCH set                            ;Sprung falls Flag gesetzt
  endm
CMD BMI,<2r>

;Sprung wenn ungleich
ACTION macro
  test SignZero,01000000b               ;ZF prfen
  BRANCH clear                          ;Sprung falls Flag gelscht
  endm
CMD BNE,<2r>

;Sprung wenn positiv
ACTION macro
  test SignZero,10000000b               ;SF prfen
  BRANCH clear                          ;Sprung falls Flag gelscht
  endm
CMD BPL,<2r>

;Sprung wenn kein berlauf
ACTION macro
  test Overflow,00000001b               ;VF prfen
  BRANCH clear                          ;Sprung falls Flag gelscht
  endm
CMD BVC,<2r>

;Sprung wenn berlauf
ACTION macro
  test Overflow,00000001b               ;VF prfen
  BRANCH set                            ;Sprung falls Flag gesetzt
  endm
CMD BVS,<2r>

;CF lschen
ACTION macro
  xor DL,DL
  endm
CMD CLC,<2n>

;Dezimalmodus ausschalten
ACTION macro
  and Flags,11110111b
  endm
CMD CLD,<2n>

;Interrupts einschalten
ACTION macro
  and Flags,11111011b                   ;IF lschen
  endm
CMD CLI,<2n>

;VF lschen
ACTION macro
  mov Overflow,00000000b
  endm
CMD CLV,<2n>

;Akku mit Wert vergleichen
ACTION macro
  READ                                  ;Operand lesen
  cmp Akku,DATA                         ;Vergleich ausfhren
  cmc                                   ;Subtraktion 8086->6502
  SETSZC                                ;Vernderte Flags setzen
  endm
CMD CMP,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;X-Register mit Wert vergleichen
ACTION macro
  READ                                  ;Operand lesen
  cmp XReg,DATA                         ;Vergleich ausfhren
  cmc                                   ;Subtraktion 8086->6502
  SETSZC                                ;Vernderte Flags setzen
  endm
CMD CPX,<2b,3z,4a>

;X-Register mit Wert vergleichen
ACTION macro
  READ                                  ;Operand lesen
  cmp YReg,DATA                         ;Vergleich ausfhren
  cmc                                   ;Subtraktion 8086->6502
  SETSZC                                ;Vernderte Flags setzen
  endm
CMD CPY,<2b,3z,4a>

;Wert um 1 verringern
ACTION macro
  READ                                  ;Alten Wert lesen
  dec DATA                              ;Operation ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  WRITE                                 ;Neuen Wert zurckschreiben
  endm
CMD DEC,<5z,6zx,6a,7ax>

;X-Register um 1 verringern
ACTION macro
  dec XReg                              ;Operation ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD DEX,<2n>

;Y-Register um 1 verringern
ACTION macro
  dec YReg                              ;Operation ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD DEY,<2n>

;Exclusiv-Oder-Verknpfung Akkumulator
ACTION macro
  READ                                  ;Operand lesen
  xor Akku,DATA                         ;Verknpfung ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD EOR,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;Wert um 1 erhhen
ACTION macro
  READ                                  ;Alten Wert lesen
  inc DATA                              ;Operation ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  WRITE                                 ;Neuen Wert zurckschreiben
  endm
CMD INC,<5z,6zx,6a,7ax>

;X-Register um 1 erhhen
ACTION macro
  inc XReg                              ;Operation ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD INX,<2n>

;Y-Register um 1 erhhen
ACTION macro
  inc YReg                              ;Operation ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD INY,<2n>

;Unbedingter Sprung
ACTION macro
  mov SI,BX                             ;Sprung ausfhren
  JUMP                                  ;Speicherbasis angleichen
  endm
CMD JMP,<3a,6i>

;Aufruf eines Unterprogramms
ACTION macro
  mov AX,SI                             ;Alte Adresse holen
  mov SI,BX                             ;Sprung ausfhren
  dec AX                                ;Der 6502 verringert den Wert um 1
  mov BX,StackPtr                       ;Alte Adresse auf Stapel
  mov ES:[BX],AH
  dec BL
  mov ES:[BX],AL
  dec BL
  mov StackPtr,BX
  JUMP                                  ;Speicherbasis angleichen
  endm
CMD JSR,<6a>

;Akkumulator laden
ACTION macro
  READ                                  ;Operand lesen
  mov Akku,DATA                         ;und bertragen
  and DATA,DATA                         ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD LDA,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;X-Register laden
ACTION macro
  READ                                  ;Operand lesen
  mov XReg,DATA                         ;und bertragen
  and DATA,DATA                         ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD LDX,<2b,3z,4zy,4a,4ay>

;Y-Register laden
ACTION macro
  READ                                  ;Operand lesen
  mov YReg,DATA                         ;und bertragen
  and DATA,DATA                         ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD LDY,<2b,3z,4zx,4a,4ax>

;Schieben um 1 Stelle nach rechts
ACTION macro
  READ                                  ;Alten Wert lesen
  shr DATA,1                            ;Verschiebung ausfhren
  SETSZC                                ;Vernderte Flags setzen
  WRITE                                 ;Neuen Wert zurckschreiben
  endm
CMD LSR,<2n,5z,6zx,6a,7ax>

;Leerer Befehl
ACTION macro
  endm
CMD NOP,<2n>

;Oder-Verknpfung Akkumulator
ACTION macro
  READ                                  ;Operand lesen
  or Akku,DATA                          ;Verknpfung ausfhren
  SETSZ                                 ;Vernderte Flags setzen
  endm
CMD ORA,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;Push Akkumulator
ACTION macro
  mov AL,Akku                           ;Akkumulator holen
  mov BX,StackPtr                       ;und auf Stapel
  mov ES:[BX],AL
  dec BL
  mov StackPtr,BX
  endm
CMD PHA,<3n>

;Push Flags
ACTION macro
  GETFLAGS                              ;Flags nach AL holen
  mov BX,StackPtr                       ;und auf Stapel
  mov ES:[BX],AL
  dec BL
  mov StackPtr,BX
  endm
CMD PHP,<3n>

;Pull Akkumulator
ACTION macro
  mov BX,StackPtr                       ;Wert von Stapel holen
  inc BL
  mov AL,ES:[BX]
  mov StackPtr,BX
  mov Akku,AL                           ;Akkumulator setzen
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD PLA,<4n>

;Pull Flags
ACTION macro
  mov BX,StackPtr                       ;Wert vom Stapel holen
  inc BL
  mov AL,ES:[BX]
  mov StackPtr,BX
  SETFLAGS                              ;Flags setzen
  endm
CMD PLP,<4n>

;Der 8086 verndert bei RCL/RCR das SF und ZF nicht, der 6502 hingegen schon.
;Deshalb mu der Emulator das Ergebnis kennen, damit die Flags mit AND
;gesetzt werden knnen. Aus diesem Grund wird der Akku in das AL-Register
;geholt, um ein paar Taktzyklen zu sparen

;Akkumulator ber CF um eine Stelle nach links schieben
ACTION macro
  mov AL,Akku                           ;Alten Inhalt lesen
  shr DL,1                              ;CF holen
  rcl AL,1                              ;Verschiebung ausfhren
  setc DL                               ;CF setzen
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  mov Akku,AL                           ;Neuen Inhalt zurckschreiben
  endm
CMD ROL,<2n>

;Schieben ber CF um eine Stelle nach links
ACTION macro
  READ                                  ;Alten Wert lesen
  shr DL,1                              ;CF holen
  rcl DATA,1                            ;Verschiebung ausfhren
  setc DL                               ;CF setzen
  and DATA,DATA                         ;SF und ZF holen
  SETSZ                                 ;und setzen
  WRITE                                 ;Neuen Wert zurckschreiben
  endm
CMD ROL,<5z,6zx,6a,7ax>

;Akkumulator ber CF um eine Stelle nach rechts schieben
ACTION macro
  mov AL,Akku                           ;Alten Inhalt lesen
  shr DL,1                              ;CF holen
  rcr AL,1                              ;Verschiebung ausfhren
  setc DL                               ;CF setzen
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  mov Akku,AL                           ;Neuen Inhalt zurckschreiben
  endm
CMD ROR,<2n>

;Schieben ber CF um eine Stelle nach rechts
ACTION macro
  READ                                  ;Alten Wert lesen
  shr DL,1                              ;CF holen
  rcr DATA,1                            ;Verschiebung ausfhren
  setc DL                               ;CF setzen
  and DATA,DATA                         ;SF und ZF holen
  SETSZ                                 ;und setzen
  WRITE                                 ;Neuen Wert zurckschreiben
  endm
CMD ROR,<5z,6zx,6a,7ax>

;Rscksprung vom Interrupt
ACTION macro
  mov BX,StackPtr                       ;Flags vom Stack holen
  inc BL
  mov AL,ES:[BX]
  inc BL
  SETFLAGS                              ;Flags setzen
  mov AL,ES:[BX]                        ;Rcksprungadresse vom Stack holen
  inc BL
  mov AH,ES:[BX]
  mov StackPtr,BX
  mov SI,AX                             ;Sprung ausfhren
  JUMP                                  ;Speicherbasis angleichen
  endm
CMD RTI,<6n>

;Rcksprung aus Unterprogramm
ACTION macro
  mov BX,StackPtr                       ;Rcksprungadresse holen
  inc BL
  mov AL,ES:[BX]
  inc BL
  mov AH,ES:[BX]
  mov StackPtr,BX
  mov SI,AX                             ;Sprung ausfhren
  inc SI                                ;Der 6502 erhht den Wert um 1
  JUMP                                  ;Speicherbasis angleichen
  endm
CMD RTS,<6n>

;Subtraktion Akkumulator mit Carry
ACTION macro
  READ                                  ;Operand lesen
  test Flags,00001000b                  ;Auf Dezimalmodus prfen
  jne @@Dec
  shr DL,1                              ;CF holen
  cmc                                   ;Subtraktion 6502->8086
  sbb Akku,DATA                         ;Operation ausfhren
  cmc                                   ;Subtraktion 8086->6502
  jmp @@NoDec
align 4
@@Dec:
  mov AH,DATA
  mov DATA,Akku
  shr DL,1                              ;CF holen
  cmc                                   ;Subtraktion 6502->8086
  sbb DATA,AH                           ;Subtraktion ausfhren
  das                                   ;Ergebnis ins Dezimalformat wandeln
  cmc                                   ;Subtraktion 8086->6502
  mov Akku,DATA                         ;Ergebnis zurckschreiben
@@NoDec:
  SETSZCV                               ;Vernderte Flags setzen
  endm
CMD SBC,<2b,3z,4zx,4a,4ax,4ay,6ix,5iy>

;CF setzen
ACTION macro
  mov DL,0000001b
  endm
CMD SEC,<2n>

;Dezimalmodus einschalten
ACTION macro
  or Flags,00001000b
  endm
CMD SED,<2n>

;Interrupts sperren
ACTION macro
  or Flags,00000100b
  endm
CMD SEI,<2n>

;Akkumulator schreiben
ACTION macro
  mov DATA,Akku                         ;Akku auslesen
  WRITE                                 ;und Wert schreiben
  endm
CMD STA,<3z,4zx,4a,5ax,5ay,6ix,5iy>

;X-Register schreiben
ACTION macro
  mov DATA,XReg                         ;Register auslesen
  WRITE                                 ;und Wert schreiben
  endm
CMD STX,<3z,4zy,4a,5ay>

;Y-Register schreiben
ACTION macro
  mov DATA,YReg                         ;Register auslesen
  WRITE                                 ;und Wert schreiben
  endm
CMD STY,<3z,4zx,4a,5ax>

;Akkumulator -> X-Register
ACTION macro
  mov AL,Akku                           ;bertragung vornehmen
  mov XReg,AL
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD TAX,<2n>

;Akkumulator -> Y-Register
ACTION macro
  mov AL,Akku                           ;bertragung vornehmen
  mov YReg,AL
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD TAY,<2n>

;SP -> X-Register
ACTION macro
  mov AL,byte ptr StackPtr              ;bertragung vornehmen
  mov XReg,AL
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD TSX,<2n>

;X-Register -> Akkumulator
ACTION macro
  mov AL,XReg                           ;bertragung vornehmen
  mov Akku,AL
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD TXA,<2n>

;X-Register -> SP
ACTION macro
  mov AL,XReg                           ;bertragung vornehmen
  mov byte ptr StackPtr,AL
  endm                                  ;Keine Flags setzen!
CMD TXS,<2n>

;Y-Register -> Akkumulator
ACTION macro
  mov AL,YReg                           ;bertragung vornehmen
  mov Akku,AL
  and AL,AL                             ;SF und ZF holen
  SETSZ                                 ;und setzen
  endm
CMD TYA,<2n>

EmulateImage proc near c public uses SI DI,wRAMSeg:word,wPC:word
  mov ES,wRAMSeg                        ;Zeiger auf RAM und Register holen
  mov AX,VC1541ROM                      ;Segment C000 Bytes vor dem ROM
  sub AX,0C00h
  mov wROMSeg,AX
  xor ECX,ECX                           ;HIWORD mu 0 sein
  mov DL,Carry                          ;Carry-Flag nach Bit 0 von DL
  mov SI,wPC                            ;Startadresse setzen
  JUMP                                  ;FS anpassen
  NEXTCMD                               ;Ersten 6502-Befehl ausfhren
??? label near
  xor AX,AX                             ;Absturz -> Fehler zurckgeben
  mov fCtrlBreak,AX
  jmp Return
BRKn label near
  mov AX,1                              ;Warteschleife erreicht -> OK
Return:
  mov Carry,DL                          ;Genderte Register sichern
  mov ProgCounter,SI
  ret
EmulateImage endp

;Track und Sektor prfen
;< ES:[0] = Floppy-RAM
;  BX     = Puffernummer (wird zerstrt)
;> AL     = Fehlermeldung
;           1 = 00, OK
;           2 = 20,READ ERROR (Sektor nicht gefunden)
;           0 = 24,READ ERROR
;           7 = 25,WRITE ERROR
;           8 = 26,WRITE PROTECT ON
;           F = 74,DRIVE NOT READY (keine Diskette im Laufwerk)
;  CX     = Sektor in der Datei
abSektorenProTrack label byte
  db 0,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21
  db 19,19,19,19,19,19,19
  db 18,18,18,18,18,18
  db 17,17,17,17,17
awSektorenAbAnfang label word
  dw 0,0,21,42,63,84,105,126,147,168,189,210,231,252,273,294,315,336
  dw 357,376,395,414,433,452,471
  dw 490,508,526,544,562,580
  dw 598,615,632,649,666
CheckTrackAndSector proc near
  shl BX,1
  mov CL,ES:[06h+BX]                    ;Track holen und prfen
  cmp CL,36
  jae Error
  mov AL,ES:[07h+BX]                    ;Sektor holen und prfen
  xor CH,CH
  cmp AL,abSektorenProTrack[ECX]
  jae Error
  mov CX,awSektorenAbAnfang[ECX*2]      ;Sektor in der Datei berechnen
  xor AH,AH
  add CX,AX
  mov AL,01h                            ;OK zurckgeben
  ret
Error:
  mov AL,02h                            ;Sektor nicht gefunden
  ret
CheckTrackAndSector endp

;Schreibzugriff auf die Adressen 0 bis 5
NewJob proc near
  and AL,AL                             ;Bit 7 = 0: nichts zu tun
  jns Return
  push DX
  push BX
  mov DI,3F00h                          ;Jobcode fr Lesen
  cmp AL,80h
  je ReadWrite
  cmp AL,90h                            ;Jobcode fr Schreiben
  je Write
  test AL,1                             ;Laufwerk 1 nicht vorhanden
  jne DriveNotReady
TestParams:
  call CheckTrackAndSector              ;Bei allen anderen Codes nur
  jmp Exit                              ;Track und Sektor prfen
Write:
  mov DI,4000h
ReadWrite:
  call CheckTrackAndSector              ;Liegt der Sektor im gltigen Bereich?
  cmp AL,01h
  jne Exit
  mov BX,hImageFile                     ;Dateihandle prfen
  cmp BX,0
  jle DriveNotReady
  mov wAbsoluteSector,CX                ;als Index fr Fehlercodes
  xor DL,DL                             ;Sektornummer * 256 nach CX:DX
  mov DH,CL
  mov CL,CH
  xor CH,CH
  mov AX,4200h                          ;Seek
  int 21h
  jc DOSError
  pop CX                                ;Pufferadresse nach DX
  push CX
  xor DL,DL
  mov DH,ES:[9Ah+ECX*2]
  push DS
  mov AX,ES
  mov DS,AX
  mov CX,256                            ;Sektor lesen oder schreiben
  mov AX,DI
  int 21h
  pop DS
  jc DOSError
  mov AL,01h                            ;Der Job wurde erledigt
  cmp pbError,0                         ;Fehlertabelle vorhanden?
  je Exit
  push ES
  les BX,pbError
  add BX,wAbsoluteSector
  mov AL,ES:[BX]                        ;Fehlercode holen
  pop ES
  jmp Exit
DOSError:
  mov AH,AL                             ;Fehlernummer ins 1541-Format wandeln
  mov AL,08h                            ;26,WRITE PROTECT ON
  cmp AH,05h
  je Exit
  cmp AH,13h
  je Exit
  xor AL,AL                             ;24,READ ERROR
  cmp AH,17h
  je Exit
  cmp AH,1Eh
  je Exit
  mov AL,07h                            ;25,WRITE ERROR
  cmp AH,1Dh
  je Exit
DriveNotReady:
  mov AL,0Fh                            ;74,DRIVE NOT READY
Exit:
  pop BX
  pop DX
  mov ES:[BX],AL
Return:
  ret
NewJob endp

IMAGE_TEXT ends
end
