// Verbindung ber paralleles Kabel und Joystick testen

#include "pc64.h"

static void ShowJoystick(HWND hwnd, int iState) {
  static int iOldState;
  int iChanged = iState ^ iOldState;
  int iMask = 1;
  for (int i = 0; i < 5; i++) {
    if (iChanged & iMask) {
      WinSetAttr(GetDlgItem(hwnd, IDT_JOYSTATE + i), iState & iMask ? 0xF7 : 0x07, TRUE);
    }
    iMask <<= 1;
  }
  iOldState = iState;
  static byte bAlternateJoy;
  if (iState == -1 || L64AlternateJoy[def.wLpt] != bAlternateJoy) {
    bAlternateJoy = L64AlternateJoy[def.wLpt];
    SetDlgItemText(hwnd, IDT_ALTJOY, bAlternateJoy ? "Alt.Joyst." : "Joystick");
  }
}

BOOL FAR PASCAL HardwareDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  const int iBufSize = 1024;
  static enum {
    eReset, eScan, eRandom, eSend, eReceive, eVerify, eIdle
  } eState;
  static byte* pbSend;
  static byte* pbReceive;
  static long lTotal;
  static long lTime;
  static word wErrors;
  static int iCount;
  char acNum[16];
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    if (!SearchPorts(hwnd, IDB_HARDWAREPORT)) {
      EndDialog(hwnd, FALSE);
      return FALSE;
    }
    pbSend = (byte*)malloc(iBufSize);
    assert(pbSend);
    if (!pbSend) {
      EndDialog(hwnd, FALSE);
      return ErrorBox(NULL, apcDOSError[8]);
    }
    pbReceive = (byte*)malloc(iBufSize);
    assert(pbReceive);
    if (!pbReceive) {
      free(pbSend);
      EndDialog(hwnd, FALSE);
      return ErrorBox(NULL, apcDOSError[8]);
    }
    for (i = 0; i < 4; i++) {
      SetDlgItemInt(hwnd, IDE_LINKWAITS + i, L64LinkWaits[i], FALSE);
      SetDlgItemInt(hwnd, IDE_JOYWAITS + i, L64JoyWaits[i], FALSE);
    }
    CheckDlgButton(hwnd, IDB_SCREENON, def.fScreenOn);
    ShowJoystick(hwnd, -1);
    ShowJoystick(hwnd, 0);
    srand(*(word*)0x0000046CL);
    eState = eReset;
    CenterWindow(hwnd);
    wDialogHelp = IDM_OPTIONSHARDWARE;
    hwndEnterIdle = hwnd;
    return FALSE;
  case WM_PAINT:
    {
      PAINTSTRUCT ps;
      HDC hdc = BeginPaint(hwnd, &ps);
      for (int y = 3; y <= 4; y++) {
        for (int x = 21; x <= 54; x += 11) {
          TextOut(hdc, x, y, "", 2);
        }
      }
      EndPaint(hwnd, &ps);
    }
    return TRUE;
  case WM_LBUTTONDOWN:
  case WM_MOUSEREPEAT:
    {
      int iControl, iDelta;
      switch (HIWORD(lParam)) {
      case 3:
        iControl = IDE_LINKWAITS;
        break;
      case 4:
        iControl = IDE_JOYWAITS;
        break;
      default:
        return FALSE;
      }
      switch (LOWORD(lParam)) {
      case 54:
        iControl++;
      case 43:
        iControl++;
      case 32:
        iControl++;
      case 21:
        iDelta = 1;
        break;
      case 55:
        iControl++;
      case 44:
        iControl++;
      case 33:
        iControl++;
      case 22:
        iDelta = -1;
        break;
      default:
        return FALSE;
      }
      int iValue = GetDlgItemInt(hwnd, iControl, NULL, TRUE) + iDelta & 127;
      SetDlgItemInt(hwnd, iControl, iValue, TRUE);
      HWND hwndControl = GetDlgItem(hwnd, iControl);
      SendMessage(hwnd, WM_COMMAND, iControl, MAKELONG(hwndControl, EN_UPDATE));
      SetFocus(NULL);
      SetFocus(hwndControl);
    }
    return TRUE;
  case WM_ENTERIDLE:
    assert(GetLptPort(def.wLpt));
    switch (eState) {
    case eReset:
      SetDlgItemText(hwnd, IDT_L64VERSION, NULL);
      SetDlgItemText(hwnd, IDT_KBYTES, NULL);
      SetDlgItemText(hwnd, IDT_ERRORS, NULL);
      SetDlgItemText(hwnd, IDT_RATE, NULL);
      eState = eScan;
      break;
    case eScan:
      *(long*)L64State = -1;
      pbSend[0] = 0x22;
      if (L64Send(def.wLpt, pbSend, 1) > 0) {
        if (L64Receive(def.wLpt, pbReceive, 4096) > 0) {
          wsprintf(acNum, "%X.%02X", pbReceive[1], pbReceive[0]);
          SetDlgItemText(hwnd, IDT_L64VERSION, acNum);
          pbSend[0] = (byte)(0x20 + IsDlgButtonChecked(hwnd, IDB_SCREENON));
          if (L64Send(def.wLpt, pbSend, 1) > 0) {
            lTotal = lTime = wErrors = 0;
            SetDlgItemInt(hwnd, IDT_KBYTES, 0, FALSE);
            SetDlgItemInt(hwnd, IDT_ERRORS, 0, FALSE);
            eState = eRandom;
          }
        }
      }
      break;
    case eRandom:
      pbSend[0] = 0x24;
      iCount = 1 + (int)((long)rand() * (iBufSize - 1) / (RAND_MAX + 1U));
      assert(iCount > 0);
      assert(iCount < iBufSize);
      for (i = 1; i < iCount; i++) {
        pbSend[i] = (byte)rand();
      }
      eState = eSend;
      break;
    case eSend:
      ResetTimer();
      L64Send(def.wLpt, pbSend, iCount);
      lTime += GetTimer();
      goto Update;
    case eReceive:
      ResetTimer();
      L64Receive(def.wLpt, pbReceive, iCount);
      lTime += GetTimer();
    Update:
      switch (L64Result) {
      case -1:
        eState = eScan;
      case -2:
        SetDlgItemInt(hwnd, IDT_ERRORS, ++wErrors, FALSE);
        break;
      default:
        assert(L64Result == iCount);
        lTotal += iCount;
        SetDlgItemInt(hwnd, IDT_KBYTES, (word)(lTotal / 1024), FALSE);
        if (eState == eSend) eState = eReceive;
        else eState = eVerify;
      }
      sprintf(acNum, "%.1f", lTotal / 1024.0 * 1193182.0 / lTime);
      SetDlgItemText(hwnd, IDT_RATE, acNum);
      break;
    case eVerify:
      if (memcmp(pbSend, pbReceive, iCount)) {
        ErrorBox(NULL, acUnrecovered);
        eState = eIdle;
      } else eState = eRandom;
      break;
    case eIdle:
      break;
    }
    *(long*)L64AlternateJoy = -1;
    ShowJoystick(hwnd, L64Joystick(def.wLpt));
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDB_HARDWAREPORT + 0:
    case IDB_HARDWAREPORT + 1:
    case IDB_HARDWAREPORT + 2:
    case IDB_HARDWAREPORT + 3:
      if (HIWORD(lParam) == BN_CLICKED) {
        CheckRadioButton(hwnd, IDB_HARDWAREPORT, IDB_HARDWAREPORT + 3, wParam);
        int i = wParam - IDB_HARDWAREPORT;
        if (i != (int)def.wLpt) {
          def.wLpt = i;
          SaveDefault();
        }
        eState = eReset;
        return TRUE;
      }
      break;
    case IDE_LINKWAITS + 0:
    case IDE_LINKWAITS + 1:
    case IDE_LINKWAITS + 2:
    case IDE_LINKWAITS + 3:
      {
        word w = wParam - IDE_LINKWAITS;
        assert(w < 4);
        switch (HIWORD(lParam)) {
        case EN_UPDATE:
          L64LinkWaits[w] = (byte)min(GetDlgItemInt(hwnd, wParam, NULL, FALSE), 127);
          if (w == def.wLpt) eState = eScan;
          return TRUE;
        case EN_KILLFOCUS:
          SetDlgItemInt(hwnd, wParam, L64LinkWaits[w], FALSE);
          return TRUE;
        }
      }
      break;
    case IDE_JOYWAITS + 0:
    case IDE_JOYWAITS + 1:
    case IDE_JOYWAITS + 2:
    case IDE_JOYWAITS + 3:
      {
        word w = wParam - IDE_JOYWAITS;
        assert(w < 4);
        switch (HIWORD(lParam)) {
        case EN_UPDATE:
          L64JoyWaits[w] = (byte)min(GetDlgItemInt(hwnd, wParam, NULL, FALSE), 127);
          return TRUE;
        case EN_KILLFOCUS:
          SetDlgItemInt(hwnd, wParam, L64JoyWaits[w], FALSE);
          return TRUE;
        }
      }
      break;
    case IDB_SCREENON:
      eState = eScan;
      return TRUE;
    case IDOK:
      *(dword*)def.abLinkWaits = *(dword*)L64LinkWaits;
      *(dword*)def.abJoyWaits = *(dword*)L64JoyWaits;
      def.fScreenOn = IsDlgButtonChecked(hwnd, IDB_SCREENON);
      SaveDefault();
    case IDCANCEL:
      *(dword*)L64LinkWaits = *(dword*)def.abLinkWaits;
      *(dword*)L64JoyWaits = *(dword*)def.abJoyWaits;
      pbSend[0] = (byte)(0x20 + def.fScreenOn);
      L64Send(def.wLpt, pbSend, 1);
      free(pbSend);
      free(pbReceive);
      hwndEnterIdle = NULL;
      wDialogHelp = 0;
      EndDialog(hwnd, TRUE);
      return TRUE;
    }
    break;
  }
  return FALSE;
}
