// Zuordnung von Laufwerken

#include "pc64.h"

void RelDir(char* pcRelDir, char* pcAbsDir) {
  assert(pcRelDir);
  assert(pcAbsDir);
  char acCurrDir[80];
  _getcwd(acCurrDir, 80);
  int iLength = strlen(acCurrDir);
  if (!memcmp(pcAbsDir, acCurrDir, iLength)) {
    if (pcAbsDir[iLength] == '\\') {
      iLength++;
    } else if (pcAbsDir[iLength]) {
      iLength = 0;
    }
  } else {
    iLength = 0;
  }
  if (pcAbsDir[iLength]) {
    strcpy(pcRelDir, pcAbsDir + iLength);
  } else {
    strcpy(pcRelDir, ".");
  }
}

void SetFileWndDir(FILEWND* pfw) {
  assert(pfw);
  char acNewDir[80];
  if (pfw->acFileName[0]) {
    strcpy(acNewDir, pfw->acFileName);
    char* pc = strrchr(acNewDir, '\\');
    assert(pc);
    if (pc - acNewDir < 3) {
      pc++;
    }
    *pc = 0;
  } else {
    strcpy(acNewDir, ::acDir);
  }
  assert(acNewDir[1] == ':');
  _chdrive(acNewDir[0] - '@');
  _chdir(acNewDir);
}

flag SetFloppies(FILEWND* pfw, flag fReport) {
  assert(pfw);
  // Provisorium: globale Drucker an den Adressen 4 bis 7
  pfw->apDevice[4] = &aPrinter[0];
  pfw->apDevice[5] = &aPrinter[1];
  pfw->apDevice[6] = &aPrinter[2];
  pfw->apDevice[7] = &aPrinter[3];
  SetFileWndDir(pfw);
  flag afOK[8];
  flag fReturn = TRUE;
  for (int i = 0; i < 8; i++) {
    iRetries = 5;
    fReturn &= afOK[i] = SetDir(&pfw->apDevice[8 + i], pfw->c.floppies.aacName[i]);
    if (pfw->apDevice[8 + i]) {
      pfw->apDevice[8 + i]->Stop();
    }
  }
  if (!fReturn && fReport) {
    char* pcBuffer = (char*)malloc(2048);
    assert(pcBuffer);
    strcpy(pcBuffer, acNoDevice1);
    for (i = 0; i < 8; i++) {
      if (!afOK[i]) {
        wsprintf(strend(pcBuffer), "%d = %s\n", 8 + i, pfw->c.floppies.aacName[i]);
      }
    }
    strcat(pcBuffer, acNoDevice2);
    ErrorBox(NULL, pcBuffer);
    free(pcBuffer);
  }
  return fReturn;
}

static FLOPPIES floppies;
static word wDrive;
static void GetCurrentDrive(HWND hwnd) {
  assert(wDrive < 8);
  memset(floppies.aacName[wDrive], 0, 80);
  if (IsDlgButtonChecked(hwnd, IDB_FLOPPYON)) {
    char acDir[80];
    GetDlgItemText(hwnd, IDDT_FLOPPIES, acDir, 80);
    if (IsLink(acDir)) {
      strcpy(floppies.aacName[wDrive], acDir);
    } else {
      RelDir(floppies.aacName[wDrive], acDir);
    }
  }
}

static void SetCurrentDrive(HWND hwnd) {
  assert(wDrive < 8);
  CheckDlgButton(hwnd, IDB_FLOPPYON, floppies.aacName[wDrive][0]);
  SetDlgItemText(hwnd, IDDT_FLOPPIES, floppies.aacName[wDrive]);
}

BOOL FAR PASCAL FloppiesDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    SetFileWndDir(pfw);
    floppies = pfw->c.floppies;
    wDrive = 0;
    SetCurrentDrive(hwnd);
    CheckRadioButton(hwnd, IDB_FLOPPIES, IDB_FLOPPIES + 7, IDB_FLOPPIES);
    wDialogHelp = IDM_OPTIONSFLOPPIES;
    SetFocus(GetDlgItem(hwnd, IDDT_FLOPPIES));
    return FALSE;
  case WM_COMMAND:
    switch (wParam) {
    case IDB_FLOPPIES + 0:
    case IDB_FLOPPIES + 1:
    case IDB_FLOPPIES + 2:
    case IDB_FLOPPIES + 3:
    case IDB_FLOPPIES + 4:
    case IDB_FLOPPIES + 5:
    case IDB_FLOPPIES + 6:
    case IDB_FLOPPIES + 7:
      if (HIWORD(lParam) == BN_CLICKED) {
        GetCurrentDrive(hwnd);
        wDrive = wParam - IDB_FLOPPIES;
        SetCurrentDrive(hwnd);
        return TRUE;
      }
      return FALSE;
    case IDOK:
      GetCurrentDrive(hwnd);
      if (memcmp(&floppies, &pfw->c.floppies, sizeof FLOPPIES)) {
        pfw->c.floppies = floppies;
        pfw->fModified = TRUE;
      }
      if (IsDlgButtonChecked(hwnd, IDB_DEFFLOPPIES)) {
        if (memcmp(&floppies, &def.c.floppies, sizeof FLOPPIES)) {
          def.c.floppies = floppies;
          SaveDefault();
        }
      }
      SetFloppies(pfw, TRUE);
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}
