// Fensterprozedur fr Emulator-Fenster

#include "pc64.h"

LONG FAR PASCAL FileWndProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  int i;
  FILEWND* pfwTemp;
  HDC hdc;
  PAINTSTRUCT ps;
  switch (wMsg) {
  case WM_CREATE:
    SetWindowLong(hwnd, 0, lSetWindowLong);
    wChildren++;
    fDoArrange = TRUE;
    break;
  case WM_SIZE:
    pfwTemp = (FILEWND*)GetWindowLong(hwnd, 0);
    assert(pfwTemp);
    pfwTemp->iWidth = LOWORD(lParam);
    pfwTemp->iHeight = HIWORD(lParam);
    if (pfwTemp->acLogName[0]) {
      AdjustFileWnd(pfwTemp, hwnd);
    } else {
      SetScrollRange(hwnd, SB_VERT, 0, 0, TRUE);
    }
    goto Default;
  case WM_MDIACTIVATE:
    if (wParam) {
      hwndChild = hwnd;
      pfw = (FILEWND*)GetWindowLong(hwnd, 0);
      assert(pfw);
      assert(!hLogFile);
      if (pfw->acLogName[0]) {
        hLogFile = _lopen(pfw->acLogName, OF_READWRITE | OF_SHARE_DENY_NONE);
        strcpy(sLogFile, pfw->acLogName);
      }
    } else {
      assert(hwndChild == hwnd);
      hwndChild = NULL;
      pfw = NULL;
      if (hLogFile > 0) _lclose(hLogFile);
      hLogFile = NULL;
    }
    goto Default;
  case WM_ERASEBKGND:
    assert(wParam);
    assert(wParam != 0xFFFF);
    if (fErase) {
      HBRUSH hbr = SelectObject((HDC)wParam, CreateSolidBrush(AttrToRGB(def.awColor[DTC_FILEWNDBACK])));
      RECT rc;
      GetClientRect(hwnd, &rc);
      PatBlt((HDC)wParam, rc.left, rc.top, rc.right - rc.left + 1, rc.bottom - rc.top + 1, PATCOPY);
      DeleteObject(SelectObject((HDC)wParam, hbr));
    }
    return TRUE;
  case WM_PAINT:
    hdc = BeginPaint(hwnd, &ps);
    assert(hdc);
    pfwTemp = (FILEWND*)GetWindowLong(hwnd, 0);
    assert(pfwTemp);
    if (pfwTemp->acLogName[0] && pfwTemp->iHeight > 0) {
      int hFile;
      if (hwnd == hwndChild) {
        assert(pfwTemp == pfw);
        assert(hLogFile);
        hFile = hLogFile;
      } else {
        assert(pfwTemp != pfw);
        hFile = _lopen(pfwTemp->acLogName, OF_READ | OF_SHARE_DENY_NONE);
      }
      if (hFile > 0) {
        assert(pfwTemp->lSize == _filelength(hFile) / 80);
        assert(pfwTemp->lPosition >= 0);
        assert(pfwTemp->lPosition < pfwTemp->lSize);
        int iUpper, iLower;
        if (pfwTemp->lSelection != -1) {
          long lStart = pfwTemp->lSelection - pfwTemp->lStart;
          if (lStart < 0) iUpper = 0;
          else if (lStart > (long)pfwTemp->iHeight) iUpper = pfwTemp->iHeight;
          else iUpper = (int)lStart;
          if (iUpper > pfwTemp->iLine) {
            iLower = iUpper;
            iUpper = pfwTemp->iLine;
          } else iLower = pfwTemp->iLine;
        } else iUpper = iLower = pfwTemp->iLine;
        _llseek(hFile, (pfwTemp->lStart + ps.rcPaint.top) * 80, 0);
        for (int i = ps.rcPaint.top; i < ps.rcPaint.bottom; i++) {
          char acLine[80];
          if (_lread(hFile, acLine, 80) != 80) break;
          switch (acLine[0]) {
          case 32:
            if (*(long*)(acLine + 1) != 0x204D4552L) {
              SetTextColor(hdc, def.awColor[DTC_INFO]);
              break;
            }
          case '':
            SetTextColor(hdc, def.awColor[DTC_REM]);
            break;
          case '\xFF':
            SetTextColor(hdc, def.awColor[DTC_WARNING]);
            acLine[0] = 32;
            break;
          default:
            SetTextColor(hdc, def.awColor[DTC_TRACE]);
          }
          if (i >= iUpper && i <= iLower) SetBkColor(hdc, def.awColor[DTC_FILESELBACK]);
          else SetBkColor(hdc, def.awColor[DTC_FILEWNDBACK]);
          TextOut(hdc, 0, i, acLine, 78);
        }
        if (hwnd != hwndChild) _lclose(hFile);
      }
    }
    EndPaint(hwnd, &ps);
    break;
  case WM_KEYDOWN:
  case WM_CHAR:
    assert(pfw);
    switch (wParam) {
    case VK_F1:
      Help(hwndFrame, IDH_FILEWND);
      return TRUE;
    case VK_F5:
      PostMessage(hwndFrame, WM_COMMAND, IDM_RUNSTART, 0);
      return TRUE;
    }
    if (pfw->acLogName[0]) {
      switch (wParam) {
      case VK_UP:
        MoveFileSel(-1, FALSE);
        break;
      case VK_DOWN:
        MoveFileSel(1, FALSE);
        break;
      case VK_PGUP:
        MoveFileSel(-pfw->iHeight, FALSE);
        break;
      case VK_PGDN:
        MoveFileSel(pfw->iHeight, FALSE);
        break;
      case VK_CTRL_HOME:
        MoveFileSel(-pfw->lPosition, FALSE);
        break;
      case VK_CTRL_END:
        MoveFileSel(pfw->lSize - pfw->lPosition, FALSE);
        break;
      case VK_SH_UP:
        MoveFileSel(-1, TRUE);
        break;
      case VK_SH_DOWN:
        MoveFileSel(1, TRUE);
        break;
      case VK_SH_PGUP:
        MoveFileSel(-pfw->iHeight, TRUE);
        break;
      case VK_SH_PGDN:
        MoveFileSel(pfw->iHeight, TRUE);
        break;
      case VK_CTRL_HOME | SHIFT_SHIFT:
        MoveFileSel(-pfw->lPosition, TRUE);
        break;
      case VK_CTRL_END | SHIFT_SHIFT:
        MoveFileSel(pfw->lSize - pfw->lPosition, TRUE);
        break;
      case 'R':
        SearchTag("REM ", TRUE);
        break;
      case 'r':
        SearchTag("REM ", FALSE);
        break;
      case 'V':
        SearchTag("VIC ", TRUE);
        break;
      case 'v':
        SearchTag("VIC ", FALSE);
        break;
      case 'S':
        SearchTag("SID ", TRUE);
        break;
      case 's':
        SearchTag("SID ", FALSE);
        break;
      case 'C':
        SearchTag("CIA ", TRUE);
        break;
      case 'c':
        SearchTag("CIA ", FALSE);
        break;
      case 'E':
        SearchTag("IEC ", TRUE);
        break;
      case 'e':
        SearchTag("IEC ", FALSE);
        break;
      case 'D':
        SearchTag("DEV ", TRUE);
        break;
      case 'd':
        SearchTag("DEV ", FALSE);
        break;
      case 'I':
        SearchTag("INT ", TRUE);
        break;
      case 'i':
        SearchTag("INT ", FALSE);
        break;
      case VK_SH_F4:
        SearchTag("\xFF", TRUE);
        break;
      case VK_F4:
        SearchTag("\xFF", FALSE);
        break;
      case '_':
        SearchTag("", TRUE);
        break;
      case '-':
        SearchTag("", FALSE);
        break;
      }
    }
    break;
  case WM_VSCROLL:
    assert(pfw);
    assert(pfw->acLogName[0]);
    switch (wParam) {
    case SB_LINEUP:
      MoveFileSel(-1, FALSE);
      break;
    case SB_LINEDOWN:
      MoveFileSel(1, FALSE);
      break;
    case SB_PAGEUP:
      MoveFileSel(-pfw->iHeight, FALSE);
      break;
    case SB_PAGEDOWN:
      MoveFileSel(pfw->iHeight, FALSE);
      break;
    case SB_TOP:
      MoveFileSel(-pfw->lPosition, FALSE);
      break;
    case SB_BOTTOM:
      MoveFileSel(pfw->lSize - pfw->lPosition, FALSE);
      break;
    case SB_THUMBTRACK:
    case SB_THUMBPOSITION:
      MoveFileSel(((long)LOWORD(lParam) << pfw->iShift) - pfw->lPosition, FALSE);
      break;
    }
    break;
  case WM_LBUTTONDOWN:
    SetCapture(hwnd);
    assert(pfw);
    if (pfw->acLogName[0]) MoveFileSel((int)HIWORD(lParam) - pfw->iLine, FALSE);
    break;
  case WM_MOUSEMOVE:
  case WM_MOUSEREPEAT:
    if (GetCapture() == hwnd && pfw && pfw->acLogName[0]) {
      MoveFileSel((int)HIWORD(lParam) - pfw->iLine, TRUE);
    }
    break;
  case WM_LBUTTONUP:
    if (GetCapture() == hwnd) ReleaseCapture();
    break;
  case WM_SYSCOMMAND:
    switch (wParam & 0xFFF0) {
    case SC_MINIMIZE:
    case SC_RESTORE:
      fDoArrange = TRUE;
    }
    goto Default;
  case WM_CLOSE:
    if (CloseFileWnd(hwnd, NULL)) {
      goto Default;
    }
    break;
  case WM_DESTROY:
    pfwTemp = (FILEWND*)GetWindowLong(hwnd, 0);
    assert(pfwTemp);
    for (i = 4; i < 8; i++) {   // Drucker sind derzeit noch global
      pfwTemp->apDevice[i] = NULL;
    }
    for (i = 0; i < 16; i++) {
      if (pfwTemp->apDevice[i]) {
        delete pfwTemp->apDevice[i];
      }
    }
    free(pfwTemp);
    if (--wChildren) {
      fDoArrange = TRUE;
    }
    break;
  default:
  Default:
    return DefMDIChildProc(hwnd, wMsg, wParam, lParam);
  }
  return 0;
}
