// Verwaltung von Datei-Fenstern

#include "pc64.h"

BOOL FAR PASCAL FileOptDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  FILEOPT fileopt;
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    CheckRadioButton(hwnd, IDB_SAVENAME, IDB_SAVENAME + 2, IDB_SAVENAME + pfw->c.fileopt.wSaveName);
    SetFocus(GetDlgItem(hwnd, IDB_SAVENAME + pfw->c.fileopt.wSaveName));
    wDialogHelp = IDM_OPTIONSFILE;
    return FALSE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        for (i = 0; i < 3; i++) {
          if (IsDlgButtonChecked(hwnd, IDB_SAVENAME + i)) {
            fileopt.wSaveName = i;
          }
        }
        assert(pfw);
        flag fPrompt = fileopt.wSaveName == 2 && pfw->c.fileopt.wSaveName != 2 && pfw->acFileName[0];
        if (memcmp(&fileopt, &pfw->c.fileopt, sizeof FILEOPT)) {
          pfw->c.fileopt = fileopt;
          pfw->fModified = TRUE;
          Database(pfw, TRUE);
        }
        if (IsDlgButtonChecked(hwnd, IDB_DEFFILE)) {
          if (memcmp(&fileopt, &def.c.fileopt, sizeof FILEOPT)) {
            def.c.fileopt = fileopt;
            SaveDefault();
          }
        }
        if (fPrompt) {
          MessageBeep(MB_ICONQUESTION);
          if (MessageBox(hwnd, acQuerySave, acConfirm, MB_ICONQUESTION | MB_YESNO) == IDYES) {
            assert(pfw->acFileName[0]);
            if (SaveImage(pfw, pfw->acFileName)) {
              pfw->fModified = FALSE;
              pfw->fTemp = FALSE;
            }
          }
        }
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
