// Basisklasse aller an den C64 anschliebaren Gerte

class CDevice {
public:
  // Destruktor fr "delete" bei abgeleiteten Klassen
  virtual ~CDevice() {};
  // Typ liefern
  virtual word GetType() = 0;
  // Verzeichnis setzen
  virtual flag SetDir(char* pDir) = 0;
  // Verzeichnis liefern
  virtual void GetDir(char* pDir, word wMax) = 0;
  // Gert zurcksetzen
  virtual word Reset() = 0;
  // Befehl abschicken
  virtual word Command(char* sCommand, word wLength) = 0;
  // Fehlermeldung holen
  virtual word GetError(char* pBuffer, word wMax) = 0;
  // Status in Image schreiben
  virtual flag Save(int hFile) = 0;
  // Status aus Image lesen
  virtual flag Load(int hFile) = 0;
  // Emulation beginnen
  virtual word Start() = 0;
  // Emulation beenden
  virtual word Stop() = 0;
  // Datei ffnen
  virtual word Open(word wChannel, char* pcName, word wLength) = 0;
  // Zeichen schreiben
  virtual word Put(word wChannel, byte bValue) = 0;
  // Ende Schreiben
  virtual word Unlisten() = 0;
  // Zeichen lesen
  virtual word Get(word wChannel) = 0;
  // Block schreiben
  virtual word Write(word wChannel, byte* pbBuffer, word* pwCount) = 0;
  // Block lesen
  virtual word Read(word wChannel, byte* pbBuffer, word* pwCount) = 0;
  // Datei schlieen
  virtual word Close(word wChannel) = 0;
  // Satzlnge einer relativen Datei liefern
  virtual byte GetRelLength(word wChannel) = 0;
  // Disketten kopieren
  virtual flag BeginTrack(flag fWrite) = 0;
  virtual word ReadNextTrack(byte* pbBuffer) = 0;
  virtual flag WriteNextTrack(byte* pbBuffer, word wLength) = 0;
  virtual flag EndTrack() = 0;
  // Gre holen
  virtual int GetBlocks(word wChannel) {
    return -1;
  }
  // Datum holen
  virtual dword GetDateAndTime(word wChannel) {
    return 0;
  }
  // Datum setzen
  virtual void SetDateAndTime(word wChannel, dword dwDateAndTime) {
  };
};

// Verschiedene Gertetypen
#define DEVNONE    0
#define DEVFLOPPY  1
#define DEVLINK    2
#define DEVIMAGE   3
#define DEVPRINTER 4

// Rckgabewerte der Funktionen mit "word"
#define EOUTPUT   0x0300  // Time out bei der Ausgabe
#define EINPUT    0x42C3  // Time out bei der Eingabe
#define ENDOFFILE 0x4000  // End of file
#define ENODEVICE 0x8000  // Device not present
