// Auswahlbalken im Dateifenster bewegen

#include "pc64.h"

void AdjustFileWnd(FILEWND* pfw, HWND hwnd) {
  assert(pfw);
  assert(pfw->acLogName[0]);
  if (pfw->lStart > pfw->lSize - pfw->iHeight) {
    pfw->lStart = pfw->lSize - pfw->iHeight;
  }
  if (pfw->lStart < 0) {
    pfw->lStart = 0;
  }
  if (pfw->lPosition < 0) {
    pfw->lPosition = 0;
  } else if (pfw->lPosition > pfw->lSize - 1) {
    pfw->lPosition = pfw->lSize - 1;
  }
  long lLine = pfw->lPosition - pfw->lStart;
  if (lLine < 0) {
    lLine = 0;
    pfw->lStart = pfw->lPosition;
  } else if (lLine > (long)pfw->iHeight - 1) {
    lLine = (long)pfw->iHeight - 1;
    pfw->lStart = pfw->lPosition - lLine;
  }
  pfw->iLine = (int)lLine;
  assert(hwnd);
  long lRange = pfw->lSize - pfw->iHeight;
  pfw->iShift = 0;
  while (lRange >= 32768L) {
    lRange >>= 1;
    pfw->iShift++;
  }
  if (lRange < 0) {
    lRange = 0;
  }
  SetScrollRange(hwnd, SB_VERT, 0, (int)lRange, FALSE);
  SetScrollPos(hwnd, SB_VERT, (int)(pfw->lStart >> pfw->iShift), TRUE);
}

void MoveFileSel(long lMove, flag fShift) {
  assert(pfw);
  assert(hwndChild);
  flag fShiftOff = FALSE;
  if (fShift) {
    if (pfw->lSelection == -1) {
      pfw->lSelection = pfw->lPosition;
    }
  } else if (pfw->lSelection != -1) {
    pfw->lSelection = -1;
    fShiftOff = TRUE;
  }
  long lStartDiff = -pfw->lStart;
  long lPosDiff = -pfw->lPosition;
  pfw->lPosition += lMove;
  AdjustFileWnd(pfw, hwndChild);
  lStartDiff += pfw->lStart;
  lPosDiff += pfw->lPosition;
  fErase = FALSE;
  if (lPosDiff == 1 && !fShiftOff) {
    RECT rc;
    rc.left = 0;
    rc.right = pfw->iWidth;
    if (lStartDiff == 1) {
      assert(pfw->iLine == pfw->iHeight - 1);
      rc.top = 0;
      rc.bottom = pfw->iHeight - 1;
      ScrollWindow(hwndChild, 0, -1, &rc, NULL);
    } else {
      assert(lStartDiff == 0);
    }
    rc.top = pfw->iLine - 1;
    rc.bottom = pfw->iLine + 1;
    InvalidateRect(hwndChild, &rc, FALSE);
    UpdateWindow(hwndChild);
  } else if (lPosDiff == -1 && !fShiftOff) {
    RECT rc;
    rc.left = 0;
    rc.right = pfw->iWidth;
    if (lStartDiff == -1) {
      assert(pfw->iLine == 0);
      rc.top = 1;
      rc.bottom = pfw->iHeight;
      ScrollWindow(hwndChild, 0, 1, &rc, NULL);
    } else {
      assert(lStartDiff == 0);
    }
    rc.top = pfw->iLine;
    rc.bottom = pfw->iLine + 2;
    InvalidateRect(hwndChild, &rc, FALSE);
    UpdateWindow(hwndChild);
  } else if (!_kbhit()) {
    InvalidateRect(hwndChild, NULL, FALSE);
    UpdateWindow(hwndChild);
  }
  fErase = TRUE;
}
