/*===========================================================================*/
/*                                                                           */
/* File    : WPRIVATE.H                                                      */
/*                                                                           */
/* Purpose : Private include file for MEWEL internals                        */
/*                                                                           */
/* History :                                                                 */
/*                                                                           */
/* (C) Copyright 1989-1992 Marc Adler/Magma Systems     All Rights Reserved  */
/*===========================================================================*/

#define _WPRIVATE_H

#if defined(__TSC__)
#define DOS        1
#define MSC        1
#define MEWEL_GUI  1
#endif

#if defined(_MSC_VER) || defined(__HIGHC__)
#define MSC        1
#endif

#if defined(__ZTC__)
#define MSDOS      1
#endif

/*
  For ports of MEWEL to native GUIs (like Motif, DecWindows, Mac, Amiga),
  define the constant USE_NATIVE_GUI
*/
#if defined(MOTIF) || defined(DECWINDOWS) || defined(MAC) || defined(AMIGA) || defined(OPENLOOK)
#define USE_NATIVE_GUI   1
#endif



#if defined(OS2) && defined(INCLUDE_OS2)
#define INCL_DOS
#define INCL_SUB
#define INCL_MOU
#include <os2def.h>
#include <bse.h>
#endif /* OS2 */


#ifndef NO_STD_INCLUDES
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#if !defined(VAXC)
# include <fcntl.h>
# if defined(__TURBOC__)
#  include <alloc.h>
#  include <mem.h>
#  include <dir.h>
# elif defined(__ZTC__)
#  include <direct.h>
# else
#  if !defined(MAC)
#  include <malloc.h>
#  endif /* MAC */
#  if !defined(__WATCOMC__)
#   include <memory.h>
#  endif
#  if (defined(MSC) || defined(__WATCOMC__) || defined(__HIGHC__)) && !defined(UNIX)
#   include <direct.h>
#   if defined(DOS)
#    include <conio.h>
#   endif
#  endif
# endif

# if defined(UNIX)
#  include <sys/types.h>
#  include <sys/stat.h>
#  if defined(INCLUDE_CURSES)
#   xinclude "mcurses.h"
#  endif
# elif defined(VAXC)
# include <types.h>
# include <stat.h>
# else /* !UNIX && !VAXC */
#  if !defined(MAC)
#  include <dos.h>
#  include <io.h>
#  include <sys\types.h>
#  include <sys\stat.h>
#  endif /* MAC */
# endif

#else  /* defined(VAX) */
# if defined(INCLUDE_CURSES)
#x  include "mcurses.h"
# endif
#endif

#endif  /* NO_STD_INCLUDES */

/*
  Definition of functions which maniuplate segments and offsets and
  create FAR pointers from segment/offset pairs. Most compilers
  already support these macros, but we must take care of UNIX & VMS.
*/
#if !defined(WC386) && !defined(__HIGHC__)
#ifndef FP_SEG
#define FP_SEG(fp) (*((unsigned FAR *)&(fp)+1))
#endif
#endif

#if defined(__HIGHC__)
#define MK_FARP(fp,seg,ofs) \
((*(((unsigned short*)&(fp)) + sizeof(unsigned int)/sizeof(unsigned short))= \
(unsigned short)(seg)), (*(unsigned int *)&(fp) = (unsigned int)(ofs)))
#endif

#if !defined(WC386)
#ifndef MK_FP
#define MK_FP(seg,ofs)	((void FAR *) \
		   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif
#endif



/*
  Keywords
*/

#if defined(VAXC)
# define unlink(s) delete(s)
# define tell(f)   lseek(f,0,1)
/* prototypes for vaxstr.c */
char *strdup(char *s);
char *strupr(char *s);
int  stricmp(char *s, char *t);
int  strnicmp(char *s, char *t,int n);
#endif


/*
  Function prototypes
*/
#if defined(UNIX) || defined(VAXC)
extern char *strupr();
extern char *getcwd();
#endif

#ifdef sun
/* Subsitute atexit() requires that we intercept all exit() calls. */
#define	exit	win_cleanup_exit
#endif

#if defined(XENIX) && !defined(PCTEST)
extern char *strupr(char *);
extern int  stricmp(char *, char *);
extern int  strnicmp(char *, char *, int);
#endif

#if defined(__ZTC__)
/*#define stricmp  lstricmp*/
#define tell(f) lseek(f, 0L, SEEK_CUR)
#define _dos_setdrive(a, b) dos_setdrive((unsigned) a, (unsigned *)b)
#define _dos_getdrive(a)    dos_getdrive((unsigned *)a)
#define _dos_getftime       dos_getftime
#endif

/*
  File processing differences
*/
#if defined(UNIX)
#define CH_SLASH   '/'
#define STR_SLASH  "/"
#define DRIVESPEC_LENGTH  0
#if !defined(O_BINARY)
#define O_BINARY   0
#endif
#elif defined(VAXC)
#define CH_SLASH   '/'
#define STR_SLASH  "/"
#define DRIVESPEC_LENGTH  0
#else  /* !UNIX */
#define CH_SLASH   '\\'
#define STR_SLASH  "\\"
#define DRIVESPEC_LENGTH  2
#endif

#ifndef MAXPATH
#if defined(UNIX) || defined(VAXC) || defined(OS2)
#define MAXPATH		256
#else
#define MAXPATH		128
#endif
#endif

/*
  The max length of a auto buffer
*/
#define MAXBUFSIZE      133   /* 132 columns + 1 for null terminator */

/*
  DOS and OS/2 use 2 bytes per screen cell, and Curses uses 1 byte
*/
#if defined(UNIX) || defined(VAXC)
#define SCREENCELLSIZE   sizeof(short)
#else
#define SCREENCELLSIZE   2
#endif

/*
  Test to see if a string pointer is a numeric resource id
*/
#if defined(UNIX) || defined(VAXC)
#define ISNUMERICRESOURCE(s)   ((((DWORD) (s)) & 0xFFFF0000L) == 0L)
#else
#define ISNUMERICRESOURCE(s)   ((FP_SEG(s)) == 0)
#endif


/*
  Opsys-dependent functions
*/

/*
  CDPLUS should be defined if we want to use CTRL keys for accelerators
  on a PC-based UNIX. This affects winaccel.c and winmenu.c
*/
#if defined(UNIX) && (defined(XENIX) || defined(MICROPORT))
#define CDPLUS
#endif


#if !defined(UNIX) && !defined(VAXC) && !defined(MOTIF) && !defined(DECWINDOWS)

/*
  null-define some Curses functions
*/
#define refresh()
#define endwin()
#define standout()
#define standend()
#define move()
#define LINES
#define COLS

#endif

/*
  Defines for highlighting for UNIX/VMS systems
*/

#if defined(DOS) || defined(OS2)
#define HIGHLITE_ON    standout
#elif defined(MOTIF) || defined(DECWINDOWS)
#define HIGHLITE_ON()
#elif defined(VAXC)
# define HIGHLITE_ON() \
{ \
 VirtualScreenFlush(); \
 setattr(_REVERSE); \
}
#elif defined(__AIX__)
# define HIGHLITE_ON()
#else
#define HIGHLITE_ON() \
{ \
 VirtualScreenFlush(); \
 standout(); \
}
#endif

#if defined(MOTIF) || defined(DECWINDOWS)
#define HIGHLITE_OFF()
#elif defined(VAXC)
#define HIGHLITE_OFF()   clrattr(_REVERSE)
#else
#define HIGHLITE_OFF   standend
#endif


extern unsigned MouseHandle;

/*
  For the 386 DOS Extenders, we need to redefine the way that int86()
  is called.
*/
#if (defined(__WATCOMC__) && defined(__386__))
#define ax  eax
#define bx  ebx
#define cx  ecx
#define dx  edx
#define si  esi
#define di  edi
#define int86  int386
#define int86x int386x
#endif

#ifdef ERGO
extern int ParaToSel(unsigned short, unsigned short *);
#endif

#if defined(MOTIF) || defined(DECWINDOWS)
x#include <xmewel.h>
#endif


