// Generelle Definitionen fr alle Module

#include "..\version.h"

#define PC64
#define BETA ""
#define COPYRIGHT "Public Domain (no Copyright)"
#define MEMORY 520
#define L64VERSION "1.12"
#define L64HEXVER 0x0112

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <errno.h>
#include <dos.h>
#include <conio.h>
#include <direct.h>
#include <malloc.h>
#include "windows.h"
#include "commdlg.h"
#include "dirtree.h"
#include "resource.h"

#pragma warning(disable: 4061 4062 4505)

extern "C" {
  #define DOS
  #define INCLUDE_MOUSE
  #include "winternl.h"
}

typedef BYTE byte;
typedef WORD word;
typedef UINT uint;
typedef DWORD dword;
typedef BOOL flag;
typedef double real;

#if defined(_DEBUG)
  #define assert(x) if (!(x)) _assert(#x, __FILE__, __LINE__)
  extern void _assert(char* pcCondition, char* pcFile, word wLine);
  extern void tracefile(char* pcName);
  extern void __cdecl trace(char* pcFormat, ...);
#else
  #define assert(x)
  #define tracefile(x)
  #define trace(x)
#endif

#undef INT
#define TRA 0x0001
#define REM 0x0002
#define VIC 0x0004
#define SID 0x0008
#define CIA 0x0010
#define IEC 0x0020
#define DEV 0x0040
#define INT 0x0080
#define INFO(t) if (wRunDebug & t) CMsg("\x20"#t" "
#define WARNING(t) if (wRunDebug & t) CMsg("\xFF"#t" "
#define EWRITE 0x0027
#define EREAD 0x0028
#define WM_PASSKEYS (WM_USER + 14641)

#include "device.h"
#include "floppy.h"
#include "link.h"
#include "image.h"
#include "printer.h"

struct FILEOPT {
  word wSaveName;
};

struct ROMS {
  char aacName[4][13];
};

struct KEYBOARD {
  flag fNationalKeys;
  flag fTabSwitch;
};

struct JOYSTICK {
  word awPort[2];
  word awFire[2];
  long alStart[2];
  long alCount[2];
  word awFlags[2];
};

struct FLOPPIES {
  char aacName[8][81];
};

enum IECMODE {
  IEC_FREE, IEC_LISTEN, IEC_TALK, IEC_OPEN, IEC_CLOSE, IEC_READ, IEC_WRITE
};

struct IECs {
  byte bDevice;
  byte bChannel;
  IECMODE eMode;
  char acName[64];
  word wName;
  char acCommand[64];
  word wCommand;
  char acError[64];
  word wError;
};

struct FILTERS {
  word wFlags;
};

struct TIMING {
  word wRefresh;
  word wPerformance;
  word wAlgorithm;
  int iClocksPerInt;
  word wNewLine;
  flag fVICDelay;
  flag fNTSC;
  word wRealTime;
};

struct SOUND {
  byte abVolume[5];
  byte abEnable[2];
};

struct COMMON {
  FILEOPT fileopt;
  ROMS roms;
  KEYBOARD keyboard;
  JOYSTICK joystick;
  FLOPPIES floppies;
  IECs iec;
  FILTERS filters;
  TIMING timing;
  SOUND sound;
};

struct DEFAULT {
  struct COMMON c;
  flag f28Lines;
  flag fLocalBus;
  flag fAutoArrange;
  word wAutoArrange;
  flag fMaximizeSingle;
  flag fSaveNoName;
  flag fReplace;
  #define DTC_FILEWNDBACK 0
  #define DTC_FILESELBACK 1
  #define DTC_TRACE 2
  #define DTC_REM 3
  #define DTC_INFO 4
  #define DTC_WARNING 5
  #define DTC_DIRTREEBACK 6
  #define DTC_DIRTREEFORE 7
  #define DTC_LISTBOXBACK 8
  #define DTC_LISTBOXFORE 9
  #define DTC_HELPBACK 10
  #define DTC_HELPNORMAL 11
  #define DTC_HELPBOLD 12
  #define DTC_HELPUNDERLINE 13
  #define DTC_HELPITALICS 14
  #define DTC_HELPBOLDITALICS 15
  #define DTC_COUNT 16
  word awColor[DTC_COUNT];
  byte abLinkWaits[4];
  byte abJoyWaits[4];
  flag fScreenOn;
  word wLpt;
  flag fSwapEMS;
  flag fSwapXMS;
  flag fWinSound;
  char aacPrinterFile[4][80];
  word awPrinterConvert[4];
};

struct FILEWND {
  struct COMMON c;       // Fensterbezogene Optionen
  char acFileName[80];   // Vollstndiger Dateiname
  char acTempName[80];   // Zwischendatei bei mehreren Fenstern
  char acLogName[80];    // Name der Protokolldatei
  CDevice* apDevice[16]; // Zeiger auf die Gerte am IEC-Bus
  flag fModified;        // nderungen gegenber Datei vorhanden
  flag fTemp;            // Temporre Zwischendatei vorhanden
  long lSize;            // Anzahl Zeilen in der Protokolldatei
  long lStart;           // Oberste Zeile in der Protokolldatei
  long lPosition;        // Aktuelle Zeile in der Protokolldatei
  long lSelection;       // Anfangszeile markierter Bereich oder -1
  int iWidth;            // Breite des Fensters
  int iHeight;           // Hhe des Fensters
  int iLine;             // Cursorzeile
  int iRow;              // Cursorspalte
  int iShift;            // "lSize" fr Scrollbar reduzieren
  real rPerformance;     // Tatschliche Leistung der CPU in Prozent
  char acC64Name[17];    // Dateiname bei "Manager / Ausfhren"
};

struct LINKWND {
  CDevice* pDevice;      // Gert und Flag fr "Namen vorhanden"
  HWND hwnd;             // MDI-Fenster
  HWND hwndDirTree;      // Unterfenster fr Verzeichnisauswahl
  HWND hwndListBox;      // Unterfenster fr Namen
  HWND hwndFocus;        // Aktives Unterfenster
  int iSplit;            // Position des Trennstriches
};

struct WNDPOS {
  flag fIsLinkWnd;
  char acName[80];
  int iLeft;
  int iTop;
  int iRight;
  int iBottom;
  DWORD dStyle;
};

inline char* strend(char* pc) {
  return pc + strlen(pc);
}

inline int muldiv(int a, int b, int c) {
  return (int)((long)a * b / c);
}

void SetOptionDlgTitle(HWND hwnd, FILEWND* pfw);
flag SetROMs(FILEWND* pfw);
flag SetKeyboard(FILEWND* pfw, flag fReport);
flag SetFloppies(FILEWND* pfw, flag fReport);
char* MakeStr(char* sText, word wLength, word wMax);
void SetError(word wError);
flag ErrorBox(char* pcFile, char* pcMessage = NULL);
BOOL SetTextCharHeight(WORD wHeight);
flag RunStart(word wReset);
void CenterWindow(HWND hwnd);
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int iCmdShow);
LONG FAR PASCAL FrameWndProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
LONG FAR PASCAL FileWndProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
LONG FAR PASCAL LinkWndProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL AboutDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL ROMsDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL KeyboardDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL JoysticksDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL FloppiesDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL FileOptDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL DesktopDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL FiltersDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL EventsDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL CloneDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL CloningDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL HardwareDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL CopyMoveDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL DeleteDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL RenameDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL ImportDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL ExportingDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL TimingDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL SoundDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL SearchTextDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL SearchAdrDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL SearchingDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL MakeDirDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL RenameDirDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL MakeRenameImageDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL CopyImageDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL CompTestDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL ReadROMsDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
BOOL FAR PASCAL PrintersDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam);
LONG FAR PASCAL MsgFilter(int iCode, WORD, LPMSG lpmsg);
int MessageLoop();
flag SaveImage(FILEWND* pfw, char* pcName);
flag LoadImage(FILEWND* pfw, char* pcName);
flag SaveDefault();
char* addext(char* pcPath, char* pcName, char* pcExt);
void AutoArrange();
FILEWND* OpenFileWnd();
flag SaveFileWnd(HWND hwnd, flag fPrompt);
flag CloseFileWnd(HWND hwnd, int hFile);
flag CloseLinkWnd(HWND hwnd, int hFile);
FILEWND* AllocFileWnd();
HWND CreateFileWnd(FILEWND* pfw, WNDPOS* pwp);
flag SwitchToFileWnd(FILEWND* pfw);
void DeleteTempFiles(FILEWND* pfw);
void InitMenu();
flag ReloadFileWnd();
flag DuplicateFileWnd();
flag CloseAllWindows();
void DeleteLogFile(FILEWND* pfw);
void AdjustFileWnd(FILEWND* pfw, HWND hwnd);
void MoveFileSel(long lMove, flag fShift);
void SearchTag(char* pcTag, flag fBack);
void Search();
void Help(HWND hwndParent, word wContext);
void PrepareToRun(FILEWND* pfw);
HWND CreateLinkWnd(WNDPOS* pwp);
flag IsLink(char* pcDir);
flag IsImage(char* pcDir);
void DeleteNames(LINKWND* plw);
flag ReadNames(LINKWND* plw);
void SetLinkAndHelpColors();
word GetLptPort(word wLpt);
flag SearchPorts(HWND hwnd, int iFirstButton);
flag ReduceName(const char* sC64Name, char* pDOSName);
flag LinkImport();
flag LinkExport();
flag AbortProgress(HWND hwndPro);
void SetDlgItemProgress(HWND hwndDialog, word wID, long lValue, long lMax);
word ScanForC64Drives();
flag DefAbortProc();
flag RunAbortProc();
HWND LinkExecute();
void RelDir(char* pcRelDir, char* pcAbsDir);
void SetFileWndDir(FILEWND* pfw);
flag UserIgnoresWindowsNT();
void ReplaceFileWnd();
flag SetDir(CDevice** ppDevice, char* pcDir);
char* GetFileWndTitle(FILEWND* pfw);
flag Database(FILEWND* pfw, flag fWrite);
flag DelDir();
flag DelImage();
void SetDlgItemHex(HWND hwnd, int iItem, long lValue, int iLength);
long GetDlgItemHex(HWND hwnd, int iItem);
void UpdateAllDirTrees(char* pcOld, char* pcNew);
void InitSound();
HWND RunC64Program();

extern "C" void __cdecl ResetTimer();
extern "C" long __cdecl GetTimer();
extern "C" void __cdecl RelocateSegments();
extern "C" flag __cdecl CheckSystem();
extern "C" void __cdecl Reset();
extern "C" void __cdecl Emulate_D();
extern "C" void __cdecl Emulate_R();
extern "C" word __cdecl wRunDebug;
extern "C" void __cdecl CMsg(char* sFormat, ...);
extern "C" byte __far * __cdecl lpRam;
extern "C" byte __far * __cdecl lpKernel;
extern "C" byte __far * __cdecl lpBasic;
extern "C" byte __far * __cdecl lpModule;
extern "C" byte __far * __cdecl lpChar;
extern "C" byte __cdecl abColor[1024];
extern "C" byte __cdecl bModule;
extern "C" char __cdecl sImage[80];
extern "C" flag __cdecl fCtrlBreak;
extern "C" word __cdecl wDebug;
extern "C" char __cdecl sLogFile[80];
extern "C" int __cdecl hLogFile;
extern "C" byte __cdecl VGAColors[16][3];
extern "C" word __cdecl awUpdate[2];
extern "C" void __near * __cdecl pImageStart;
extern "C" int __cdecl iImageSize;
extern "C" void __near * __cdecl pDefaultStart;
extern "C" int __cdecl iDefaultSize;
extern "C" flag __cdecl fLocalBus;
extern "C" flag __cdecl fNationalKeys;
extern "C" flag __cdecl fGreyCursor;
extern "C" flag __cdecl fTabSwitch;
extern "C" word __cdecl awJoyPort[2];
extern "C" word __cdecl awJoyFire[2];
extern "C" long __cdecl alJoyStart[2];
extern "C" long __cdecl alJoyCount[2];
extern "C" word __cdecl awJoyFlags[2];
extern "C" char __near __cdecl acRunError[256];
extern "C" HWND __cdecl hwndHelp;
extern "C" word __cdecl wCtrlTab;
extern "C" byte __cdecl PhysAttrs[9][2];
extern "C" char __near __cdecl acLoad[60];
extern "C" char __near __cdecl acC64Version[];
extern "C" long __cdecl lVersion;
extern "C" word __cdecl wRealTime;
extern "C" word __cdecl wNewLine;
extern "C" dword __cdecl adPCTicks[2];
extern "C" dword __cdecl adC64Ticks[2];
extern "C" byte __cdecl bAdlib;
extern "C" word __cdecl wDSPCommand;
extern "C" word __cdecl wAdlib;
extern "C" byte __cdecl bVolAdlib;
extern "C" byte __cdecl bVolDSP;
extern "C" byte __cdecl bVolMaster;
extern "C" byte __cdecl bVolFM;
extern "C" byte __cdecl bVolVoice;
extern "C" flag __cdecl fWindowsNT;
extern "C" word __cdecl wRefresh;
extern "C" dword __cdecl dClocksPerRefresh;
extern "C" dword __cdecl dTicksPerRefresh;
extern "C" dword __cdecl dRealTicksPerRefresh;
extern "C" dword __cdecl dSIDtoAdlib;
extern "C" word __cdecl wLinesPerFrame;
extern "C" dword __cdecl adTimeAdd[2];
extern "C" byte __cdecl awCharTab[512]; // "byte" wegen einfacherem Zugriff
extern "C" int __cdecl iClocksPerInt;
extern "C" word __cdecl wPerformance;
extern "C" word __cdecl wLineDelay;
extern "C" word __cdecl wSpriteDelay;
extern "C" flag __cdecl fTotalReset;
extern "C" word __cdecl wResume;
extern "C" flag __cdecl fSwapEMS;
extern "C" flag __cdecl fSwapXMS;
extern "C" word __cdecl wAlgorithm;
extern "C" word __near __cdecl afnJoystick_D[8];
extern "C" word __near __cdecl afnJoystick_R[8];
extern HANDLE hInst;
extern HANDLE hAccel;
extern HWND hwndFrame;
extern HWND hwndClient;
extern HWND hwndChild;
extern FILEWND* pfw;
extern HMENU hmenu;
extern char acStart[80];
extern char* pcStart;
extern char __far acCopyright[];
extern char __far acNoCPU[];
extern char __far acNoVGA[];
extern char __far acNoDos[];
extern char __far acNotEnoughMemory[];
extern char __far* apcDOSError[0x66];
extern char __near acNone[];
extern char __near acUnknown[];
extern char __near acUntitled[];
extern char __far acROMLength[];
extern char __far acUseBIOS[];
extern char __far acNoIEC[];
extern char __far acNoImage[];
extern char __far acNoCurrent[];
extern char __far acConfirm[];
extern CDevice* apDevice[16];
extern IECs iec;
extern char __far acNoDevice1[];
extern char __far acNoDevice2[];
extern char __near acError[];
extern word wChildren;
extern flag fDoArrange;
extern long lSetWindowLong;
extern DEFAULT def;
extern char __far acImageFilter[];
extern char __far acFileSave[];
extern char __far acFileOpen[];
extern char __far acFileHasChanged[];
extern FILEWND* pfwLast;
extern char __far acReloadFile[];
extern flag fRunDebug;
extern char* apcColor[DTC_COUNT];
extern int iFrameWidth;
extern int iFrameHeight;
extern flag fErase;
extern char __near acHelpFile[];
extern char __far acNoHelp[];
extern word wDialogHelp;
extern HWND hwndPassKeys;
extern char __far acCantFindL64[];
extern char __far acNoLptPorts[];
extern char __far acErrorReadingL64[];
extern char __far acCloneStopped[];
extern char __far acCloneSuccess[];
extern char __far acEnterClose1[];
extern HWND hwndEnterIdle;
extern char __far acUnrecovered[];
extern char __far acMoving[];
extern char __far acCopying[];
extern char __far acSameDest[];
extern char __far acDeviceNotPresent[];
extern char __far acOutput[];
extern char __far acInput[];
extern char __far acUnknownBusError[];
extern HANDLE hDrives;
extern char __far acNotEmpty[];
extern char __far acDelete[];
extern char __far acDrivesFound[];
extern char __far acDrivesNotFound[];
extern char __far acImportFilter[];
extern char __far acImport[];
extern char __far acOverwrite[];
extern char __far acIsAlreadyC64[];
extern flag (__far *pfnLinkAbortProc)();
extern int iRetries;
extern char __far acReset[];
extern char __far acScanDrives[];
extern char __far acDir[];
extern char __far acShellDir[];
extern HWND hwndMultiLineEdit;
extern char __far acWindowsNT[];
extern HWND hwndMsgFilter;
extern char __far acPerformance[];
extern char __far* apcPresent[2];
extern word wDSPBase;
extern char acSearchText[80];
extern word wSearchFrom;
extern word wSearchTo;
extern flag fSearchBack;
extern flag fSearchAdr;
extern char __far acEndIsLessThanStart[];
extern char __far acQuerySave[];
extern char __far acConfig[80];
extern char __far acDatabase[80];
extern char __far acWrongRecordLen[];
extern char acDestDir[80];
extern char acImportDir[80];
extern char __far acDelImage[];
extern char __far acOverwriteImage[];
extern char __far acWantFormat[];
extern byte __far* gpbError;
extern char __far acNoL64[];
extern CPrinter aPrinter[4];
extern char __far acNoFile1[];
extern char __far acNoFile2[];
extern char __far acRunDir[80];
extern char __far acRunName[19];
extern long lRunStart;
extern flag fQuit;
