// Zwischen verschiedenen Gertearten umschalten

#include "pc64.h"

// Prfen, ob der bergebene Name auf ein Link zeigt
flag IsLink(char* pcName) {
  assert(pcName && *pcName);
  uint uLast = strlen(pcName) - 1;
  if (uLast != 2 && uLast != 3) {
    return FALSE;
  }
  if (pcName[uLast] != ':') {
    return FALSE;
  }
  if (strspn(pcName, "0123456789") != uLast) {
    return FALSE;
  }
  return TRUE;
}

// Prfen, ob der bergebene Name auf ein Imagefile zeigt
flag IsImage(char* pcName) {
  assert(pcName && *pcName);
  char* pcExt = strrchr(pcName, '.');
  if (!pcExt || _stricmp(pcExt, ".D64")) {
    return FALSE;
  }
  int hFile = _lopen(pcName, READ | OF_SHARE_DENY_NONE);
  if (hFile == -1) {
    return FALSE;
  }
  _lclose(hFile);
  return TRUE;
}

// Neues Verzeichnis setzen und ntigenfalls Typ umschalten
flag SetDir(CDevice** ppDevice, char* pcDir) {
  word wNew;
  if (!pcDir || !*pcDir) {
    wNew = DEVNONE;
  } else if (IsLink(pcDir)) {
    wNew = DEVLINK;
  } else if (IsImage(pcDir)) {
    wNew = DEVIMAGE;
  } else {
    wNew = DEVFLOPPY;
  }
  word wOld;
  if (!*ppDevice) {
    wOld = DEVNONE;
  } else {
    wOld = (*ppDevice)->GetType();
  }
  if (wNew != wOld) {
    if (wOld) {
      delete *ppDevice;
      *ppDevice = NULL;
    }
    switch (wNew) {
    case DEVNONE:
      break;
    case DEVFLOPPY:
      *ppDevice = new CFloppy;
      assert(*ppDevice);
      break;
    case DEVLINK:
      *ppDevice = new CLink;
      assert(*ppDevice);
      break;
    case DEVIMAGE:
      *ppDevice = new CImage;
      assert(*ppDevice);
      break;
    }
  }
  if (wNew != DEVNONE) {
    return (*ppDevice)->SetDir(pcDir);
  } else {
    return TRUE;
  }
}
